#include "stdafx.h"

#include "commctrl.h"
#include "AppliBase.h"
#include "TwrListView.h"

/**
 * RXgN^
 */
TwrListView::TwrListView() : TwrWnd()
{
}

/**
 * RXgN^
 *
 * @param IuWFNgɌѕtEChẼnh
 */
TwrListView::TwrListView(HWND newHwnd) : TwrWnd()
{
	hWnd = newHwnd;
}


/**
 * Xgr[쐬܂B
 *
 * @return 쐬Xgr[̃EChEnh
 */
HWND TwrListView::create(void)
{
	hWnd = CreateWindowEx(
		WS_EX_CLIENTEDGE,
		_T("LISTVIEW"),
		NULL,
		WS_CHILD|WS_VISIBLE|LBS_NOINTEGRALHEIGHT|WS_TABSTOP,
		left,	// X
		top,	// Y
		width,	// Width
		height,	// Height
		GetDesktopWindow(),	// Parent
		NULL,
		hInst,
		NULL);

	return hWnd;
}

/**
 * Xgr[ɗvf}܂B
 *
 * @param index }ʒu
 * @param item ǉ镶
 */
void TwrListView::insertItem(int index, TCHAR *item)
{
	LVITEM itemInfo;
	
	memset(&itemInfo, 0x00, sizeof(LVITEM));
	itemInfo.mask = LVIF_TEXT;
	itemInfo.iItem = index;
	itemInfo.pszText = item;
	itemInfo.cchTextMax = _tcslen(item) + 1;

	SendMessage(hWnd, LVM_INSERTITEM , (WPARAM)0, (LPARAM)&itemInfo);
}

/**
 * Xgr[̃X^Cݒ肵܂B
 *
 * @param newStyle VX^C
 * @return ݒ茋
 */
unsigned int TwrListView::SetExtendedStyle(unsigned int newStyle)
{
	return SendMessage(hWnd, LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)newStyle);
}

/**
 * Xgr[ɗ}܂B
 *
 * @param no ԍ
 * @param title ̃^Cg
 * @param nFormat tH[}bg
 * @param nWidth 
 * @param nSubItem ̃TuACẽCfbNX
 * @return }
 */
int TwrListView::insertColumn(
	int no,
	TCHAR *title, 
	int nFormat,
	int nWidth,
	int nSubItem 
)
{
	LVCOLUMN columnInfo;
	
	columnInfo.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	columnInfo.pszText = title;
	columnInfo.fmt = nFormat;
	columnInfo.cx = nWidth;
	if (nSubItem > -1) {
		columnInfo.iSubItem = nSubItem;
	} else {
		columnInfo.iSubItem = 0;
	}
	
	return SendMessage(hWnd, LVM_INSERTCOLUMN, (WPARAM)no, (LPARAM)(&columnInfo));
}

/**
 * Xgr[̃`FbNԂύX܂B
 *
 * @param index `FbNԂύXs
 * @param checked true:`FbNĂ false:`FbNĂȂ
 */
void TwrListView::checkItem(int index, bool checked)
{
	ListView_SetCheckState(hWnd, index, (checked ? TRUE : FALSE));
}

/**
 * Xgr[̍sI܂B
 *
 * @param index Is
 */
void TwrListView::selectItem(int index)
{
	LVITEM itemInfo;
	
	itemInfo.mask = LVIF_STATE;
	itemInfo.iItem = index;
	itemInfo.state = LVIS_SELECTED ;
	itemInfo.stateMask = LVIS_SELECTED ;

	SendMessage(hWnd, LVM_SETITEM, (WPARAM)0, (LPARAM)(&itemInfo));
}

/**
 * Xgr[̍s̃`FbNԂ擾܂B
 *
 * @param index `FbNԂ擾s
 * @return true:`FbNĂ false:`FbNĂȂ
 */
bool TwrListView::isChecked(int index)
{
	BOOL state;
	
	state = ListView_GetCheckState(hWnd, index);

	return (state ? true : false);
}

