#include "stdafx.h"

#include "TwrCore.h"
#include "BaseDialog.h"
#include "ModelessDialog.h"

BaseDialog *BaseDialog::modalCallback;
static BaseDialog *modelessCallback[10];
static int modelessCallbacks = 0;

/**
 * [hX_CAÕR[obNB
 *
 */
void initModelessCallback(void)
{
	for (int i = 0; i < 10; i++) {
		modelessCallback[i] = NULL;
	}
}

/**
 * RXgN^
 */
BaseDialog::BaseDialog() : TwrWnd()
{
	parentWindow = NULL;
	// dialogResource = resource;
	isModeless = false;
}


/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
BaseDialog::BaseDialog(HWND parent, int resource) : TwrWnd()
{
	parentWindow = parent;
	dialogResource = resource;
	isModeless = false;
}

/**
 * fXgN^
 */
BaseDialog::~BaseDialog()
{
	if (isModeless) {
		delModelessDialog(hWnd);

		for (int i = 0; i < 10; i++) {
			if (modelessCallback[i] == this) {
				modelessCallback[i] = NULL;
				modelessCallbacks--;
				break;
			}
		}
		if (hWnd != NULL) {
			if (IsWindow(hWnd)) {
				DestroyWindow(hWnd);
			}
		}
	}
}

/**
 * [__CAO\B
 *
 * @return _CAO̖߂l
 */
INT_PTR BaseDialog::showModal()
{
	modalCallback = this;
	return ::DialogBox(
		hInst,
		MAKEINTRESOURCE(dialogResource),
		parentWindow,
		&BaseDialog::modalDialogProc);
}

/**
 * [hX_CAO\B
 *
 * @return _CAO̖߂l
 */
HWND BaseDialog::showModeless()
{
	isModeless = true;

	hWnd = CreateDialog(
		hInst,
		MAKEINTRESOURCE(dialogResource),
		parentWindow,
		&BaseDialog::modelessDialogProc);

	if (hWnd != NULL) {
		bool found = false;
		int empty = -1;
		for (int i = 0; i < 10; i++) {
			if (modelessCallback[i] == this) {
				found = true;
				break;
			}
			if ((modelessCallback[i] == NULL) && (empty == -1)){
				empty = i;
			}
		}
		if (!found) {
			if (empty > -1) {
				modelessCallback[empty] = this;
				modelessCallbacks++;
			}
		}

		addModelessDialog(hWnd);
	}
	this->OnInitDialog();

	return hWnd;
}

/**
 * [__CAÕ_CAOv[VW
 *
 * @param hDlg _CAÕEChEnh
 * @param message bZ[W
 * @param wParam WPARAM
 * @param lParam LPARAM
 * @return 
 */
INT_PTR CALLBACK BaseDialog::modalDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	return modalCallback->dialogProc(hDlg, message, wParam, lParam);
}

/**
 * [hX_CAÕ_CAOv[VW
 *
 * @param hDlg _CAÕEChEnh
 * @param message bZ[W
 * @param wParam WPARAM
 * @param lParam LPARAM
 * @return 
 */
INT_PTR CALLBACK BaseDialog::modelessDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	for (int i = 0;i < 10; i++) {
		if (modelessCallback[i] == NULL) {
			continue;
		}
		if (hDlg == modelessCallback[i]->getHwnd()) {
			return modelessCallback[i]->dialogProc(hDlg, message, wParam, lParam);
		}
	}
	return 0;
}

/**
 * _CAÕ_CAOv[VW
 *
 * @param hDlg _CAÕEChEnh
 * @param message bZ[W
 * @param wParam WPARAM
 * @param lParam LPARAM
 * @return 
 */
INT_PTR CALLBACK BaseDialog::dialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	hWnd = hDlg;
	switch (message)
	{
		case WM_INITDIALOG:
			return OnInitDialog();

		case WM_COMMAND:
			return OnCommand(wParam);
	}

	return (INT_PTR)FALSE;
}

/**
 * _CAOƃ_CAOIuWFNg̃f[^̓Ƃ܂B
 *
 * @param toObj true:_CAO̓eIuWFNgɊi[B
 *              false:IuWFNg̓e_CAOɊi[B
 */
void BaseDialog::UpdateData(bool toObj)
{
}


/**
 * _CAȌɌĂяo܂B
 *
 * @return 
 */
INT_PTR BaseDialog::OnInitDialog()
{
	if (title.length() > 0) {
		::SetWindowText(hWnd, title.c_str());
	}
	return (INT_PTR)FALSE;
}


/**
 * _CAO삪sꂽɌĂяo܂B
 *
 * @return 
 */
INT_PTR BaseDialog::OnCommand(WPARAM wParam)
{
	if (!isModeless) {
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hWnd, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
	}
	return (INT_PTR)FALSE;
}

/**
 * _CAO\[X̃EChE擾܂B
 *
 * @param item \[XID
 * @return _CAÕIuWFNg
 */
TwrWnd *BaseDialog::GetDlgItem(int item)
{
	HWND itemHwnd = ::GetDlgItem(hWnd, item);
	if (itemHwnd == NULL) {
		return NULL;
	}

	TwrWnd *newWnd;
	try {
		newWnd = new TwrWnd(itemHwnd);
		if (newWnd == NULL) {
			return NULL;
		}
		
	}catch(...) {
		return NULL;
	}
	return newWnd;
}

/**
 * _CAO\[X̃EChEnh擾܂B
 *
 * @param \[XID
 * @return _CAÕEChẼnh
 */
HWND BaseDialog::GetDlgItemRaw(int item)
{
	return ::GetDlgItem(hWnd, item);
}

