// AppliBase.cpp : AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "commctrl.h"

#include "TwrCore.h"
#include "WindowAppliBase.h"
#include "ModelessDialog.h"

// O[oϐ:
TCHAR szTitle[MAX_LOADSTRING];					// ^Cg o[̃eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// C EBhE NX
BaseForm *baseForm;

// AvP[VŗL̃O[oϐ
WindowAppliBase *appObj;

extern void initModelessCallback(void);

// ̃R[h W[Ɋ܂܂֐̐錾]܂:
int runApplication(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPTSTR    lpCmdLine,
	int       nCmdShow);
BOOL				InitInstance(HINSTANCE, int);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
bool handleDialogMessage(LPMSG lpMsg);

/**
 * AvP[VC[`
 *
 * @param hInstance AvP[ṼCX^Xnh
 * @param hPrevInstance gp
 * @param lpCmdLine R}hC
 * @param nCmdShow \
 * @return vOIR[h
 */
int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	INITCOMMONCONTROLSEX iccx;
	iccx.dwSize = sizeof(INITCOMMONCONTROLSEX);
	iccx.dwICC = ICC_TAB_CLASSES;
	if (!InitCommonControlsEx(&iccx)) {
         return FALSE;
	}

	initModelessDialog();
	initModelessCallback();

	// ŃAvP[VNX̃CX^Xݒ肵܂B
	appObj = createAppli();
	baseForm = appObj->createBaseForm();

	// EChE\ÕAvP[V̏sB
	appObj->OnAppliStart(lpCmdLine);

	int result = runApplication(hInstance, hPrevInstance, lpCmdLine, nCmdShow);

	// AvP[V̌nsB
	appObj->OnAppliEnd();

	delete appObj;
	return result;
}

/**
 * AvP[VJn
 *
 * @param hInstance AvP[ṼCX^Xnh
 * @param hPrevInstance gp
 * @param lpCmdLine R}hC
 * @param nCmdShow \
 * @return vOIR[h
 */
int runApplication(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPTSTR    lpCmdLine,
	int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	// O[oĂ܂B
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDS_APP_CLASS, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// AvP[V̏s܂:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_APP_ACCEL));
	doEvents();

	// EChE\ɍssB
	appObj->OnWindowShow();

	// C bZ[W [v:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (handleDialogMessage(&msg)) {
			// bZ[W[hX_CAÔ̂ꍇ
			// ȂB
			continue;
		}
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}

//
//   ֐: InitInstance(HINSTANCE, int)
//
//   ړI: CX^X nhۑāAC EBhE쐬܂B
//
//   Rg:
//
//        ̊֐ŁAO[oϐŃCX^X nhۑA
//        C vO EBhE쐬ѕ\܂B
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // O[oϐɃCX^Xi[܂B

   baseForm->setClass(szWindowClass);
   baseForm->setTitle(szTitle);
   hWnd = baseForm->Create(hInstance);
   if (!hWnd)
   {
      return FALSE;
   }

   baseForm->ShowWindow(nCmdShow);
   baseForm->UpdateWindow();

   return TRUE;
}

//
//  ֐: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  ړI:  C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	LRESULT lResult = baseForm->WndProc(hWnd, message, wParam, lParam);

	return lResult;
}

/**
 * Windows̃CxgB
 *
 * @return Cxg
 */
int doEvents()
{
	MSG msg;
    // bZ[W̏
    while (::PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) {
		BOOL bRet = GetMessage(&msg, NULL, 0, 0);
		if (bRet > 0){
			if (handleDialogMessage(&msg)) {
				// bZ[W[hX_CAÔ̂ꍇ
				// ȂB
				continue;
			} else {
				::TranslateMessage(&msg);
				::DispatchMessage (&msg);
			}
		} else {
			break;
		}
    }
	return 0;
}

/**
 * fXgN^
 */
WindowAppliBase::~WindowAppliBase()
{
}

/**
 * AvP[VEChENX̃CX^X𐶐܂B
 *
 * @return AvP[VEChENX̃CX^X
 */
BaseForm *WindowAppliBase::createBaseForm()
{
	return new BaseForm();
}

/**
 * AvP[V̊Jns܂B
 *
 * @return \
 */
int WindowAppliBase::OnAppliStart(TCHAR *lpCmdLine)
{
	// ̊֐I[o[ChăAvŗL̏s܂B
	return 0;
}

/**
 * EChE\ꂽƂ̏s܂B
 *
 * @return \
 */
int WindowAppliBase::OnWindowShow()
{
	// ̊֐I[o[ChāA̕\̏s܂B
	return 0;
}

/**
 * AvP[V̏Is܂B
 *
 * @return \
 */
int WindowAppliBase::OnAppliEnd()
{
	// ̊֐I[o[ChăAvŗĽ㏈s܂B
	return 0;
}
