#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<dos.h>
#include	<dos2.h>

#define DIRBUF 16384 /* 512 entrys */

/* directory entry(MSX-DOS) */
struct dirent {
	unsigned char name[8];
	unsigned char ext[3];
	unsigned char attr;
	unsigned char reserve[10];
	unsigned int time;
	unsigned int date;
	unsigned int entry;
	unsigned long size;
};

struct lfnent {
	unsigned char entry;
	unsigned int name1[5];
	unsigned char attr;
	unsigned char reserve;
	unsigned char chksum;
	unsigned int name2[6];
	unsigned int entry;
	unsigned int name3[2];
};

unsigned char chknamesum(struct dirent *);

struct DPB *dp;
struct dirent *dir; /* fBNgGg̃obt@ */
unsigned int maxentry;

static char *version_res = "@(#)Real Volume Label Version 1.10\nBy Tatsuhiko Syoji 1999\n";

/* ec[ɌŗL̊֐ */
void usage();

/* LSI-C̐^ */
void con_puts(char *s)
{
	while(*s){
		if (*s == '\n'){
			msx_bdos((char)0x02,0x0d,0);
			msx_bdos((char)0x02,0x0a,0);
		}else{
			msx_bdos((char)0x02,*s,0);
		}
		s++;
	}
}

int putdir(unsigned char drive)
{

	if (((dp->data_start - dp->dir_start) * dp->sec_size) > DIRBUF){
		_dos_abswrite(dir,drive,dp->dir_start,DIRBUF / dp->sec_size);
	}else{
		_dos_abswrite(dir,drive,dp->dir_start,dp->data_start - dp->dir_start);
	}

	return(0);
}


/* getcwd͐V */
int getdir(unsigned char drive)
{

	if (((dp->data_start - dp->dir_start) * dp->sec_size) > DIRBUF){
		maxentry = DIRBUF / 32;
		_dos_absread(dir,drive,dp->dir_start,DIRBUF / dp->sec_size);
	}else{
		maxentry = (dp->data_start - dp->dir_start) * (dp->sec_size / 32);
		_dos_absread(dir,drive,dp->dir_start,dp->data_start - dp->dir_start);
	}

	return(0);
}

void exmain()
{
	unsigned int i,j;
	unsigned int vol_ent,enp_ent;
	struct dirent dirbuf;

	enp_ent = maxentry;
	for (i = 0;i < maxentry;i++){
		if (dir[i].name[0] == '\0'){ /* Volume label not found */
			if (i+1 == maxentry){
				j = i; /* fBNgGgI㏑ */
			}else{
				j = i + 1;
			}
			for (;j > 0;j--){
				dir[j] = dir[j-1];
			}
			strncpy(dir[0].name,"No name    ",11);
			dir[0].attr = 0x08;
			dir[0].time = 0;
			dir[0].date = 0;
			dir[0].entry = 0;
			dir[0].size = 0;
			return;
		}
		if (dir[i].attr == 0x08 && dir[i].name[0] != 0xe5){ /* Volume label found */
			vol_ent = i;
			break;
		}
		if (dir[i].name[0] == 0xe5){
			enp_ent = i;
		}
	}
	if (i == maxentry){ /* Volume label not found */
		if (enp_ent < maxentry){ /* 󂫃GgɃ_~[x */
			strncpy(dir[enp_ent].name,"No name    ",11);
			dir[enp_ent].attr = 0x08;
			dir[enp_ent].time = 0;
			dir[enp_ent].date = 0;
			dir[enp_ent].entry = 0;
			dir[enp_ent].size = 0;
			vol_ent = enp_ent;
		}else{
			con_puts("Empty entry not found.\n");
			return;
		}
	}

	dirbuf = dir[vol_ent];
	for (i = vol_ent;i > 0;i--){
		dir[i] = dir[i-1];
	}
	dir[0] = dirbuf;

}

void usage()
{
	con_puts(version_res+4);
	con_puts("Usage:\nREALVOL Drive\n");
	exit(0);
}

int parse_opt(int argc,char *argv[])
{
	int i,path_arg;

	path_arg = 0;

	for(i = 1;i < argc;i++){
		if (argv[i][0] == '/' || argv[i][0] == '-'){ /* Option */
			switch (toupper(argv[i][1])){
				case '?':
				case 'H':
					usage();
				break;
				default:
					con_puts("Error:Illegal option.");
					exit(1);
				break;
			}
		}else{
			if (path_arg == 0){ /* ŏ̂̕ݗL */
				path_arg = i;
			}
		}
	}
	return(path_arg);
}

int main(int argc,char *argv[])
{
	unsigned char drive;
	unsigned int path_arg;

	path_arg = parse_opt(argc,argv);
	/* parse only drive name for getting DPB */
	if (path_arg == 0){ /* Current drive */
		/* Ŝ߂ɃhCuKw肷悤ɂB */
		usage();
	}else{
		if (!isalpha(argv[path_arg][0])){
			usage();
		}else{
			drive = toupper(argv[path_arg][0]) - 'A';
		}
	}

	/* FATɎgmۂB */
	dp = _dos_getDPB(drive+1);

	/* fBNgobt@̓TCYŒƂBTufBNgł́AfBXNeʂ̌t@C邩炫肪Ȃ */
	if ((dir = (struct dirent *)malloc(DIRBUF)) == NULL){
		con_puts("Error:No enough Directory buffer memory.");
		exit(1);
	}
	_dos_absread(dir,drive,0,1); /* Read boot sector */

	/* fprintf(stderr,"%5.5s\n",(unsigned char *)((unsigned char *)dir + 0x36)); */
	/* FAT16hCu͏݂ۏ؂Ȃ̂ŁAG[ƂB */
	if (memcmp((unsigned char *)((unsigned char *)dir + 0x36),"FAT16",5) == 0){

		con_puts("Error:FAT16 is not supported.");
		free(dir);
		exit(1);
	}

	/* fBNgǂݍ */
	getdir(drive);

	exmain();
	putdir(drive);

	free(dir);
	return(0);
}
