#include	<stdio.h>
#include	<stdlib.h>
#include	<unixio.h>
#include	<string.h>
#include	<ctype.h>
#include	<glib.h>

extern char map[22][22],mark[22][22],*snb;
extern int nm,all,miss,stage,maxst,rank;
char *modes[] = {"  TEST","  EASY","NORMAL","  HARD"};

char fg,bg,bd;
char spr[] = {0xff,0x81,0x81,0x81,0x81,0x81,0x81,0xff};

int chkmp();
void vdpsc2();

char *title = "Numbers Paint for MSX-DOS By Tatsu 1996";

/* VDPSCREEN 2ɂ */
#asm
	global	_vdpsc2

_vdpsc2:
	push	ix
	push	iy

	ld	iy,(0fcc1H-1)	;IYH <- Main ROM'S slot number
	ld	ix,007eH	;SETGRP
	call	001cH	;CALSLT

	pop	iy
	pop	ix
	ret

#endasm

/* BASICBLOAD߂Ǝ悤ȓ */
char bloads(str,off)
char *str;
unsigned int off;
{
	int fp;
	unsigned char *buf,hd;
	unsigned int cnt,cnt2,cnt3,s_adr,e_adr,r_adr,left;

	if ((fp = open(str,0)) == -1){
		return(1);
	}
	/* Header - check code 0xfe,start addr.,end addr.,run addr. - */
	if (read(fp,(char *)&hd,1) == 0){
		close(fp);
		return(1);
	}
	if (hd != 0xfe){
		close(fp);
		return(1);
	}
	if (read(fp,(char *)&s_adr,2) == 0){
		close(fp);
		return(1);
	}
	if (read(fp,(char *)&e_adr,2) == 0){
		close(fp);
		return(1);
	}
	if (read(fp,(char *)&r_adr,2) == 0){
		close(fp);
		return(1);
	}
	if ((buf = malloc(2048)) == NULL){
		close(fp);
		return(1);
	}
	/* Data */
	cnt = s_adr + off;
	left = 0;
	cnt2 = s_adr;
	while (cnt2 <= e_adr){
		if (left == 0){
			if ((left = read(fp,buf,2048)) == 0){
				close(fp);
				free(buf);
				return(1);
			}
			cnt3 = 0;
		}
		vpoke(cnt,buf[cnt3]);
		left--;
		cnt2++;
		cnt++;
		cnt3++;
	}

	close(fp);
	free(buf);
	return(0);
}

#define TIME *(unsigned *)(0xfc9e)

/* Cӂ̒̈ꉹ炷֐ */
void play2(on,tem,len,vol)
int on; /* K */
int tem; /* e| */
int len; /*  */
int vol;
{
	unsigned count;
	static int table[] = { 0,
		3420,3229,3047,2876,2715,2562,2419,2283,2155,2034,1920,1812,
		1710,1614,1524,1438,1357,1281,1209,1141,1077,1017, 960, 906,
		 855, 807, 762, 719, 679, 641, 605, 571, 539, 508, 480, 453,
		 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226,
		 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113,
		 107, 101,  95,  90,  85,  80,  76,  71,  67,  64,  60,  57,
		  53,  50,  48,  45,  42,  40,  38,  36,  34,  32,  30,  28,
		  27,  25,  24,  22,  21,  20,  19,  18,  17,  16,  15,  14
	};
	sound( (unsigned char)7,(unsigned char)(0x38 | rdpsg((unsigned char)7)) );
	sound((unsigned char)8,(unsigned char)vol);
	if (on > 0){
		sound( (unsigned char)0,(unsigned char)(table[on] % 0x100) );
		sound( (unsigned char)1,(unsigned char)(table[on] >> 8) );
	}else{
		sound((unsigned char)8,(unsigned char)0);
	}
	count = 14400 / (tem * len);
	for(TIME = 0;TIME < count;){
	}
	sound((unsigned char)8,(unsigned char)0);

}

/* MML߂Ė炷֐ */
void play(mml)
char *mml;
{
	char buf[5];
	int oct,tem,voi,len,vol,deflen;
	static int tab[] = {10,12,1,3,5,6,8};

	tem = 120;
	len = 4;
	oct = 4;
	vol = 15;
	deflen = 4;

	while (*mml){
		switch (*mml){
			case 'T':
				mml++;
				strncpy(buf,mml,3);
				buf[3] = '\0';
				tem = atoi(buf);
				mml += 3;
			break;
			case 'L':
				mml++;
				if (isdigit(*mml)){
					deflen = 0;
					while(isdigit(*mml)){
						deflen = deflen * 10 + (*mml - '0');
						mml++;
					}
				}
			break;
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'A':
			case 'B':
				voi = tab[*mml-0x41];
				mml++;
				if (*mml == '+'){
					voi += 1;
					mml++;
				}
				if (*mml == '-'){
					voi -= 1;
					mml++;
				}
				len = 0;
				if (isdigit(*mml)){
					while(isdigit(*mml)){
						len = len * 10 + (*mml - '0');
						mml++;
					}
				}else{
					len = deflen;
				}
				play2(voi + oct * 12,tem,len,vol);
			break;
			case 'O':
				mml++;
				oct = (int)(*mml - 0x31);
				mml++;
			break;
			case 'R':
				mml++;
				if (isdigit(*mml)){
					len = 0;
					while(isdigit(*mml)){
						len = len * 10 + (*mml - '0');
						mml++;
					}
				}else{
					len = deflen;
				}
				play2(0,tem,len,vol);
			break;
			case 'V':
				mml++;
				strncpy(buf,mml,2);
				buf[2] = '\0';
				vol = atoi(buf);
				mml += 2;
			break;
			default:
				mml++;
			break;
		}
	}
}

/* VRAMڏ݂ŕ\s */
void vputs(x,y,s)
int x;
int y;
char *s;
{
	unsigned int a;

	a = 0x1800 + x + y * 32;
	setwrt(a);
	while(*s){
		outvdp(*s);
		a++;
		s++;
	}
}

void window(x,y,sx,sy)
int x;
int y;
int sx;
int sy;
{
	int i,j;

	/* ܸ */
	for (i = 0;i < sy;i++){
		for (j = 0;j < sx;j++){
			if (j == 0 || j == (sx-1)){
				vpoke((unsigned int)(0x1800 + x + j + (y + i) * 32),(unsigned char)0x16);
			}else{
				vpoke((unsigned int)(0x1800 + x + j + (y + i) * 32),(unsigned char)0x20);
			}
		}
	}

	/* ֺܸ */
	for (i = 0;i < sy;i = i + sy - 1){
		for (j = 0;j < sx;j++){
			vpoke((unsigned int)(0x1800 + x + j + (y + i) * 32),(unsigned char)0x17);
		}
	}

	vpoke((unsigned int )(0x1800 + x + y * 32),(unsigned char)0x18);
	vpoke((unsigned int)(0x1800 + x + sx - 1 + y * 32),(unsigned char)0x19);
	vpoke((unsigned int)(0x1800 + x + (y + sy - 1)* 32),(unsigned char)0x1a);
	vpoke((unsigned int)(0x1800 + x + sx - 1 + (y + sy - 1) * 32),(unsigned char)0x1b);
}

void loadgr()
{
	bloads("npmsx1.pat",0);
	bloads("npmsx1.col",0);
	bloads("npmsx1.pat",0x800);
	bloads("npmsx1.col",0x800);
	bloads("npmsx1.pat",0x1000);
	bloads("npmsx1.col",0x1000);
}

void status()
{
	char buf[20];

	sprintf(buf,"%5d",stage);
	vputs(26,8,buf);

	sprintf(buf,"%5d",miss);
	vputs(26,12,buf);

}

void printst(s)
int s;
{
	char buf[20];

	if (s > 0){
		sprintf(buf,"%5d",s);
		vputs(26,8,buf);
	}else{
		sprintf(buf," EXIT");
		vputs(26,8,buf);
	}
}

void printrk()
{
	char buf[20];

	sprintf(buf,"%s",modes[rank]);
	vputs(25,10,buf);

}

/* XvCgp^[` */
void sp_ini()
{
	int i;

	setwrt(0x3800);
	for (i = 0;i < 8;i++){
		outvdp(spr[i]);
	}
}

void iniscr()
{

	fg = c_fore;
	bg = c_back;
	bd = c_bord;

	ginit();
	screen((char)1);
	color(15,1,1);
	vdpsc2();
	inispr((char)0);
	sp_ini();
	loadgr();

}

void gamsc()
{

	cls();
	window(0,1,22,22);
	window(22,1,10,13);
	window(22,14,10,9);

	vputs(24,2,"NUMBERS");
	vputs(25,3,"PAINT");
	vputs(23,5,"BY TATSU");
	vputs(23,7,"STAGE:");
	vputs(23,9,"MODE:");
	vputs(23,11,"MISS:");

	vputs(23,15,"jklm:");
	vputs(27,16,"MOVE");
	vputs(23,17,"A:CHECK");
	vputs(23,18,"B:MARK");
	vputs(23,19,"A+B:");
	vputs(24,20,"M.MARK");
	vputs(23,21,"ESC:EXIT");
}

void endscr()
{
	color(fg,bg,bd);
	screen((char)0);
	fprintf(stderr,"%s\nPlease play me again.m(__)m\n",title);
}

void selsc()
{
	char buf[34];

	gamsc();

	window(0,11,32,3);

	sprintf(buf,"STAGE SELECT (1-%-d)",maxst);
	vputs(1,12,buf);
}

void alldis()
{
	int i,j;
	unsigned c;
	unsigned int a;

	status();
	printrk();

	for (j = 1;j < 21;j++){
		for (i = 1;i < 21;i++){
			c = chkmp(i,j) + 96;
			a = 0x1800 + i + (j+1) * 32;
			vpoke(a,(unsigned char)c);
		}
	}
}

void ansdis()
{
	int i,j;
	unsigned int a;

	status();

	for (j = 1;j < 21;j++){
		for (i = 1;i < 21;i++){
			if (map[i][j] & 1){
				a = 0x1800 + i + (j+1) * 32;
				vpoke(a,(unsigned char)105);
			}else{
				a = 0x1800 + i + (j+1) * 32;
				vpoke(a,(unsigned char)137);

			}
		}
	}
}

void trued(x,y)
int x;
int y;
{
	unsigned c;
	unsigned int a;

	c = chkmp(x,y) + 128;
	a = 0x1800 + x + (y+1) * 32;
	vpoke(a,(unsigned char)c);

}

void falsd(x,y)
int x;
int y;
{
	unsigned c;
	unsigned int a;

	c = chkmp(x,y) + 144;
	a = 0x1800 + x + (y+1) * 32;
	vpoke(a,(unsigned char)c);
	beep();

}

void tmpd(x,y)
int x;
int y;
{
	unsigned c;
	unsigned int a;

	c = chkmp(x,y) + 112;
	a = 0x1800 + x + (y+1) * 32;
	vpoke(a,(unsigned char)c);

}

void resd(x,y)
int x;
int y;
{
	unsigned c;
	unsigned int a;

	c = chkmp(x,y) + 96;
	a = 0x1800 + x + (y+1) * 32;
	vpoke(a,(unsigned char)c);
}

/* XvCgōJ[\̕\ */
void dispcs(x,y)
int x;
int y;
{
	setwrt(0x1b00);
	outvdp((unsigned char)((y+1)*8-1));
	outvdp((unsigned char)(x*8));
	outvdp((unsigned char)0);
	outvdp((unsigned char)2);

}

/* XvCgōJ[\ */
void udiscs(x,y)
int x;
int y;
{
	setwrt(0x1b00);
	outvdp((unsigned char)208);
	outvdp((unsigned char)(x*8));
	outvdp((unsigned char)0);
	outvdp((unsigned char)2);
}

char xstck()
{
	char a;
	a = gstex((char)0);
	if (a){
		return(a);
	}
	a = gstex((char)1);
	if (a){
		return(a);
	}
	return(gstex((char)2));
}

char xtrig1()
{
	if ( gttrig((char)2) ){
		return(1);
	}
	if ( gttrig((char)1) ){
		return(1);
	}
	return(gttrig((char)0));
}

char xtrig3()
{
	if ( gttrig((char)4) ){
		return(1);
	}
	if ( gttrig((char)3) ){
		return(1);
	}
	return( (snsmat((char)6) & 0x04) == 0);
}

char getxx()
{
	char ret;

	ret = xstck();

	if ((ret > 0) && (ret < 9)){ /* Cursor */
		return(ret);
	}
	if (ret == 9){ /* RUN */
		return(13);
	}
	if (ret == 10){ /* Joy's SEL. */
		return(11);
	}
	if (xtrig1()){ /* SPC */
		if (xtrig3()){ /* SPC + GRAPH */
			return(12);
		}else{
			return(9);
		}
	}
	if (xtrig3()){ /* GRAPH */
		return(10);
	}
	if ((snsmat((char)7) & 0x04) == 0){ /* ESC */
		return(11);
	}
	if ((snsmat((char)4) & 0x08) == 0){ /* 'N' */
		return(12);
	}
	if ((snsmat((char)3) & 0x01) == 0){ /* 'C' */
		return(13);
	}

	return(0);
}

char getx()
{

	char ret,r2,rx;

	ret = 0;
	r2 = 0;
	while(ret == 0){
		rx = getxx();
		ret = rx;
		if (rx != 0){
			do{
				r2 = rx;
				rx = getxx();
			}while (r2 == rx);
		}
	}
	return(ret);
}

void aclear()
{
	cls();

	vputs(7,8,"CONGRATULATIONS !!");

	vputs(6,10,"FINAL STAGE CLEAR !!");

	vputs(4,12,"BUT,THIS GAME ISN'T END.");

	vputs(2,14,"MAKE NEW STAGE AND SOLVE IT!");

	vputs(9,16,"NUMBERS PAINT");

	vputs(4,18,"BY TATSUHIKO SYOJI 1996");

	play("T120V15O5L4EA2GEB2A2");

	kilbuf();
	getx();
	gamsc();
}

void clear()
{
	udiscs();

	window(0,9,32,6);
	vputs(1,10,"CONGRATULATIONS !!");
	vputs(1,11,"STAGE:");
	vputs(1,12,snb);
	vputs(23,13,"CLEAR !!");

	play("T120V15O5L4EDE8G8A");

	kilbuf();
	getx();

	gamsc();
	ansdis();
	kilbuf();
	getx();

	if ((rank > 0) && (stage == maxst)){
		aclear();
	}
}

void gover()
{

	udiscs();

	window(0,10,32,3);
	vputs(1,11,"GAME OVER!! TRY AGAIN !!");
	play("T120V15O4CD8C8ECR8EF");
	kilbuf();
	getx();
}

