/* Msx Kana Filter By Tatsuhiko Syoji */
/* Version 1.1 1996/04/14 :SSpɕϊ郂[hǉ */
/* Version 1.2 1996/04/27 :t@CwȂǂ̋AŒ̕ϊ */
/*                         [h̒ǉ */

#ifdef MSXC
#include	<stdio.h>
typedef char void;
#else
#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#endif

unsigned _CMAPM[] = {
	0x8140,0x8149,0x8168,0x8194,0x8190,0x8193,0x8195,0x8166, /* ASCII */
	0x8169,0x816a,0x8196,0x817b,0x8143,0x817c,0x8144,0x815e,
	0x824f,0x8250,0x8251,0x8252,0x8253,0x8254,0x8255,0x8256,
	0x8257,0x8258,0x8146,0x8147,0x8183,0x8181,0x8184,0x8148,
	0x8197,0x8260,0x8261,0x8262,0x8263,0x8264,0x8265,0x8266,
	0x8267,0x8268,0x8269,0x826a,0x826b,0x826c,0x826d,0x826e,
	0x826f,0x8270,0x8271,0x8272,0x8273,0x8274,0x8275,0x8276,
	0x8277,0x8278,0x8279,0x816d,0x818f,0x816e,0x814f,0x8151,
	0x8165,0x8281,0x8282,0x8283,0x8284,0x8285,0x8286,0x8287,
	0x8288,0x8289,0x828a,0x828b,0x828c,0x828d,0x828e,0x828f,
	0x8290,0x8291,0x8292,0x8293,0x8294,0x8295,0x8296,0x8297,
	0x8298,0x8299,0x829a,0x816f,0x8162,0x8170,0x8150,0x8140,
	0x8140,0x8140,0x8140,0x8140,0x819b,0x819c,0x82f0,0x829f, /* Japanese */
	0x82a1,0x82a3,0x82a5,0x82a7,0x82e1,0x82e3,0x82e5,0x82c1,
	0x8140,0x82a0,0x82a2,0x82a4,0x82a6,0x82a8,0x82a9,0x82ab,
	0x82ad,0x82af,0x82b1,0x82b3,0x82b5,0x82b7,0x82b9,0x82bb,
	0x8140,0x8142,0x8175,0x8176,0x8141,0x8145,0x8392,0x8340,
	0x8342,0x8344,0x8346,0x8348,0x8383,0x8385,0x8387,0x8362,
	0x815b,0x8341,0x8343,0x8345,0x8347,0x8349,0x834a,0x834c,
	0x834e,0x8350,0x8352,0x8354,0x8356,0x8358,0x835a,0x835c,
	0x835e,0x8360,0x8363,0x8365,0x8367,0x8369,0x836a,0x836b,
	0x836c,0x836d,0x836e,0x8371,0x8374,0x8377,0x837a,0x837d,
	0x837e,0x8380,0x8381,0x8382,0x8384,0x8386,0x8388,0x8389,
	0x838a,0x838b,0x838c,0x838d,0x838f,0x8393,0x814a,0x814b,
	0x82bd,0x82bf,0x82c2,0x82c4,0x82c6,0x82c8,0x82c9,0x82ca,
	0x82cb,0x82cc,0x82cd,0x82d0,0x82d3,0x82d6,0x82d9,0x82dc,
	0x82dd,0x82de,0x82df,0x82e0,0x82e2,0x82e4,0x82e6,0x82e7,
	0x82e8,0x82e9,0x82ea,0x82eb,0x82ed,0x82f1,0x8140,0x8140,
};

unsigned h2zen2(c)
unsigned c;
{
	if (c < 32){
		return(c);
	}else{
		return(_CMAPM[c-32]);
	}
}

unsigned z2han2(c)
unsigned c;
{
	int i;
	for (i = 0;i < 224;i++){
		if (_CMAPM[i] == c){
			return((unsigned)(i+32));
		}
	}
	return(c);
}

unsigned _CMAPG[] = {
	0x8140,0x8c8e,0x89ce,0x9085,0x96d8,0x8be0,0x9379,0x93fa, /* @ΐ؋y */
	0x944e,0x897e,0x8e9e,0x95aa,0x9562,0x9553,0x90e7,0x969c, /* N~bS疜 */
	0x83ce,0x84a8,0x84a6,0x84a7,0x84a5,0x84a9,0x84a0,0x849f, /* ΄ */
	0x84a1,0x84a2,0x84a4,0x84a3,0x817e,0x91e5,0x9286,0x8fac  /* ~咆 */
};

void dispmg(c)
char c;
{
	unsigned int cx;
	
	cx = _CMAPG[c - 0x40];
	printf("%c%c",(char)(cx >> 8),(char)(cx & 0x00ff));
}

char mode;

void mkf(fpi)
FILE *fpi;
{
	int c;
	char c2;
	unsigned int c3;

	while((c = getc(fpi)) != EOF){
		c2 = (char)c;
		if (c2 < 128){
			if (c2 == 1){ /* MSX Graphic Char. (2 Byte) */
				c = getc(fpi);
				dispmg((char)c);
			}else{
				switch(mode){
					case 0:
					case 2:
						putc(c2,stdout);
					break;
					case 1:
						if (c < 32){
							putc(c2,stdout);
						}else{
							c3 = h2zen2((unsigned)c2);
							putc((char)(c3 >> 8),stdout);
							putc((char)(c3 & 0x00ff),stdout);
						}
					break;
				}
			}
		}else{
			if ((c2 < 0xa0) || (c2 > 0xdf)){ /* MSX Hiragana */
				c3 = h2zen2((unsigned)c2);
				putc((char)(c3 >> 8),stdout);
				putc((char)(c3 & 0x00ff),stdout);
			}else{ /* Katakana */
				if (mode == 2){
					putc(c2,stdout);
				}else{
					c3 = h2zen2((unsigned)c2);
					putc((char)(c3 >> 8),stdout);
					putc((char)(c3 & 0x00ff),stdout);
				}
			}
		}
	}
}

void usage()
{
	fprintf(stderr,"Usage:MKF Option or filename ...\nOption:\n/Z:Convert ALL\n/M:Convert only MSX Characters\n/H,/?:Display this\n\n");
}

int main(argc,argv)
int argc;
char *argv[];
{
	int i,f;
	FILE *fpi;

	f = 0;
	mode = 0;

	if (argc > 1){
		for (i = 1;i < argc;i++){
			if ((argv[i][0] == '-') || (argv[i][0] == '/')){
				switch(toupper(argv[i][1])){
					case 'Z':
						mode = 1;
					break;
					case 'M':
						mode = 2;
					break;
					case 'H':
					case '?':
						usage();
						exit(1);
					break;
				}
			}else{
				if ((fpi = fopen(argv[i],"r")) == NULL){
					fprintf(stderr,"Can't open %s\n",argv[i]);
					exit(2);
				}
				mkf(fpi);
				f++;
				fclose(fpi);
			}
		}
	}
	
	if (f == 0){
		mkf(stdin);
	}
	return(0);
}
