#pragma nonrec
#include	<stdio.h>
#include	<glib.h>
#include	<macatck.h>
#include	<uty.h>

char sprpat[] = {
	0x40,0x40,0xC0,0xE0,0xF0,0xFB,0xFF,0xEF,0xE4,0xEC,0xFC,0xFF,0xE7,0xE7,0x43,0x41, /* My ship(0) */
	0x04,0x04,0x06,0x0E,0x1E,0xBE,0xFE,0xEE,0x4E,0x6E,0x7E,0xFE,0xCE,0xCE,0x84,0x04,
	0x00,0x01,0x1D,0x3F,0x7F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x3F,0x1E,0x0C, /* MaOintosh(4) */
	0xC0,0x80,0x38,0xFC,0xFE,0xF8,0xF8,0xF0,0xF0,0xF0,0xF0,0xF8,0xFE,0xFC,0x78,0x30,
	0x07,0x18,0x60,0x07,0x18,0x60,0x07,0x18,0x60,0x07,0x18,0x60,0x07,0x1D,0x62,0x28, /* My shot(8) */
	0xC0,0x30,0x0C,0xC0,0x30,0x0C,0xC0,0x30,0x0C,0xC0,0x30,0x0C,0xC0,0x30,0x2C,0x84,
	0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00, /* Mini MaO(12) */
	0x00,0x00,0x00,0x00,0x00,0x80,0x80,0xC0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
	0x66,0x3c,0x6e,0x6e,0x62,0x7e,0x3c,0xe7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* Clockun(16) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xff,0x81,0x81,0x81,0x81,0x81,0x81,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* Gear(20) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x03,0x0F,0x1F,0x3F,0x7F,0x7F,0xFF,0xFF,0xFF,0xFF,0x7F,0x7F,0x3F,0x1F,0x0F,0x03, /* Crash #0 (24) */
	0xC0,0xF0,0xF8,0xFC,0xFE,0xFE,0xFF,0xFF,0xFF,0xFF,0xFE,0xFE,0xFC,0xF8,0xF0,0xC0,
	0x03,0x0F,0x1F,0x3F,0x7F,0x7F,0xFF,0xFE,0xFE,0xFF,0x7F,0x7F,0x3F,0x1F,0x0F,0x03, /* Crash #1 (28) */
	0xC0,0xF0,0xF8,0xFC,0xFE,0xFE,0xFF,0x7F,0x7F,0xFF,0xFE,0xFE,0xFC,0xF8,0xF0,0xC0,
	0x03,0x0F,0x1F,0x3F,0x7F,0x7F,0xFE,0xFC,0xFC,0xFE,0x7F,0x7F,0x3F,0x1F,0x0F,0x03, /* Crash #2 (32) */
	0xC0,0xF0,0xF8,0xFC,0xFE,0xFE,0x7F,0x3F,0x3F,0x7F,0xFE,0xFE,0xFC,0xF8,0xF0,0xC0,
	0x03,0x0F,0x1F,0x3F,0x7F,0x7C,0xF8,0xF8,0xF8,0xF8,0x7C,0x7F,0x3F,0x1F,0x0F,0x03, /* Crash #3 (36) */
	0xC0,0xF0,0xF8,0xFC,0xFE,0x3E,0x1F,0x1F,0x1F,0x1F,0x3E,0xFE,0xFC,0xF8,0xF0,0xC0,
	0x03,0x0F,0x1F,0x3F,0x7C,0x78,0xF0,0xF0,0xF0,0xF0,0x78,0x7C,0x3F,0x1F,0x0F,0x03, /* Crash #4 (40) */
	0xC0,0xF0,0xF8,0xFC,0x3E,0x1E,0x0F,0x0F,0x0F,0x0F,0x1E,0x3E,0xFC,0xF8,0xF0,0xC0,
	0x03,0x0F,0x1F,0x3C,0x70,0x70,0xE0,0xE0,0xE0,0xE0,0x70,0x70,0x3C,0x1F,0x0F,0x03, /* Crash #5 (44) */
	0xC0,0xF0,0xF8,0x3C,0x0E,0x0E,0x07,0x07,0x07,0x07,0x0E,0x0E,0x3C,0xF8,0xF0,0xC0,
	0x03,0x0F,0x1C,0x30,0x60,0x60,0xC0,0xC0,0xC0,0xC0,0x60,0x60,0x30,0x1C,0x0F,0x03, /* Crash #6 (48) */
	0xC0,0xF0,0x38,0x0C,0x06,0x06,0x03,0x03,0x03,0x03,0x06,0x06,0x0C,0x38,0xF0,0xC0,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* Crash #7 (52) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

char sprcol[] = {
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x08,0x09,
	0x02,0x02,0x02,0x02,0x0A,0x0A,0x09,0x09,0x08,0x08,0x0D,0x0D,0x04,0x04,0x04,0x04,
	0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
	0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x0A,0x08,0x04,0x02,0x02,0x02,0x02,0x02,0x02,
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
	0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03

};

#pragma optimize space
VOID setsp()
{
	int i,j;
	char *c;

	/* Set pattern */
	setwrt(0x7800);
	c = sprpat;
	for (i = 0;i < 448;i++){
		outvdp(*c);
		c++;
	}
}

VOID setsc()
{
	int i,j;
	char *c;

	/* Set color */
	setwrt(0x7400);
	c = sprcol;
	for (i = 0;i < 16;i++){ /* My ship color */
		outvdp(*c);
		c++;
	}

	for (i = 0;i < 8;i++){ /* Shot color */
		c = sprcol + 32;
		for (j = 0;j < 16;j++){
			outvdp(*c);
			c++;
		}
	}

	for (i = 0;i < 10;i++){ /* MaOintosh color */
		c = sprcol + 16;
		for (j = 0;j < 16;j++){
			outvdp(*c);
			c++;
		}
	}

	for (i = 0;i < 11;i++){ /* Mini MaO color */
		c = sprcol + 48;
		for (j = 0;j < 16;j++){
			outvdp(*c);
			c++;
		}
	}

	c = sprcol + 80; /* Gear color */
	for (j = 0;j < 16;j++){
		outvdp(*c);
		c++;
	}

	c = sprcol + 64; /* Clockun color */
	for (j = 0;j < 16;j++){
		outvdp(*c);
		c++;
	}

}

/*
#define BLDBUF 4096
STATUS bloads(str)
char *str;
{
	FD fp;
	char *buf;
	unsigned cnt2,cnt3,s_adr,e_adr;
	if ((buf = malloc(BLDBUF)) == NULL){
		return(ERROR);
	}
	if ((fp = open(str,0)) == ERROR){
		free(buf);
		return(ERROR);
	}
	*buf = 0xfe;
	/* Header - check code 0xfe,start addr.,end addr.,run addr. - */
	if (read(fp,buf,1) < 1){
		close(fp);
		free(buf);
		return(ERROR);
	}
	if (buf[0] != 0xfe){
		close(fp);
		free(buf);
		return(ERROR);
	}
	if (read(fp,(char *)&s_adr,2) < 2){
		close(fp);
		free(buf);
		return(ERROR);
	}
	if (read(fp,(char *)&e_adr,2) < 2){
		close(fp);
		free(buf);
		return(ERROR);
	}
	*buf = 0;
	*(buf+1) = 0;
	if (read(fp,buf,2) < 2){
		close(fp);
		free(buf);
		return(ERROR);
	}
	/* Data */
	fsetwt((char)0,s_adr+0x8000);
	while ((cnt2 = read(fp,buf,BLDBUF)) == BLDBUF){
		for (cnt3 = 0;cnt3 < cnt2;cnt3++){
			outvdp(*(buf + cnt3));
		}
	}
	for (cnt3 = 0;cnt3 < cnt2;cnt3++){
		outvdp(*(buf + cnt3));
	}
	close(fp);
	free(buf);
	return(OK);
}
*/

VOID vputs(x,y,s)
unsigned int x;
unsigned int y;
char *s;
{

	glocate(x,y);

	while(*s){
		grpprt(*s,(char)0);
		s++;
	}
}

BOOL title(hi_sc,rank,hinm)
unsigned int hi_sc;
unsigned *rank;
char hinm[][4];
{
	char s1,s2,sp,se,sr,tt;
	char buf[20];

	color((char)15,(char)1,(char)1);
	cls();

	star();
	cpyv2v(0,0,103,63,(char)1,76,74,(char)0,(char)0);

	while(gtrigx((char)1) != 0){}
	while(gtrigx((char)3) != 0){}
	TIME = 0;
	tt = 0;
	do{
		sp = gtrigx((char)0);
		s1 = gtrigx((char)1);
		s2 = gtrigx((char)3);
		se = 0;
		if ((snsmat((char)7) & 0x04) == 0){ /* ESC Key */
			se = 1;
		}
		sr = 0;
		if (gstckx() == 9){
			sr = 1;
		}
		if (TIME > 450){
			cls();
			star();
			tt++;
			if (tt > 3){
				tt = 0;
			}
			switch(tt){
				case 0:
					cpyv2v(0,0,103,63,(char)1,76,74,(char)0,(char)0);
				break;
				case 1:
					color((char)1,(char)15,(char)1);
					cpyv2v(128,0,247,55,(char)1,68,78,(char)0,(char)0);
					sprintf(buf,"%5u00",hi_sc);
					vputs(68+56,78+40,buf);
					color((char)15,(char)1,(char)1);
				break;
				case 2:
					cpyv2v(128,56,247,143,(char)1,68,62,(char)0,(char)0);
				break;
				case 3:
					disphs(rank,hinm,11);
				break;
				default:;
				break;
			}
			TIME = 0;
		}
	}while((s1 == 0) && (s2 == 0) && (sp == 0) && (se == 0) && (sr == 0));

	while(gstckx() == 9){}

	cls();
	if ((s2 == 0) && (se == 0)){
		return(YES);
	}else{
		return(NO);
	}
}

VOID dispsc(sc,hi_sc)
unsigned int sc;
unsigned int hi_sc;
{
	char buf[20];

	color((char)1,(char)15,(char)1);
	cpyv2v(0,104,119,151,(char)1,68,82,(char)0,(char)0);

	sprintf(buf,"%5u00",sc);
	vputs(68+56,82+24,buf);
	sprintf(buf,"%5u00",hi_sc);
	vputs(68+56,82+32,buf);

	TIME = 0;
	while(TIME < 300){}
	dispon();
	inipos();
	/* redisp(); */
	dispf = 1;
	while(dispf){} /* Wait */

	dispoff();
	color((char)15,(char)1,(char)1);
	cls();
}

VOID miss(t)
unsigned int t;
{
	char buf[20];
	int lf;

	color((char)1,(char)15,(char)1);
	cpyv2v(0,64,111,103,(char)1,72,86,(char)0,(char)0);

	lf = 10800-t;
	if (lf <= 0){
		sprintf(buf,"%3u",0);
	}else{
		sprintf(buf,"%3u",lf/60);
	}

	vputs(72+48,86+24,buf);

	TIME = 0;
	while(TIME < 104){}
	color((char)15,(char)1,(char)1);
	cls();
	star();
	tline();
}

VOID star()
{
	int i;

	disscr();
	for (i = 0;i < 100;i++){
		pset(rndx(256),rndx(212),(char)10,(char)0);
	}
	enascr();
}

VOID tline()
{
	line(0,84,11,84,(char)10,(char)0);
	cpyv2v(112,0,119,46,(char)1,0,121,(char)0,(char)0);
}
