#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<dos.h>
#include	<dos2.h>
#include	<conio.h>
#include	"lfnkill.h"


static char *what = "@(#)Long File Name KILLer Version 0.20 Tatsu Version\nBy Tatsuhiko Syoji 1999,2000";
unsigned char diagmode;
char query = 1;

void usage()
{
	printf("%s\n\nUsage:\nLFNKILL [Drive:][path] [Option]...\nOption:\n/?,/H Display this message\n/N Delete LFN without query\n/D Diagnostic mode\n",what+4);
	exit(1);
}

int parse_opt(int argc,char *argv[])
{
	int i,path_arg;

	path_arg = 0;

	for(i = 1;i < argc;i++){
		if (argv[i][0] == '/' || argv[i][0] == '-'){ /* Option */
			switch (toupper(argv[i][1])){
				case '?':
				case 'H':
					usage();
				break;
				case 'D':
					diagmode = 1;
				break;
				case 'N':
					query = 0;
				break;
				default:
					fprintf(stderr,"Error:Illegal option.\n");
					exit(1);
				break;
			}
		}else{
			if (path_arg == 0){ /* ŏ̂̕ݗL */
				path_arg = i;
			}
		}
	}
	return(path_arg);
}

void lfnkill(unsigned int start,unsigned int end)
{
	unsigned int i;

	if (diagmode){
		printf("Start entry NO.%x(%u) End entry NO.%x(%u)\n",start,start,end,end);
	}
	for (i = start;i <= end;i++){
		dir[i].name[0] = 0xe5;
	}
}

int exmain(void)
{
	unsigned char lf,write_flag,answer;
	unsigned int i,j,bufsize,start,end;

	lf = 0;
	write_flag = 0;
	for (i = 0;i < maxentry;i++){
#ifdef DEBUG
		printf("\n%d ",i);
#endif
		if (dir[i].name[0] == '\0'){ /* No more file */
			if (lf){
				printf("Broken LFN...Kill!\n");
				lfnkill(start,end);
				lf = 0;
				write_flag = 1;
			}
			break;
		}
		if (dir[i].name[0] == 0xe5){ /* Deleted file */
			if (lf){
				printf("Broken LFN...Kill!\n");
				lfnkill(start,end);
				lf = 0;
				write_flag = 1;
			}
			continue;
		}else if (dir[i].attr == 0x0f && dir[i].entry == 0){ /* Long File Name */
			for (j = i;j < maxentry;j++){
				if (dir[j].attr != 0x0f || dir[j].entry != 0){
					break;
				}
			}
			j--;
			start = i;
			end = j;
			lf = chklfn(i,j,ldir);
			i = j; /* Skip LFN?s */
		}else{ /* Short File Name */
			if (lf == 0){
				continue;
			}
			printf("SFN = %8.8s %3.3s ",dir[i].name,dir[i].ext);
			if (dir[i].attr & 0x10){ /* fBNg */
				printf("(DIR)\n");
			}else if (dir[i].attr & 0x08){ /* {[x */
				printf("(VOL)\n");
			}else{
				printf("(FILE)\n");
			}

			if (lf){
				if (chknamesum(&(dir[i])) != ldir[i-1].chksum){ /* `FbNlĂȂ */
					printf("Broken LFN...Kill!\n");
					lfnkill(start,end);
					write_flag = 1;
				}else{
					printf("LFN = %s\n",longname);
					if (query){
						fprintf(stderr,"Delete OK? ");
						answer = getche();
						fprintf(stderr,"\n");
						if (toupper(answer) == 'Y'){
							lfnkill(start,end);
							write_flag = 1;
						}
					}else{
						lfnkill(start,end);
						write_flag = 1;
					}
				}
			}
			lf = 0;
		}
	}
	return(write_flag);
}
