#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<dos.h>
#include	<dos2.h>

#define DIRBUF 16384 /* 256 entrys */

/* directory entry(MSX-DOS) */
struct dirent {
	unsigned char name[8];
	unsigned char ext[3];
	unsigned char attr;
	unsigned char reserve[10];
	unsigned int time;
	unsigned int date;
	unsigned int entry;
	unsigned long size;
};

struct lfnent {
	unsigned char entry;
	unsigned int name1[5];
	unsigned char attr;
	unsigned char reserve;
	unsigned char chksum;
	unsigned int name2[6];
	unsigned int entry;
	unsigned int name3[2];
};

unsigned char chknamesum(struct dirent *);
unsigned char _megascsi_absread(void *,unsigned char,unsigned long,int);
int chkmegascsi(void);

unsigned char *fatbuf;
struct DPB *dp;
struct dirent *dir; /* fBNgGg̃obt@ */
struct lfnent *ldir;
unsigned char isdos2,isfat16;
unsigned int chainbuf[64],maxentry;
unsigned char truepath[256]; /* Win95/98VFATł255ȉ */
unsigned char longname[257];
static unsigned long fb_top,fb_end; /* obt@ɓĂFAT͈̔ */

/* ec[ɌŗL̊֐ */
int parse_opt(int,char *[]);
int exmain(void);

/* #define DEBUG 1 */

/* long file name handling functions */
int unccat(unsigned char *dst,unsigned int *src,int len)
{
	unsigned char *d;

	d = dst;
	while(*d){
		d++;
	}

	while(*src != 0){
		/* 蔲unicode->ASCIIϊ */
		if (*src > 0x1f && *src < 0x80){ /* ASCII characters */
			*d = *src;
		}else{
			if (*src > 0xff60 && *src < 0xffa0){ /* pJ^Ji */
				*d = *src - 0xfec0;
			}else{
				*d = '?';
			}
		}
		d++;
		len--;
		if (len == 0){
			break;
		}
		src++;
	}
	*d = '\0';
	if (len > 0){
		return(1);
	}
	return(0);
}

int chklfn(int start,int end,struct lfnent *ldir)
{
	int i;
	unsigned char lent;

	lent = 0;
	longname[0] = '\0';

	for (i = end;i >= start;i--){
		if (ldir[end].chksum != ldir[i].chksum){
			return(0);
		}
		if (lent != (ldir[i].entry-1) && (lent+0x41) != (ldir[i].entry)){
			return(0);
		}

		if (unccat(longname,ldir[i].name1,5)){
			break;
		}
		if (unccat(longname,ldir[i].name2,6)){
			break;
		}
		if (unccat(longname,ldir[i].name3,2)){
			break;
		}

		if ((lent+0x41) == (ldir[i].entry)){
			break;
		}else{
			lent = ldir[i].entry;
		}
	}
	return(1);
	/* printf("%s\n",longname); */
}

/* directory handling functions */

int sfncmp(unsigned char *sfn,unsigned char *dirname)
{
	int i;
	for (i = 0;i < 11;i++){
		if (sfn[i] == ' ' && *dirname == '\0'){
			break;
		}
		if (*dirname == '.'){
			i = 8;
			dirname++;
		}
		if (toupper(sfn[i]) != toupper(*dirname)){
			return(1);
		}
		dirname++;
	}
	return(0);
}

unsigned char absread(void *buf,unsigned char drive,unsigned long start_sector,int sectors)
{
	if (isfat16){
		if (_megascsi_absread(buf,drive,start_sector,sectors)){
			fprintf(stderr,"Error:Disk read error.\n");
			free(dir);
			free(fatbuf);
			return(1);

		}
	}else{
		_dos_absread(buf,drive,start_sector,sectors);
	}
}

unsigned char abswrite(void *buf,unsigned char drive,unsigned long start_sector,int sectors)
{
	if (isfat16){
		fputs("Error:FAT16 is not supported.",stderr);
/*
		if (_megascsi_abswrite(buf,drive,start_sector,sectors)){
			free(dir);
			free(fatbuf);
			return(1);

		}
*/
	}else{
		_dos_abswrite(buf,drive,start_sector,sectors);
	}
}


unsigned int finddir(unsigned char *dirname)
{
	unsigned char lf;
	unsigned int i,j;

#ifdef DEBUG
	printf("Directory %s searching...",dirname);
#endif

	lf = 0;
	for (i = 0;i < maxentry;i++){
		if (dir[i].name[0] == '\0'){ /* No more file */
			break;
		}
		if (dir[i].name[0] == 0xe5){ /* Deleted file */
			continue;
		}else if (dir[i].attr == 0x0f && dir[i].entry == 0){ /* Long File Name */
			for (j = i;j < maxentry;j++){
				if (dir[j].attr != 0x0f || dir[j].entry != 0){
					break;
				}
			}
			j--;
			lf = chklfn(i,j,ldir);
			i = j;
		}else{ /* Short File Name */
			if (dir[i].attr & 0x10){ /* fBNg */
				if (sfncmp(dir[i].name,dirname) == 0){
					return(dir[i].entry);
				}else if (lf){
					if (chknamesum(&(dir[i])) == ldir[i-1].chksum){ /* `FbNlĂ */
						if (stricmp(longname,dirname) == 0){
							return(dir[i].entry);
						}
					}
				}
			}

			lf = 0;
		}
	}
	return(0xffff);
}

unsigned int getfat(unsigned char drive,unsigned int cl) /* Ok */
{
	unsigned int fe,nc,ss,cx;
	unsigned long int sec;

	if (isfat16){ /* FAT16 file system */
		/* printf("FAT entry %u seeking...\n",cl); */
		sec = (unsigned long)cl * 2 / dp->sec_size + dp->fat_start; /* Ԗڂ̃ZN^ɓĂ邩? */
		if (sec < fb_top || sec > fb_end){ /* obt@̒ɂȂ */
			absread(fatbuf,drive,sec,8192 / dp->sec_size);
			fb_top = sec;
			fb_end = sec + 8192 / dp->sec_size - 1;
		}

		cx = (sec - fb_top) * dp->sec_size + (cl << 1) % dp->sec_size;

		nc = (*(fatbuf + cx + 1) << 8) + *(fatbuf + cx);
	}else{ /* FAT12 file system */
		fe = (cl >> 1) * 3;
		if (cl & 1){
			nc = fatbuf[fe+2];
			nc = nc << 4;
			nc += (fatbuf[fe+1] >> 4);
		}else{
			nc = fatbuf[fe+1] & 0x0f;
			nc = nc << 8;
			nc += fatbuf[fe];
		}
		if (nc > 0xff6){
			nc += 0xf000;
		}
	}
	return(nc);
}

unsigned int readdir(unsigned char drive,unsigned int cl) /* Ok */
{
	unsigned int i,cs,cc;
	unsigned long sec;

	if (cl == 0){ /* root directory */
		if (((dp->data_start - dp->dir_start) * dp->sec_size) > DIRBUF){
			maxentry = DIRBUF / 32;
			absread(dir,drive,dp->dir_start,DIRBUF / dp->sec_size);
		}else{
			maxentry = (dp->data_start - dp->dir_start) * dp->sec_size / 32;
			absread(dir,drive,dp->dir_start,dp->data_start - dp->dir_start);
		}
	}else{
		cs = DIRBUF / (dp->sec_size * (dp->clu_mask+1));
		cc = (dp->sec_size * (dp->clu_mask+1)) / 32;
		for (i = 0;i < cs;i++){
			chainbuf[i] = cl;
			sec = dp->data_start + ((unsigned long)cl-2)*(dp->clu_mask+1);
			absread(dir + (cc*i),drive,sec,dp->clu_mask + 1);
			cl = getfat(drive,cl);
			if (cl > 0xfff6){
				i++;
				break;
			}
		}
		chainbuf[i] = 0xffff;
		maxentry = cc * i;
	}
}

unsigned int writedir(unsigned char drive,unsigned int cl) /* Ok */
{
	unsigned int i,cs,cc;
	unsigned long sec;

	if (cl == 0){ /* root directory */
		if (((dp->data_start - dp->dir_start) * dp->sec_size) > DIRBUF){
			maxentry = DIRBUF / 32;
			abswrite(dir,drive,dp->dir_start,DIRBUF / dp->sec_size);
		}else{
			maxentry = (dp->data_start - dp->dir_start) * dp->sec_size / 32;
			abswrite(dir,drive,dp->dir_start,dp->data_start - dp->dir_start);
		}
	}else{
		cs = DIRBUF / (dp->sec_size * (dp->clu_mask+1));
		cc = (dp->sec_size * (dp->clu_mask+1)) / 32;
		for (i = 0;i < cs;i++){
			chainbuf[i] = cl;
			sec = dp->data_start + ((unsigned long)cl-2)*(dp->clu_mask+1);
			abswrite(dir + (cc*i),drive,sec,dp->clu_mask + 1);
			cl = getfat(drive,cl);
			if (cl > 0xfff6){
				i++;
				break;
			}
		}
		chainbuf[i] = 0xffff;
		maxentry = cc * i;
	}
}

extern void _cwd(void);
extern char _cwd_buf[];

/* JghCuEfBNg擾 */
char *getcwd(char *buf,int n)
{
	_cwd();

	if (buf == NULL){
		if ((buf = malloc(strlen(_cwd_buf)+1)) == NULL){
			return(NULL);
		}
	}

	if (strlen(_cwd_buf) > n){ /* full path name is too long */
		return(NULL);
	}else{
		strcpy(buf,_cwd_buf);
		return(buf);
	}
}

/* LSI-C̐^ */
void _dos_getdrive(unsigned *drive)
{
	char a;
	a = msx_bdos((char)0x19,0,0);
	*drive = (unsigned)a;
}

void _dos_setdrive(unsigned drive,unsigned *drives)
{
	char a;
	int hl,i;
	a = msx_bdos((char)0x0e,(int)drive,0);

	hl = msx_bdosh((char)0x18,0,0);
	*drives = 0;
	for (i = 0;i < 16;i++){
		if (hl & 0x0001){
			(*drives)++;
		}
		hl = hl >> 1;
	}
}

/* getcwd͐V */
int getdir(unsigned char drive,unsigned char *path)
{
	unsigned int dirc,i,chd;
	unsigned char *np;
	MSXFIB fib;

	if (isdos2){
		if (*path == '\\' || *path == '/'){ /* absolute specification */
			dirc = 0;
			path++;
			*truepath = drive + 'A';
			strcpy(truepath+1,":\\");

		}else{ /* relative specification */
			/* JghCu擾 */
			_dos_getdrive(&chd);
			/* JghCuhCuɂB */
			/* getcwd()̓JghCũJgfBNg邽߁B */
			/* hCuƂTÔȂUNIX`̂߂̎dlłB */
			_dos_setdrive(drive,&i);
			getcwd(truepath,255);
			/* JghCu߂B */
			_dos_setdrive(chd,&i);

			if (strlen(truepath) > 3){
				if (findfirst(truepath,0x12,&fib)){ /* not found */
#ifdef DEBUG
					printf("Can't get current directory\n");
#endif
					return(1);
				}else{
					dirc = fib.cl;
					strcat(truepath,"\\");
				}
			}else{
				dirc = 0;
			}
		}
		strcat(truepath,path);
	}else{
		*truepath = drive + 'A';
		strcpy(truepath+1,":\\");
		if (*path == '\\' || *path == '/'){
			path++;
		}
		strcat(truepath,path);
		dirc = 0;
	}
#ifdef DEBUG
	printf("1st search directory's Cluster:%x\n",dirc);
#endif
	/* path:next directory name */
	readdir(drive,dirc);
	/* Ok! */

#ifdef DEBUG
	printf("Full path: %s\nSearch path: %s\n",truepath,path);
	for (i = 0x80;i < 0x100;i++){
		printf("%02x  ",(int)(*(unsigned char *)i));
	}
#endif

	for (np = strtok(path,"\\/");np != NULL;np = strtok(NULL,"\\/")){
#ifdef DEBUG
		printf("Next directory %x\n",(unsigned int)path);
#endif
		dirc = finddir(np);
#ifdef DEBUG
		printf("%x\n",dirc);
#endif

		if (dirc == 0xffff){ /* Directory not found */
			return(1);
		}else{
			readdir(drive,dirc);
		}
	}
	printf(" Directory of %s\n",truepath);

	return(0);
}

int main(int argc,char *argv[])
{
	unsigned char drive,lf,*path,*dc,*p;
	unsigned int i,j,bufsize,dosver,path_arg;

	isfat16 = 0;
	dosver = _dos_getver();
	if (dosver >= 0x200){ /* DOS2̊KwfBNgT|[g */
		isdos2 = 1;
	}else{
		isdos2 = 0;
	}

	path_arg = parse_opt(argc,argv);
	/* parse only drive name for getting DPB */
	if (path_arg == 0){
		/* drive = msx_bdos(0x19,0,0); */
		_dos_getdrive(&drive);
		path = "";
	}else{
		if ((dc = strchr(argv[path_arg],':')) == NULL){
			/* drive = msx_bdos(0x19,0,0); */
			_dos_getdrive(&drive);
			path = argv[path_arg];
		}else{
			if (!isalpha(*(dc-1))){ /* illegal drive name */
				usage();
			}else{
				drive = toupper(*(dc-1)) - 'A';
				path = dc + 1;
			}
		}
	}

	/* FATɎgmۂB */
	dp = _dos_getDPB(drive+1);

	/* fBNgobt@̓TCYŒƂBTufBNgł́AfBXNeʂ̌t@C邩炫肪Ȃ */
	if ((dir = (struct dirent *)malloc(DIRBUF)) == NULL){
		fprintf(stderr,"Error:No enough Directory buffer memory.\n");
		exit(1);
	}
	ldir = (struct lfnent *)dir;
	_dos_absread(dir,drive,0,1); /* Read boot sector */

	/* fprintf(stderr,"%5.5s\n",(unsigned char *)((unsigned char *)dir + 0x36)); */
	if (memcmp((unsigned char *)((unsigned char *)dir + 0x36),"FAT16",5) == 0){
		isfat16 = 1;
		fputs("Error:FAT16 is not supported.",stderr);
		if (!chkmegascsi()){ /* Reserved for other implementation of FAT16 */
			fprintf(stderr,"Error:MEGA-SCSI not found.\n");
		}
		free(dir);
		exit(1);
	}

	/* bufsize = (dp->dir_start - dp->fat_start) / dp->fat_copy * dp->sec_size; */
	bufsize = 8192; /* FAT12ł͂ꂾΑBFAT16ł́AKvɂȂǂށB */
	if ((fatbuf = (struct dirent *)malloc(bufsize)) == NULL){
		fprintf(stderr,"Error:No enough FAT buffer memory.\n");
		free(dir);
		exit(1);
	}

	/* FATǂݍ */
	if (isfat16){
		absread(fatbuf,drive,dp->fat_start,8192 / dp->sec_size);
		fb_top = dp->fat_start;
		fb_end = dp->fat_start + 8192 / dp->sec_size - 1;
	}else{
		absread(fatbuf,drive,dp->fat_start,(dp->dir_start - dp->fat_start) / dp->fat_copy);
	}

	/* fBNgǂݍ */
	if (getdir(drive,path)){
		printf("Directory not found\n");
		free(dir);
		free(fatbuf);
		return(1);
	}

	if (exmain()){
		writedir(drive,chainbuf[0]);
	}

	free(dir);
	free(fatbuf);
	return(0);
}
