;Copyright (c) 1998-2000 Tatsuhiko Syoji, Japan . All rights reserved.
;
;Redistribution and use in source and binary forms, with or without
;modification, are permitted provided that the following conditions are
;met:
;
;1 Redistributions of source code must retain the above copyright notice,
; this list of conditions and the following disclaimer as the first lines
; of this file unmodified.
;
;2 Redistributions in binary form must reproduce the above copyright
;notice, this list of conditions and the following disclaimer in the
;documentation and/or other materials provided with the distribution.
;
;THIS SOFTWARE IS PROVIDED BY Tatsuhiko Syoji ``AS IS'' AND ANY EXPRESS
;ORIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL Tatsuhiko Syoji BE LIABLE FOR ANY DIRECT,
; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
;(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
;SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
;STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
;IN
; ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
;POSSIBILITY OF SUCH DAMAGE.

;Interrpt sample for Kinrou-5th for HI-TECH C

	org	4000H

;In this file
	global	_inton,_intoff
	global	_kinrou_intflag

timi	equ	0fd9fh
jpcode	equ	0f7h
MINTER	equ	6029H		;Kinrou 5th's interrupt entry

_inton:
	di
	ld	hl,timi
	ld	de,intsav
	ld	bc,5
	ldir
	ld	a,jpcode
	ld	(timi),a
	ld	a,(0f342h)
	ld	(timi+1),a
	ld	hl,intmain
	ld	(timi+2),hl
	ld	a,0c9H
	ld	(timi+4),a
	ei
	ret

_intoff:
	di
	ld	hl,intsav
	ld	de,timi
	ld	bc,5
	ldir
	ei
	ret

intsav:
	nop
	nop
	nop
	nop
	ret

intflag:
	defb	0ffh

intmain:
	di
	push	af
	push	hl
	push	de
	push	bc
	push	ix
	push	iy

	ld	a,(intflag)
	and	a
	jp	z,qrtint
	xor	a
	ld	(intflag),a

	ld	a,(_kinrou_intflag)
	and	a
	call	nz,MINTER

iend:

ocall:
	call	intsav		;call old int
	ld	a,0ffh
	ld	(intflag),a
qrtint:
	pop	iy
	pop	ix
	pop	bc
	pop	de
	pop	hl
	pop	af
	ei
	ret

_kinrou_intflag:
	defb	0

	end
