/*
 * Copyright (c) 1998-2000 Tatsuhiko Syoji, Japan . All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * 1 Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer as the first lines
 *  of this file unmodified.
 *
 * 2 Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY Tatsuhiko Syoji ``AS IS'' AND ANY EXPRESS
 * ORIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL Tatsuhiko Syoji BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include	<stdio.h>
#include	<msxio.h>
#include	<stdlib.h>
#include	<conio.h>
#include	<ctype.h>
#include	<memutil.h>
#include	"d:kinrou.h"

void inton(void);
void intoff(void);
extern unsigned char kinrou_intflag;

int main(int argc,char *argv[])
{
	char *buf;
	int fp;
	unsigned int c,v;
	char s,pf;

	if (argc < 2){
		exit(1);
	}

/* Notes
  ftHgł́Amalloc͉ʃ烁tĂ̂ŁA
y[W0mallocmۂubN󋵂B
ŁAy[W0ɋȃf[^[hĂ܂ƁA荞݃[`
ĂяoꂽΘJ5̉t[`͋ȃf[^ꂸA
ȂtȂ/ςȉƂ󋵂邱ƂɂȂB
*/
	setheaptop(0x8000);

	if ( (buf = malloc(8192)) == NULL){
		exit(1);
	}

	if ((fp = open("KINROU5.DRV",0)) == -1){
		free(buf);
		exit(1);
	}
	if (read(fp,(unsigned char *)0x5ff9,0x2007) == 0){
		free(buf);
		close(fp);
		exit(1);
	}
	close(fp);

	fprintf(stderr,"Driver load OK !\n");

	if ((fp = open(argv[1],0)) == -1){
		free(buf);
		exit(1);
	}

	if (read(fp,buf,8192) == 0){
		close(fp);
		exit(1);
	}
	close(fp);
	fprintf(stderr,"Music file load OK !\n");
	kinrou_init(); /* sȂƉsꂸAPSGȂB */

	kinrou_intflag = 0;
	inton();

	if (kinrou_play2(buf,0)){
		fprintf(stderr,"Setup error.\n");
		intoff();
		free(buf);
		exit(1);
	}
	kinrou_intflag = 1;

	do{
		while(kbhit()){}

		c = getch(); /* AāAtxwƁAdȂ? */
		c = toupper(c);
		switch(c){
			case 'P':
				kinrou_play2(buf,0);
				kinrou_intflag = 1;
				pf = 1;
			break;
			case 'S':
				kinrou_pause();
			break;

			case 'F':
				kinrou_fadeout(16);
				kinrou_intflag = 0;
			break;
			case 'V':
				v++;
				if (v > 15){
					v = 0;
				}
				kinrou_vol(v);
			break;
		}
	}while(c != 'Q');
	kinrou_stop();
	kinrou_intflag = 0;

	intoff();
 	free(buf);

	return(0);

}
