--
	psect text
bdos	equ	0005h

-dosver.as
	global	__dos_getver

__dos_getver:
	push	ix
	push	iy

	ld	c,6fh
	call	bdos
	or	a
	jp	nz,notmdos
	ld	a,b
	cp	2
	jp	c,isdos1

isdos2:
	ex	de,hl
	pop	iy
	pop	ix
	ret

notmdos:
	ld	hl,0
	pop	iy
	pop	ix
	ret
isdos1:
	ld	hl,0100H
	pop	iy
	pop	ix
	ret

-GETDPB.AS
;struct DPB *_dos_getDPB(unsigned char drive)

	global	__dos_getDPB

__dos_getDPB:
	pop	hl
	pop	de
	push	de
	push	hl

	push	ix
	push	iy

	ld	c,1bh
	call	bdos
	push	ix
	pop	hl

	pop	iy
	pop	ix
	ret

-PHREAD.AS
;unsigned char _PHYDIO_read(char *buf,unsigned char drive,unsigned sector,unsigned char len,unsigned char mediaid)

	global	csv,cret

	global	__PHYDIO_read

exptbl	equ	0fcc1h
PHYDIO	equ	0ffa7h
CALSLT	equ	001ch

__PHYDIO_read:

	call	csv

	ld	l,(ix+6)	;buf
	ld	h,(ix+7)

	ld	a,(ix+8)	;drive

	ld	e,(ix+10)	;Sector
	ld	d,(ix+11)

	ld	b,(ix+12)	;Number of sectors

	ld	c,(ix+14)	;Media ID

	push	iy
	push	ix

	ld	iy,(exptbl-1)
	ld	ix,0144h
	or	a		;reset carry flag
	call	CALSLT		;CALSLT

	pop	ix
	pop	iy

	jp	c,cantread

	ld	hl,0
	jp	cret

cantread:
	ld	h,0
	ld	l,a
	jp	cret

-PHWRITE.AS
;unsigned char _PHYDIO_write(char *buf,unsigned char drive,unsigned sector,unsigned char len,unsigned char mediaid)

	global	csv,cret

	global	__PHYDIO_write

exptbl	equ	0fcc1h
PHYDIO	equ	0ffa7h
CALSLT	equ	001ch

__PHYDIO_write:

	call	csv

	ld	l,(ix+6)	;buf
	ld	h,(ix+7)

	ld	a,(ix+8)	;drive

	ld	e,(ix+10)	;Sector
	ld	d,(ix+11)

	ld	b,(ix+12)	;Number of sectors

	ld	c,(ix+14)	;Media ID

	push	iy
	push	ix


	ld	iy,(exptbl-1)
	ld	ix,0144h
	scf		;cy set
	call	CALSLT	;CALSLT

	pop	ix
	pop	iy

	jp	c,cantwt

	ld	hl,0
	jp	cret

cantwt:
	ld	h,0
	ld	l,a
	jp	cret

--
#include	<msxio.h>

-ABSREAD.C
/* MSX-C Version 1.1Zbgrdsec֐LSI C-86 Zbg */
/* absread֐݊ */
void _dos_absread(buf,drv,sec,len)
char *buf;
int drv;
unsigned sec;
int len;
{
	int secx;
	msx_bdos((char)0x1a,buf,0);
	secx = (len << 8) + drv;
	msx_bdos((char)0x2f,sec,secx);
}

-ABSWRITE.C
/* MSX-C Version 1.1Zbgwtsec֐LSI C-86 Zbg */
/* abswrite֐݊ */
void _dos_abswrite(buf,drv,sec,len)
char *buf;
int drv;
unsigned sec;
int len;
{
	int secx;
	msx_bdos((char)0x1a,buf,0);
	secx = (len << 8) + drv;
	msx_bdos((char)0x30,sec,secx);
}

