#ifndef __CTYPE_H
#define __CTYPE_H

/*
 * improved toupper,tolower
 * added strupr, strlwr
 * PGN 12/93
 */

#define _U	0x01
#define	_L	0x02
#define	_N	0x04
#define	_S	0x08
#define _P	0x10
#define _C	0x20
#define	_X	0x40

extern	unsigned char	_ctype_[];	/* in libc.lib */

#define	isalpha(c)	((_ctype_+1)[c]&(_U|_L))
#define	isupper(c)	((_ctype_+1)[c]&_U)
#define	islower(c)	((_ctype_+1)[c]&_L)
#define	isdigit(c)	((_ctype_+1)[c]&_N)
#define	isxdigit(c)	((_ctype_+1)[c]&(_N|_X))
#define	isspace(c)	((_ctype_+1)[c]&_S)
#define ispunct(c)	((_ctype_+1)[c]&_P)
#define isalnum(c)	((_ctype_+1)[c]&(_U|_L|_N))
#define isprint(c)	((_ctype_+1)[c]&(_P|_U|_L|_N|_S))
#define isgraph(c)	((_ctype_+1)[c]&(_P|_U|_L|_N))
#define iscntrl(c)	((_ctype_+1)[c]&_C)
#define isascii(c)	(!((c)&0xFF80))
#define toascii(c)	((c)&0x7F)

extern char toupper(char);
extern char tolower(char);

/* By Tatsu */
/* Add _tolower,_toupper.By Tatsu 1997/1/4 */
#define	_tolower(c)	((c) - 'A' + 'a')
#define	_toupper(c)	((c) - 'a' + 'A')
int iscsymf(unsigned char);
int iscsym(unsigned char);

#endif /* __CTYPE_H */
