#ifndef	__MSXIO_H
#define	__MSXIO_H

/* header file for MSX-DOS I/O routines for Z-80 C */

/* get basic definitions */

#ifndef	_STDDEF
typedef	int		ptrdiff_t;	/* result type of pointer difference */
typedef	unsigned	size_t;		/* type yielded by sizeof */
#define	_STDDEF
#define	offsetof(ty, mem)	((int)&(((ty *)0)->mem))

#ifndef	NULL
#define	NULL	((void *)0)
#endif	NULL

extern int	errno;			/* system error number */
#endif	_STDDEF

/*	hitech.h has definitions for uchar, ushort etc */

#include	<hitech.h>
#if	z80
#define	MAXFILE		8	/* max number of files open */
#else	z80
#define	MAXFILE		15	/* max number of files open */
#endif	z80
#define	SECSIZE		128	/* no. of bytes per sector */

extern struct	msxfcb {
	uchar	dr;		/* drive code */
	char	name[8];	/* file name */
	char	ft[3];		/* file type */
	uchar	ex;		/* file extent */
	char	fil;		/* not used */
	unsigned int recsiz; /* record size */
	long	filesize;
	unsigned short fcbdate;
	unsigned short fcbtime;
	char	dm[8];		/* CP/M disk map */
	char	nr;		/* next record to read or write */
	long	rwp;		/* read/write pointer in bytes */
	uchar	use;		/* use flag */
	uchar	uid;		/* user id belonging to this file */
}	_mfcb[MAXFILE];

/* bdos call returning value in a */
unsigned char msx_bdos(unsigned int,...);
/* bdos call returning value in hl */
unsigned short msx_bdosh(unsigned int,...);
struct msxfcb *getfcb(void);
uchar setfcb(struct msxfcb *, char *);

/*	 flag values in fcb.use */

#define	U_READ	1		/* file open for reading */
#define	U_WRITE	2		/* file open for writing */
#define	U_RDWR	3		/* open for read and write */
#define	U_CON	4		/* device is console */
#define	U_RDR	5		/* device is reader */
#define	U_PUN	6		/* device is punch */
#define	U_LST	7		/* list device */

/*	 special character values */

#define	CPMETX	032		/* ctrl-Z, CP/M end of file for text */
#define	CPMRBT	003		/* ctrl-C, reboot CPM */


#define	MPM	0x100		/* bit to test for MP/M */
#define	CCPM	0x400		/* bit to test for CCP/M */

#define	ISMPM()	(bdoshl(CPMVERS)&MPM)	/* macro to test for MPM */

/*	 what to do after you hit return */

#define	EXIT	(*(int (*)())0)	/* where to go to reboot CP/M */

/*	 bdos calls etc. */

#define	CPMRCON	1		/* read console */
#define	CPMWCON	2		/* write console */
#define	CPMRRDR	3		/* read reader */
#define	CPMWPUN	4		/* write punch */
#define	CPMWLST	5		/* write list */
#define	CPMDCIO	6		/* direct console I/O */
#define	CPMGIOB	7		/* get I/O byte */
#define	CPMSIOB	8		/* set I/O byte */
#define	CPMRCOB	10		/* read console buffered */
#define	CPMICON	11		/* interrogate console ready */
#define	CPMVERS	12		/* return version number */

/*	BDOS calls */

#define	CPMRDS	13		/* reset disk system */
#define	CPMLGIN	14		/* log in and select disk */
#define	CPMOPN	15		/* open file */
#define	CPMCLS	16		/* close file */
#define	CPMFFST	17		/* find first */
#define	CPMFNXT	18		/* find next */
#define	CPMDEL	19		/* delete file */
#define	CPMREAD	20		/* read next record */
#define	CPMWRIT	21		/* write next record */
#define	CPMMAKE	22		/* create file */
#define	CPMREN	23		/* rename file */
#define	CPMILOG	24		/* get bit map of logged in disks */
#define	CPMIDRV	25		/* interrogate drive number */
#define	CPMSDMA	26		/* set DMA address for i/o */
#define	CPMSUID	32		/* set/get user id */
#define	CPMRRAN	33		/* read random record */
#define	CPMWRAN	34		/* write random record */
#define	CPMCFS	35		/* compute file size */

#define	O_RDONLY	0x00	/* Open for reading only */
#define	O_WRONLY	0x01	/* Open for writing only */
#define	O_RDWR		0x02	/* Open for reading and writing */

/* Declarations for chmod(). */
#define S_IWRITE 0x80
#define S_IREAD 0x100

/*
 *	Declarations for Unix style low-level I/O functions.
 */

int	open(char *, int);
int	close(int);
int	creat(char *,...);
int	dup(int);
long	lseek(int, long, int);
int	read(int, void *, int);
int	unlink(char *);
#define remove(f) unlink(f)
int	write(int, void *, int);
int	isatty(int);
int	chmod(char *, int);
int rename(char *,char *);

#endif /* __MSXIO_H */
