--
#include	<stdio.h>
-freopen.c
/*
 *	freopen.c - stdio freopen 
 */

extern int	open(char *, int), creat(char *, int);
long	lseek(int, long, int);

FILE *freopen(name, mode, iob)
char *	name, * mode;
register FILE *	iob;
{
	uchar		c;
	unsigned char flagb;

	fclose(iob);
	c = 0;
	iob->_flag &= _IONBF;
	switch(*mode) {
		case 'w':
			c++;
		case 'a':
			c++;
		case 'r':
			if (mode[1] == 'b'){
				iob->_flag = _IOBINARY;
			}
		break;
	}

	switch(c) {
		case 0: /* Read */
			iob->_file = open(name, 0);
		break;
		case 1: /* Append(Write) */
			if ((iob->_file = open(name, 2)) >= 0){
				break;
			} /* else fall through */
		case 2: /* Write */
			iob->_file = creat(name, 0666);
		break;
	}
	if (iob->_file < 0){
		return (FILE *)NULL;
	}
	if (!(iob->_flag & (_IONBF|_IOMYBUF))){
		iob->_base = _bufallo();
	}
	if (iob->_base == (char *)-1) {
		iob->_base = (char *)0;
		close(iob->_file);
		iob->_flag = 0;
		return (FILE *)NULL;
	}
	iob->_ptr = iob->_base;
	iob->_cnt = 0;
	if (c){
		iob->_flag |= _IOWRT;
	}else{
		iob->_flag |= _IOREAD;
	}
	if (iob->_base && c){
		iob->_cnt = BUFSIZ;
	}
	if (c == 1){
		if (iob->_flag & _IOBINARY){
			fseek(iob, 0L, 2);
		}else{
			flagb = iob->_flag;
			iob->_flag |= _IOREAD;
			while (fgetc(iob) != EOF)
				;
			lseek(iob->_file,(long)(-iob->_cnt),1);

			iob->_flag = flagb;
			iob->_cnt = 0;
			if (iob->_base && c){
				iob->_cnt = BUFSIZ;
			}
			iob->_ptr = iob->_base;
		}
	}
	return iob;
}

-fclose.c

/*
 *	fclose - for MSX-DOS stdio
 */

extern int	close(int);
int	write(int, void *, int);
long	lseek(int, long, int);

int fclose(f)
register FILE *	f;
{
	
	char e;
	
	if(!(f->_flag & (_IOREAD|_IOWRT))){
		return(EOF);
	}
	fflush(f);
	if ( (f->_flag & _IOWRT) && ((f->_flag & _IOBINARY) == 0) ){
		lseek(fileno(f),0L,2);
		e = 0x1a;
		write(fileno(f),&e,1);
	}
	f->_flag &= ~(_IOREAD|_IOWRT|_IONBF);
	if(f->_base && !(f->_flag & _IOMYBUF)) {
		_buffree(f->_base);
		f->_base = (char *)NULL;
	}
	if(close(fileno(f)) == -1 || f->_flag & _IOERR)
		return EOF;
	else
		return 0;
}

-fseek.c
#include	<msxio.h>

extern long	lseek(), _fsize(), ftell();

int fseek(f, offs, ptr)
register FILE *	f;
long		offs;
int		ptr;
{
	long	roffs;

	clreof(f);
	if (!f->_base){
		if (lseek(fileno(f), offs, ptr) == -1L){
			return -1;
		}else{
			return 0;
		}
	}
	if(f->_flag & _IOWRT){
		fflush(f);
	}
	switch(ptr) {
		case 0:	/* relative to beginning of file */
		break;
		case 1:	/* relative to current postion */
			offs += ftell(f);
		break;
		case 2:	/* relative toend of file- CP/M makes us work hard */
			offs += _fsize(fileno(f));
		break;
		default:
			return -1;
	}
	if ((roffs = offs - ftell(f)) == 0){
		return 0;
	}
	if (f->_flag & _IOREAD){
		if (roffs >= 0 && roffs <= f->_cnt){
			f->_cnt -= roffs;
			f->_ptr += roffs;
			return 0;
		}else{
			f->_cnt = 0;
		}
	}

	if (lseek(f->_file, offs, 0) == -1L){
		return -1;
	}
	return 0;
}

long ftell(f)
register FILE *	f;
{
	long	pos;

	pos = lseek(f->_file, 0L, 1);
	if (f->_cnt < 0){
		f->_cnt = 0;
	}
	if (f->_base && f->_flag & _IOWRT){
		pos += BUFSIZ;
	}
	return pos - f->_cnt;
}
-chmod.as

;MSX-DOS1 doesn't have file mode
;int chmod(name, mode)
	global	_chmod

_chmod:
	ld	hl,0
	ret

--
#include	<msxio.h>
-rename.c

int rename(n1, n2)
char *	n1, * n2;
{
	struct msxfcb	fc[2];
	char *dum;

	unlink(n2);

	if (setfcb(&fc[0], n1)){
		return(-1);
	}

	dum = (char *)(&fc[0]);
	dum += 16;
	if(setfcb((struct msxfcb *)dum, n2)){
		return(-1);
	}

	if (msx_bdos(CPMREN,&fc[0],0) != 0){
		return(-1);
	}
	
	return(0);
}

-isatty.c

int isatty(fd)
int	fd;
{
	switch(_mfcb[fd].use) {
		case U_CON:
		case U_RDR:
		case U_PUN:
		case U_LST:
			return 1;
		break;
	}
	return 0;
}

-read.c

int read(fd, buf, nbytes)
int	fd;
char *buf;
int nbytes;
{
	int i;
	register struct msxfcb *fc;
	ushort	cnt;

	cnt = 0;
	if(fd >= MAXFILE){
		return -1;
	}
	fc = &_mfcb[fd];
	switch(fc->use){
		case U_RDR:
			cnt = nbytes;
			while(nbytes) {
				nbytes--;
				if ( (*buf++ = msx_bdos(CPMRRDR,0,0) ) == '\n'){
					break;
				}
			}
			return cnt - nbytes;
		break;
		case U_CON:
			if(nbytes > 128){
				nbytes = 128;
			}
			buf[0] = nbytes;
			msx_bdos(CPMRCOB, buf);
			cnt = (uchar)buf[1];
			if(cnt < nbytes) {
				msx_bdos(CPMWCON, '\n');
				buf[cnt+2] = '\n';
				cnt++;
			}
			for (i = 0;i < cnt;i++){
				buf[i] = buf[i+2];
			}
			return cnt;
		break;
		case U_READ:
		case U_RDWR:
			msx_bdos(0x1a,buf,0);
			return(msx_bdosh(0x27,fc,nbytes));
		break;
		default:
			return -1;
		break;
	}
}

-write.c

int write(fd, buf, nbytes)
int	fd;
char *buf;
int	nbytes;
{
	register struct msxfcb *fc;
	uchar	offs;
	short	c;
	ushort	count;

	if(fd >= MAXFILE){
		return -1;
	}
	fc = &_mfcb[fd];

	offs = CPMWCON;
	count = nbytes;

	switch(fc->use) {
		case U_PUN:
			while(nbytes--) {
				_sigchk();
				msx_bdos(CPMWPUN, *buf++,0);
			}
			return count;
		break;
		case U_LST:
			offs = CPMWLST;
		case U_CON:
			while(nbytes--) {
				_sigchk();
				c = (char)*buf;
				buf++;
				msx_bdos(offs, c,0);
			}
			return count;
		break;
		case U_WRITE:
		case U_RDWR:
			msx_bdos(0x1a,buf,0);
			return(msx_bdosh(0x26,fc,nbytes));
		break;
		default:
			return -1;
		break;
	}
}

-open.c

int open(name, mode)
char *	name;
{
	register struct msxfcb *	fc;

	if (++mode > U_RDWR){
		mode = U_RDWR;
	}

	if(!(fc = getfcb())){
		return -1;
	}

	if(!setfcb(fc, name)) {
		if(msx_bdos(CPMOPN, fc,0) == 0xff) {
			putfcb(fc);
			return -1;
		}
		fc->use = mode;
		fc->recsiz = 1;
	}

	return fc - _mfcb;
}

-creat.c

int creat(name)
char *	name;
{
	register struct msxfcb *fc;

	if (!(fc = getfcb())){
		return -1;
	}

	if (!setfcb(fc, name)) {
		unlink(name);
		if(msx_bdos(CPMMAKE, fc,0) == 0xff) {
			fc->use = 0;
			return -1;
		}
		fc->use = U_WRITE;
		fc->recsiz = 1;
	}
	return fc - _mfcb;
}

-close.c

int close(fd)
int fd;
{
	register struct msxfcb *fc;

	if(fd >= MAXFILE){
		return -1;
	}
	fc = &_mfcb[fd];
	if (fc->use == U_WRITE || fc->use == U_RDWR){
		msx_bdos(CPMCLS, fc,0);
	}
	fc->use = 0;
	return 0;
}

-dup.c

int dup(fd)
int	fd;
{
	register struct msxfcb *	fp;

	if(_mfcb[fd].use && (fp = getfcb())) {
		*fp = _mfcb[fd];
		return fp - _mfcb;
	}
	return -1;
}

-unlink.c

int unlink(name)
char *	name;
{
	struct msxfcb	fc;
	short		retval;

	if(setfcb(&fc, name)){
		return 0;
	}
	retval = msx_bdos(CPMDEL, &fc,0);
	return(retval);
}

-fcbname.c
#include	<string.h>

/*
 *	char *	fcbname(i);
 *	short	i;
 *
 *	Returns a character string which is the name of the file currently
 *	open on file descriptor i. The name is extracted from the corresponding
 *	fcb.
 */

char *fcbname(i)
int	i;
{
	register struct msxfcb *fc;
	static char		abuf[20];
	register char *cp,*xp;


	fc = &_mfcb[i];

	switch(fc->use) {
		case U_CON:
			return "CON:";
		case U_RDR:
			return "RDR:";
		case U_PUN:
			return "PUN:";
		case U_LST:
			return "LST:";
		case U_READ:
		case U_WRITE:
		case U_RDWR:
			cp = abuf;
			if (fc->dr) {
				*cp++ = 'A' + fc->dr - 1;
				*cp++ = ':';
			}
			for(xp = fc->name ; *xp > ' ' && xp < fc->name + 8;){
				*cp++ = *xp++;
			}
			*cp++ = '.';
			for(xp = fc->ft ; *xp > ' ' && xp < fc->ft + 3;){
				*cp++ = *xp++;
			}
			*cp = 0;
			return abuf;
		default:
			return (char *)0;
	}
}

-getfcb.c
#include	<ctype.h>

/*
 *	Syntax of MSX-DOS file names is:
 *
 *	[[a-hA-H]:]name[.ext]
 *
 *	E.g.
 *		file.txt
 *		a:file
 */


#define	DNAMLEN	4	/* length of device names */

static char	dnames[][DNAMLEN] =
{
	"CON:",
	"RDR:",
	"PUN:",
	"LST:",
};

#define	NDNAMES	4

extern int	atoi(char *);

static char upcase(c)
char	c;
{
	if(islower(c)){
		return toupper(c);
	}
	return c;
}

struct msxfcb *getfcb(void)
{
	register struct msxfcb *fp;

	for(fp = _mfcb ; fp < &_mfcb[MAXFILE] ; fp++){
		if(!fp->use) {
			fp->use = U_READ;
			fp->rwp = 0;
			return fp;
		}
	}
	return (struct msxfcb *)0;
}

int putfcb(fc)
register struct msxfcb *	fc;
{
	fc->use = 0;
}

int fc_parse(fc, name)
register char *	name;
register struct msxfcb *	fc;
{
	register char *	cp;
	char		c;

	fc->dr = 0;
	cp = name;

	if(isalpha(*name) && name[1] == ':') {
		fc->dr = upcase(*name) - 'A' + 1;
		name += 2;
	}
	cp = fc->name;
	while(*name != '.' && *name != '*' && *name > ' ' && cp < &fc->name[8]){
		*cp++ = upcase(*name++);
	}
	if(*name == '*'){
		c = '?';
	}else{
		c = ' ';
	}
	while(cp < &fc->name[8]){
		*cp++ = c;
	}
	while(*name && *name++ != '.'){
		continue;
	}
	while(*name > ' ' && *name != '*' && cp < &fc->ft[3]){
		*cp++ = upcase(*name++);
	}
	if(*name == '*'){
		c = '?';
	}else{
		c = ' ';
	}
	while(cp < &fc->ft[3]){
		*cp++ = c;
	}
	fc->ex = fc->nr = 0;
}

uchar setfcb(fc, name)
register char *		name;
struct msxfcb *	fc;
{
	uchar i,j;

	while(isspace(*name)){
		name++;
	}

	for(i = 0 ; i < NDNAMES ; i++){ /* name is device name ? */
		for(j = 0 ; ;){
			if (dnames[i][j] != upcase(name[j])){
				break;
			}else if(++j == DNAMLEN) {
				fc->use = i+U_CON;
				return 1;
			}
		}
	}
	fc_parse(fc, name);
	return 0;
}

-seek.c

long _fsize(fd)
uchar	fd;
{
	register struct msxfcb *	fc;

	if (fd >= MAXFILE){
		return -1;
	}
	fc = &_mfcb[fd];

	return fc->filesize;
}

long lseek(fd, offs, whence)
int fd;
long	offs;
int whence;
{
	register struct msxfcb *fc;
	long			pos;

	if (fd >= MAXFILE){
		return -1;
	}
	fc = &_mfcb[fd];

	switch(whence) {
		case 1:
			pos = fc->rwp + offs;
		break;

		case 2:
			pos = offs + _fsize(fd);
		break;
		default:
			pos = offs;
		break;

	}
	if(pos >= 0) {
		fc->rwp = pos;
		return fc->rwp;
	}
	return -1;
}
-cleanup.c

#define	FILL	0, "        ", "   ", 0, 0, 0, 0, 0, 0, {0}, 0, 0

struct msxfcb _mfcb[MAXFILE] =
{
	{ FILL, U_CON },	/* stdin */
	{ FILL, U_CON },	/* stdout */
	{ FILL, U_CON },	/* stderr */
};

_cpm_clean()
{
	uchar	i;

	i = 0;
	do{
		close(i);
	}while(++i < MAXFILE);
}

_putrno(where, rno)
uchar *	where;
long	rno;
{
	where[0] = rno & 0xFF;
	where[1] = (rno >> 8) & 0xFF;
	where[2] = (rno >> 16) & 0xFF;
}
--
entry	equ	5		; CP/M entry point
-mbdoshl.as
;	unsigned int  msx_bdosh(func,de,hl)

	global	csv,cret
	global	_msx_bdosh

	psect	text
_msx_bdosh:
	ld	(saveix),ix
	pop	ix
	pop	bc
	pop	de
	pop	hl
	push	hl
	push	de
	push	bc
	push	ix

	push	iy
	call	entry
	pop	iy

	ld	ix,(saveix)
	ret

saveix:
	defw	0
-mbdos.as
;	unsigned char msx_bdos(func,de,hl)

	global	csv,cret
	global	_msx_bdos

	psect	text
_msx_bdos:
	ld	(saveix),ix
	pop	ix
	pop	bc
	pop	de
	pop	hl
	push	hl
	push	de
	push	bc
	push	ix

	push	iy
	call	entry
	pop	iy

	ld	ix,(saveix)
	ld	l,a
	ld	h,0
	ret

saveix:
	defw	0
