#ifndef __ETCLIB_H
#define __ETCLIB_H

typedef struct find_t{
	char drive;
	char name[8];
	char ext[3];
	char atr;
	char dummy[10];
	int time;
	int date;
	int clst;
	int size[2];
} DIR;

struct  dosdate_t       {
	char   day;       /* (1-31)        */
	char   month;     /* (1-12)        */
	unsigned int    year;      /* N(1980-2099)   */
	char   dayofweek; /* j(0:j...) */
};

struct  dostime_t       {
	char hour;    /* (0-23) */
	char minute;  /* (0-59) */
	char second;  /* b(0-59) */
	char hsecond; /* 1/100b(0-99) */
};

struct  diskfree_t      {
	unsigned total_clusters;      /* NX^             */
	unsigned avail_clusters;      /* gp\NX^       */
	unsigned sectors_per_cluster; /* NX^̃ZN^ */
	unsigned bytes_per_sector;    /* ZN^̃oCg   */
};

typedef struct dpb{
	char drive;
	char id;
	int sec_s;
	char d_mask;
	char d_sft;
	char c_mask;
	char c_sft;
	int fi_fat;
	char fat_c;
	char ents;
	int fi_dat;
	int la_cls;
	char si_fat;
	int fi_dir;
	char *fatbuf;
} DPB;

VOID getdate(),gettime(),getdrive(),setdrive(),cputs(),swab();
STATUS setdate(),settime(),cprintf();
char findfirst(),findnext(),*calloc(),putch(),*cgets(),*getdpb(),*bsearch();
int cscanf();
unsigned rotl(),rotr(),getdiskfree();

#endif
