;Assembly part of DIT.COM

	psect text

;struct DPB *_dos_getDPB(unsigned char drive)

	global	__dos_getDPB

__dos_getDPB:
	pop	hl
	pop	de
	push	de
	push	hl

	push	ix
	push	iy

	ld	c,1bh
	call	0005H
	push	ix
	pop	hl

	pop	iy
	pop	ix
	ret

	global	csv,cret
;unsigned char _PHYDIO_read(char *buf,unsigned char drive,unsigned sector,unsigned char len,unsigned char mediaid)

	global	__PHYDIO_read

exptbl	equ	0fcc1h
PHYDIO	equ	0ffa7h
CALSLT	equ	001ch

__PHYDIO_read:

	call	csv

	ld	l,(ix+6)	;buf
	ld	h,(ix+7)

	ld	a,(ix+8)	;drive

	ld	e,(ix+10)	;Sector
	ld	d,(ix+11)

	ld	b,(ix+12)	;Number of sectors
	
	ld	c,(ix+14)	;Media ID

	push	iy
	push	ix


	ld	iy,(exptbl-1)
	ld	ix,0144h
	or	a		;reset carry flag
	call	CALSLT		;CALSLT

	pop	ix
	pop	iy

	jp	c,cantread

	ld	hl,0
	jp	cret
	
cantread:
	ld	h,0
	ld	l,a
	jp	cret

;unsigned char _PHYDIO_write(char *buf,unsigned char drive,unsigned sector,unsigned char len,unsigned char mediaid)


	global	__PHYDIO_write

;exptbl	equ	0fcc1h
;PHYDIO	equ	0ffa7h
;CALSLT	equ	001ch

__PHYDIO_write:

	call	csv

	ld	l,(ix+6)	;buf
	ld	h,(ix+7)

	ld	a,(ix+8)	;drive

	ld	e,(ix+10)	;Sector
	ld	d,(ix+11)

	ld	b,(ix+12)	;Number of sectors
	
	ld	c,(ix+14)	;Media ID

	push	iy
	push	ix


	ld	iy,(exptbl-1)
	ld	ix,0144h
	scf		;cy set
	call	CALSLT	;CALSLT

	pop	ix
	pop	iy

	jp	c,cantwt
	
	ld	hl,0
	jp	cret
	
cantwt:
	ld	h,0
	ld	l,a
	jp	cret

;unsigned char getkmode(void)

	global	_getkmode

_getkmode:
	ld	a,0ffh
	ld	de,1100h

	push	ix
	push	iy
	call	0ffcah		;Call ext. BIOS
	pop	iy
	pop	ix

	ld	h,0
	ld	l,a
	ret

;void setkmode(unsigned char)

	global	_setkmode

_setkmode:
	pop	bc
	pop	hl
	push	hl
	push	bc
	
	ld	a,l
	ld	de,1101h

	push	ix
	push	iy
	call	0ffcah		;Call ext. BIOS
	pop	iy
	pop	ix

	ret
