/* 1998/05/06 disk->file  */
/* 1998/05/07 SULNQ̃fBXNC[Wɐ */
/* G~[^B */
/* 1998/05/07 filedisk */

#include	<stdio.h>
#include	<stdlib.h>
#include	<msxio.h>
#include	<string.h>
#include	<ctype.h>
#include	<glib.h>
#include	<uty.h>
#include	"d:dit.h"

unsigned int start_sec,end_sec;
unsigned char media,mediaid,method;
unsigned char kmode,width,scr; /* ̉ʕ\f[^ */
unsigned int param_tbl[21] = {
	0,719,0xf9,		/* auto(dummy) */
	0,1439,0xf9,	/* 2DD,9 Sectors */
	0,719,0xf9,		/* 2DD,9 Sectors(1st) */
	720,1439,0xf9,	/* 2DD,9 Sectors(2nd) */
	0,1279,0xfb,	/* 2DD,8 Sectors */
	0,719,0xf8,		/* 1DD,9 Sectors */
	0,639,0xfa		/* 1DD,8 Sectors */
};
unsigned char *flushbuf;

unsigned char *vers = "@(#)Disk Image Tool for MSX (DIT) \nVersion 1.1 By Tatsu 1995,1998,2000\n";

/* MSX-C Version 1.1Zbgrdsec֐LSI C-86 Zbg */
/* absread֐݊ */
void _dos_absread(buf,drv,sec,len)
char *buf;
int drv;
unsigned sec;
int len;
{
	int secx;
	msx_bdos((char)0x1a,buf,0);
	secx = (len << 8) + drv;
	msx_bdos((char)0x2f,sec,secx);
}

/* MSX-C Version 1.1Zbgwtsec֐LSI C-86 Zbg */
/* abswrite֐݊ */
void _dos_abswrite(buf,drv,sec,len)
char *buf;
int drv;
unsigned sec;
int len;
{
	int secx;
	msx_bdos((char)0x1a,buf,0);
	secx = (len << 8) + drv;
	msx_bdos((char)0x30,sec,secx);
}

void chkmedia(unsigned char drive)
{
	struct DPB *d;

	d = _dos_getDPB(drive);
	mediaid = d->media;
	start_sec = 0;
	end_sec = d->data_start + (d->clu_end-1) * (d->clu_mask+1) - 1;

	/* FDD̃[h̏ꍇA2DD,9ZN^̃ftHgOɂB */
	if ((mediaid == 0xf9) && (usrmode == 1)){
		end_sec = 719;
	}
}

void exexit(int rc)
{
	char c;

	fprintf(stderr,"\n--- Hit any key ---\n");
	kilbuf();
	c = chget();
	if (kmode != 255){
		setkmode(kmode);
	}
	*(unsigned char *)0xf3ae = width;
	screen(scr);
	exit(rc);
}

#define SECTOR_LEN 512
#define MAX_VPAGE 247

/* 0-223 -> 0-247 */
unsigned int storeptr;
void vstore(unsigned char *buf)
{
	unsigned int i;

	lsetwt((unsigned long)0x1000+(unsigned long)storeptr*(unsigned long)SECTOR_LEN); /* LXgȂunsigned short int */

	for (i = 0;i < SECTOR_LEN;i++){
		outvdp(*buf);
		buf++;
	}
	storeptr++;
}

void vflushfil(int fd,unsigned int ds)
{
	unsigned int i,j;

	for (i = 0;i < ds;i++){
		lsetrd((unsigned long)0x1000+(unsigned long)i * (unsigned long)SECTOR_LEN);
		for (j = 0;j < SECTOR_LEN;j++){
			flushbuf[j] = invdp();
		}
		write(fd,flushbuf,SECTOR_LEN);
	}
}

void soerror(unsigned char *fn,unsigned char *buf,unsigned int size)
{
	int fdo,len;
	char *fnbuf,*p;

	len = strlen(fn);
	len = len + 5;
	if ((fnbuf = malloc(len)) == NULL){
		fprintf(stderr,"No enough memory.\n");
		exexit(2);
	}
	strcpy(fnbuf,fn);
	p = strrchr(fnbuf,'.');
	if (p == NULL){
		strcat(fnbuf,".SOE");
	}else{
		strcpy(p,".SOE");
	}


	if ((fdo = creat(fnbuf)) == -1){
		fprintf(stderr,"Can't open %s\n",fn);
		free(fnbuf);
		exexit(1);
	}
	write(fdo,buf,size);
	free(fnbuf);
	close(fdo);

}

void fd2file(unsigned char drive,unsigned char *fn)
{
	unsigned int i,ds,ecp;
	int fdo;
	unsigned char *buf,en,*ecbuf;

	if ((fdo = creat(fn)) == -1){
		fprintf(stderr,"Can't open %s\n",fn);
		exexit(1);
	}
	if ((buf = malloc(SECTOR_LEN)) == NULL){
		close(fdo);
		fprintf(stderr,"No enough memory.\n");
		exexit(2);
	}
	if ((ecbuf = malloc(MAX_SECTOR)) == NULL){
		free(buf);
		close(fdo);
		fprintf(stderr,"No enough memory.\n");
		exexit(2);
	}
	if ((flushbuf = malloc(MAX_SECTOR)) == NULL){
		free(ecbuf);
		free(buf);
		close(fdo);
		fprintf(stderr,"No enough memory.\n");
		exexit(2);
	}
	ds = 0;
	storeptr = 0;
	ecp = 0;
	for (i = start_sec;i <= end_sec;i++){
		switch(method){
			case 0:
				_dos_absread(buf,drive,i,1);
				en = 0;
			break;
			case 1:
				en = _PHYDIO_read(buf,drive,i,1,param_tbl[media*3+2]);
			break;
		}
		if (en > 0){ /* PhyLoCP compatible */
			if (en < 4){
				fprintf(stderr,"Not ready or write protected.\n");
				close(fdo);
				free(buf);
				free(ecbuf);
				free(flushbuf);
				exexit(1);
			}else{
				memcpy(buf,"_ErrSec_",8);
				*(buf+8) = en;
				ecbuf[ecp] = en & 0xfe;
			}
		}else{
			ecbuf[ecp] = 0x0f;
		}
		ecp++;
		/* write(fdo,buf,SECTOR_LEN); ZN^[h/Cg͐ɓĂ悤B*/

		vstore(buf);
		ds++;
		if (ds > MAX_VPAGE){
			vflushfil(fdo,ds);
			storeptr = 0;
			ds = 0;
		}
	}
	if (ds > 0){
		vflushfil(fdo,ds);
		storeptr = 0;
		ds = 0;
	}
	if (method){
		soerror(fn,ecbuf,ecp);
	}
	close(fdo);
	free(buf);
	free(ecbuf);
	free(flushbuf);

}

int vflushfd(unsigned char drive,unsigned int ssec,unsigned int ds)
{
	unsigned char *buf,en;
	unsigned int i,j;

	buf = malloc(SECTOR_LEN);
	for (i = 0;i < ds;i++){
		lsetrd((unsigned long)0x1000+(unsigned long)i * (unsigned long)SECTOR_LEN);
		for (j = 0;j < SECTOR_LEN;j++){
			buf[j] = invdp();
		}
		switch(method){
			case 0:
				_dos_abswrite(buf,drive,i+ssec,1);
				en = 0;
			break;
			case 1:
				en = _PHYDIO_write(buf,drive,i+ssec,1,param_tbl[media*3+2]);
			break;
		}
		if (en > 0){
			free(buf);
			return(1);
		}
	}
	storeptr = 0;
	free(buf);
	return(0);

}

void file2fd(unsigned char *fn,unsigned char drive)
{
	unsigned int i,ssec,ds,r;
	int fdi;
	unsigned char *buf;

	if ((fdi = open(fn,0)) == -1){
		fprintf(stderr,"Can't open %s\n",fn);
		exexit(1);
	}
	if ((buf = malloc(SECTOR_LEN)) == NULL){
		fprintf(stderr,"No enough memory.\n");
		close(fdi);
		exexit(2);
	}

	ssec = start_sec;
	ds = 0;
	storeptr = 0;

	for (i = start_sec;i <= end_sec;i++){
		r = read(fdi,buf,SECTOR_LEN);
		if (r < SECTOR_LEN){
			fprintf(stderr,"Can't read disk image file.\n");
			free(buf);
			close(fdi);
			exexit(1);
		}

		vstore(buf);
		ds++;
		if (ds > MAX_VPAGE){
			if (vflushfd(drive,ssec,ds)){
				fprintf(stderr,"Can't write disk.\n");
				free(buf);
				close(fdi);
				exexit(1);
			}
			ssec += ds;
			ds = 0;
		}
	}
	if (ds > 0){
		if (vflushfd(drive,ssec,ds)){
			fprintf(stderr,"Can't write disk.\n");
			free(buf);
			close(fdi);
			exexit(1);
		}
		ds = 0;
	}
	close(fdi);
	free(buf);

}

void fd2fd(unsigned char drive,unsigned char drive2)
{
	unsigned int i,ssec,ds,r;
	unsigned char *buf,en;

	if ((buf = malloc(SECTOR_LEN)) == NULL){
		fprintf(stderr,"No enough memory.\n");
		exexit(2);
	}
	ds = 0;
	storeptr = 0;
	for (i = start_sec;i <= end_sec;i++){
		switch(method){
			case 0:
				_dos_absread(buf,drive,i,1);
				en = 0;
			break;
			case 1:
				en = _PHYDIO_read(buf,drive,i,1,param_tbl[media*3+2]);
			break;
		}
		/* write(fdo,buf,SECTOR_LEN); ZN^[h/Cg͐ɓĂ悤B*/

		vstore(buf);
		ds++;
		if (ds > MAX_VPAGE){
			if (vflushfd(drive2,ssec,ds)){
				fprintf(stderr,"Can't write disk.\n");
				free(buf);
				exexit(1);
			}
			ssec += ds;
			ds = 0;
		}
	}
	if (ds > 0){
		if (vflushfd(drive2,ssec,ds)){
			fprintf(stderr,"Can't write disk.\n");
			free(buf);
			exexit(1);
		}
		ssec += ds;
		ds = 0;
	}

	free(buf);

}

void chkopt(int argc,char *argv[])
{
	int i;

	for (i = 4;i < argc;i++){
		if (argv[i][0] != '/' && argv[i][0] != '-'){
			continue;
		}
		switch (toupper(argv[i][1])){
			case 'T':
				if (argv[i][2] != '\0'){
					media = atoi(&argv[i][2]);
				}else if (i < (argc - 1)){
					i++;
					media = atoi(argv[i]);
				}
			break;
			case 'P':
				method = 1;
			break;
		}
	}
}

void usage(void)
{
	fprintf(stderr,"%sUsage:DIT Command P1 P2 Options...\nCommand:\nV:FDD -> Disk image P1:Drive P2:Filename\nR:Disk image -> FDD P1:Filename P2:Drive\nC:Diskcopy P1:Source P2:Distination\nOptions:\n/P Use PHYDIO\n/Tn Media type select\n n=0:Auto Detect\n n=1:2DD 9 Sectors\n n=2:2DD 9 Sectors(the first half)\n n=3:2DD 9 Sectors(the second half)\n n=4:2DD 8 Sectors\n n=5:1DD 9 Sectors\n n=6:1DD 8 Sectors\n",vers+4);
	exit(1);
}

void mediastat(void)
{
	fprintf(stderr,"Start %d sector end %d sector\n",start_sec,end_sec);
	if (method == 1){
		fprintf(stderr,"Mode:PHYDIO\n");
	}else{
		fprintf(stderr,"Mode:DOS absolute read/writefunction \n");
	}
}


int main(int argc,char *argv[])
{
	unsigned char drive,drive2;

	media = 0;
	method = 0;

	if (argc < 4){
		usage();
	}else{
		chkopt(argc,argv);
	}

	ginit();
	setheaptop(0x8000);
	/* VRAM[NGAɂ邽߂̐ݒ */
	width = *(unsigned char *)0xf3ae;
	scr = *(unsigned char *)0xfcaf;
	kmode = getkmode();
	if (kmode != 255){
		setkmode(0); /* set ANK mode */
	}
	kmode = getkmode();
	*(unsigned char *)0xf3ae = 40;
	screen((unsigned char)0);

	fprintf(stderr,"%s",vers+4);

	switch (toupper(argv[1][0])){
		case 'V':
			drive = toupper(argv[2][0]) - 'A';

			if (media == 0){
				if (method == 1){ /* PHYDIOɂ̓fBAIDKv */
					fprintf(stderr,"Unknoun media.\n");
					exexit(1);
				}else{
					chkmedia(drive+1);
				}
			}else{
				start_sec = param_tbl[media*3];
				end_sec = param_tbl[media*3+1];
			}

			fprintf(stderr,"\nSource disk's informations\n");
			mediastat();
			fd2file(drive,argv[3]);
		break;
		case 'R':
			drive = toupper(argv[3][0]) - 'A';

			if (media == 0){
				if (method == 1){ /* PHYDIOɂ̓fBAIDKv */
					fprintf(stderr,"Unknoun media.\n");
					exexit(1);
				}else{
					chkmedia(drive+1);
				}
			}else{
				start_sec = param_tbl[media*3];
				end_sec = param_tbl[media*3+1];
			}

			fprintf(stderr,"\nDistination disk's informations\n");
			mediastat();
			file2fd(argv[2],drive);
		break;
		case 'C':
			drive = toupper(argv[2][0]) - 'A';
			drive2 = toupper(argv[3][0]) - 'A';
			usrmode = 0;

			if (media == 0){
				if (method == 1){ /* PHYDIOɂ̓fBAIDKv */
					fprintf(stderr,"Unknoun media.\n");
					exexit(1);
				}else{
					chkmedia(drive+1);
				}
			}else{
				start_sec = param_tbl[media*3];
				end_sec = param_tbl[media*3+1];
			}

			fprintf(stderr,"\nSource disk's informations\n");
			mediastat();
			fd2fd(drive,drive2);
		break;
		default:
			fprintf(stderr,"Command %c not found.\n",argv[1][0]);
		break;
	}
	if (kmode != 255){
		setkmode(kmode);
	}
	*(unsigned char *)0xf3ae = width;
	screen(scr);

}
