#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NTfunction.h"
#include	"Bookmark.h"

#include	"XbelBookmark.h"
#include	"XbelWriter.h"

XbelWriter::XbelWriter(void)
{
	m_target = 0;
	m_level = 0;
	placesPut = true;
	putIEToolbar = true;
	m_ignore = false;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
}

XbelWriter::~XbelWriter()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * Xy[Xo͂B
 *
 * @param fp o͐̃t@C|C^
 * @param tabs ^u̐
 */
void XbelWriter::spput(FILE *fp,int tabs)
{
	int i;
	
	for (i = 0;i < tabs;i++){
		fputc('\t',fp);
	}
}


/**
 * tH_̏o͂B
 *
 */
void XbelWriter::putFolder(Bookmark *item)
{
	if (m_layout == XBEL_LAYOUT_QTWEB) {
		switch(item->getFolderType()) {
			case Bookmark::toolBar:
				spput(cs_fpo,m_level + 1);
				fprintf(cs_fpo,"<folder>\n");
				spput(cs_fpo,m_level + 2);
				fprintf(cs_fpo,"<title>Bookmarks Bar</title>\n");
				break;
			case Bookmark::menuBar:
				spput(cs_fpo,m_level + 1);
				fprintf(cs_fpo,"<folder>\n");
				spput(cs_fpo,m_level + 2);
				fprintf(cs_fpo,"<title>Bookmarks Menu</title>\n");
				break;
			case Bookmark::viTrash:
				m_ignore = true;
				m_ignoreSince = m_level;
				break;
			default:
				if ((putIEToolbar == false) && (item->isIEToolbar())) {
					m_ignore = true;
					m_ignoreSince = m_level;
				}
				if (!m_ignore) {
					spput(cs_fpo,m_level + 1);
					fprintf(cs_fpo,"<folder>\n");
					spput(cs_fpo,m_level + 2);
					fprintf(cs_fpo,"<title>");
					wchar_t *filenameW = item->getIeNameW();
					if (filenameW != NULL){
						putname(cs_fpo,filenameW);
					}
					fprintf(cs_fpo,"</title>\n");
				}
				break;
		}
	} else {
		spput(cs_fpo,m_level + 1);
		fprintf(cs_fpo,"<folder>\n");
		spput(cs_fpo,m_level + 2);
		fprintf(cs_fpo,"<title>");
		wchar_t *filenameW = item->getIeNameW();
		if (filenameW != NULL){
			putname(cs_fpo,filenameW);
		}
		fprintf(cs_fpo,"</title>\n");
	}
	if (!m_ignore) {
		char *desc = item->getDescription();
		if (desc != NULL) {
			spput(cs_fpo,m_level + 2);
			fprintf(cs_fpo,"<desc>");
			putname2(cs_fpo,desc);
			fprintf(cs_fpo,"</desc>\n");
		}
	}

	m_level++;

}

/**
 * tH_Io͂B
 *
 * @param item o͂tH_
 */
void XbelWriter::putFolderEnd(Bookmark *item,bool isLast)
{
	m_level--;

	if (!m_ignore) {
		spput(cs_fpo,m_level + 1);
		fprintf(cs_fpo,"</folder>\n");
	}
	if (m_level == m_ignoreSince) {
		m_ignore = false;
	}
}

/**
 * URL̏o͂B
 *
 * @param item URLo͂ubN}[N
 */
void XbelWriter::putURL(Bookmark *item)
{
	if (item->getURL() != NULL){
		char *p;
		wchar_t *wp;
		p = item->getURL();
/*
		if (strncmp("file:",p,5) == 0){
			wp = UTF8towcFileNameInternal(item->getURL());
		} else {
			if (strncmp("javascript:", p,11) == 0) {
				// Mozillȁꍇ͂̂܂
				p = item->getURL();
			}else{
			}
		}
*/
		wp = UTF8towcFileNameInternal(item->getURL());

		putname(cs_fpo,wp);
	}
}

/**
 * ubN}[N̏o͂B
 */
void XbelWriter::putBookmark(Bookmark *item,bool isLast)
{
	if (!placesPut) {
		// Firefox 3̃X}[gubN}[NtH_炱𖳎B
		if (item->isPlaceURI()) {
			return;
		}
	}
	if (m_ignore) {
		return;
	}

	// Xbel̃Zp[^
	if (item->getSeparator()) {
		spput(cs_fpo,m_level + 1);
		fprintf(cs_fpo,"<separator />\n");
		return;
	}

	// printf("putBookmark\n");
	spput(cs_fpo,m_level + 1);
	// Jnvf
	fprintf(cs_fpo,"<bookmark href=\"");
	putURL(item);
	fprintf(cs_fpo,"\">\n");
	// ^Cg
	spput(cs_fpo,m_level + 2);
	fprintf(cs_fpo,"<title>");
	if (item->getIeNameW() != NULL){
		putname(cs_fpo,item->getIeNameW());
	}
	fprintf(cs_fpo,"</title>\n");

	char *desc = item->getDescription();
	if (desc != NULL) {
		spput(cs_fpo,m_level + 1);
		fprintf(cs_fpo,"<desc>");
		putname2(cs_fpo,desc);
		fprintf(cs_fpo,"</desc>\n");
	}

	spput(cs_fpo,m_level + 1);
	fprintf(cs_fpo,"</bookmark>\n");

}

/*
	ubN}[Ñwb_o͂B
	
		Ȃ
	߂l
		Ȃ
*/
void XbelWriter::putHeader(void)
{
	fprintf(cs_fpo,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
	fprintf(cs_fpo,"<!DOCTYPE xbel>\n");
	fprintf(cs_fpo,"<xbel version=\"1.0\">\n");
	//fprintf(cs_fpo,"<dict>\n");
	//fprintf(cs_fpo,"\t<key>Children</key>\n");
	//fprintf(cs_fpo,"\t<array>\n");


}

/*
	ubN}[Ñtb^o͂B
	
		fpo o͐
	߂l
		Ȃ
*/
void XbelWriter::putFooter(void)
{
	fprintf(cs_fpo,"</xbel>\n");
}

/**
 * &̕HTML̕QƂɕϊȂ當o͂B
 *
 * @param fp o͐FILE\̂ւ̃|C^
 * @param name o͂镶
 */
void XbelWriter::putname2(FILE *fp,char *name)
{
//	debugprintf("putname2\n");
	while(*name){
		switch(*name){
			case '&':
				fprintf(fp,"&amp;");
			break;
			case '<':
				fprintf(fp,"&lt;");
			break;
			case '>':
				fprintf(fp,"&gt;");
			break;
			case '\"':
				fprintf(fp,"&quot;");
			break;
			default:
				fputc(*name,fp);
			break;
		}
		name++;
	}
}

/**
 * ėpo̓[` wchar_t -> UTF8ϊt
 *
 * @param fp o͐FILE\̂ւ̃|C^
 * @param name o͂镶
 */
void XbelWriter::putname(FILE *fp,wchar_t *name)
{

	wchar_t *unicode;
	unsigned char *utf8;
	int utf8Count;
	
//	debugprintf("putname\n");
	if (name == NULL)
		return;
	
	unicode = name;

	// Unicode -> UTF8
	utf8Count = countUTF16LEtoUTF8str(unicode);
	utf8 = (unsigned char *)calloc(utf8Count + 1,sizeof(unsigned char));
	if (utf8 == NULL){
		return;
	}
	toUTF8(utf8,unicode);

	putname2(fp,(char *)utf8);

	free(utf8);

}

