#ifndef XBELREADER_H
#define XBELREADER_H

#include	<vector>
#include	"Bookmark.h"
#include	"HTMLtag.h"
#include	"Logger.h"

#include	"IBookmarkTree.h"
#include	"BookmarkTree.h"

#include	"TJsonValue.h"

#undef EXTERN
#ifdef ISXBELREADER
#define EXTERN
#else
#define EXTERN extern
#endif

class XbelReader {

	// vpeBXgvfߏ
	enum ItemType {
		INVALID,	// sȃ^Cv
		INITIAL,	// 
		NONE,	// ^CvȂ
		ARRAY,	// z
		OBJECT,	// IuWFNg
		KEY,	// L[݂ĂB
		VALUE,	// l
		NEED_SEPARATOR	// ؂肪Kv
	};

	// HTML͏
	struct XbelParseStatus {
		char previous;	/* 1O̕ */
		int inTag;	/* ^O̒ǂH */
		int inComment;	/* RgǂH */
		int isUtf8;	/* UTF-8ǂH */
		int inDD;	/* DDGgǂH */
		int storeing;	/* vf̒gi[邩ǂH */
		char itemType;	/* vf̌` */
		unsigned int folderLevel;	/* tH_̊Kw */
	};

private:
	char noIEfavorites;	// 1:IÊCɓRo[gȂB 0:
	IbookmarkTree *writer;	// ݗpIuWFNg
	int isSilentMode;	// 1:t@CI[vsbZ[WȂ 0:

	// ꎞobt@
	char *scFile,*work;
	char item[BUFLEN],*pItem;	// H3̒gۑ
	int cItem;				// item̕JEgp
	Bookmark bookmark;
	int f_item;
	int m_bookmarkNo;	// ǂݍłubN}[N̔ԍ
	char *urlBuf;	// URLϊpobt@
	std::vector<Bookmark> folderStack;
	int m_layout;	// tH_CAEg
	bool ignoreToolbar;	// c[o[𖳎邩ǂ
	Logger *logger;

	// IuWFNgf͗p
	int parseStart(struct XbelParseStatus *stat);
	int parseFolder(struct XbelParseStatus *stat,TJsonValue *folderArray);
	int parseItem(struct XbelParseStatus *stat,TJsonValue *item);

	// XBEL IuWFNgf\zp
	unsigned int elementPoint;	// \vf݈̌ʒu
	std::vector<ItemType> elementStack;	// \vf
	unsigned int valuePoint;	// \vf݈̌ʒu
	std::vector<TJsonValue *> valueStack;	// \vf
	TJsonValue topValue;		// 擪̒l
	TJsonValue *currentValue;	// ݈Ăl
	ItemType currentElement;

	void pushElement(ItemType type);
	void popElement(void);
	ItemType previousElement(void);

	void pushValue(TJsonValue *value);
	void popValue(void);
	TJsonValue * previousValue(void);


	int flushItem(struct XbelParseStatus *stat);
	int setName(struct XbelParseStatus *stat,char *name);

	int parseFolderElement(struct XbelParseStatus *stat,HTMLtag *tag);
	int parseTitleElement(struct XbelParseStatus *stat,HTMLtag *tag);
	int parseBookmarkElement(struct XbelParseStatus *stat,HTMLtag *tag);
	int parseXbelElement(struct XbelParseStatus *stat,HTMLtag *tag);
	int parseDescElement(struct XbelParseStatus *stat,HTMLtag *tag);
	int parseSeparatorElement(struct XbelParseStatus *stat,HTMLtag *tag);

	int parseElement(struct XbelParseStatus *stat,HTMLtag *tag);
	int parseHTML(struct XbelParseStatus *stat,HTMLtag *tag,char c);
	void initParseStatus(struct XbelParseStatus *stat);
	int readUtf16(const char *filename,struct XbelParseStatus *stat,int flag);
	int readUtf32(const char *filename,struct XbelParseStatus *stat,int flag);
	int read8bit(const char *bmFile,struct XbelParseStatus *stat);

public:
	char setIEfavoritesImport(char mode){	noIEfavorites = mode;return mode;}
	XbelReader();
	~XbelReader();
	/**
	* ubN}[NoIuWFNgݒ肷B
	* BookmarkTreeɂݒ肵āARs[sB
	*
	*/
	void setBookmarkWriter(IbookmarkTree *obj)
	{
		writer = obj;
	}

	int readBookmark(const char *bmFile,const char *fvDir);
	void setSilentMode(int mode){	isSilentMode = mode;}
	int getBookmarkNo(void) { return m_bookmarkNo; }
	void setBookmarkNo(int no){	m_bookmarkNo = no;}

	/**
	 * tH_CAEgݒ肷B
	 *
	 * @param no CAEgԍ
	 */
	void setLayout(int no)
	{
		m_layout = no;
	}
	void setIgnoreToolbar(bool flag) {
		ignoreToolbar = flag;
	}

	void setLogger(Logger *loggerObj) {
		logger = loggerObj;
	}
};

#undef EXTERN

#endif
