#define ISXBELREADER

// Wwb_
#include	<stdlib.h>

#include	<fstream>
#include	<iostream>
#include	<assert.h>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>

// BookSyncʃwb_
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"

// vbgtH[wb_
#include	"XbelBookmark.h"
#include	"XbelReader.h"
#include	"IbookmarkTree.h"
#include	"..\core\messages.h"

#ifdef __BORLANDC__
#define	_stricmp stricmp
#endif

extern int g_lang;
extern int g_verbose;

/**
 *	RXgN^
 */
XbelReader::XbelReader()
{
	noIEfavorites = 0;	// C|[gIÊCɓ΂Ȃ
	isSilentMode = 1;
	ignoreToolbar = false;

	urlBuf = NULL;
	writer = NULL;

	// Ăl̏
	currentValue = &topValue;
	currentElement = INITIAL;

	elementPoint = 0;
	valuePoint = 0;

	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}

}

/**
 * fXgN^
 */
XbelReader::~XbelReader()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * bookmarkoB
 *
 * @param stat XML`vpeBXg͏
 * @return 0  1 G[
 */
int XbelReader::flushItem(struct XbelParseStatus *stat)
{
	int result = 0;
	Bookmark *bm;

	try{
		bm = new Bookmark(bookmark);
		if (bm == NULL){
			return 1;
		}
	}catch(...){
		return 1;
	}

	switch(stat->itemType){
		//case -1:	// Ȃ
		//break;
		case 1:	// Bookmark
			result = writer->storeItem(bm);
			if (result != 0) {
				logger->debug("Bookmark store error");
			}
		break;
		case 2:	// Folder
			result = writer->storeItem(bm);
			if (result != 0) {
				logger->debug("Folder store error");
			}
		break;
	}
	delete bm;

	return result;
}

/**
 * ubN}[NEtH_ݒ肷B
 *
 * @param stat XML`vpeBXg͏
 * @param name ubN}[NEtH_
 * @return 0:G[Ȃ
 */
int XbelReader::setName(struct XbelParseStatus *stat,char *name)
{
	if (m_layout == XBEL_LAYOUT_QTWEB) {
		// QtWeb browser̃ubN}[N̏ꍇɃtH_̔zuƖO
		// tH_𔻒肷鏈sB
		if (stat->itemType == 2) {	// ŏʊKw̃tH_̏ꍇɎ̏sB
			if (stat->folderLevel == 0) {
				if (!strcmp(name,"Bookmarks Menu")) {
					bookmark.setFolderType(Bookmark::menuBar);
				} else if (!strcmp(name,"Bookmarks Bar")) {
					bookmark.setFolderType(Bookmark::toolBar);
				} else {
					bookmark.setFolderType(Bookmark::normalFolder);
				}
			}
		}
	} else {
		bookmark.setFolderType(Bookmark::normalFolder);
	}

	// ubN}[N
	// QƂϊB
	convChRef(work,name,g_lang);
	bookmark.setName(work);

	// O̐ݒ(}`oCg)
	char *p;
	p = UTF8tombFileNameInternal(name);

	// QƂϊB
	convChRef(work,p,g_lang);

	if (g_verbose) {
		std::cout << work << "\n" << std::flush;
	}
	bookmark.setIeName(work);

	// O̐ݒ(Unicode)
	wchar_t *wp;
	wp = UTF8towcFileNameInternal(name);
	// QƂϊB
	convChRefW(wp,wp);

	bookmark.setIeNameW(wp);

	return 0;
}

/*********************************
  XBELfߕ
**********************************/

/**
 * ACẻ
 *
 * @param stat XML`vpeBXg͏
 * @param item ͂sIuWFNg
 * @return 0:́Eϊ 1:͎s
 */
int XbelReader::parseItem(struct XbelParseStatus *stat,TJsonValue *item)
{
	int result = 0;
	char *titleValue = NULL;
	char *descValue = NULL;

	bookmark.reset();
	bookmark.getXbelBookmark(m_bookmarkNo)->reset();

	// tH_EubN}[N
	TJsonValue *title = item->getObjectValue("title");
	if (title != NULL) {
		if (title->getType() == TJsonValue::VALUE) {
			// name̒l
			titleValue = title->getValue();
			setName(stat,titleValue);
		}
	}

	// descvf
	TJsonValue *desc = item->getObjectValue("desc");
	if (desc != NULL) {
		if (desc->getType() == TJsonValue::VALUE) {
			// name̒l
			descValue = desc->getValue();
			// QƂϊB
			convChRef(work,descValue,g_lang);
			bookmark.setDescription(work);
		}
	}

	if (item->getType() == TJsonValue::OBJECT) {
		// ubN}[N̏
		bookmark.setItemType(Bookmark::bookmark);
		stat->itemType = 1;

		TJsonValue *separator = item->getObjectValue("separator");
		if (separator == NULL) {
			// URL̏
			TJsonValue *url = item->getObjectValue("href");
			if (url != NULL) {
				if (url->getType() == TJsonValue::VALUE) {
					// url̒l
					if (url->getValue() != NULL) {
						convChRefUTF8(urlBuf,url->getValue(),g_lang);
						bookmark.setURL(urlBuf);
					}
				}
			}
			// ƂĈȉ̌`ׂB
			// http://www.w3.org/TR/NOTE-datetime
			// YYYY-MM-DDThh:mm:ssTZD
		} else {
			bookmark.setSeparator(true);
		}
		flushItem(stat);
	} else {
		// tH_̏
		bookmark.setItemType(Bookmark::folder);
		stat->itemType = 2;

		// ƂĈȉ̌`ׂB
		// http://www.w3.org/TR/NOTE-datetime
		// YYYY-MM-DDThh:mm:ssTZD

		// QtWebuEŨCAEg̏ꍇAtH_̎ނ̔菈sB
		if (stat->folderLevel == 0) {
			if (titleValue != NULL) {
				if (!strcmp(titleValue,"Bookmarks Bar")) {
					bookmark.setFolderType(Bookmark::toolBar);
				} else if (!strcmp(titleValue,"Bookmarks Menu")) {
					bookmark.setFolderType(Bookmark::menuBar);
				} else {
					bookmark.setFolderType(Bookmark::normalFolder);
				}
			}
		}

		if (bookmark.getFolderType() != Bookmark::toolBar || ignoreToolbar == false) {
			flushItem(stat);

			stat->folderLevel++;
			result = parseFolder(stat,item);
			writer->upFolder();
			stat->folderLevel--;
		}
	}

	return result;
}

/**
 * tH_̉
 *
 * @param stat XML`vpeBXg͏
 * @param folderArray tH_̔z
 * @return 0:́Eϊ 1:͎s
 */
int XbelReader::parseFolder(struct XbelParseStatus *stat,TJsonValue *folderArray)
{
	int result = 0;
	unsigned int count = folderArray->getArrayCount();

	for (unsigned int i = 0;i < count;i++) {
		// tH_̊evf擾B
		TJsonValue *item = folderArray->getArrayValue(i);
		if (item == NULL) {
			// itemIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("Folder item not found");
			return 1;
		}else{
			// 擾vfɉsB
			switch (item->getType()) {
				case TJsonValue::OBJECT:
					// itemIuWFNg̉͂ɓ
					result = parseItem(stat,item);
					if (result) {
						logger->debug("Folder item parse error");
						return 1;
					}
					break;
				case TJsonValue::ARRAY:
					result = parseItem(stat,item);
					if (result) {
						logger->debug("Folder item parse error");
						return 1;
					}
					break;
				default:
					logger->debug("Bad folder item");
					return 1;
			}
		}
	}

	return result;	
}

/**
 * ubN}[N͊Jn
 *
 * @param stat XML`vpeBXg͏
 * @return 0:́Eϊ 1:͎s
 */
int XbelReader::parseStart(struct XbelParseStatus *stat)
{
	int result = 0;	// ͌

	if (topValue.getType() != TJsonValue::ARRAY) {
		// gbvIuWFNg͔złKv̂ŁA
		// łȂꍇ͕stH[}bgG[
		logger->debug("Bad top level item");
		return 1;
	} else {
		// ŏ̔z̉͂ɓ
		result = parseFolder(stat,&topValue);
	}
	return result;
}



/*****************************
  XBELt@C͕
*****************************/

/**
 * \vfX^bNɒlpushB
 *
 * @param type \vf
 */
void XbelReader::pushElement(ItemType type)
{
	if (elementPoint >= elementStack.size()) {
		elementStack.push_back(type);
		elementPoint++;
	} else {
		elementStack[elementPoint] = type;
		elementPoint++;
	}
}

/**
 * \vfX^bN̒lpopB
 */
void XbelReader::popElement(void)
{
	if (elementPoint > 0) {
		elementPoint--;
	}
}

/**
 * 1O̍\vfԂB
 *
 * @return \vf
 */
XbelReader::ItemType XbelReader::previousElement(void)
{
	if (elementPoint == 0) {
		return XbelReader::NONE;
	}
	return elementStack[elementPoint - 1];
}

/**
 * lX^bNɒlpushB
 *
 * @param type \vf
 */
void XbelReader::pushValue(TJsonValue *value)
{
	if (valuePoint >= valueStack.size()) {
		valueStack.push_back(value);
		valuePoint++;
	} else {
		valueStack[valuePoint] = value;
		valuePoint++;
	}
}

/**
 * \vfX^bN̒lpopB
 */
void XbelReader::popValue(void)
{
	if (valuePoint > 0) {
		valuePoint--;
	}
}

/**
 * 1O̍\vfԂB
 *
 * @return \vf
 */
TJsonValue *XbelReader::previousValue(void)
{
	if (valuePoint == 0) {
		return NULL;
	}
	return valueStack[valuePoint - 1];
}

/* evfʂ̉߃W[ */

/**
 * foldervf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int XbelReader::parseFolderElement(struct XbelParseStatus *stat,HTMLtag *tag)
{
	int ret = 0;
	if ( !tag->isEndtag() ){
		// GgJn
		TJsonValue *newValue;
		switch (currentElement) {
			case INITIAL:
				// ŏł܂^܂ĂȂꍇxbelvfKvȂ̂ŁA
				// G[ƂB
				logger->debug("XBEL element not found in folder");
				return 1;
			case ARRAY:
				// z̏ꍇ͒lIuWFNgȂ̂ō쐬B
				newValue = currentValue->addArrayValue();
				if (newValue == NULL) {
					logger->debug("Folder item create error");
					return 1;
				}
				newValue->setType(TJsonValue::ARRAY);
				newValue->setValue(item);
				pushValue(currentValue);
				pushElement(currentElement);

				currentValue = newValue;
				currentElement = ARRAY;
				break;
			case OBJECT:
				// IuWFNg(=ubN}[N)̒ɔz(=tH_)邱Ƃ͂Ȃ̂
				// G[ƂB
				logger->debug("Invalid folder item");
				return 1;
			default:
				// ̑̏Ԃ̎̓G[ƂB
				logger->debug("Bad folder item");
				return 1;
		}
	} else {
		// ĂzIāA1O̗vfɖ߂B
		if (valuePoint > 0) {
			currentValue = previousValue();
			popValue();
		}
		if (elementPoint > 0) {
			currentElement = previousElement();
			popElement();
		}
	}
	return 0;
}

/**
 * bookmarkvf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int XbelReader::parseBookmarkElement(struct XbelParseStatus *stat,HTMLtag *tag)
{
	int ret = 0;

	if ( !tag->isEndtag() ){
		// GgJn
		TJsonValue *newValue;
		char *href;
		switch (currentElement) {
			case INITIAL:
				// ŏł܂^܂ĂȂꍇxbelvfKvȂ̂ŁA
				// G[ƂB
				logger->debug("XBEL element not found in bookmark");
				return 1;
			case ARRAY:
				// z̏ꍇ͒ǉB
				newValue = currentValue->addArrayValue();
				newValue->setType(TJsonValue::OBJECT);
				// ܂ňĂ̂ޔB
				pushElement(currentElement);
				pushValue(currentValue);
				// Ăvf̓fBNVi
				currentElement = OBJECT;
				// AVvfB
				currentValue = newValue;

				// hrefǂݍށB
				href = tag->getAttrValue("href");
				if (href != NULL) {
					TJsonValue *hrefValue;
					hrefValue = currentValue->addObjectValue("href");
					if (hrefValue == NULL) {
						logger->debug("Href attribute create error");
						return 1;
					}
					hrefValue->setType(TJsonValue::VALUE);
					hrefValue->setValue(href);
				}
				break;
			case OBJECT:
				// IuWFNg(=ubN}[N)̒
				// IuWFNg(=ubN}[N)邱Ƃ͂Ȃ̂
				// G[ƂB
				logger->debug("Invalid nesting bookmark");
				return 1;
			default:
				// ̑̏Ԃ̎̓G[ƂB
				logger->debug("Invalid bookmark");
				return 1;
		}
	} else {
		// ĂfBNViIāA1O̗vfɖ߂B
		if (valuePoint > 0) {
			currentValue = previousValue();
			popValue();
		}
		if (elementPoint > 0) {
			currentElement = previousElement();
			popElement();
		}
	}

	return ret;
}

/**
 * separatorvf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int XbelReader::parseSeparatorElement(struct XbelParseStatus *stat,HTMLtag *tag)
{
	int ret = 0;

	if ( tag->isEndtag() ){
		// GgJn
		TJsonValue *newValue;
		switch (currentElement) {
			case INITIAL:
				// ŏł܂^܂ĂȂꍇxbelvfKvȂ̂ŁA
				// G[ƂB
				logger->debug("Xbel element not found");
				return 1;
			case ARRAY:
				// z̏ꍇ͒ǉB
				newValue = currentValue->addArrayValue();
				newValue->setType(TJsonValue::OBJECT);
				// ܂ňĂ̂ޔB
				pushElement(currentElement);
				pushValue(currentValue);
				// Ăvf̓fBNVi
				currentElement = OBJECT;
				// AVvfB
				currentValue = newValue;

				TJsonValue *hrefValue;
				hrefValue = currentValue->addObjectValue("separator");
				if (hrefValue == NULL) {
					logger->debug("Href attribute create error");
					return 1;
				}
				hrefValue->setType(TJsonValue::VALUE);
				hrefValue->setValue("1");

				// ĂfBNViIāA1O̗vfɖ߂B
				if (valuePoint > 0) {
					currentValue = previousValue();
					popValue();
				}
				if (elementPoint > 0) {
					currentElement = previousElement();
					popElement();
				}
				break;
			case OBJECT:
				// IuWFNg(=ubN}[N)̒
				// IuWFNg(=ubN}[N)邱Ƃ͂Ȃ̂
				// G[ƂB
				logger->debug("Invalid nesting separator");
				return 1;
			default:
				// ̑̏Ԃ̎̓G[ƂB
				logger->debug("Invalid separator");
				return 1;
		}
	}

	return ret;
}

/**
 * xbelvf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int XbelReader::parseXbelElement(struct XbelParseStatus *stat,HTMLtag *tag)
{
	int ret = 0;

	if ( !tag->isEndtag() ){
		// GgJn
		switch (currentElement) {
			case INITIAL:
				// ŏł܂^܂ĂȂꍇ
				// ݈Ă镨fBNViƂB
				currentValue->setType(TJsonValue::ARRAY);
				currentElement = ARRAY;
				break;
			case ARRAY:
				// ŏȊOłꂪG[ƂB
				logger->debug("Invalid array element");
				return 1;
			case OBJECT:
				// ŏȊOłꂪG[ƂB
				logger->debug("Invalid object element");
				return 1;
			default:
				// ŏȊOłꂪG[ƂB
				logger->debug("Invalid element");
				return 1;
		}
	} else {
		// ĂfBNViIāA1O̗vfɖ߂B
		if (valuePoint > 0) {
			currentValue = previousValue();
			popValue();
		}
		if (elementPoint > 0) {
			currentElement = previousElement();
			popElement();
		}
	}

	return ret;
}

/**
 * titlevf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int XbelReader::parseTitleElement(struct XbelParseStatus *stat,HTMLtag *tag)
{
	if ( !tag->isEndtag() ){
		// GgJn
		pItem = item;
		cItem = 0;
		stat->storeing = 1;	/* vf̒gi[JnB */
	}else{
		*pItem = '\0';
		stat->storeing = 0;

		TJsonValue *newValue;
		switch (currentElement) {
			case INITIAL:
				// ŏł܂^܂ĂȂꍇ͔z񂩃fBNViłKv̂
				// G[ƂB
				logger->debug("Xbel element not found");
				return 1;
			case ARRAY:
				// tH_
				newValue = currentValue->addObjectValue("title");
				if (newValue == NULL) {
					logger->debug("Title attribute create error");
					return 1;
				}
				newValue->setType(TJsonValue::VALUE);
				newValue->setValue(item);

				break;
			case OBJECT:
				// ubN}[N
				newValue = currentValue->addObjectValue("title");
				if (newValue == NULL) {
					logger->debug("Title attribute create error");
					return 1;
				}
				newValue->setType(TJsonValue::VALUE);
				newValue->setValue(item);

				break;
			default:
				// ̑̏Ԃ̎̓G[ƂB
				logger->debug("Invalid title");
				return 1;
		}
	}
	return 0;
}

/**
 * descvf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int XbelReader::parseDescElement(struct XbelParseStatus *stat,HTMLtag *tag)
{
	if ( !tag->isEndtag() ){
		// GgJn
		pItem = item;
		cItem = 0;
		stat->storeing = 1;	/* vf̒gi[JnB */
	}else{
		*pItem = '\0';
		stat->storeing = 0;

		TJsonValue *newValue;
		switch (currentElement) {
			case INITIAL:
				// ŏł܂^܂ĂȂꍇ͔z񂩃fBNViłKv̂
				// G[ƂB
				logger->debug("Xbel element not found");
				return 1;
			case ARRAY:
				// tH_
				newValue = currentValue->addObjectValue("desc");
				if (newValue == NULL) {
					logger->debug("Desc attribute create error");
					return 1;
				}
				newValue->setType(TJsonValue::VALUE);
				newValue->setValue(item);

				break;
			case OBJECT:
				// ubN}[N
				newValue = currentValue->addObjectValue("desc");
				if (newValue == NULL) {
					logger->debug("Desc attribute create error");
					return 1;
				}
				newValue->setType(TJsonValue::VALUE);
				newValue->setValue(item);

				break;
			default:
				// ̑̏Ԃ̎̓G[ƂB
				logger->debug("Invalid desc attribute");
				return 1;
		}
	}
	return 0;
}

/**
 * XMLevf̉͂sB
 *
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return 0 ͐ 1 ̓G[
 */
int XbelReader::parseElement(struct XbelParseStatus *stat,HTMLtag *tag)
{
	int ret = 0;

	if ( !strcmp(tag->getName(),"xbel") ){
		ret = parseXbelElement(stat,tag);
	}

	if ( !strcmp(tag->getName(),"title") ){
		ret = parseTitleElement(stat,tag);
	}

	if ( !strcmp(tag->getName(),"folder") ){
		ret = parseFolderElement(stat,tag);
	}

	if ( !strcmp(tag->getName(),"bookmark") ){
		ret = parseBookmarkElement(stat,tag);
	}

	if ( !strcmp(tag->getName(),"desc") ){
		ret = parseDescElement(stat,tag);
	}

	if ( !strcmp(tag->getName(),"separator") ){
		ret = parseSeparatorElement(stat,tag);
	}

	return ret;
}

/**
 * HTML̊{Iȉ͂sB
 *
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @param c ǂݍ񂾕
 * @return 0:͐ 1:̓G[
 */
int XbelReader::parseHTML(struct XbelParseStatus *stat,HTMLtag *tag,char c)
{
	int result;	/* ^Oߌ */
	int ret = 0;

	if (!stat->inTag){
		/* ^O̒ł͂Ȃ */
		if (c == '<'){
			stat->inTag = 1;
			stat->inComment = 0;
			tag->init();

		}else{
			/* ʏ̕ */
			//std::cout << c;
			if (stat->storeing){
				/* vf̒li[B(A,DD) */
				if (cItem < (BUFLEN - 1)){
					*pItem = c;
					pItem++;
					cItem++;
				}
			}
		}
	}else{
		/* ^O̒ */
		if (!stat->inComment){
			result = tag->doParse(c);
		}else{
			/* Rg */
			if (c == '-' && stat->previous == '-'){	// RgI
				//std::cout << "RgI\n";
				stat->inComment = 0;
			}
			result = 0;
		}
		switch(result){
			case 0:	/* ^Oi[ */
			break;
			case 2:	/* RgJn */
				stat->inComment = 1;
			break;
			case 1:	/* ^OI */
				if (tag->getName() != NULL){
					/* ^Ỏ͂sB */
					ret = parseElement(stat,tag);
					stat->inTag = 0;
				}
			break;
			case 3:	/* ߃G[̎͂܂ł𖳌ɂB */
				stat->inTag = 0;
			break;
		}
	}
	stat->previous = c;
	return ret;
}

/**
 * XMLߏԏ
 *
 * @param stat ߏ
 */
void XbelReader::initParseStatus(struct XbelParseStatus *stat)
{
	stat->previous = 0;	/* 1O̕ */
	stat->inTag = 0;	/* ^O̒ǂH */
	stat->inComment = 0;	/* RgǂH */
	stat->isUtf8 = 1;	/* UTF-8ǂH */
	stat->inDD = 0;	/* DDGgǂ? */
	stat->storeing = 0;	/* i[Ă邩ǂ */
	stat->itemType = -1;	/* ݈ĂvftH_ubN}[NH */
	stat->folderLevel = 0;	/* Kw */

	f_item = 0;
}

/**
 * UTF-16GR[ht@CǂݍށB
 *
 * @param filename t@C
 * @param stat t@Cǂݍݏ
 * @param flag 0:gGfBA 1:rbOGfBA
 * @return 0:G[Ȃ 1:G[
 */
int XbelReader::readUtf16(const char *filename,struct XbelParseStatus *stat,int flag)
{
	FILE *fp;
	unsigned char buf[16],utf8buf[16];
	size_t read;
	unsigned int high,low;
	wchar_t wbuf[2],wch;
	unsigned char *p;
	int result = 0;
	HTMLtag tag;	// ^OIuWFNg

	wbuf[1] = 0x00;

	fp = fopen(filename,"rb");
	if (fp == NULL) {
		return 1;
	}
	while(1) {
		read = fread(buf,1,2,fp);
		if (read < 2) {
			break;
		}
		if (flag) {
			high = buf[0];
			low = buf[1];
		} else {
			high = buf[1];
			low = buf[0];
		}
		wch = (high << 8) | low;
		wbuf[0] = wch;
		toUTF8(utf8buf,wbuf);
		p = utf8buf;
		while(*p) {
			result = parseHTML(stat,&tag,*p);	/* HTMLߕɓnB */
			if (result){
				/* G[炻̎_ŔB */
				break;
			}
			p++;
		}
	}
	fclose(fp);
	return result;
}

/**
 * UTF-32GR[ht@CǂݍށB
 *
 * @param filename t@C
 * @param stat t@Cǂݍݏ
 * @param flag 0:gGfBA 1:rbOGfBA
 * @return 0:G[Ȃ 1:G[
 */
int XbelReader::readUtf32(const char *filename,struct XbelParseStatus *stat,int flag)
{
	FILE *fp;
	unsigned char buf[16],utf8buf[16];
	unsigned long ul;
	size_t read;
	unsigned int high,low;
	wchar_t wbuf[2];
	unsigned char *p;
	int result = 0;
	HTMLtag tag;	// ^OIuWFNg

	wbuf[1] = 0x00;

	fp = fopen(filename,"rb");
	if (fp == NULL) {
		return 1;
	}
	while(1) {
		read = fread(buf,1,4,fp);
		if (read < 4) {
			break;
		}
		if (flag) {
			high = buf[0];
			low = buf[1];
		} else {
			high = buf[3];
			low = buf[2];
		}
		ul = (high << 8) | low;
		if (flag) {
			high = buf[2];
			low = buf[3];
		} else {
			high = buf[1];
			low = buf[0];
		}
		ul = (ul << 16) | (high << 8) | low;

		wbuf[0] = (wchar_t)ul;
		toUTF8(utf8buf,wbuf);
		p = utf8buf;
		while(*p) {
			result = parseHTML(stat,&tag,*p);	/* HTMLߕɓnB */
			if (result){
				/* G[炻̎_ŔB */
				break;
			}
			p++;
		}
	}
	fclose(fp);
	return result;
}


/**
 * UTF-88bitŃGR[hꂽt@CǂݍށB
 *
 * @param bmFile ubN}[Nt@C
 * @param stat t@Cǂݍݏ
 * @return 0:ǂݍ݁ERo[g 1:ǂݍ݁ERo[gs
 */
int XbelReader::read8bit(const char *bmFile,struct XbelParseStatus *stat)
{
	int ret = 0;	// s
	FILE *fp;
	HTMLtag tag;	// ^OIuWFNg
	int c;	// ǂݍ񂾕
	int prev = 0;

	fp = fopen(bmFile,"rb");
	if (fp == NULL) {
		return 1;
	}

	// t@Cǂݍ݂sB
	while(1){
		c = fgetc(fp);
		if (c == EOF) {
			break;
		}
		if (c == 0x0a) {
			// s1nB
			if (prev == '\n') {
				prev = c;
				continue;
			}
		}
		if (c == 0x0d) {
			c = '\n';
		}
		ret = parseHTML(stat,&tag,c);	/* HTMLߕɓnB */
		if (ret){
			/* G[炻̎_ŔB */
			break;
		}
		prev = c;
	}

	fclose(fp);

	return(ret);
}

/**
 * ͂JnBmۂB
 *
 * @param bmFile ubN}[Nt@C
 * @param fvDir gp
 * @return 0: 0:s
 */
int XbelReader::readBookmark(const char *bmFile,const char *fvDir)
{
	int ret;
	struct XbelParseStatus stat;	// ߏԍ\

	initParseStatus(&stat);	// ͏ԂB

	// ꎞobt@mۂB
	work = NULL;
	try{
		work = new char[BUFLEN];
		if (work == NULL){
			return 1;
		}
	}catch(...){
		return 1;
	}

	switch(checkBOM(bmFile)) {
		case ENCODE_8BIT:
			ret = read8bit(bmFile,&stat);
			break;
		case ENCODE_UTF8_BOM:
			ret = read8bit(bmFile,&stat);
			break;
		case ENCODE_UTF16_BE:
			ret = readUtf16(bmFile,&stat,1);
			break;
		case ENCODE_UTF16_LE:
			ret = readUtf16(bmFile,&stat,0);
			break;
		case ENCODE_UTF32_BE:
			ret = readUtf32(bmFile,&stat,1);
			break;
		case ENCODE_UTF32_LE:
			ret = readUtf32(bmFile,&stat,0);
			break;
		case -1:
			delete []work;
			return -1;
	}

	if (ret == 0) {
		// G[Ȃꍇ͂Ŋi[JnB
		ret = parseStart(&stat);
	}

	delete []work;

	return ret;
}

