#ifndef VIWRITER_H
#define VIWRITER_H

#include	<stdio.h>
#include	<vector>
#include "Bookmark.h"
#include "IBookmarkWriter.h"

#include	"ViMetaData.h"

class ViWriter : public IBookmarkWriter {
private:
	int m_spaces;	// ݂̃Xy[X̌
	FILE *cs_fpo;	// ubN}[No͗pt@C|C^
	char *urlBuf;
	int urlBufLen;

	// ݑΏۂ̑
	int m_target;
	bool placesPut;	// Firefox 3̃X}[gubN}[NtH_o͂邩ǂH
	bool m_ignore;
	bool putIEToolbar;	// IÊCɓo[o͂邩ǂ
	bool isFirstRoot;
	unsigned int m_ignoreSince;
	int bookmarkType;	// 0:Chrome 1:Vivaldi bookmarks bar
	bool inFolder;
	bool m_putTrash;	// ݔo͂邩ǂ
	bool allPut;	// ׂẴubN}[No͂邩ǂ
	bool syncedPut;
	int m_level;

	std::vector<int> itemsCount;
	int maxLevel;

	ViMetaData* metaData;

	int reallocUrlBuf(int size);
	void spput(FILE *fp,int spaces);
	void putWithEscape(FILE *fp, char *str);
	void putname(FILE *fp,wchar_t *name);
	void putname2(FILE *fp,char *name);
	void putname3(FILE *fp, char *name);
	void putURL(Bookmark *item);
	void putToolbarFolder(Bookmark *item);
	void putMenubarFolder(Bookmark *item);
	void putNormalFolder(Bookmark *item);
	void putFolderEndInfo(Bookmark *item);
	void putItemPause(void);
	bool putMetaValue(const char *key, char *value, bool outValue);
	bool putMetaValue(const char *key, bool value, bool outValue);

public:
	ViWriter();
	~ViWriter();

	/* ubN}[No̓C^[tFCXCvg */
	void putHeader(void);
	void putFolder(Bookmark *item);
	void putFolderEnd(Bookmark *item,bool isLast);
	void putBookmark(Bookmark *item,bool isLast);
	void putFooter(void);

	// ubN}[No͗pt@C|C^ݒ
	void setFilePointer(FILE *fpo) {cs_fpo = fpo;};

	// ݑΏۑ̐ݒ
	int getTarget(void) {return m_target;};
	void setTarget(int target) {m_target = target;};

	void setPlacesPut(bool mode) {
		placesPut = mode;
	}
	bool getIEToolbarPut(void) {
		return putIEToolbar;
	}
	void setIEToolbarPut(bool value) {
		putIEToolbar = value;
	}

#if 0
	int getBookmarkType(void) {
		return bookmarkType;
	}
	void setBookmarkType(int mode) {
		bookmarkType = mode;
	}
#endif

	bool getInFolder(void) {
		return inFolder;
	}
	void setInFolder(bool value) {
		inFolder = value;
	}

	/**
	 * ݔo͂邩ǂ擾B
	 *
	 * @return true:ݔo͂ false:o͂Ȃ
	 */
	bool getTrashMode(void) {
		return m_putTrash;
	}

	/**
	 * ݔo͂邩ǂݒ肷B
	 *
	 * @param mode true:ݔo͂ false:o͂Ȃ
	 * @return true:ݔo͂ false:o͂Ȃ
	 */
	bool setTrashMode(bool mode) {
		m_putTrash = mode;
		return mode;
	}

	/**
	 * ׂẴtH_o͂邩ǂ擾B
	 *
	 * @return true:o͂ false:o͂Ȃ
	 */
	bool getAllPut(void) {
		return allPut;
	}

	/**
	 * ׂẴtH_o͂邩ǂݒ肷B
	 *
	 * @param mode true:o͂ false:o͂Ȃ
	 * @return true:o͂ false:o͂Ȃ
	 */
	bool setAllPut(bool mode) {
		allPut = mode;
		return mode;
	}

	/**
	 * ^f[^IuWFNgݒ肷B
	 *
	 *  @param metaData ^f[^IuWFNg
	 */
	void setMetaData(ViMetaData* metaData) {
		this->metaData = metaData;
	}
};

#endif	// VIWRITER_H
