#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NTfunction.h"
#include	"Bookmark.h"
#include	"url.h"

#include	"ViWriter.h"

/**
 * RXgN^
 */
ViWriter::ViWriter()
{
	m_target = 0;
	m_level = 0;
	placesPut = true;
	m_ignore = false;
	itemsCount.push_back(0);
	putIEToolbar = true;
	isFirstRoot = true;
	bookmarkType = 1;
	inFolder = true;
	allPut = false;
	syncedPut = false;
	cs_fpo = NULL;
	m_ignoreSince = -1;
	m_putTrash = false;
	m_spaces = 0;
	metaData = NULL;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
	urlBufLen = BUFLEN;
}

/**
 * fXgN^
 */
ViWriter::~ViWriter()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int ViWriter::reallocUrlBuf(int size)
{
	delete []urlBuf;
	try {
		urlBuf = NULL;
		urlBuf = new char[size];
		if (urlBuf == NULL) {
			return -1;
		}
		urlBufLen = size;
	} catch (...) {
		return -1;
	}
	return size;
}

/**
 * Xy[Xo͂B
 *
 * @param fp o͐̃t@C|C^
 * @param tabs ^u̐
 */
void ViWriter::spput(FILE *fp,int tabs)
{
	int i;
	
	for (i = 0;i < (tabs * 3);i++){
		fputc(' ',fp);
	}
}

/**
 * 悤ɕGXP[vďo͂B
 *
 * @param fp o͐̃t@C|C^
 * @param str o͑Ώە
 */
void ViWriter::putWithEscape(FILE *fp, char *str)
{
	char *p = str;

	while (*p) {
		switch (*p) {
			case '\\':
				// _uNH[g̓GXP[vB
				fputc('\\', fp);
				fputc(*p, fp);
				break;
			case '\r':
				fputc('\\', fp);
				fputc('r', fp);
				break;
			case '\n':
				fputc('\\', fp);
				fputc('n', fp);
				break;
			default:
				fputc(*p, fp);
				break;
		}
		p++;
	}
}

/**
 * tH_AubN}[ÑJ}؂o͂ƃJ}Kvǂ̃JEgsB
 *
 */
void ViWriter::putItemPause(void)
{
	if ((inFolder) || (m_level < 2)) {
		// tH_ɃtH_ꍇ͊etH_̏Ԃ
		// J}łB
		if (itemsCount[m_level] > 0) {
			fprintf(cs_fpo,", ");
		}
		itemsCount[m_level] += 1;
	} else {
		if (m_level < 2) {
			// 1iڂ܂ł͊etH_̏Ԃ
			// J}łB
			if (itemsCount[m_level] > 0) {
				fprintf(cs_fpo,", ");
			}
			itemsCount[m_level] += 1;
		} else {
			// tH_̒2iڂ̏ԂɃJ}łB
			if (itemsCount[2] > 0) {
				fprintf(cs_fpo,", ");
			}
			itemsCount[2] += 1;
		}
	}
}

/**
 * tH_̏o͂B
 *
 * @param item o͑Ώۂ̃tH_
 */
void ViWriter::putFolder(Bookmark *item)
{
	switch(item->getFolderType()) {
		case Bookmark::toolBar:
			if (m_level == 0) {
				putToolbarFolder(item);
			} else {
				putNormalFolder(item);
			}
			break;
		case Bookmark::menuBar:
			if (m_level == 0) {
				putMenubarFolder(item);
			} else {
				putNormalFolder(item);
			}
			break;
		case Bookmark::mobile:
			if (m_level == 0) {
				if (!isFirstRoot) {
					fprintf(cs_fpo, ",\n");
				}
				isFirstRoot = false;
				spput(cs_fpo, 2);
				fprintf(cs_fpo, "\"synced\": {\n");
				spput(cs_fpo, 3);
				fprintf(cs_fpo, "\"children\": [ ");
				syncedPut = true;
			} else {
				putNormalFolder(item);
			}
			break;
		case Bookmark::viTrash:
			if (m_level == 0) {
				if (!isFirstRoot) {
					fprintf(cs_fpo, ",\n");
				}
				isFirstRoot = false;
				spput(cs_fpo, 2);
				fprintf(cs_fpo, "\"trash\": {\n");
				spput(cs_fpo, 3);
				fprintf(cs_fpo, "\"children\": [ ");

				if (!m_putTrash) {
					// S~o͂ȂƂ͖B
					m_ignore = true;
					m_ignoreSince = 0;
					putFolderEndInfo(item);
				}
			} else {
				putNormalFolder(item);
			}
			break;
		default:
			putNormalFolder(item);
			break;
	}
	m_level++;

	// ̊Kw̗vfB
	if (m_level >= itemsCount.size()) {
		itemsCount.push_back(0);
	} else {
		itemsCount[m_level] = 0;
	}
}

/**
 * Chromeł̓ubN}[No[ɓtH_̏o͂B<br>
 * (Vivaldił͖)
 *
 * @param item o͑Ώۂ̃tH_
 */
void ViWriter::putToolbarFolder(Bookmark *item)
{
	// ׂĂo͂Ȃꍇ͖
	// VivaldĩubN}[NŃubN}[No[Ɠꍇ͖B
	m_ignore = true;
	m_ignoreSince = 0;
}

/**
 * Chromeł͂̑̃ubN}[NɓtH_̏o͂B<br>
 * (Vivaldił̓ubN}[No[ɍւB)
 *
 * @param item o͑Ώۂ̃tH_
 */
void ViWriter::putMenubarFolder(Bookmark *item)
{
	m_ignore = false;
	if (!isFirstRoot) {
		fprintf(cs_fpo, ",\n");
	}
	isFirstRoot = false;
	spput(cs_fpo, 2);

	// Vivaldi bookmarks bar
	// ق̃j[o[ubN}[No[ɍւB
	fprintf(cs_fpo, "\"bookmark_bar\": {\n");

	spput(cs_fpo, 3);
	fprintf(cs_fpo, "\"children\": [ ");

}

/**
 * ʏtH_̏o͂B
 *
 * @param item o͑Ώۂ̃tH_
 */
void ViWriter::putNormalFolder(Bookmark *item)
{
	if (m_level == 0) {
		// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂B
		m_ignore = true;
		m_ignoreSince = 0;
	} else {
		if ((putIEToolbar == false) && (item->isIEToolbar())) {
			m_ignore = true;
			m_ignoreSince = m_level;
		}
		if (!m_ignore) {
			// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂A
			// Kŵ݃JEgB
			if ((inFolder) || (m_level < 2)) {
				// tH_̍ŏ̗vfȊȌꍇ1O̗vf̋؂Ƃ,łB
				putItemPause();

				fprintf(cs_fpo, "{\n");
				spput(cs_fpo, 3 + m_level);
				fprintf(cs_fpo, "\"children\": [");
			}
		}
	}
}

/**
 * tH_ĨtH_̏o͂B
 *
 * @param item o͑Ώۂ̃tH_
 */
void ViWriter::putFolderEndInfo(Bookmark *item)
{
	fprintf(cs_fpo,"],\n");
	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"date_added\": \"");
	putChromeDateTime(cs_fpo,item->getAdddate());
	fprintf(cs_fpo,"\",\n");

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"date_modified\": \"");
	putChromeDateTime(cs_fpo,item->getModified());
	fprintf(cs_fpo,"\",\n");

	ViBookmark *viInfo = item->getViBookmark(m_target);
	if (viInfo->getID() != NULL) {
		spput(cs_fpo,3 + m_level);
		fprintf(cs_fpo,"\"id\": \"");
		wchar_t *wp = UTF8towcFileNameInternal(viInfo->getID());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo,"\",\n");
	}

	if (viInfo->getGUID() != NULL) {
		spput(cs_fpo, 3 + m_level);
		fprintf(cs_fpo, "\"guid\": \"");
		wchar_t* wp = UTF8towcFileNameInternal(viInfo->getGUID());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo, "\",\n");
	}

	// meta_infoo͂B
	spput(cs_fpo, 3 + m_level);
	fprintf(cs_fpo, "\"meta_info\": {\n");
	bool outMetaInfoValue = false;

	outMetaInfoValue = putMetaValue("Description", item->getDescription(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue("Nickname", item->getShortcut(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue("Speeddial", viInfo->getSpeedDial(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue("Thumbnail", viInfo->getThumbnail(), outMetaInfoValue);
	if (viInfo->getBookmarkBar()) {
		outMetaInfoValue = putMetaValue(BOOKMARKBAR, viInfo->getBookmarkBar(), outMetaInfoValue);
	}

	fprintf(cs_fpo, "\n");
	spput(cs_fpo, 3 + m_level);
	fprintf(cs_fpo, "},\n");
	// meta_info͂܂

	// for Vivaldi
#if 0
	if (bookmarkType == 1) {
		char guid[40];
		createUUID(guid);
		strupr(guid);	// UUID͑啶łȂƔFȂBŁH

		spput(cs_fpo,3 + m_level);
		fprintf(cs_fpo,"\"guid\": \"");
		fprintf(cs_fpo,"%s\",\n", guid);
		//spput(cs_fpo,3 + m_level);
		//fprintf(cs_fpo,"\"description\": \"\",\n");
	}
#endif
	// for Vivaldi end

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"name\": \"");
	if (item->getFolderType() == Bookmark::mobile) {
		putJSONString(cs_fpo, L"oC̃ubN}[N");
	} else {
		if (item->getIeNameW() != NULL){
			putJSONString(cs_fpo,item->getIeNameW());
		}
	}
	fprintf(cs_fpo,"\",\n");
	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"type\": \"folder\"\n");
	spput(cs_fpo,2 + m_level);
	fprintf(cs_fpo,"}");
	switch(item->getFolderType()) {
		case Bookmark::toolBar:
			break;
		case Bookmark::menuBar:
			break;
		case Bookmark::mobile:
			break;
		default:
			break;
	}
}

/**
 * tH_Io͂B
 *
 * @param item o͂tH_
 */
void ViWriter::putFolderEnd(Bookmark *item,bool isLast)
{
	m_level--;

	// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂A
	// Kŵ݃JEgB
	if (!m_ignore) {
		if ((inFolder) || (m_level < 2)) {
			putFolderEndInfo(item);
		}
	}
	if (m_level == m_ignoreSince) {
		m_ignore = false;
	}
}

/**
 * URL̏o͂B
 *
 * @param item URLo͂ubN}[N
 */
void ViWriter::putURL(Bookmark *item)
{
	if (item->getURL() != NULL){
		char *p;
		wchar_t *wp;
		int escapeLen;

		p = item->getURL();
		if (strncmp("javascript:", p,11) == 0) {
			// ubN}[Nbg̏ꍇURLGR[h
			escapeLen = strlen(p) * 3;
			if ((escapeLen + 1) > urlBufLen) {
				reallocUrlBuf(escapeLen);
			}
			encodeURL(urlBuf, p);
			p = urlBuf;
		} else if (strncmp("file:", p, 5) == 0) {
			// file:̏ꍇURLGR[hB
			escapeLen = strlen(p) * 3;
			if ((escapeLen + 1) > urlBufLen) {
				reallocUrlBuf(escapeLen);
			}
			encodeURL(urlBuf, p);
			p = urlBuf;
		}

		wp = UTF8towcFileNameInternal(p);

		putJSONString(cs_fpo,wp);
	}
}

/**
 * ubN}[N̏o͂B
 */
void ViWriter::putBookmark(Bookmark *item,bool isLast)
{
	if (!placesPut) {
		// Firefox 3̃X}[gubN}[NtH_炱𖳎B
		if (item->isPlaceURI()) {
			return;
		}
	}

	// VivaldiɂZp[^͂Ȃ̂ŉɏݐƂB
	if (item->getSeparator()) {
		return;
	}
	if (m_ignore) {
		// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂B
		return;
	}
	if (m_level == 0) {
		// ŏ̊Kw(ubN}[No[Ȇ̃ubN}[NƂ)
		// ɂ̓ubN}[N͓Ȃ̂Ŕ΂B
		return;
	}

	// tH_̍ŏ̗vfȊȌꍇ1O̗vf̋؂Ƃ,łB
	putItemPause();

	fprintf(cs_fpo,"{\n");
	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"date_added\": \"");
	putChromeDateTime(cs_fpo,item->getAdddate());
	fprintf(cs_fpo,"\",\n");
	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"date_modified\": \"");
	putChromeDateTime(cs_fpo,item->getModified());
	fprintf(cs_fpo,"\",\n");

	ViBookmark *viInfo = item->getViBookmark(m_target);

	// for Vivaldi
#if 0
	if (bookmarkType == 1) {
		char guid[40];
		createUUID(guid);
		strupr(guid);	// UUID͑啶łȂƔFȂBŁH

		spput(cs_fpo,4 + m_level);
		fprintf(cs_fpo,"\"guid\": \"");
		fprintf(cs_fpo,"%s\",\n", guid);
		//spput(cs_fpo,4 + m_level);
		//fprintf(cs_fpo,"\"description\": \"\",\n");
		//spput(cs_fpo,4 + m_level);
		//fprintf(cs_fpo,"\"nickname\": \"\",\n");
	}
#endif
	// for Vivaldi end

	if (viInfo->getID() != NULL) {
		spput(cs_fpo,3 + m_level);
		fprintf(cs_fpo,"\"id\": \"");
		wchar_t *wp = UTF8towcFileNameInternal(viInfo->getID());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo,"\",\n");
	}

	// meta_infoo͂B
	spput(cs_fpo, 3 + m_level);
	fprintf(cs_fpo, "\"meta_info\": {\n");
	bool outMetaInfoValue = false;

	outMetaInfoValue = putMetaValue("Description", item->getDescription(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue("Nickname", item->getShortcut(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue("Speeddial", viInfo->getSpeedDial(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue("Thumbnail", viInfo->getThumbnail(), outMetaInfoValue);

	fprintf(cs_fpo, "\n");
	spput(cs_fpo, 3 + m_level);
	fprintf(cs_fpo, "},\n");
	// meta_info͂܂

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"name\": \"");
	if (item->getIeNameW() != NULL){
		putJSONString(cs_fpo,item->getIeNameW());
	}
	fprintf(cs_fpo,"\",\n");

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"type\": \"url\",\n");

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"url\": \"");
	putURL(item);
	fprintf(cs_fpo,"\"\n");

	spput(cs_fpo,2 + m_level);
	fprintf(cs_fpo,"}");

}

/**
* meta_info̒l̏o͂sB
*
* @param key L[
* @param value l
* @param outValue ȑOmeta_infoڂ̏o͗L
* @return Vmeta_infȍo͗L
*/
bool ViWriter::putMetaValue(const char *key, char *value, bool outValue)
{
	// o͂lȂꍇ
	if (value == NULL) {
		// o̗͂LȌԂ̂܂܂ɂB
		return outValue;
	}
	// Oɉ炩̒lo͂Ăꍇ
	if (outValue) {
		// ؂,\no͂B
		fprintf(cs_fpo, ",\n");
	}
	// L[ƒlo͂B
	spput(cs_fpo, 4 + m_level);
	fprintf(cs_fpo, "\"%s\": \"", key);
	// lɂ"ꍇ̂ŁAGXP[vB
	putWithEscape(cs_fpo, value);
	fputc('\"', cs_fpo);

	return true;
}

/**
* meta_info̒l̏o͂sB
*
* @param key L[
* @param value l
* @param outValue ȑOmeta_infoڂ̏o͗L
* @return Vmeta_infȍo͗L
*/
bool ViWriter::putMetaValue(const char *key, bool value, bool outValue)
{
	// Oɉ炩̒lo͂Ăꍇ
	if (outValue) {
		// ؂,\no͂B
		fprintf(cs_fpo, ",\n");
	}
	// L[ƒlo͂B
	spput(cs_fpo, 5 + m_level);
	fprintf(cs_fpo, "\"%s\": \"%s\"", key, value ? "true" : "false");

	return true;
}

/**
 * ubN}[Ñwb_o͂B
 */
void ViWriter::putHeader(void)
{
	fprintf(cs_fpo,"{\n");	// Top level object
	fprintf(cs_fpo,"   \"roots\": {\n");

	if (allPut) {
		// ׂĂo͂ꍇ
		// ubN}[No[̋
		fprintf(cs_fpo, "      \"bookmark_bar\": {\n");

		spput(cs_fpo, 3 + m_level);
		fprintf(cs_fpo, "\"children\": [ ");

		// Kw1iKi߂ĊetH_ʏtH_ƂB
		m_level++;
		itemsCount.push_back(0);

	}
}

/**
 * ubN}[Ñtb^o͂B
 */
void ViWriter::putFooter(void)
{
	Bookmark *baseFolder = new Bookmark();
	char *p;
	wchar_t *wName;

	if (allPut) {
		m_level = 0;

		baseFolder->setIeName("ubN}[N");
		p = mbtoUTF8Internal("ubN}[N");
		baseFolder->setName(p);
		wName = mbtowcInternal("ubN}[N");
		baseFolder->setIeNameW(wName);
		baseFolder->setItemType(Bookmark::folder);
		baseFolder->setFolderType(Bookmark::toolBar);

		spput(cs_fpo, 3 + m_level);
		putFolderEndInfo(baseFolder);
		// ōŏ̃[gIB
		isFirstRoot = false;
	}

	// bookmark_bar̍ŏ
	fprintf(cs_fpo, ",\n");
	baseFolder->setIeName("̑̃ubN}[N");
	p = mbtoUTF8Internal("̑̃ubN}[N");
	baseFolder->setName(p);
	wName = mbtowcInternal("̑̃ubN}[N");
	baseFolder->setIeNameW(wName);
	baseFolder->setFolderType(Bookmark::menuBar);

	fprintf(cs_fpo, "      \"other\": {\n");
	spput(cs_fpo, 3 + m_level);
	fprintf(cs_fpo, "\"children\": [ \n");
	spput(cs_fpo, 3 + m_level);
	putFolderEndInfo(baseFolder);

	if (!syncedPut) {
		if (m_level == 0) {
			if (!isFirstRoot) {
				fprintf(cs_fpo, ",\n");
			}
			isFirstRoot = false;
			spput(cs_fpo, 2);
			fprintf(cs_fpo, "\"synced\": {\n");

			baseFolder->setIeName("oC̃ubN}[N");
			p = mbtoUTF8Internal("oC̃ubN}[N");
			baseFolder->setName(p);
			wName = mbtowcInternal("oC̃ubN}[N");
			baseFolder->setIeNameW(wName);
			baseFolder->setItemType(Bookmark::folder);
			baseFolder->setFolderType(Bookmark::mobile);

			spput(cs_fpo, 3);
			fprintf(cs_fpo, "\"children\": [ \n");
			spput(cs_fpo, 3 + m_level);
			putFolderEndInfo(baseFolder);
			syncedPut = true;
		}
	}

	if (!m_putTrash) {
		fprintf(cs_fpo, ",\n");
		fprintf(cs_fpo, "      \"trash\": {\n");
		baseFolder->setIeName("ݔ");
		p = mbtoUTF8Internal("ݔ");
		baseFolder->setName(p);
		wName = mbtowcInternal("ݔ");
		baseFolder->setIeNameW(wName);
		baseFolder->setItemType(Bookmark::folder);
		baseFolder->setFolderType(Bookmark::viTrash);
		spput(cs_fpo, 3 + m_level);
		fprintf(cs_fpo, "\"children\": [ \n");
		spput(cs_fpo, 3 + m_level);
		putFolderEndInfo(baseFolder);
	}

	delete baseFolder;

	fprintf(cs_fpo,"\n");
	fprintf(cs_fpo,"   },\n");

	if (m_target == 0) {
		if (metaData->getViSyncMetaData1() != NULL) {
			fprintf(cs_fpo, "   \"sync_metadata\": \"%s\"\n", metaData->getViSyncMetaData1());
		}
	} else {
		if (metaData->getViSyncMetaData2() != NULL) {
			fprintf(cs_fpo, "   \"sync_metadata\": \"%s\"\n", metaData->getViSyncMetaData2());
		}
	}

	fprintf(cs_fpo,"   \"version\": 1\n");
	fprintf(cs_fpo,"}\n");	// Top level object
}

/**
 * &HTML̕QƂɕϊȂ當o͂B
 *
 * @param fp t@C|C^
 * @param name o͂镶
 */
void ViWriter::putname3(FILE *fp, char *name)
{
	//	debugprintf("putname2\n");
	while (*name) {
		switch (*name) {
		case '\n':
			fprintf(fp, "\\r");
			break;
		default:
			fputc(*name, fp);
			break;
		}
		name++;
	}
}


/**
 * &HTML̕QƂɕϊȂ當o͂B
 *
 * @param fp t@C|C^
 * @param name o͂镶
 */
void ViWriter::putname2(FILE *fp,char *name)
{
//	debugprintf("putname2\n");
	while(*name){
		switch(*name){
			case '&':
				fprintf(fp,"&amp;");
			break;
			case '<':
				fprintf(fp,"&lt;");
			break;
			case '>':
				fprintf(fp,"&gt;");
			break;
			case '\"':
				fprintf(fp,"&quot;");
			break;
			case '\n':
				fprintf(fp, "&quot;");
				break;
			default:
				fputc(*name,fp);
			break;
		}
		name++;
	}
}

/**
 * ėpo̓[` SJIS -> UTF8ϊt
 *
 * @param fp t@C|C^
 * @param name o͂镶
 */
void ViWriter::putname(FILE *fp,wchar_t *name)
{

	wchar_t *unicode;
	unsigned char *utf8;
	int utf8Count;
	
//	debugprintf("putname\n");
	if (name == NULL)
		return;
	
	unicode = name;

	// Unicode -> UTF8
	utf8Count = countUTF16LEtoUTF8str(unicode);
	utf8 = (unsigned char *)calloc(utf8Count + 1,sizeof(unsigned char));
	if (utf8 == NULL){
		return;
	}
	toUTF8(utf8,unicode);

	putname2(fp,(char *)utf8);

	free(utf8);

}

