#ifndef VIBOOKMARK_H
#define VIBOOKMARK_H

// Wwb_
#include	<stdio.h>
#include	"bslib.h"

#define DESCRIPTION "Description"
#define NICKNAME "Nickname"
#define SPEEDDIAL "Speeddial"
#define THUMBNAIL "Thumbnail"
#define BOOKMARKBAR "Bookmarkbar"

class ViBookmark {
private:
	char *m_id;	// ID
	char* m_guid;	// ID
	bool m_isSpeedDial;
	char *m_Thumbnail;
	bool m_isBookmarkBar;

	void _init(void);
	void _reset(void);

protected:
	void _copy(const ViBookmark &src);
	void copy(const ViBookmark &src);

public:
	/* EʁEj */
	ViBookmark();
	ViBookmark(const ViBookmark &src);
	virtual ~ViBookmark();

	ViBookmark & operator = (const ViBookmark &src);
	void copyWithoutId(ViBookmark *src);
	int copyBookmarkIdentifier(ViBookmark *src);

	void reset(void);

	char *getID(void) const { return m_id; };
	char *setID(const char *item);

	char* getGUID(void) const { return m_guid; };
	char* setGUID(const char* item);

	bool getSpeedDial(void) const { return m_isSpeedDial; };
	bool setSpeedDial(const bool value)
	{
		m_isSpeedDial = value;
		return value;
	}

	char *getThumbnail(void) const { return m_Thumbnail; };
	char *setThumbnail(const char *item)
	{
		return reAllocate(m_Thumbnail, item);
	}

	bool getBookmarkBar(void) const { return m_isBookmarkBar; };
	bool setBookmarkBar(const bool value)
	{
		m_isBookmarkBar = value;
		return value;
	}

};

#endif	// VIBOOKMARK_H
