#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"encutil.h"
#include	"encutil2.h"
#include	"bplistReader.h"

#ifdef USE_TRACE
#define tracePrintf printf
#else
#define tracePrintf
#endif

/**
 * RXgN^
 *
 * @param fpo õt@C|C^
 */
bplistReader::bplistReader(FILE *fpo)
{
	fp = NULL;
	fpOut = fpo;
	offsetSize = 0;
	objectRefs = 0;
	objectCount = 0;
	topObject = 0;
	offsetTableOffset = 0;
	offsetTable = NULL;
}

bplistReader::~bplistReader()
{
	if (offsetTable != NULL) {
		delete []offsetTable;
	}
}

/**
 * g[[ǂݍށB
 *
 * @param fp t@C|C^
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int bplistReader::getTrailer(FILE *fp)
{
	unsigned char buf[32];

	int read = fread(buf,1,8,fp);
	if (memcmp(buf,"bplist00",8)) {
		tracePrintf("File isn't bplist.\n");
		return 1;
	}

	fseek(fp,-32,SEEK_END);
	read = fread(buf,1,32,fp);
	if (read < 32) {
		tracePrintf("Can't read trailer.\n");
		return 1;
	}
	offsetSize = buf[6];
	objectRefs = buf[7];
	tracePrintf("offsetSize:%u .\n",offsetSize);
	tracePrintf("objectRefs:%u .\n",objectRefs);

	objectCount = 0;
	for (int i = 12;i < 16;i++) {
		objectCount <<= 8;
		objectCount = objectCount + buf[i];
	}
	tracePrintf("%lu Objercts.\n",objectCount);

	topObject = 0;
	for (int i = 20;i < 24;i++) {
		topObject <<= 8;
		topObject = topObject + buf[i];
	}
	tracePrintf("topObject at %lu.\n",topObject);

	offsetTableOffset = 0;
	for (int i = 28;i < 32;i++) {
		offsetTableOffset <<= 8;
		offsetTableOffset = offsetTableOffset + buf[i];
	}
	tracePrintf("offsetTableOffset is %lu.\n",offsetTableOffset);

	return 0;
}

/**
 * ItZbge[uǂݍށB
 *
 * @param fp t@C|C^
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int bplistReader::getOffsetTable(FILE *fp)
{
	try {
		offsetTable = new unsigned char[offsetSize * objectCount];
	}catch(...) {
		return 1;
	}

	fseek(fp,offsetTableOffset,SEEK_SET);
	unsigned long read = fread(offsetTable,offsetSize,objectCount,fp);
	if (read < objectCount) {
		return 1;
	}
	for (unsigned long i = 0;i < objectCount;i++) {
		unsigned long offset = 0;
		for (unsigned int j = 0;j < offsetSize;j++) {
			offset <<= 8;
			offset = offset + offsetTable[i * offsetSize + j];
		}
		// tracePrintf("OffsetTable #%lu : %lu\n",i,offset);
	}

	return 0;
}

/**
 * IuWFNgǂݍށB
 *
 * @param fp t@C|C^
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int bplistReader::getObject(FILE *fp,unsigned long no,bool isKey)
{
	unsigned char object;
	int result = 0;

	// ܂AItZbge[uǂށB
	unsigned long offset = 0;
	for (unsigned int j = 0;j < offsetSize;j++) {
		offset <<= 8;
		offset = offset + offsetTable[no * offsetSize + j];
	}
	fseek(fp,offset,SEEK_SET);
	int read = fread(&object,1,1,fp);
	if (read < 1) {
		return 1;
	}

	// ^
	unsigned char type = (object >> 4) & 0x0f;
	// TCY
	unsigned char size = object & 0x0f;

	tracePrintf("\n",no,offset);
	tracePrintf("Object %lu at 0x%lx\n",no,offset);
	tracePrintf("Object type : %u\n",type);
	tracePrintf("Object size : %u\n",size);

	switch(type) {
		case 0:
			tracePrintf("type:NULL/bool/fill\n");
			break;
		case 2:
			tracePrintf("type:real\n");
			break;
		case 3:
			tracePrintf("type:date\n");
			break;
		case 4:
			tracePrintf("type:data\n");
			break;
		case 5:
			tracePrintf("type:ASCII string\n");
			result = readAsciiString(fp,size,isKey);
			break;
		case 6:
			tracePrintf("type:Unicode string\n");
			result = readUnicodeString(fp,size,isKey);
			break;
		case 8:
			tracePrintf("type:uid\n");
			break;
		case 10:
			tracePrintf("type:array\n");
			result = readArray(fp,size);
			break;
		case 13:
			tracePrintf("type:dict(ionary)\n");
			result = readDict(fp,size);
			break;
	}

	return result;
}

/**
 * ASCIIǂݍށB
 *
 * @param fp t@C|C^
 * @param size TCY
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int bplistReader::readAsciiString(FILE *fp,unsigned char size,bool isKey)
{
	unsigned char *buf;
	unsigned long realSize,read;
	int result = 0;

	// lB
	if (size < 15) {
		realSize = size;
	} else {
		unsigned char sizeFlag;
		unsigned char sizeBuf;
		int sizeSize;

		fread(&sizeFlag,1,1,fp);
		if (sizeFlag == 0x10) {
			sizeSize = 1;
		} else if (sizeFlag == 0x11) {
			sizeSize = 2;
		} else {
			tracePrintf("\aUnknown size.\n");
		}
		realSize = 0;
		for (int i = 0;i < sizeSize;i++) {
			fread(&sizeBuf,1,1,fp);
			realSize <<= 8;
			realSize += sizeBuf;
		}
	}

	// Ɍobt@mۂB
	try {
		buf = new unsigned char[realSize + 1];
	}catch(...) {
		return 1;
	}

	// ǂݍŕ\B
	buf[realSize] = '\0';
	read = fread(buf,1,realSize,fp);
	if (read < realSize) {
		result = 1;
		tracePrintf("ASCII String read fail.\n");
	} else {
		tracePrintf("ASCII String : %s\n",buf);
		if (!isKey) {
			fprintf(fpOut,"<string>");
		}
		putEscapedString(buf);
		if (!isKey) {
			fprintf(fpOut,"</string>\n");
		}
	}

	delete []buf;
	return result;
}

/**
 * UnicodeǂݍށB
 *
 * @param fp t@C|C^
 * @param size TCY
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int bplistReader::readUnicodeString(FILE *fp,unsigned char size,bool isKey)
{
	wchar_t *buf;
	unsigned long realSize,read;
	int result = 0;

	// lB
	if (size < 15) {
		realSize = size;
	} else {
		unsigned char sizeFlag;
		unsigned char sizeBuf;
		int sizeSize;

		fread(&sizeFlag,1,1,fp);
		if (sizeFlag == 0x10) {
			sizeSize = 1;
		} else if (sizeFlag == 0x11) {
			sizeSize = 2;
		} else {
			tracePrintf("\aUnknown size.\n");
		}
		realSize = 0;
		for (int i = 0;i < sizeSize;i++) {
			fread(&sizeBuf,1,1,fp);
			realSize <<= 8;
			realSize += sizeBuf;
		}
	}

	// Ɍobt@mۂB
	try {
		buf = new wchar_t[(realSize + 1)];
	}catch(...) {
		return 1;
	}

	// ǂݍŕ\B
	buf[realSize] = L'\0';

	for (unsigned long i = 0;i < realSize;i++) {
		// rbOGfBA2oCgǂݍށB
		unsigned char c;
		read = fread(&c,1,1,fp);
		if (read < 1) {
			result = 1;
			tracePrintf("Unicode String read fail.\n");
			break;
		}
		buf[i] = c;
		buf[i] <<= 8;
		read = fread(&c,1,1,fp);
		if (read < 1) {
			result = 1;
			tracePrintf("Unicode String read fail.\n");
			break;
		}
		buf[i] += c;
	}

	if (result == 0) {
		char *p = wctoUTF8Internal(buf);
		tracePrintf("Unicode String : %s\n",p);
		if (!isKey) {
			fprintf(fpOut,"<string>");
		}
		putEscapedString((unsigned char *)p);
		if (!isKey) {
			fprintf(fpOut,"</string>\n");
		}
	}

	delete []buf;
	return result;
}

/**
 * zǂݍށB
 *
 * @param fp t@C|C^
 * @param size TCY
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int bplistReader::readArray(FILE *fp,unsigned char size)
{
	unsigned int *buf;
	unsigned long realSize,read;
	int result = 0;

	// ڐlB
	if (size < 15) {
		realSize = size;
	} else {
		unsigned char sizeFlag;
		unsigned char sizeBuf;
		int sizeSize;

		fread(&sizeFlag,1,1,fp);
		if (sizeFlag == 0x10) {
			sizeSize = 1;
		} else if (sizeFlag == 0x11) {
			sizeSize = 2;
		} else {
			tracePrintf("\aUnknown size.\n");
		}
		realSize = 0;
		for (int i = 0;i < sizeSize;i++) {
			fread(&sizeBuf,1,1,fp);
			realSize <<= 8;
			realSize += sizeBuf;
		}
	}

	// Ɍobt@mۂB
	try {
		buf = new unsigned int[realSize];
	}catch(...) {
		return 1;
	}

	// zɓIuWFNgǂݍ
	for (unsigned long i = 0;i < realSize;i++) {
		// rbOGfBA2oCgǂݍށB
		unsigned char c;

		unsigned int item = 0;
		for (unsigned int j = 0;j < objectRefs;j++) {
			item <<= 8;
			read = fread(&c,1,1,fp);
			if (read < 1) {
				result = 1;
				tracePrintf("Array read fail.\n");
				break;
			}
			item += c;
		}
		buf[i] = item;
	}

	fprintf(fpOut,"<array>\n");
	if (result == 0) {
		for (unsigned long i = 0;i < realSize;i++) {
			tracePrintf("\tArray Item #%lu : %u\n",i,buf[i]);

			result = getObject(fp,buf[i],false);
			if (result) {
				break;
			}

		}
	}
	fprintf(fpOut,"</array>\n");

	delete []buf;
	return result;
}

/**
 * (dict(ionary)ǂݍށB
 *
 * @param fp t@C|C^
 * @param size TCY
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int bplistReader::readDict(FILE *fp,unsigned char size)
{
	unsigned int *keyBuf = NULL;
	unsigned int *itemBuf = NULL;
	unsigned long realSize,read;
	int result = 0;

	// ڐlB
	if (size < 15) {
		realSize = size;
	} else {
		unsigned char sizeFlag;
		unsigned char sizeBuf;
		int sizeSize;

		fread(&sizeFlag,1,1,fp);
		if (sizeFlag == 0x10) {
			sizeSize = 1;
		} else if (sizeFlag == 0x11) {
			sizeSize = 2;
		} else {
			tracePrintf("\aUnknown size.\n");
		}
		realSize = 0;
		for (int i = 0;i < sizeSize;i++) {
			fread(&sizeBuf,1,1,fp);
			realSize <<= 8;
			realSize += sizeBuf;
		}
	}

	// Ɍobt@mۂB
	try {
		keyBuf = new unsigned int[realSize];
		itemBuf = new unsigned int[realSize];
	}catch(...) {
		if (keyBuf != NULL) {
			delete []keyBuf;
		}
		return 1;
	}

	// zɓIuWFNgǂݍ
	for (unsigned long i = 0;i < realSize;i++) {
		// rbOGfBA2oCgǂݍށB
		unsigned char c;
		unsigned int key = 0;
		for (unsigned int j = 0;j < objectRefs;j++) {
			key <<= 8;

			read = fread(&c,1,1,fp);
			if (read < 1) {
				result = 1;
				tracePrintf("Array read fail.\n");
				break;
			}
			key += c;
		}
		keyBuf[i] = key;
	}

	// zɓIuWFNgǂݍ
	if (result == 0) {
		for (unsigned long i = 0;i < realSize;i++) {
			// rbOGfBA2oCgǂݍށB
			unsigned char c;

			unsigned int item = 0;
			for (unsigned int j = 0;j < objectRefs;j++) {
				item <<= 8;

				read = fread(&c,1,1,fp);
				if (read < 1) {
					result = 1;
					tracePrintf("Array read fail.\n");
					break;
				}
				item += c;
			}
			itemBuf[i] = item;
		}
	}

	if (result == 0) {
		fprintf(fpOut,"<dict>\n");
		for (unsigned long i = 0;i < realSize;i++) {
			tracePrintf("\tDictionary key #%lu : %u\n",i,keyBuf[i]);
			fprintf(fpOut,"<key>");
			result = getObject(fp,keyBuf[i],true);
			if (result) {
				break;
			}
			fprintf(fpOut,"</key>\n");

			tracePrintf("\tDictionary Item #%lu : %u\n",i,itemBuf[i]);

			result = getObject(fp,itemBuf[i],false);
			if (result) {
				break;
			}

			tracePrintf("\n\n",i,itemBuf[i]);
		}
		fprintf(fpOut,"</dict>\n");
	}

	delete []keyBuf;
	delete []itemBuf;
	return result;
}

/**
 * oCiplist`t@CI[vēǂݍ݂JnB
 *
 * @param s o͑Ώە
 */
void bplistReader::putEscapedString(unsigned char *s)
{
	while(*s) {
		switch(*s) {
			case '\"':
				fprintf(fpOut,"&quot;");
				break;
			case '&':
				fprintf(fpOut,"&amp;");
				break;
			case '<':
				fprintf(fpOut,"&lt;");
				break;
			case '>':
				fprintf(fpOut,"&gt;");
				break;
			default:
				fprintf(fpOut,"%c",*s);
				break;
		}
		s++;
	}
}

/**
 * oCiplist`t@CI[vēǂݍ݂JnB
 *
 * @param fp t@C|C^
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int bplistReader::readBplist(const char *filename)
{
	tracePrintf("reading start...\n");
	fp = fopen(filename,"rb");
	if (fp == NULL) {
		return 1;
	}
	// ܂̓g[[̓ǂݍ
	int result = getTrailer(fp);

	// ̓ItZbge[uǂݍ
	if (!result) {
		result = getOffsetTable(fp);
	}

	fprintf(fpOut,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
	fprintf(fpOut,"<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">");

	// ŏ̃IuWFNgǂݍ݃X^[g
	if (!result) {
		result = getObject(fp,0,false);
	}
	/*
	if (!result) {
		for (unsigned int i = 1;i < objectCount;i++) {
			result = getObject(fp,i);
		}
	}
	*/


	fclose(fp);

	return result;
}
