#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NTfunction.h"
#include	"Bookmark.h"
#include	"url.h"

#include	"SafariBookmark.h"
#include	"SafariWriter.h"

SafariWriter::SafariWriter(void)
{
	m_target = 0;
	m_level = 0;
	placesPut = true;
	putIEToolbar = true;
	m_ignore = false;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
	urlBufLen = BUFLEN;
}

SafariWriter::~SafariWriter()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int SafariWriter::reallocUrlBuf(int size)
{
	delete []urlBuf;
	try {
		urlBuf = NULL;
		urlBuf = new char[size];
		if (urlBuf == NULL) {
			return -1;
		}
		urlBufLen = size;
	} catch (...) {
		return -1;
	}
	return size;
}

/**
 * Xy[Xo͂B
 *
 * @param fp o͐̃t@C|C^
 * @param tabs ^u̐
 */
void SafariWriter::spput(FILE *fp,int tabs)
{
	int i;
	
	for (i = 0;i < tabs;i++){
		fputc('\t',fp);
	}
}


/**
 * tH_̏o͂B
 *
 */
void SafariWriter::putFolder(Bookmark *item)
{
	if (item->getFolderType() == Bookmark::viTrash) {
		m_ignore = true;
		m_ignoreSince = m_level;
	}

	if ((putIEToolbar == false) && (item->isIEToolbar())) {
		m_ignore = true;
		m_ignoreSince = m_level;
	}

	if (!m_ignore) {
		// printf("putFolder\n");
		spput(cs_fpo,m_level + 2);
		fprintf(cs_fpo,"<dict>\n");
		spput(cs_fpo,m_level + 3);
		fprintf(cs_fpo,"<key>Children</key>\n");
		spput(cs_fpo,m_level + 3);
		fprintf(cs_fpo,"<array>\n");
	}

	m_level++;

}

/**
 * tH_Io͂B
 *
 * @param item o͂tH_
 */
void SafariWriter::putFolderEnd(Bookmark *item,bool isLast)
{
	m_level--;

	if (!m_ignore) {
		spput(cs_fpo,m_level + 3);
		fprintf(cs_fpo,"</array>\n");
		spput(cs_fpo,m_level + 3);
		fprintf(cs_fpo,"<key>Title</key>\n");

		spput(cs_fpo,m_level + 3);
		switch(item->getFolderType()) {
			case Bookmark::toolBar:
				fprintf(cs_fpo,"<string>BookmarksBar</string>\n");
				break;
			case Bookmark::menuBar:
				fprintf(cs_fpo,"<string>BookmarksMenu</string>\n");
				break;
			default:
				fprintf(cs_fpo,"<string>");
				wchar_t *filenameW = item->getIeNameW();
				if (filenameW != NULL){
					putname(cs_fpo,filenameW);
				}
				fprintf(cs_fpo,"</string>\n");
				break;
		}
		if (item->getSafariBookmark(m_target)->getAutoTab()) {
			spput(cs_fpo,m_level + 3);
			fprintf(cs_fpo,"<key>WebBookmarkAutoTab</key>\n");
			spput(cs_fpo,m_level + 3);
			fprintf(cs_fpo,"<true/>\n");
		}

		spput(cs_fpo,m_level + 3);
		fprintf(cs_fpo,"<key>WebBookmarkType</key>\n");
		spput(cs_fpo,m_level + 3);
		fprintf(cs_fpo,"<string>WebBookmarkTypeList</string>\n");

		spput(cs_fpo,m_level + 2);
		fprintf(cs_fpo,"</dict>\n");
	}
	if (m_level == m_ignoreSince) {
		m_ignore = false;
	}
}

/**
 * URL̏o͂B
 *
 * @param item URLo͂ubN}[N
 */
void SafariWriter::putURL(Bookmark *item)
{
	if (item->getURL() != NULL){
		char *p;
		int escapeLen;
		p = item->getURL();

		if (strncmp("javascript:", p,11) == 0) {
			// ubN}[Nbg̏ꍇURLGR[h
			escapeLen = strlen(p) * 3;
			if ((escapeLen + 1) > urlBufLen) {
				reallocUrlBuf(escapeLen);
			}
			encodeURL(urlBuf, p);
			p = urlBuf;
		} else if (strncmp("file:", p, 5) == 0) {
			// file:̏ꍇURLGR[h
			escapeLen = strlen(p) * 3;
			if ((escapeLen + 1) > urlBufLen) {
				reallocUrlBuf(escapeLen);
			}
			encodeURL(urlBuf, p);
			p = urlBuf;
		}

		putname2(cs_fpo,p);
	}
}

/**
 * WebBookmarkTypeProxy̏o͂B
 */
void SafariWriter::putProxy(Bookmark *item,bool isLast)
{
	spput(cs_fpo,m_level + 3);
	fprintf(cs_fpo,"<dict>\n");

	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<key>WebBookmarkIdentifier</key>\n");
	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<string>");
	if (item->getIeNameW() != NULL){
		putname(cs_fpo,item->getIeNameW());
	}
	fprintf(cs_fpo,"</string>\n");

	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<key>Title</key>\n");
	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<string>");
	if (item->getIeNameW() != NULL){
		putname(cs_fpo,item->getIeNameW());
	}
	fprintf(cs_fpo,"</string>\n");

	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<key>WebBookmarkType</key>\n");
	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<key>WebBookmarkTypeProxy</key>\n");

	spput(cs_fpo,m_level + 3);
	fprintf(cs_fpo,"</dict>\n");

}

/**
 * ubN}[N̏o͂B
 */
void SafariWriter::putBookmark(Bookmark *item,bool isLast)
{
	if (m_ignore) {
		return;
	}

	if (!placesPut) {
		// Firefox 3̃X}[gubN}[NtH_炱𖳎B
		if (item->isPlaceURI()) {
			return;
		}
	}

	// Safariɂ̓Zp[^ȂĂ̂͂Ȃ̂ŉɏݐƂB
	if (item->getSeparator()) {
		return;
	}
	if (item->getSafariBookmark(m_target)->getProxy()) {
		putProxy(item,isLast);
		return;
	}

	// printf("putBookmark\n");
	spput(cs_fpo,m_level + 3);
	fprintf(cs_fpo,"<dict>\n");
	// URIDictionary
	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<key>URIDictionary</key>\n");
	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<dict>\n");
	// URL
	spput(cs_fpo,m_level + 5);
	fprintf(cs_fpo,"<key></key>\n");
	spput(cs_fpo,m_level + 5);
	fprintf(cs_fpo,"<string>");
	putURL(item);
	fprintf(cs_fpo,"</string>\n");
	//fprintf(cs_fpo,"<key>WebBookmarkUUID</key>\n);
	//fprintf(cs_fpo,"<string>C7225B52-1E1E-4147-BBEB-D6F269AA778B</string>\n");
	// ^Cg
	spput(cs_fpo,m_level + 5);
	fprintf(cs_fpo,"<key>title</key>\n");
	spput(cs_fpo,m_level + 5);
	fprintf(cs_fpo,"<string>");
	if (item->getIeNameW() != NULL){
		putname(cs_fpo,item->getIeNameW());
	}
	fprintf(cs_fpo,"</string>\n");

	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"</dict>\n");

	// URL
	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<key>URLString</key>\n");
	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<string>");
	putURL(item);
	fprintf(cs_fpo,"</string>\n");
	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<key>WebBookmarkType</key>\n");
	spput(cs_fpo,m_level + 4);
	fprintf(cs_fpo,"<string>WebBookmarkTypeLeaf</string>\n");
	//fprintf(cs_fpo,"<key>WebBookmarkUUID</key>\n");
	//fprintf(cs_fpo,"<string>BC025DB2-21E3-A849-91EA-43B9BECDC772</string>\n");
	spput(cs_fpo,m_level + 3);
	fprintf(cs_fpo,"</dict>\n");

}

/*
	ubN}[Ñwb_o͂B
	
		Ȃ
	߂l
		Ȃ
*/
void SafariWriter::putHeader(void)
{
	fprintf(cs_fpo,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
	fprintf(cs_fpo,"<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n");
	fprintf(cs_fpo,"<plist version=\"1.0\">\n");
	fprintf(cs_fpo,"<dict>\n");
	fprintf(cs_fpo,"\t<key>Children</key>\n");
	fprintf(cs_fpo,"\t<array>\n");


}

/*
	ubN}[Ñtb^o͂B
	
		fpo o͐
	߂l
		Ȃ
*/
void SafariWriter::putFooter(void)
{
	fprintf(cs_fpo,"\t</array>\n");
	fprintf(cs_fpo,"\t<key>WebBookmarkGroupVersionString</key>\n");
	fprintf(cs_fpo,"\t<string>5</string>\n");
	fprintf(cs_fpo,"\t<key>WebBookmarkType</key>\n");
	fprintf(cs_fpo,"\t<string>WebBookmarkTypeList</string>\n");
	//fprintf(cs_fpo,"\t<key>WebBookmarkUUID</key>\n");
	//fprintf(cs_fpo,"\t<string>149BA3E7-11FE-6042-8616-A10B8B1829ED</string>\n");
	fprintf(cs_fpo,"</dict>\n");
	fprintf(cs_fpo,"</plist>\n");
}

/*
	&HTML̕QƂɕϊȂ當o͂B
	
		fp t@C|C^
		name o͂镶
	߂l
		Ȃ
*/
void SafariWriter::putname2(FILE *fp,char *name)
{
//	debugprintf("putname2\n");
	while(*name){
		switch(*name){
			case '&':
				fprintf(fp,"&amp;");
			break;
			case '<':
				fprintf(fp,"&lt;");
			break;
			case '>':
				fprintf(fp,"&gt;");
			break;
			case '\"':
				fprintf(fp,"&quot;");
			break;
			default:
				fputc(*name,fp);
			break;
		}
		name++;
	}
}

/*
	ėpo̓[` SJIS -> UTF8ϊt
	
		fp o͐FILE\̂ւ̃|C^
		name o͂镶
	߂l
		Ȃ
*/
void SafariWriter::putname(FILE *fp,wchar_t *name)
{

	wchar_t *unicode;
	unsigned char *utf8;
	int utf8Count;
	
//	debugprintf("putname\n");
	if (name == NULL)
		return;
	
	unicode = name;

	// Unicode -> UTF8
	utf8Count = countUTF16LEtoUTF8str(unicode);
	utf8 = (unsigned char *)calloc(utf8Count + 1,sizeof(unsigned char));
	if (utf8 == NULL){
		return;
	}
	toUTF8(utf8,unicode);

	putname2(fp,(char *)utf8);

	free(utf8);

}

