#ifndef SAFARIREADER_H
#define SAFARIREADER_H

#include	<vector>
#include	"Bookmark.h"
#include	"HTMLtag.h"
#include	"Logger.h"

#include	"IBookmarkTree.h"
#include	"BookmarkTree.h"

#include	"TJsonValue.h"

#undef EXTERN
#ifdef ISSAFARIREADER
#define EXTERN
#else
#define EXTERN extern
#endif

class SafariReader {

	// vpeBXgvfߏ
	enum ItemType {
		INVALID,	// sȃ^Cv
		INITIAL,	// 
		NONE,	// ^CvȂ
		ARRAY,	// z
		OBJECT,	// IuWFNg
		KEY,	// L[݂ĂB
		VALUE,	// l
		NEED_SEPARATOR	// ؂肪Kv
	};

	// HTML͏
	struct SafariParseStatus {
		char previous;	/* 1O̕ */
		int inTag;	/* ^O̒ǂH */
		int inComment;	/* RgǂH */
		int isUtf8;	/* UTF-8ǂH */
		int inDD;	/* DDGgǂH */
		int storeing;	/* vf̒gi[邩ǂH */
		char itemType;	/* vf̌` */
		unsigned int folderLevel;	/* tH_̊Kw */
	};

private:
	char noIEfavorites;	// 1:IÊCɓRo[gȂB 0:
	IbookmarkTree *writer;	// ݗpIuWFNg
	int isSilentMode;	// 1:t@CI[vsbZ[WȂ 0:

	// ꎞobt@
	char *scFile,*work;
	char item[BUFLEN],*pItem;	// H3̒gۑ
	int cItem;				// item̕JEgp
	Bookmark bookmark;
	int f_item;
	int m_bookmarkNo;	// ǂݍłubN}[N̔ԍ
	char *urlBuf;	// URLϊpobt@
	char *urlBuf2;	// URLϊpobt@
	int urlBuf2Len;
	std::vector<Bookmark> folderStack;
	bool ignoreToolbar;	// c[o[𖳎邩ǂ
	Logger *logger;

	int reallocUrlBuf(int size);

	// IuWFNgf͗p
	int parseStart(struct SafariParseStatus *stat);
	int parseToplevel(struct SafariParseStatus *stat,TJsonValue *roots);
	int parseBar(struct SafariParseStatus *stat,TJsonValue *topObject);
	int parseFolder(struct SafariParseStatus *stat,TJsonValue *folderArray);
	int parseItem(struct SafariParseStatus *stat,TJsonValue *item);

	// plist IuWFNgf\zp
	unsigned int elementPoint;	// \vf݈̌ʒu
	std::vector<ItemType> elementStack;	// \vf
	unsigned int valuePoint;	// \vf݈̌ʒu
	std::vector<TJsonValue *> valueStack;	// \vf
	TJsonValue topValue;		// 擪̒l
	TJsonValue *currentValue;	// ݈Ăl
	ItemType currentElement;

	void pushElement(ItemType type);
	void popElement(void);
	ItemType previousElement(void);

	void pushValue(TJsonValue *value);
	void popValue(void);
	TJsonValue * previousValue(void);


	int flushItem(struct SafariParseStatus *stat);
	int setName(struct SafariParseStatus *stat,char *name);

	int parseArrayElement(struct SafariParseStatus *stat,HTMLtag *tag);
	int parseKeyElement(struct SafariParseStatus *stat,HTMLtag *tag);
	int parseStringElement(struct SafariParseStatus *stat,HTMLtag *tag);
	int parseDictElement(struct SafariParseStatus *stat,HTMLtag *tag);

	int parseElement(struct SafariParseStatus *stat,HTMLtag *tag);
	int parseHTML(struct SafariParseStatus *stat,HTMLtag *tag,char c);
	void initParseStatus(struct SafariParseStatus *stat);
	int readFile(const char *bmFile,const char *fvDir);
	char *decodeAndRealloc(char *p);

public:
	char setIEfavoritesImport(char mode){	noIEfavorites = mode;return mode;}
	SafariReader();
	~SafariReader();
	/**
	* ubN}[NoIuWFNgݒ肷B
	* BookmarkTreeɂݒ肵āARs[sB
	*
	*/
	void setBookmarkWriter(IbookmarkTree *obj)
	{
		writer = obj;
	}

	int readBookmark(const char *bmFile,const char *fvDir);
	void setSilentMode(int mode){	isSilentMode = mode;}
	int getBookmarkNo(void) { return m_bookmarkNo; }
	void setBookmarkNo(int no){	m_bookmarkNo = no;}
	int isBplist(const char *filename);
	void setIgnoreToolbar(bool flag) {
		ignoreToolbar = flag;
	}
	void setLogger(Logger *loggerObj) {
		logger = loggerObj;
	}

};

#undef EXTERN

#endif
