#define ISSAFARIREADER

// Wwb_
//#if defined(_DEBUG) && defined(_MSC_VER)
//#define _CRTDBG_MAP_ALLOC
//#endif

#include	<stdlib.h>

//#if defined(_DEBUG) && defined(_MSC_VER)
//#include	<crtdbg.h>
//#endif

#include	<fstream>
#include	<iostream>
#include	<assert.h>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>

// BookSyncʃwb_
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"

// vbgtH[wb_
#include	"SafariBookmark.h"
#include	"SafariReader.h"
#include	"IbookmarkTree.h"
#include	"..\core\messages.h"

#ifdef __BORLANDC__
#define	_stricmp stricmp
#endif

extern int g_lang;
extern int g_verbose;

/**
 *	RXgN^
 */
SafariReader::SafariReader()
{
	noIEfavorites = 0;	// C|[gIÊCɓ΂Ȃ
	isSilentMode = 1;

	urlBuf = NULL;
	writer = NULL;

	// Ăl̏
	currentValue = &topValue;
	currentElement = INITIAL;

	elementPoint = 0;
	valuePoint = 0;
	ignoreToolbar = false;

	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
	try {
		urlBuf2 = new char[BUFLEN];
	} catch (...) {
		delete []urlBuf;
	}
	urlBuf2Len = BUFLEN;

}

/**
 * fXgN^
 */
SafariReader::~SafariReader()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
	if (urlBuf2 != NULL) {
		delete []urlBuf2;
	}
}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int SafariReader::reallocUrlBuf(int size)
{
	delete []urlBuf2;
	try {
		urlBuf2 = NULL;
		urlBuf2 = new char[size];
		if (urlBuf2 == NULL) {
			logger->debug("No enough memory");
			return -1;
		}
		urlBuf2Len = size;
	} catch (...) {
		logger->debug("No enough memory");
		return -1;
	}
	return size;
}

/**
 * bookmarkoB
 *
 * @param stat XML`vpeBXg͏
 * @return 0  1 G[
 */
int SafariReader::flushItem(struct SafariParseStatus *stat)
{
	int result = 0;
	Bookmark *bm;

	try{
		bm = new Bookmark(bookmark);
		if (bm == NULL){
			logger->debug("Bookmark copy error");
			return 1;
		}
	}catch(...){
		logger->debug("Bookmark copy error");
		return 1;
	}

	switch(stat->itemType){
		//case -1:	// Ȃ
		//break;
		case 1:	// Bookmark
			result = writer->storeItem(bm);
		break;
		case 2:	// Folder
			result = writer->storeItem(bm);
		break;
	}
	delete bm;

	return result;
}

/**
 * ubN}[NEtH_ݒ肷B
 *
 * @param stat XML`vpeBXg͏
 * @param name ubN}[NEtH_
 * @return 0:G[Ȃ
 */
int SafariReader::setName(struct SafariParseStatus *stat,char *name)
{
	if (stat->itemType == 2) {	// ŏʊKw̃tH_̏ꍇɎ̏sB
		if (stat->folderLevel == 0) {
			if (!strcmp(name,"BookmarksMenu")) {
				bookmark.setFolderType(Bookmark::menuBar);
			} else if (!strcmp(name,"BookmarksBar")) {
				bookmark.setFolderType(Bookmark::toolBar);
			} else {
				bookmark.setFolderType(Bookmark::normalFolder);
			}
		}
	}

	// ubN}[N
	bookmark.setName(name);

	// O̐ݒ(}`oCg)
	char *p;
	p = UTF8tombFileNameInternal(name);

	// QƂϊB
	convChRef(work,p,g_lang);

	if (g_verbose) {
		std::cout << work << "\n" << std::flush;
	}
	bookmark.setIeName(work);

	// O̐ݒ(Unicode)
	wchar_t *wp;
	wp = UTF8towcFileNameInternal(name);
	// QƂϊB
	convChRefW(wp,wp);

	bookmark.setIeNameW(wp);

	return 0;
}

/*********************************
  vpeBXgfߕ
**********************************/

/**
 * ACẻ
 *
 * @param stat XML`vpeBXg͏
 * @param item ͂sIuWFNg
 * @return 0:́Eϊ 1:͎s
 */
int SafariReader::parseItem(struct SafariParseStatus *stat,TJsonValue *item)
{
	int result = 0;

	// IuWFNg̒g킷typeɊmFB
	TJsonValue *type = item->getObjectValue("WebBookmarkType");
	if (type == NULL) {
		// type݂Ȃꍇ͕stH[}bgG[
		logger->debug("Type not found");
		return 1;
	} else {
		if (type->getType() != TJsonValue::VALUE) {
			// typelłȂꍇ͕stH[}bgG[
			logger->debug("Value type is not value.");
			return 1;
		} else if (type->getValue() == NULL) {
			// typeɒlĂȂꍇstH[}bgG[
			logger->debug("Value is NULL.");
			return 1;
		}
	}

	char *typeValue = type->getValue();
	if (!strcmp(typeValue,"WebBookmarkTypeLeaf")) {
		bookmark.reset();
		bookmark.getSafariBookmark(m_bookmarkNo)->reset();

		// ubN}[N̏
		// URL̏
		TJsonValue *url = item->getObjectValue("URLString");
		if (url != NULL) {
			if (url->getType() == TJsonValue::VALUE) {
				// url̒l
				if (url->getValue() != NULL) {
					convChRefUTF8(urlBuf,url->getValue(),g_lang);
					char *p = urlBuf;
					if (strncmp("javascript:", p,11) == 0) {
						// JavaScript(ubN}[Nbg)URLGR[hĂ̂
						// Ŏg߃fR[h
						p = decodeAndRealloc(p);
						if (p == NULL) {
							logger->debug("javascript: URL decode error");
							return 1;
						}
					} else if (strncmp("file:", p, 5) == 0) {
						// file:URLGR[hĂ̂
						// Ŏg߃fR[h
						p = decodeAndRealloc(p);
						if (p == NULL) {
							logger->debug("file: URL decode error");
							return 1;
						}
					}
					bookmark.setURL(p);
				}
			}
		}
		// ubN}[NoB
		bookmark.setItemType(Bookmark::bookmark);
		stat->itemType = 1;

		// ubN}[NURIDictionary̒ɂ̂łB
		TJsonValue *uriDictionary = item->getObjectValue("URIDictionary");

		if (uriDictionary != NULL) {
			TJsonValue *name = uriDictionary->getObjectValue("title");
			if (name != NULL) {
				if (name->getType() == TJsonValue::VALUE) {
					// name̒l
					setName(stat,name->getValue());
				}
			}
		}

		flushItem(stat);
	} else if (!strcmp(typeValue,"WebBookmarkTypeList")) {
		bookmark.reset();
		bookmark.getSafariBookmark(m_bookmarkNo)->reset();

		// tH_oB
		bookmark.setItemType(Bookmark::folder);
		bookmark.setFolderType(Bookmark::normalFolder);
		stat->itemType = 2;

		TJsonValue *name = item->getObjectValue("Title");
		if (name != NULL) {
			if (name->getType() == TJsonValue::VALUE) {
				// name̒l
				setName(stat,name->getValue());
			}
		}
		// NbN̏
		TJsonValue *autoTab = item->getObjectValue("WebBookmarkAutoTab");
		if (autoTab != NULL) {
			bookmark.getSafariBookmark(m_bookmarkNo)->setAutoTab(true);
		}

		flushItem(stat);

		stat->folderLevel++;

		// type:folderƑgƂȂchildrenz(tH_)̑݃`FbNsB
		TJsonValue *children = item->getObjectValue("Children");
		if (children == NULL) {
			// childrenIuWFNg݂Ȃꍇ͋̃tH_
		}else{
			if (children->getType() != TJsonValue::ARRAY) {
				// childrenzłȂꍇ͕stH[}bgG[
				logger->debug("Children is not array.");
				return 1;
			} else {
				// childrenIuWFNg̉͂ɓ
				result = parseFolder(stat,children);
			}
		}

		// KwЂƂオB
		writer->upFolder();
		stat->folderLevel--;
	} else if (!strcmp(typeValue,"WebBookmarkTypeProxy")) {
		bookmark.reset();
		bookmark.getSafariBookmark(m_bookmarkNo)->reset();

		// ubN}[NoB
		bookmark.setItemType(Bookmark::bookmark);
		stat->itemType = 1;
		bookmark.getSafariBookmark(m_bookmarkNo)->setProxy(true);

		// ubN}[NURIDictionary̒ɂ̂łB
		TJsonValue *uriDictionary = item->getObjectValue("Title");

		if (uriDictionary != NULL) {
			if (uriDictionary->getType() == TJsonValue::VALUE) {
				// name̒l
				setName(stat,uriDictionary->getValue());
			}
		}

		flushItem(stat);
	} else {
		// tH_AubN}[NȊÔ͍Ƃ둶݂Ȃ̂ŃG[
		logger->debug("Unknown type.");
		return 1;
	}
	return result;
}

/**
 * URLGR[h̃fR[hƍĊmۂsB
 *
 * @param p fR[hsURL
 * @return NULL:fR[h NULL:fR[hs
 */
char *SafariReader::decodeAndRealloc(char *p)
{
	int count = decodeURL(NULL, p);
	if ((count + 1) > urlBuf2Len) {
		int result = reallocUrlBuf(count + 2);
		if (result == -1) {
			return NULL;
		}
	}
	decodeURL(urlBuf2, p);
	return urlBuf2;
}

/**
 * tH_̉
 *
 * @param stat XML`vpeBXg͏
 * @param folderArray tH_̔z
 * @return 0:́Eϊ 1:͎s
 */
int SafariReader::parseFolder(struct SafariParseStatus *stat,TJsonValue *folderArray)
{
	int result = 0;
	unsigned int count = folderArray->getArrayCount();

	for (unsigned int i = 0;i < count;i++) {
		// 
		TJsonValue *item = folderArray->getArrayValue(i);
		if (item == NULL) {
			// itemIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("Folder item not found.");
			return 1;
		}else{
			if (item->getType() != TJsonValue::OBJECT) {
				// itemIuWFNgłȂꍇ͕stH[}bgG[
				logger->debug("Folder item is not object.");
				return 1;
			} else {
				// itemIuWFNg̉͂ɓ
				result = parseItem(stat,item);
				if (result) {
					break;
				}
			}
		}
	}

	return result;	
}

/**
 * ubN}[No[Ȃ̃ubN}[Ñgbv̉
 *
 * @param stat XML`vpeBXg͏
 * @param topObject ubN}[No[Ȇ̃ubN}[ÑIuWFNg
 * @return 0:́Eϊ 1:͎s
 */
int SafariReader::parseBar(struct SafariParseStatus *stat,TJsonValue *topObject)
{
	int result = 0;	// ͌

	assert(stat->folderLevel == 0);

	stat->folderLevel++;
	// ԍŏ̔z(tH_)̑݃`FbNsB
	TJsonValue *children = topObject->getObjectValue("Children");
	if (children == NULL) {
		// ChildrenIuWFNg݂Ȃꍇ
		// ̃o[ƂƂŁA߂B
	}else{
		if (children->getType() != TJsonValue::ARRAY) {
			// childrenIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("Bookmark bar is not array.");
			return 1;
		} else {
			// childrenIuWFNg̉͂ɓ
			result = parseFolder(stat,children);
		}
	}
	writer->upFolder();
	stat->folderLevel--;

	return result;
}

/**
 * ubN}[No[Ȃ̃ubN}[N
 *
 * @param stat XML`vpeBXg͏
 * @param roots [gxIuWFNg("roots")
 * @return 0:́Eϊ 1:͎s
 */
int SafariReader::parseToplevel(struct SafariParseStatus *stat,TJsonValue *roots)
{
	int result = 0;	// ͌

	unsigned int items = roots->getArrayCount();

	for (unsigned int i = 0;i < items;i++) {
		TJsonValue *item = roots->getArrayValue(i);
		if (item == NULL) {
			logger->debug("Top level item is not found.");
			return 1;
		}
		if (item->getType() != TJsonValue::OBJECT) {
			// z̒gfBNViłȂꍇ͕stH[}bgG[
			logger->debug("Top level item is not dictionary.");
			return 1;
		}

		bookmark.reset();
		bookmark.getSafariBookmark(m_bookmarkNo)->reset();

		// level = 0;
		TJsonValue *itemType = item->getObjectValue("WebBookmarkType");
		if (itemType == NULL) {
			logger->debug("Top level bookmark item is not found.");
			return 1;
		}
		if (itemType->getType() != TJsonValue::VALUE) {
			// lłȂꍇ͕stH[}bgG[
			logger->debug("Top level bookmark item is not value.");
			return 1;
		}
		if (!strcmp("WebBookmarkTypeList",itemType->getValue())) {
			// tH_
			bookmark.setItemType(Bookmark::folder);

			stat->itemType = 2;

			TJsonValue *itemName = item->getObjectValue("Title");
			if (itemName == NULL) {
				logger->debug("Title is not found.");
				return 1;
			}

			// ubN}[No[AubN}[Nj[
			setName(stat,itemName->getValue());

			if (bookmark.getFolderType() != Bookmark::toolBar || ignoreToolbar == false) {
				flushItem(stat);
				result = parseBar(stat,item);
				if (result) {
					break;
				}
			}
		} else if (!strcmp("WebBookmarkTypeLeaf",itemType->getValue())) {
			// ubN}[N
			bookmark.setItemType(Bookmark::bookmark);
			stat->itemType = 1;
			result = parseItem(stat,item);
			if (result) {
				break;
			}
		} else if (!strcmp("WebBookmarkTypeProxy",itemType->getValue())) {
			// ubN}[N
			bookmark.setItemType(Bookmark::bookmark);
			stat->itemType = 1;
			result = parseItem(stat,item);
			if (result) {
				break;
			}
		} else {
			// m̃^Cv͖B
			return 0;
		}
	}

	return result;
}

/**
 * ubN}[N͊Jn
 *
 * @param stat XML`vpeBXg͏
 * @return 0:́Eϊ 1:͎s
 */
int SafariReader::parseStart(struct SafariParseStatus *stat)
{
	int result = 0;	// ͌

	if (topValue.getType() != TJsonValue::OBJECT) {
		// gbvIuWFNg̓IuWFNgłKv̂ŁA
		// łȂꍇ͕stH[}bgG[
		logger->debug("Top level item is not object.");
		return 1;
	} else {
		TJsonValue *roots = topValue.getObjectValue("Children");
		if (roots == NULL) {
			// ŏ̊Kw̃IuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("First children is not found.");
			return 1;
		}else{
			if (roots->getType() != TJsonValue::ARRAY) {
				// ŏ̊KwzłȂꍇ͕stH[}bgG[
				logger->debug("First children is not array.");
				return 1;
			} else {
				// rootsIuWFNg̉͂ɓ
				result = parseToplevel(stat,roots);
			}
		}

	}
	return result;
}



/*****************************
  ubN}[Nt@C͕
*****************************/

/**
 * \vfX^bNɒlpushB
 *
 * @param type \vf
 */
void SafariReader::pushElement(ItemType type)
{
	if (elementPoint >= elementStack.size()) {
		elementStack.push_back(type);
		elementPoint++;
	} else {
		elementStack[elementPoint] = type;
		elementPoint++;
	}
}

/**
 * \vfX^bN̒lpopB
 */
void SafariReader::popElement(void)
{
	if (elementPoint > 0) {
		elementPoint--;
	}
}

/**
 * 1O̍\vfԂB
 *
 * @return \vf
 */
SafariReader::ItemType SafariReader::previousElement(void)
{
	if (elementPoint == 0) {
		return SafariReader::NONE;
	}
	return elementStack[elementPoint - 1];
}

/**
 * lX^bNɒlpushB
 *
 * @param type \vf
 */
void SafariReader::pushValue(TJsonValue *value)
{
	if (valuePoint >= valueStack.size()) {
		valueStack.push_back(value);
		valuePoint++;
	} else {
		valueStack[valuePoint] = value;
		valuePoint++;
	}
}

/**
 * \vfX^bN̒lpopB
 */
void SafariReader::popValue(void)
{
	if (valuePoint > 0) {
		valuePoint--;
	}
}

/**
 * 1O̍\vfԂB
 *
 * @return \vf
 */
TJsonValue *SafariReader::previousValue(void)
{
	if (valuePoint == 0) {
		return NULL;
	}
	return valueStack[valuePoint - 1];
}

/* evfʂ̉߃W[ */

/**
 * arrayvf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int SafariReader::parseArrayElement(struct SafariParseStatus *stat,HTMLtag *tag)
{
	int ret = 0;
	if ( !tag->isEndtag() ){
		// GgJn
		TJsonValue *newValue;
		switch (currentElement) {
			case INITIAL:
				// ŏł܂^܂ĂȂꍇ
				// ݈Ă镨zƂB
				currentValue->setType(TJsonValue::ARRAY);
				currentElement = ARRAY;
				break;
			case ARRAY:
				// z̏ꍇ͒lIuWFNgȂ̂ō쐬B
				newValue = currentValue->addArrayValue();
				if (newValue == NULL) {
					logger->debug("Cannot create value object.");
					return 1;
				}
				newValue->setType(TJsonValue::ARRAY);
				newValue->setValue(item);
				pushValue(currentValue);
				pushElement(currentElement);

				currentValue = newValue;
				currentElement = ARRAY;
				break;
			case OBJECT:
				// fBNVȉꍇ̓L[̌ɗKv̂ŃG[ƂB
				logger->debug("Invalid sequence(dict -> array).");
				return 1;
			case KEY:
				// fBNVĩL[̌ɗꍇ͒lzƂB
				currentValue->setType(TJsonValue::ARRAY);
				currentElement = ARRAY;
				break;
		}
	} else {
		// ĂzIāA1O̗vfɖ߂B
		if (valuePoint > 0) {
			currentValue = previousValue();
			popValue();
		}
		if (elementPoint > 0) {
			currentElement = previousElement();
			popElement();
		}
	}
	return 0;
}

/**
 * dictvf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int SafariReader::parseDictElement(struct SafariParseStatus *stat,HTMLtag *tag)
{
	int ret = 0;

	if ( !tag->isEndtag() ){
		// GgJn
		TJsonValue *newValue;
		switch (currentElement) {
			case INITIAL:
				// ŏł܂^܂ĂȂꍇ
				// ݈Ă镨fBNViƂB
				currentValue->setType(TJsonValue::OBJECT);
				currentElement = OBJECT;
				break;
			case ARRAY:
				// z̏ꍇ͒ǉB
				newValue = currentValue->addArrayValue();
				newValue->setType(TJsonValue::OBJECT);
				// ܂ňĂ̂ޔB
				pushElement(currentElement);
				pushValue(currentValue);
				// Ăvf̓fBNVi
				currentElement = OBJECT;
				// AVvfB
				currentValue = newValue;
				break;
			case OBJECT:
				// IuWFNg̏ꍇ̓L[ȂƂȂ̂ŁA
				// G[ƂB
				logger->debug("Dict cannot contain dict.");
				return 1;
			case KEY:
				// L[w肳Ăꍇ
				// ݈Ă镨fBNViƂB
				currentValue->setType(TJsonValue::OBJECT);
				currentElement = OBJECT;
				break;
		}
	} else {
		if (currentElement == KEY) {
			// KEY̎ɒlȂĎcĂꍇ󈵂ƂB
			currentValue->setType(TJsonValue::VALUE);
			currentValue->setValue("");
			// 1O̒lɖ߂B
			currentValue = previousValue();
			popValue();
			currentElement = previousElement();
			popElement();
		}
		// ĂfBNViIāA1O̗vfɖ߂B
		if (valuePoint > 0) {
			currentValue = previousValue();
			popValue();
		}
		if (elementPoint > 0) {
			currentElement = previousElement();
			popElement();
		}
	}

	return ret;
}


/**
 * keyvf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int SafariReader::parseKeyElement(struct SafariParseStatus *stat,HTMLtag *tag)
{
	int ret = 0;

	if ( !tag->isEndtag() ){
		// GgJn
		pItem = item;
		cItem = 0;
		stat->storeing = 1;	/* vf̒gi[JnB */
	}else{
		// lɂĎstringvf̓eςB
		*pItem = '\0';
		stat->storeing = 0;
		// stat->itemType = 0;	// Oɏ񂾂̂̓tH_

		TJsonValue *newValue;
		switch (currentElement) {
			case OBJECT:
				// L[ɑΉVvf̎n܂
				newValue = currentValue->addObjectValue(item);
				if (newValue == NULL) {
					logger->debug("Cannot create value object.");
					return 1;
				}
				// L[ɑΉvfp̃IuWFNg쐬B
				pushValue(currentValue);
				currentValue = newValue;
				pushElement(currentElement);
				currentElement = KEY;

				if (!strcmp("WebBookmarkAutoTab",item)) {
					// WebBookmarkAutoTabL[(NbN)ɑΉlSafari 4ł݂͑ȂȂ̂ŁA
					// _~[ƂtrueăL[ɑΉlIƂɂB
					// (ăvpeBXg̕@ᔽɂȂȂ̂낤H)
					currentValue->setType(TJsonValue::VALUE);
					currentValue->setValue("true");
					// 1O̒lɖ߂B
					currentValue = previousValue();
					popValue();
					currentElement = previousElement();
					popElement();
				}
				break;
			case KEY:	// KEY̎ɗvfȂꍇKEYAŏo邱ƂB
				// KEYAƂ͋󈵂ƂB
				currentValue->setType(TJsonValue::VALUE);
				currentValue->setValue("");
				// 1O̒lɖ߂B
				currentValue = previousValue();
				popValue();
				currentElement = previousElement();
				popElement();

				// VL[̏
				newValue = currentValue->addObjectValue(item);
				if (newValue == NULL) {
					logger->debug("Cannot create value object.");
					return 1;
				}
				// L[ɑΉvfp̃IuWFNg쐬B
				pushValue(currentValue);
				currentValue = newValue;
				pushElement(currentElement);
				currentElement = KEY;

				if (!strcmp("WebBookmarkAutoTab",item)) {
					// WebBookmarkAutoTabL[(NbN)ɑΉlSafari 4ł݂͑ȂȂ̂ŁA
					// _~[ƂtrueăL[ɑΉlIƂɂB
					// (ăvpeBXg̕@ᔽɂȂȂ̂낤H)
					currentValue->setType(TJsonValue::VALUE);
					currentValue->setValue("true");
					// 1O̒lɖ߂B
					currentValue = previousValue();
					popValue();
					currentElement = previousElement();
					popElement();
				}
				break;
			default:
				// dictvf̎ȊOɂ͏oȂ̂ŁAsȗvfƂB
				logger->debug("Key occur without dict.");
				return 1;
		}

	}
	return 0;
}

/**
 * stringvf̉͂sB
 *
 * @param stat ǂݍݏ
 * @param tag ^O
 * @return 0:I !0:Ȃ炩ُ̈킪B
 */
int SafariReader::parseStringElement(struct SafariParseStatus *stat,HTMLtag *tag)
{
	if ( !tag->isEndtag() ){
		// GgJn
		pItem = item;
		cItem = 0;
		stat->storeing = 1;	/* vf̒gi[JnB */
	}else{
		*pItem = '\0';
		stat->storeing = 0;

		TJsonValue *newValue;
		switch (currentElement) {
			case INITIAL:
				// ŏł܂^܂ĂȂꍇ͔z񂩃fBNViłKv̂
				// G[ƂB
				logger->debug("String without parent element.");
				return 1;
			case ARRAY:
				// z̏ꍇ́A݂̒lzȂ̂ŁAlB
				newValue = currentValue->addArrayValue();
				if (newValue == NULL) {
					logger->debug("Cannot create value object.");
					return 1;
				}
				newValue->setType(TJsonValue::VALUE);
				newValue->setValue(item);
				break;
			case OBJECT:
				// fBNVȉꍇ̓L[̌ɗKv̂ŃG[ƂB
				logger->debug("Invalid sequence (dict -> string).");
				return 1;
			case KEY:
				// fBNVĩL[̌ɗꍇ͒lĂ̂Ŋi[B
				currentValue->setType(TJsonValue::VALUE);
				currentValue->setValue(item);
				// 1O̒lɖ߂B
				currentValue = previousValue();
				popValue();
				currentElement = previousElement();
				popElement();
				break;
		}

	}
	return 0;
}

/**
 * PLIST-XMLevf̉͂sB
 *
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return 0 ͐ 1 ̓G[
 */
int SafariReader::parseElement(struct SafariParseStatus *stat,HTMLtag *tag)
{
	int ret = 0;

	if ( !strcmp(tag->getName(),"key") ){
		ret = parseKeyElement(stat,tag);
	}

	if ( !strcmp(tag->getName(),"string") ){
		ret = parseStringElement(stat,tag);
	}

	if ( !strcmp(tag->getName(),"array") ){
		ret = parseArrayElement(stat,tag);
	}

	if ( !strcmp(tag->getName(),"dict") ){
		ret = parseDictElement(stat,tag);
	}

	return ret;
}

/**
 * HTML̊{Iȉ͂sB
 *
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @param c ǂݍ񂾕
 * @return 0:͐ 1:̓G[
 */
int SafariReader::parseHTML(struct SafariParseStatus *stat,HTMLtag *tag,char c)
{
	int result;	/* ^Oߌ */
	int ret = 0;

	if (!stat->inTag){
		/* ^O̒ł͂Ȃ */
		if (c == '<'){
			stat->inTag = 1;
			stat->inComment = 0;
			tag->init();

		}else{
			/* ʏ̕ */
			//std::cout << c;
			if (stat->storeing){
				/* vf̒li[B(A,DD) */
				if (cItem < (BUFLEN - 1)){
					*pItem = c;
					pItem++;
					cItem++;
				}
			}
		}
	}else{
		/* ^O̒ */
		if (!stat->inComment){
			result = tag->doParse(c);
		}else{
			/* Rg */
			if (c == '-' && stat->previous == '-'){	// RgI
				//std::cout << "RgI\n";
				stat->inComment = 0;
			}
			result = 0;
		}
		switch(result){
			case 0:	/* ^Oi[ */
			break;
			case 2:	/* RgJn */
				stat->inComment = 1;
			break;
			case 1:	/* ^OI */
				if (tag->getName() != NULL){
					/* ^Ỏ͂sB */
					ret = parseElement(stat,tag);
					stat->inTag = 0;
				}
			break;
			case 3:	/* ߃G[̎͂܂ł𖳌ɂB */
				stat->inTag = 0;
			break;
		}
	}
	stat->previous = c;
	return ret;
}

/**
 * XMLߏԏ
 *
 * @param stat ߏ
 */
void SafariReader::initParseStatus(struct SafariParseStatus *stat)
{
	stat->previous = 0;	/* 1O̕ */
	stat->inTag = 0;	/* ^O̒ǂH */
	stat->inComment = 0;	/* RgǂH */
	stat->isUtf8 = 1;	/* UTF-8ǂH */
	stat->inDD = 0;	/* DDGgǂ? */
	stat->storeing = 0;	/* i[Ă邩ǂ */
	stat->itemType = -1;	/* ݈ĂvftH_ubN}[NH */
	stat->folderLevel = 0;	/* Kw */

	f_item = 0;
}

/**
 * ubN}[Nǂݍݕ
 *
 * @param bmFile ubN}[Nt@C
 * @param fvDir uCɓvfBNg
 *
 * @return 0:ǂݍ݁ERo[g 1:ǂݍ݁ERo[gs
 */
int SafariReader::readFile(const char *bmFile,const char *fvDir)
{
	int ret = 0;	// s
	std::ifstream fin;	// ǂݍ݃Xg[
	char c;	// ǂݍ񂾕
	struct SafariParseStatus stat;	// ߏԍ\
	HTMLtag tag;	// ^OIuWFNg

	initParseStatus(&stat);	// ͏ԂB
	
	fin.open(bmFile , std::ios::in | std::ios::binary);
	if (fin.bad()) {
		return 1;
	}
	if (!fin){
		return 1;
	}
	if (!isSilentMode){
//		putMessage(SafariReader_message[g_lang][7]);
	}

	// t@Cǂݍ݂sB
	while(fin.get(c)){
		ret = parseHTML(&stat,&tag,c);	/* HTMLߕɓnB */
		if (ret){
			/* G[炻̎_ŔB */
			break;
		}
	}

	fin.close();

	if (ret == 0) {
		// G[Ȃꍇ͂Ŋi[JnB
		ret = parseStart(&stat);
	}

	return(ret);
}

/**
 * ͂JnBmۂB
 *
 * @param bmFile ubN}[Nt@C
 * @param fvDir gp
 * @return 0: 0:s
 */
int SafariReader::readBookmark(const char *bmFile,const char *fvDir)
{
	int ret;

	// ꎞobt@mۂB
	work = NULL;
	try{
		work = new char[BUFLEN];
		if (work == NULL){
			logger->debug("Cannot allocate work buffer.");
			return 1;
		}
	}catch(...){
		logger->debug("Cannot allocate work buffer.");
		return 1;
	}
	ret = readFile(bmFile,fvDir);

	delete []work;

	return ret;
}

/**
 * oCiplist`t@CI[vēǂݍ݂JnB
 *
 * @param filename t@C
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int SafariReader::isBplist(const char *filename)
{
	FILE *fp = fopen(filename,"rb");
	if (fp == NULL) {
		logger->debug("Cannot open bookmark file.");
		return -1;
	}

	unsigned char buf[32];

	int read = fread(buf,1,8,fp);
	if (read < 8) {
		logger->debug("Cannot read bookmark file.");
		fclose(fp);
		return -1;
	}

	int result = 1;
	if (memcmp(buf,"bplist00",8)) {
		// ŏbplist00Ŏn܂Ȃꍇ̓oCi`vpeBXgł͂ȂB
		result = 0;
	}
	fclose(fp);

	return result;
}

