//#pragma warning( disable : 4786)

//#if defined(_DEBUG) && defined(_MSC_VER)
//#define _CRTDBG_MAP_ALLOC
//#endif

#include	<stdlib.h>
#include	<new>
#include	<memory>

//#if defined(_DEBUG) && defined(_MSC_VER)
//#include	<crtdbg.h>
//#define new  ::new(_NORMAL_BLOCK, __FILE__, __LINE__)
//#endif

#include	<stdio.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil2.h"
#include	"Bookmark.h"
#include	"NTfunction.h"
#include	"url.h"

#include	"OperaBookmark.h"
#include	"OperaWriter.h"

#ifdef _DEBUG
#define debugprintf //printf
#else
#define debugprintf
#endif

OperaWriter::OperaWriter(void)
{
	m_target = 0;
	m_level = 0;
	syncIElinkFolder = false;
	inIELinkFolder = false;
	ieName = false;
	m_mobile = false;
	placesPut = true;
	nextToolbarPos = 99;
	cs_operaVersion = 1;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
}

OperaWriter::~OperaWriter()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * o͂B
 *
 * @param fp t@C|C^
 * @param name 
 */
void OperaWriter::putAttributeName(FILE *fp,const char *name)
{
	fprintf(fp,"\t%s=",name);

	if (m_mobile) {
		// Windows MobileOpera 9.5=2KvB
		fprintf(fp,"=");
	}
}


/**
 *	o̓[`
 */
void OperaWriter::putname2(FILE *fp,char *name)
{
	debugprintf("putname2\n");
	while(*name){
		fputc(*name,fp);
		name++;
	}
}

/*
	ėpo̓[` SJIS -> UTF8ϊt
	
		fp o͐FILE\̂ւ̃|C^
		name o͂镶
	߂l
		Ȃ
*/
void OperaWriter::putname(FILE *fp,wchar_t *name)
{

	wchar_t *unicode;
	unsigned char *utf8;
	int utf8Count;
	
	debugprintf("putname\n");
	if (name == NULL)
		return;
	
	unicode = name;

	// Unicode -> UTF8
	utf8Count = countUTF16LEtoUTF8str(unicode);
	utf8 = (unsigned char *)calloc(utf8Count + 1,sizeof(unsigned char));
	if (utf8 == NULL){
		return;
	}
	toUTF8(utf8,unicode);

	putname2(fp,(char *)utf8);

	free(utf8);


}

/**
 * ubN}[NEtH_ɋʂ̏o͂B
 * @param fp o͐
 * @param item o͑Ώۂ̃ubN}[N
 */
void OperaWriter::_putBookmark(FILE *fp,Bookmark *item)
{
	// eo
	putAttributeName(fp,"CREATED");
	fprintf(fp,"%u\n",item->getAdddate());

	// Opera 6̏ꍇ͋óA7̏ꍇ͖K₵Ƃꍇ̂ݏo
	if ((item->getLastvisit() > 0) || (getOperaVersion() == 0)){	// Opera 7ł͍ŏIKK₵ȂƏ܂ȂB
		putAttributeName(fp,"VISITED");
		fprintf(fp,"%u\n",item->getLastvisit());
	}
	if (getOperaVersion() == 0){
		// ORDEROpera 6.x̂
		putAttributeName(fp,"ORDER");
		fprintf(fp,"%ld\n",item->getOrder());
	}

	if (getOperaVersion() > 0){
		if (item->getOperaBookmark(m_target)->getOnPersonalBar()){
			putAttributeName(fp,"PERSONALBAR_POS");
			if (item->getOperaBookmark(m_target)->getPersonalBarPos() > -1){
				fprintf(fp,"%d\n",item->getOperaBookmark(m_target)->getPersonalBarPos());	// Opera 7
			} else {
				fprintf(fp,"%d\n",nextToolbarPos);	// Opera 7
				nextToolbarPos++;
			}
		}
	}

	// tH_菈
	if (item->getOperaBookmark(m_target)->getActiveFolder()){
		putAttributeName(fp,"ACTIVE FOLDER");
		fprintf(fp,"YES\n");
	}
	// Opera 6
	if  (getOperaVersion() == 0){
		if (item->getOperaBookmark(m_target)->getLinkbarFolder()){
			putAttributeName(fp,"LINKBAR FOLDER");
			fprintf(fp,"YES\n");
		}
	}
	// Opera 7
	if (getOperaVersion() > 0){
		if (item->getOperaBookmark(m_target)->getOnPersonalBar()){
			putAttributeName(fp,"ON PERSONALBAR");
			fprintf(fp,"YES\n");
		}
		if (item->getOperaBookmark(m_target)->getExpanded()){
			putAttributeName(fp,"EXPANDED");
			fprintf(fp,"YES\n");
		}
		if (item->getOperaBookmark(m_target)->getActive()){
			putAttributeName(fp,"ACTIVE");
			fprintf(fp,"YES\n");
		}
		if (item->getOperaBookmark(m_target)->getTrash()){
			putAttributeName(fp,"TRASH FOLDER");
			fprintf(fp,"YES\n");
		}
		if (item->getOperaBookmark(m_target)->getTarget() != NULL){
			putAttributeName(fp,"TARGET");
			fprintf(fp,"%s\n",item->getOperaBookmark(m_target)->getTarget());
		}
		if (item->getOperaBookmark(m_target)->getMoveCopy()){
			putAttributeName(fp,"MOVE_IS_COPY");
			fprintf(fp,"YES\n");
		}
		if (item->getOperaBookmark(m_target)->getSeparatorAllowed() == false){
			putAttributeName(fp,"SEPARATOR_ALLOWED");
			fprintf(fp,"NO\n");
		}
		if (item->getOperaBookmark(m_target)->getPartnerId() != NULL){
			putAttributeName(fp,"PARTNERID");
			fprintf(fp,"%s\n",item->getOperaBookmark(m_target)->getPartnerId());
		}
	}
}

void OperaWriter::_filePutDescription(FILE *fp,char *desc)
{
	while(*desc){
		if (*desc == 0x0a){
			// s0x02 2ɕϊďo͂B
			fputc(0x02,fp);
			fputc(0x02,fp);
		}else{
			fputc(*desc,fp);
		}
		desc++;
	}
}

/**
 * ubN}[NEtH_ʂ̏o͂B()
 *
 * @param fp t@C|C^
 * @param item o͂ubN}[N
 */
void OperaWriter::_putBookmark2(FILE *fp,Bookmark *item)
{
	if (item->getDescription() != NULL){
		// Opera 6̏ꍇ͋óA7̏ꍇ͕ꍇ̂ݏóB
		if ((strlen(item->getDescription()) > 0) || (getOperaVersion() == 0)){
			putAttributeName(fp,"DESCRIPTION");
			_filePutDescription(fp,item->getDescription());
			fputc('\n',fp);
		}
	}else{
		if (getOperaVersion() == 0){	// Opera 6̏ꍇ͋o͂B
			putAttributeName(fp,"DESCRIPTION");
			fputc('\n',fp);
		}
	}
	if (item->getShortcut() != NULL){
		// Opera 6̏ꍇ͋óA7̏ꍇ͕ꍇ̂ݏóB
		if ((strlen(item->getShortcut()) > 0) || (getOperaVersion() == 0)){
			putAttributeName(fp,"SHORT NAME");
			fprintf(fp,"%s\n",item->getShortcut());
		}
	}else{
		if (getOperaVersion() == 0){	// Opera 6̏ꍇ͋o͂B
			putAttributeName(fp,"SHORT NAME");
			fprintf(fp,"\n");
		}
	}

	if (item->getOperaBookmark(m_target)->getUniqueId() != NULL){
		// ꍇ̂ݏóB
		if ((strlen(item->getOperaBookmark(m_target)->getUniqueId())) > 0){
			putAttributeName(fp,"UNIQUEID");
			fprintf(fp,"%s\n",item->getOperaBookmark(m_target)->getUniqueId());
		}
	}

	if (item->getOperaBookmark(m_target)->getStatus() > -1){
		putAttributeName(fp,"STATUS");
		fprintf(fp,"%d\n",item->getOperaBookmark(m_target)->getStatus());
	}
	fprintf(fp,"\n");
}

/**
 * tH_̏o͂B
 *
 */
void OperaWriter::putFolder(Bookmark *item)
{
	fprintf(cs_fpo,"#FOLDER\n");

	// IÊCɓƃNtH_킹ꍇ
	if (syncIElinkFolder){
		switch (m_level){
			case 0:
				// tH_IẼNtH_ǂH
				if (item->getIeName() != NULL){
					if (!_stricmp(ieLinkFolderName,item->getIeName())){
						inIELinkFolder = true;
					}
				}
				// IẼNtH_͕K[g̉Ȃ̂ŊYȂ
				item->getOperaBookmark(m_target)->setOnPersonalBar(false);
				item->getOperaBookmark(m_target)->setPersonalBarPos(-1);
				break;
			case 1:
				if (inIELinkFolder){
					// IẼNtH_̂ƂɃp[\io[ɕ\B
					item->getOperaBookmark(m_target)->setOnPersonalBar(true);
					item->getOperaBookmark(m_target)->setPersonalBarPos(-1);
				}else{
					item->getOperaBookmark(m_target)->setOnPersonalBar(false);
					item->getOperaBookmark(m_target)->setPersonalBarPos(-1);
				}
				break;
			default:
				// IẼNtH_͕K[g̉Ȃ̂ŊYȂ
				item->getOperaBookmark(m_target)->setOnPersonalBar(false);
				item->getOperaBookmark(m_target)->setPersonalBarPos(-1);
				break;
		}
	}

	/* Opera 7.2ID */
	int id;
//	if (cs_IdFlag){
		if (OperaBookmark::getMaxID() > -1){
			if (item->getOperaBookmark(m_target)->getID() > -1){
				id = item->getOperaBookmark(m_target)->getID();
			}else{
				id = OperaBookmark::getNextID();
			}
			putAttributeName(cs_fpo,"ID");
			fprintf(cs_fpo,"%d\n",id);
		}
//	}

	putAttributeName(cs_fpo,"NAME");
	wchar_t *filenameW = item->getIeNameW();
	if (filenameW != NULL){
		putname(cs_fpo,filenameW);
	}
	fprintf(cs_fpo,"\n");

	_putBookmark(cs_fpo,item);
	_putBookmark2(cs_fpo,item);

	m_level++;
}

/**
 * tH_Io͂B
 *
 */
void OperaWriter::putFolderEnd(Bookmark *item,bool isLast)
{
	if (syncIElinkFolder){
		if (m_level == 1){
			inIELinkFolder = false;
		}
	}

	fprintf(cs_fpo,"-\n");
	m_level--;
}

/**
 * ubN}[N̏o͂B
 *
 */
void OperaWriter::putBookmark(Bookmark *item,bool isLast)
{
	if (!placesPut) {
		// Firefox 3̃X}[gubN}[NtH_炱𖳎B
		if (item->isPlaceURI()) {
			return;
		}
	}

	// IÊCɓƃNtH_킹ꍇ
	if (syncIElinkFolder){
		if (m_level == 1){
			if (inIELinkFolder){
				// IẼNtH_̂ƂɃp[\io[ɕ\B
				item->getOperaBookmark(m_target)->setOnPersonalBar(true);
				item->getOperaBookmark(m_target)->setPersonalBarPos(-1);
			}else{
				item->getOperaBookmark(m_target)->setOnPersonalBar(false);
				item->getOperaBookmark(m_target)->setPersonalBarPos(-1);
			}
		}else{
			// ŏ̊Kw̃tH_ȊO̓NtH_ɂ͂ȂȂ̂
			// falseݒ肷B
			item->getOperaBookmark(m_target)->setOnPersonalBar(false);
			item->getOperaBookmark(m_target)->setPersonalBarPos(-1);
		}
	}

	if (item->getSeparator()){
		// Zp[^̓\[gȂo͂B
		if (Bookmark::getSortMode() == 0){	/* \[gȂo͂B\[gꍇ͈ӖȂ̂ŁB */
			// oubN}[NȊOɂZp[^͖B
			// Zp[^̓ubN}[Nł̈ʒuĂ͂߂ĈӖB
			if (item->getOrgOrder(3 + m_target) < 0){
				return;
			}

			fprintf(cs_fpo,"#SEPERATOR\n");
		}else{
			return;
		}
	}else{
		fprintf(cs_fpo,"#URL\n");
	}

	/* Opera 7.2ID */
	int id;
//	if (cs_IdFlag){
		if (OperaBookmark::getMaxID() > -1){
			if (item->getOperaBookmark(m_target)->getID() > -1){
				id = item->getOperaBookmark(m_target)->getID();
			}else{
				id = OperaBookmark::getNextID();
			}
			putAttributeName(cs_fpo,"ID");
			fprintf(cs_fpo,"%d\n",id);
		}
//	}
	if (item->getSeparator()){
		// Zp[^̏ꍇIDȊO̍ڂ͏o͂Ȃ̂łŔB
		fprintf(cs_fpo,"\n");
		return;
	}

	putAttributeName(cs_fpo,"NAME");
	if (item->getIeNameW() != NULL) {
		putname(cs_fpo,item->getIeNameW());
	}

	fprintf(cs_fpo,"\n");
	if (item->getURL() != NULL) {
		char *p = item->getURL();
		if (strncmp("file:", p,5) == 0) {
			encodeURL(urlBuf,p);
			putAttributeName(cs_fpo,"URL");
			fprintf(cs_fpo,"%s\n",urlBuf);
		} else {
			putAttributeName(cs_fpo,"URL");
			fprintf(cs_fpo,"%s\n",item->getURL());
		}
	}

	_putBookmark(cs_fpo,item);

	if (getOperaVersion() > 0){
		if (item->getOperaBookmark(m_target)->getPanelPos() > -1){
			putAttributeName(cs_fpo,"PANEL_POS");
			fprintf(cs_fpo,"%d\n",item->getOperaBookmark(m_target)->getPanelPos());
		}
		if (item->getOperaBookmark(m_target)->getInPanel()){
			putAttributeName(cs_fpo,"IN PANEL");
			fprintf(cs_fpo,"YES\n");
		}
		if (item->getOperaBookmark(m_target)->getSsrInPanel()){
			putAttributeName(cs_fpo,"SMALL SCREEN");
			fprintf(cs_fpo,"YES\n");
		}
	}
	if (getOperaVersion() > 0){
		if (item->getOperaBookmark(m_target)->getIcon() != NULL){
			putAttributeName(cs_fpo,"ICONFILE");
			fprintf(cs_fpo,"%s\n",item->getOperaBookmark(m_target)->getIcon());
		}
	}
	_putBookmark2(cs_fpo,item);
}


/*
	ubN}[Ñwb_o͂B
	
		Ȃ
	߂l
		Ȃ
*/
void OperaWriter::putHeader(void)
{
	fprintf(cs_fpo,"Opera Hotlist version 2.0\n");
	fprintf(cs_fpo,"Options:encoding=utf8,version=3\n\n");

}

/*
	ubN}[Ñtb^o͂B
	
		Ȃ
	߂l
		Ȃ
*/
void OperaWriter::putFooter(void)
{
	if (syncIElinkFolder){
		if (m_level == 1){
			inIELinkFolder = false;
		}
	}

//	fprintf(cs_fpo,"-\n");
	fprintf(cs_fpo,"\n");
	m_level--;
}

