#ifndef OP25WRITER_H
#define OP25WRITER_H

#include	<stdio.h>
#include	<vector>
#include	<string>
#include	<set>

#include "Bookmark.h"
#include "IBookmarkWriter.h"
#include "BookmarkTree.h"
#include "booklist.h"

// }CtH_
#define WRITE_MY_FOLDER 0
// LACe
#define WRITE_SHARED 1
// Xs[h_C
#define WRITE_SPEED_DIAL 2
// ݔ
#define WRITE_TRASH 3
// ݔ
#define WRITE_UNSORTED 4

class Op25Writer : public IBookmarkWriter {
private:
	int m_spaces;	// ݂̃Xy[X̌
	FILE *cs_fpo;	// ubN}[No͗pt@C|C^
	char *urlBuf;
	int urlBufLen;

	// ݑΏۂ̑
	int m_target;
	// ݂̊Kwx(0`)
	unsigned int m_level;
	bool placesPut;	// Firefox 3̃X}[gubN}[NtH_o͂邩ǂH
	bool m_ignore;
	bool putIEToolbar;	// IÊCɓo[o͂邩ǂ
	bool isFirstRoot;
	unsigned int m_ignoreSince;
	bool inFolder;
	unsigned int ignoreLevel;	// q̊Kw̓tH_ȂB
	bool inSpeedDial;	// Xs[h_C̒ǂ

	std::vector<int> itemsCount;
	int maxLevel;
	std::set<std::string> *guidSet;	// GUIDi[set

	int reallocUrlBuf(int size);
	void spput(FILE *fp,int spaces);
	void putWithEscape(FILE *fp, char *str);
	void putname(FILE *fp, wchar_t *name);
	void putname2(FILE *fp,char *name);
	void putURL(Bookmark *item);
	void putFolderEndInfo(Bookmark *item);
	void putItemPause(void);
	bool putMetaValue(const char *key, char *value, bool outValue);
	bool putMetaValue(const char *key, int value, bool outValue);
	int writeOp25Unsorted(int no, BookmarkTree *bookmarkTree);
	void putBookList(BookmarkTree *bookmarkTree, BOOKLIST *unsortedList);

public:
	/* ubN}[No̓C^[tFCXCvg */
	void putHeader(void);
	void putFolder(Bookmark *item);
	void putFolderEnd(Bookmark *item,bool isLast);
	void putBookmark(Bookmark *item,bool isLast);
	void putFooter(void);

	int writeOp25CustomRoot(
		int no,
		BookmarkTree *bookmarkTree,
		bm_listitem *targetNode,
		bm_listitem *orgTargetNode,
		bool putSpeedDial,
		bool ignoreUnsorted,
		bm_listitem *orgUnsortedNode);
	int writeOp25Other(int no, BookmarkTree *bookmarkTree, bm_listitem *targetNode);
	int writeOp25UserRoot(int no, BookmarkTree *bookmarkTree, BOOKLIST *customRootList, int folderType);

	// ubN}[No͗pt@C|C^ݒ
	void setFilePointer(FILE *fpo) {cs_fpo = fpo;};

	// ݑΏۑ̐ݒ
	int getTarget(void) {return m_target;};
	void setTarget(int target) {m_target = target;};

	void setPlacesPut(bool mode) {
		placesPut = mode;
	}
	bool getIEToolbarPut(void) {
		return putIEToolbar;
	}
	void setIEToolbarPut(bool value) {
		putIEToolbar = value;
	}
	bool getInFolder(void) {
		return inFolder;
	}
	void setInFolder(bool value) {
		inFolder = value;
	}

	void setIgnoreLevel(unsigned int level) {
		ignoreLevel = level;
	}

	/**
	 * GUIDi[psetݒ肷B
	 *
	 * @param value GUIDi[pset
	 */
	void setGuidSet(std::set<std::string> *value) {
		guidSet = value;
	}

	Op25Writer(void);
	~Op25Writer();
};

#endif	// OP25WRITER_H
