#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NTfunction.h"
#include	"Bookmark.h"
#include	"url.h"

#include	"Op25Writer.h"

/**
 * RXgN^
 */
Op25Writer::Op25Writer(void)
{
	m_target = 0;
	m_level = 0;
	placesPut = true;
	m_ignore = false;
	itemsCount.push_back(0);
	putIEToolbar = true;
	isFirstRoot = true;
	inFolder = true;
	inSpeedDial = false;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
	urlBufLen = BUFLEN;
}

/**
 * fXgN^
 */
Op25Writer::~Op25Writer()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int Op25Writer::reallocUrlBuf(int size)
{
	delete []urlBuf;
	try {
		urlBuf = NULL;
		urlBuf = new char[size];
		if (urlBuf == NULL) {
			return -1;
		}
		urlBufLen = size;
	} catch (...) {
		return -1;
	}
	return size;
}

/**
 * Xy[Xo͂B
 *
 * @param fp o͐̃t@C|C^
 * @param tabs ^u̐
 */
void Op25Writer::spput(FILE *fp,int tabs)
{
	int i;
	
	for (i = 0;i < (tabs * 3);i++){
		fputc(' ',fp);
	}
}

/**
* Xy[Xo͂B
*
* @param fp o͐̃t@C|C^
* @param str o͑Ώە
*/
void Op25Writer::putWithEscape(FILE *fp, char *str)
{
	char *p = str;

	while (*p) {
		if (*p != '\"') {
			fputc(*p, fp);
		} else {
			// _uNH[g̓GXP[vB
			fputc('\\', fp);
			fputc(*p, fp);
		}
		p++;
	}
}


/**
 * tH_AubN}[ÑJ}؂o͂ƃJ}Kvǂ̃JEgsB
 *
 */
void Op25Writer::putItemPause(void)
{
	if (inFolder) {
		// tH_ɃtH_ꍇ͊etH_̏Ԃ
		// J}łB
		if (itemsCount[m_level] > 0) {
			fprintf(cs_fpo,", ");
		}
		itemsCount[m_level] += 1;
	} else {
		if (m_level < ignoreLevel) {
			// tH_Kwł͂͊etH_̏Ԃ
			// J}łB
			if (itemsCount[m_level] > 0) {
				fprintf(cs_fpo,", ");
			}
			itemsCount[m_level] += 1;
		} else {
			// tH_̒̓tH_Kw̏ԂɃJ}łB
			if (itemsCount[ignoreLevel] > 0) {
				fprintf(cs_fpo,", ");
			}
			itemsCount[ignoreLevel] += 1;
		}
	}
}


/**
 * tH_̏o͂B
 *
 * @param item o͑Ώۂ̃tH_
 */
void Op25Writer::putFolder(Bookmark *item)
{
	switch(item->getFolderType()) {
		case Bookmark::toolBar:
			m_ignore = false;
			if (!isFirstRoot) {
				fprintf(cs_fpo,",\n");
			}
			isFirstRoot = false;
			spput(cs_fpo,2);
			fprintf(cs_fpo,"\"bookmark_bar\": {\n");
			spput(cs_fpo,3);
			fprintf(cs_fpo,"\"children\": [ ");

			if (m_ignore) {
				putFolderEndInfo(item);
			}

			break;

		case Bookmark::menuBar:
			m_ignore = false;
			if (!isFirstRoot) {
				fprintf(cs_fpo,",\n");
			}
			isFirstRoot = false;
			spput(cs_fpo,2);
			fprintf(cs_fpo,"\"other\": {\n");
			spput(cs_fpo,3);
			fprintf(cs_fpo,"\"children\": [ ");

			if (m_ignore) {
				putFolderEndInfo(item);
			}
			break;

		case Bookmark::customRoot:
			m_ignore = false;
			if (!isFirstRoot) {
				fprintf(cs_fpo, ",\n");
			}
			isFirstRoot = false;
			spput(cs_fpo, 2);
			fprintf(cs_fpo, "\"custom_root\": {\n");

			if (m_ignore) {
				putFolderEndInfo(item);
			}
			break;
		case Bookmark::mobile:
			if (!isFirstRoot) {
				fprintf(cs_fpo,",\n");
			}
			isFirstRoot = false;
			spput(cs_fpo,2);
			fprintf(cs_fpo,"\"synced\": {\n");
			spput(cs_fpo,3);
			fprintf(cs_fpo,"\"children\": [ ");

			// Opera 19̃ubN}[No[ł͎gȂ̂ŖB
			m_ignore = true;
			m_ignoreSince = 0;
			putFolderEndInfo(item);
			break;
		default:
			if (m_level == 0) {
				// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂B
				m_ignore = true;
				m_ignoreSince = 0;
			} else {

				if ((putIEToolbar == false) && (item->isIEToolbar())) {
					// IẼc[o[𖳎邩ǂǂ̔
					m_ignore = true;
					m_ignoreSince = m_level;
				}
				if (!m_ignore) {
					// Ăꍇ͉AKŵ݃JEgB
					// łȂꍇ͊ẽtH_̏o͂JnB
					if ((inFolder) || (m_level < ignoreLevel)) {
						if (item->getOp25Bookmark(m_target)->getFolderType() == Op25Bookmark::myFolder) {
							// }CtH_
							spput(cs_fpo, 2 + m_level);
							fprintf(cs_fpo, "\"userRoot\": {\n");
							spput(cs_fpo, 3 + m_level);
							fprintf(cs_fpo, "\"children\": [ ");
						} else if (item->getOp25Bookmark(m_target)->getFolderType() == Op25Bookmark::shared) {
							// LubN}[N
							spput(cs_fpo, 2 + m_level);
							fprintf(cs_fpo, "\"shared\": {\n");
							spput(cs_fpo, 3 + m_level);
							fprintf(cs_fpo, "\"children\": [ ");
						} else if (item->getOp25Bookmark(m_target)->getFolderType() == Op25Bookmark::trash) {
							// ݔ
							spput(cs_fpo, 2 + m_level);
							fprintf(cs_fpo, "\"trash\": {\n");
							spput(cs_fpo, 3 + m_level);
							fprintf(cs_fpo, "\"children\": [ ");
						} else if (item->getOp25Bookmark(m_target)->getFolderType() == Op25Bookmark::unsorted) {
							// ̃ubN}[N
							spput(cs_fpo, 2 + m_level);
							fprintf(cs_fpo, "\"unsorted\": {\n");
							spput(cs_fpo, 3 + m_level);
							fprintf(cs_fpo, "\"children\": [ ");
						} else if (item->getOp25Bookmark(m_target)->getFolderType() == Op25Bookmark::speedDial) {
							// Xs[h_C(Opera 29)/Xs[h_C
							spput(cs_fpo, 2 + m_level);
							fprintf(cs_fpo, "\"speedDial\": {\n");
							spput(cs_fpo, 3 + m_level);
							fprintf(cs_fpo, "\"children\": [ ");
						} else {
							// tH_̍ŏ̗vfȊȌꍇ1O̗vf̋؂Ƃ,łB
							putItemPause();
							fprintf(cs_fpo, "{\n");
							spput(cs_fpo, 3 + m_level);
							fprintf(cs_fpo, "\"children\": [");
						}
					}
				}
			}
			break;
	}
	m_level++;

	// ̊Kw̗vfB
	if (m_level >= itemsCount.size()) {
		itemsCount.push_back(0);
	} else {
		itemsCount[m_level] = 0;
	}
}

/**
 * tH_ĨtH_̏o͂B
 *
 * @param item o͑Ώۂ̃tH_
 */
void Op25Writer::putFolderEndInfo(Bookmark *item)
{
	if (item->getFolderType() == Bookmark::customRoot) {
		// custom_root͊etH_̗vfL[ȊOȂB
		spput(cs_fpo, 2 + m_level);
		fprintf(cs_fpo, "}");
		return;
	}

	fprintf(cs_fpo, "],\n");
	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"date_added\": \"");
	putChromeDateTime(cs_fpo,item->getAdddate());
	fprintf(cs_fpo,"\",\n");

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"date_modified\": \"");
	putChromeDateTime(cs_fpo,item->getModified());
	fprintf(cs_fpo,"\",\n");

	Op25Bookmark *op25Info = item->getOp25Bookmark(m_target);
	if (op25Info->getID() != NULL) {
		spput(cs_fpo,3 + m_level);
		fprintf(cs_fpo,"\"id\": \"");
		wchar_t *wp = UTF8towcFileNameInternal(op25Info->getID());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo,"\",\n");
	}

	// meta_infoo͂B
	spput(cs_fpo, 3 + m_level);
	fprintf(cs_fpo, "\"meta_info\": {\n");
	bool outMetaInfoValue = false;

	if (inSpeedDial) {
		// Xs[h_C̊eڂɂguidK{ł(ubN}[NAtH_Ƃ)B
		// āAGUIDB
		if (m_level > 2) {
			if ((op25Info->getGuid() == NULL) && (op25Info->getFavoriteGuid() == NULL)) {
				char guidBuf[64];
				while (true){
					createUUID(guidBuf);
					// 쐬GUID܂ŏoĂȂ΂ݒ肷B
					if (guidSet->find(guidBuf) == guidSet->end()) {
						guidSet->insert(guidBuf);
						op25Info->setGuid(guidBuf);
						op25Info->setFavoriteGuid(guidBuf);
						break;
					}
				}
			}
		} else if (m_level == 2) {
			if (op25Info->getSpeedDialGuid() == NULL) {
				char guidBuf[64];
				while (true){
					createUUID(guidBuf);
					// 쐬GUID܂ŏoĂȂ΂ݒ肷B
					if (guidSet->find(guidBuf) == guidSet->end()) {
						guidSet->insert(guidBuf);
						op25Info->setSpeedDialGuid(guidBuf);
						break;
					}
				}
			}
		}
	}

	outMetaInfoValue = putMetaValue("speed_dial_root_folder_guid", op25Info->getSpeedDialGuid(), outMetaInfoValue);

	outMetaInfoValue = putMetaValue(CUSTOM_KEYWORDS, op25Info->getCustomKeywords(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(OPERA_GUID, op25Info->getGuid(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(OP25_FAVORITE_GUID, op25Info->getFavoriteGuid(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(PARTNER_ID, op25Info->getPartnerID(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(PARTNER_URL, op25Info->getPartnerUrl(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(REDIRECT, op25Info->getRedirect(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(ISLISTVIEW, op25Info->getIsListView(), outMetaInfoValue);
	if (op25Info->getLayoutMode() > 0) {
		outMetaInfoValue = putMetaValue(LAYOUTMODE, op25Info->getLayoutMode(), outMetaInfoValue);
	}

	fprintf(cs_fpo, "\n");
	spput(cs_fpo, 3 + m_level);
	fprintf(cs_fpo, "},\n");
	// meta_info͂܂

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"name\": \"");
	if (item->getFolderType() == Bookmark::mobile) {
		putJSONString(cs_fpo, L"oC̃ubN}[N");
	} else {
		if (item->getIeNameW() != NULL){
			putJSONString(cs_fpo,item->getIeNameW());
		}
	}
	fprintf(cs_fpo,"\",\n");
	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"type\": \"folder\"\n");
	spput(cs_fpo,2 + m_level);
	fprintf(cs_fpo,"}");

	switch (item->getOp25Bookmark(m_target)->getFolderType()) {
		case Op25Bookmark::normalFolder:
			// ̃L[̗L͊֌WȂ̂ŉoȂB
			break;
		case Op25Bookmark::myFolder:
		case Op25Bookmark::imported:
			// ̃L[͂Ȃ̂ŉŝݏoB
			fprintf(cs_fpo, "\n");
			break;
		default:
			// ̃L[̂ŃJ}oB
			fprintf(cs_fpo, ",\n");
			break;
	}
}

/**
 * tH_Io͂B
 *
 * @param item o͂tH_
 */
void Op25Writer::putFolderEnd(Bookmark *item,bool isLast)
{
	m_level--;

	// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂A
	// Kŵ݃JEgB
	if (!m_ignore) {
		if ((inFolder) || (m_level < ignoreLevel)) {
			putFolderEndInfo(item);
		}
	}
	if (m_level == m_ignoreSince) {
		m_ignore = false;
	}
}

/**
 * URL̏o͂B
 *
 * @param item URLo͂ubN}[N
 */
void Op25Writer::putURL(Bookmark *item)
{
	if (item->getURL() != NULL){
		char *p;
		wchar_t *wp;
		int escapeLen;

		p = item->getURL();
		if (strncmp("javascript:", p,11) == 0) {
			// ubN}[Nbg̏ꍇURLGR[h
			escapeLen = strlen(p) * 3;
			if ((escapeLen + 1) > urlBufLen) {
				reallocUrlBuf(escapeLen);
			}
			encodeURL(urlBuf, p);
			p = urlBuf;
		} else if (strncmp("file:", p, 5) == 0) {
			// file:̏ꍇURLGR[hB
			escapeLen = strlen(p) * 3;
			if ((escapeLen + 1) > urlBufLen) {
				reallocUrlBuf(escapeLen);
			}
			encodeURL(urlBuf, p);
			p = urlBuf;
		}

		wp = UTF8towcFileNameInternal(p);

		putJSONString(cs_fpo,wp);
	}
}

/**
 * ubN}[N̏o͂B
 */
void Op25Writer::putBookmark(Bookmark *item,bool isLast)
{
	if (!placesPut) {
		// Firefox 3̃X}[gubN}[NtH_𖳎ꍇȂB
		if (item->isPlaceURI()) {
			return;
		}
	}

	// Opera 25ɂZp[^͂Ȃ̂ŉɏݐƂB
	if (item->getSeparator()) {
		return;
	}
	if (m_ignore) {
		// tH_̓e𖳎ꍇ͔΂B
		return;
	}
	if (m_level == 0) {
		// ŏ̊Kw(ubN}[No[Ȇ̃ubN}[NƂ)
		// ɂ̓ubN}[N͓Ȃ̂Ŕ΂B
		return;
	}

	// tH_̍ŏ̗vfȊȌꍇ1O̗vf̋؂Ƃ,łB
	putItemPause();

	fprintf(cs_fpo,"{\n");
	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"date_added\": \"");
	putChromeDateTime(cs_fpo,item->getAdddate());
	fprintf(cs_fpo,"\",\n");
	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"date_modified\": \"");
	putChromeDateTime(cs_fpo,item->getModified());
	fprintf(cs_fpo,"\",\n");

	Op25Bookmark *op25Info = item->getOp25Bookmark(m_target);

	if (op25Info->getID() != NULL) {
		spput(cs_fpo,4 + m_level);
		fprintf(cs_fpo,"\"id\": \"");
		wchar_t *wp = UTF8towcFileNameInternal(op25Info->getID());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo,"\",\n");
	}

	// meta_info̗vfo͂B
	spput(cs_fpo, 4 + m_level);
	fprintf(cs_fpo, "\"meta_info\": {\n");
	bool outMetaInfoValue = false;

	if (op25Info->getShareData() != NULL) {
		spput(cs_fpo, 5 + m_level);
		fprintf(cs_fpo, "\"shareData\": \"");
		putWithEscape(cs_fpo, op25Info->getShareData());
		fprintf(cs_fpo, "\"");
		outMetaInfoValue = true;
	}

	outMetaInfoValue = putMetaValue(CUSTOM_KEYWORDS, op25Info->getCustomKeywords(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue("imageData", op25Info->getImageData(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue("imageIdentifier", op25Info->getImageIdentifier(), outMetaInfoValue);
	if (op25Info->getImageType() != 0) {
		outMetaInfoValue = putMetaValue("imageType", op25Info->getImageType(), outMetaInfoValue);
	}
	if (op25Info->getImageDataType() != 0) {
		outMetaInfoValue = putMetaValue("imageDataType", op25Info->getImageDataType(), outMetaInfoValue);
	}
	outMetaInfoValue = putMetaValue(IMAGEID, op25Info->getImageID(), outMetaInfoValue);
	//if (inSpeedDial) {
	// guidK{ł(ubN}[NAtH_Ƃ)B
	// āAGUIDB
	if ((op25Info->getGuid() == NULL) && (op25Info->getFavoriteGuid() == NULL)){
		char guidBuf[64];
		while (true){
			createUUID(guidBuf);
			// 쐬GUID܂ŏoĂȂ΂ݒ肷B
			if (guidSet->find(guidBuf) == guidSet->end()) {
				guidSet->insert(guidBuf);
				op25Info->setGuid(guidBuf);
				op25Info->setFavoriteGuid(guidBuf);
				break;
			}
		}
	}
	//}
	outMetaInfoValue = putMetaValue(OPERA_GUID, op25Info->getGuid(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(OP25_FAVORITE_GUID, op25Info->getFavoriteGuid(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(PARTNER_ID, op25Info->getPartnerID(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(PARTNER_URL, op25Info->getPartnerUrl(), outMetaInfoValue);
	outMetaInfoValue = putMetaValue(REDIRECT, op25Info->getRedirect(), outMetaInfoValue);

	fprintf(cs_fpo, "\n");
	spput(cs_fpo, 4 + m_level);
	fprintf(cs_fpo, "},\n");
	// meta_info̊evf͂܂

	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"name\": \"");
	if (item->getIeNameW() != NULL){
		putJSONString(cs_fpo,item->getIeNameW());
	}
	fprintf(cs_fpo,"\",\n");

	if (op25Info->getSyncTransVer() != NULL) {
		spput(cs_fpo, 4 + m_level);
		fprintf(cs_fpo, "\"sync_transaction_version\": \"%s\",\n", op25Info->getSyncTransVer());
	}
	
	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"type\": \"url\",\n");

	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"url\": \"");
	putURL(item);
	fprintf(cs_fpo,"\"\n");

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"}");
}

/**
 * meta_info̒l̏o͂sB
 *
 * @param key L[
 * @param value l
 * @param outValue ȑOmeta_infoڂ̏o͗L
 * @return Vmeta_infȍo͗L
 */
bool Op25Writer::putMetaValue(const char *key, char *value, bool outValue)
{
	// o͂lȂꍇ
	if (value == NULL) {
		// o̗͂LȌԂ̂܂܂ɂB
		return outValue;
	}
	// Oɉ炩̒lo͂Ăꍇ
	if (outValue) {
		// ؂,\no͂B
		fprintf(cs_fpo, ",\n");
	}
	// L[ƒlo͂B
	spput(cs_fpo, 5 + m_level);
	fprintf(cs_fpo, "\"%s\": \"", key);
	// lɂ"ꍇ̂ŁAGXP[vB
	putWithEscape(cs_fpo, value);
	fputc('\"', cs_fpo);

	return true;
}

/**
 * meta_info̒l̏o͂sB
 *
 * @param key L[
 * @param value l
 * @param outValue ȑOmeta_infoڂ̏o͗L
 * @return Vmeta_infȍo͗L
 */
bool Op25Writer::putMetaValue(const char *key, int value, bool outValue)
{
	// Oɉ炩̒lo͂Ăꍇ
	if (outValue) {
		// ؂,\no͂B
		fprintf(cs_fpo, ",\n");
	}
	// L[ƒlo͂B
	spput(cs_fpo, 5 + m_level);
	fprintf(cs_fpo, "\"%s\": \"%d\"", key, value);

	return true;
}

/**
 * ubN}[Ñwb_o͂B
 */
void Op25Writer::putHeader(void)
{
	fprintf(cs_fpo,"{\n");	// Top level object
	fprintf(cs_fpo,"   \"roots\": {\n");
}

/**
 * ubN}[Ñtb^o͂B
 */
void Op25Writer::putFooter(void)
{
	fprintf(cs_fpo,"\n");
	fprintf(cs_fpo,"   },\n");
	fprintf(cs_fpo,"   \"version\": 1\n");
	fprintf(cs_fpo,"}\n");	// Top level object
}

/**
 * &HTML̕QƂɕϊȂ當o͂B
 *
 * @param fp t@C|C^
 * @param name o͂镶
 */
void Op25Writer::putname2(FILE *fp,char *name)
{
//	debugprintf("putname2\n");
	while(*name){
		switch(*name){
			case '&':
				fprintf(fp,"&amp;");
			break;
			case '<':
				fprintf(fp,"&lt;");
			break;
			case '>':
				fprintf(fp,"&gt;");
			break;
			case '\"':
				fprintf(fp,"&quot;");
			break;
			default:
				fputc(*name,fp);
			break;
		}
		name++;
	}
}

/**
 * ėpo̓[` SJIS -> UTF8ϊt
 *
 * @param fp t@C|C^
 * @param name o͂镶
 */
void Op25Writer::putname(FILE *fp,wchar_t *name)
{

	wchar_t *unicode;
	unsigned char *utf8;
	int utf8Count;
	
//	debugprintf("putname\n");
	if (name == NULL)
		return;
	
	unicode = name;

	// Unicode -> UTF8
	utf8Count = countUTF16LEtoUTF8str(unicode);
	utf8 = (unsigned char *)calloc(utf8Count + 1,sizeof(unsigned char));
	if (utf8 == NULL){
		return;
	}
	toUTF8(utf8,unicode);

	putname2(fp,(char *)utf8);

	free(utf8);

}

/**
 * Opera 25customRoot(}CtH_)ȉ̗vfo͂B
 *
 * @param no ΏۂƂȂubN}[N
 * @param bookmarkTree oubN}[Nc[
 * @param targetNode Opera 25customRootÃuEŨj[o[̊i[
 * @param originalNode ƂƂOpera 25customRootÃuEŨj[o[̊i[
 * @param putSpeedDial ̃uEUɂXs[h_Co͂邩H
 * @param ignoreUnsorted Unsorted bookmarkso͂邩
 * @param orgUnsortedNode ƂƂOpera 25Unsorted bookmark̊i[
 * @return 0:o͐ 1:o͎s
 */
int Op25Writer::writeOp25CustomRoot(
	int no,
	BookmarkTree *bookmarkTree,
	bm_listitem *targetNode,
	bm_listitem *originalNode,
	bool putSpeedDial,
	bool ignoreUnsorted,
	bm_listitem *orgUnsortedNode)
{

	BOOKLIST *customRootList = targetNode->getChild();
	BOOKLIST::iterator iter;
	char *p;

	// LACȅ
	Bookmark *shared = new Bookmark();
	p = mbtoUTF8Internal("LubN}[N");
	shared->setName(p);
	shared->setIeName("LubN}[N");
	shared->setIeNameW(L"LubN}[N");
	shared->getOp25Bookmark(no)->setFolderType(Op25Bookmark::shared);
	setIgnoreLevel(3);
	inSpeedDial = false;

	putFolder(shared);

	writeOp25UserRoot(no, bookmarkTree, customRootList, WRITE_SHARED);
	putFolderEnd(shared, true);

	// Xs[h_C̏
	inSpeedDial = true;
	if (putSpeedDial) {
		writeOp25UserRoot(no, bookmarkTree, customRootList, WRITE_SPEED_DIAL);
	} else {
		// ̃uEUɃXs[h_Co͂Ȃꍇ
		// ̃Xs[h_Co͂B
		if (originalNode != NULL) {
			BOOKLIST *orgCustomRootList = originalNode->getChild();
			if (orgCustomRootList != NULL) {
				writeOp25UserRoot(no, bookmarkTree, orgCustomRootList, WRITE_SPEED_DIAL);
			}
		}
	}
	inSpeedDial = false;

	// ݔ̏
	Bookmark *trash = new Bookmark();
	p = mbtoUTF8Internal("ݔ");
	trash->setName(p);
	trash->setIeName("ݔ");
	trash->setIeNameW(L"ݔ");
	trash->getOp25Bookmark(no)->setFolderType(Op25Bookmark::trash);
	setIgnoreLevel(3);
	inSpeedDial = false;

	putFolder(trash);
	writeOp25UserRoot(no, bookmarkTree, customRootList, WRITE_TRASH);
	putFolderEnd(shared, true);

	// ̃ubN}[N(Opera 25)̏
	if (!ignoreUnsorted) {
		writeOp25Unsorted(no, bookmarkTree);
	} else {
		Bookmark *unsorted = new Bookmark();

		p = mbtoUTF8Internal("̃ubN}[N");
		unsorted->setName(p);
		unsorted->setIeName("̃ubN}[N");
		unsorted->setIeNameW(L"̃ubN}[N");
		unsorted->getOp25Bookmark(no)->setFolderType(Op25Bookmark::unsorted);
		setIgnoreLevel(3);

		putFolder(unsorted);
		if (orgUnsortedNode != NULL) {
			BOOKLIST *orgCustomRootList = orgUnsortedNode->getChild();
			if (orgCustomRootList != NULL) {
				putBookList(bookmarkTree, orgCustomRootList);
			}
		}
		putFolderEnd(unsorted, true);
		delete unsorted;
	}

	// }CtH_(userRoot)̏
	// ̃uEŨubN}[Nj[}CtH_ɏo͂̂ŁA
	// }CtH_̂̃tH_o͂1i炷B
	Bookmark *userRoot = new Bookmark();
	p = mbtoUTF8Internal("}CtH_");
	userRoot->setName(p);
	userRoot->setIeName("}CtH_");
	userRoot->setIeNameW(L"}CtH_");
	userRoot->getOp25Bookmark(no)->setFolderType(Op25Bookmark::myFolder);
	setIgnoreLevel(3);
	inSpeedDial = false;

	putFolder(userRoot);

	writeOp25UserRoot(no, bookmarkTree, customRootList, WRITE_MY_FOLDER);

	putFolderEnd(userRoot, true);
	delete userRoot;


	return 0;
}

void Op25Writer::putBookList(BookmarkTree *bookmarkTree, BOOKLIST *unsortedList)
{
	BOOKLIST::iterator iter;

	for (iter = unsortedList->begin(); iter != unsortedList->end(); ++iter) {
		if (iter->getRefer()) {
			Bookmark *bm = iter->getBookmark();
			if (bm == NULL) {
				continue;
			}
			if (bm->getItemType() == Bookmark::bookmark) {
				putBookmark(bm, false);
			} else {
				bookmarkTree->putList(iter->getChild());
			}
		}
	}

}

/**
 * Opera 25customRoot(}CtH_)ȉ̗vfo͂B
 *
 * @param no ΏۂƂȂubN}[N
 * @param bookmarkTree oubN}[Nc[
 * @return 0:o͐ 1:o͎s
 */
int Op25Writer::writeOp25Unsorted(int no, BookmarkTree *bookmarkTree)
{
	bm_listitem *targetNode;

	targetNode = bookmarkTree->getFolderNodeByAttribute(Bookmark::unFiled);
	Bookmark *unsorted = new Bookmark();

	char *p = mbtoUTF8Internal("̃ubN}[N");
	unsorted->setName(p);
	unsorted->setIeName("̃ubN}[N");
	unsorted->setIeNameW(L"̃ubN}[N");
	unsorted->getOp25Bookmark(no)->setFolderType(Op25Bookmark::unsorted);
	setIgnoreLevel(3);

	putFolder(unsorted);
	if (targetNode != NULL) {
		if (targetNode->getChild()) {
			BOOKLIST *unsortedList = targetNode->getChild();
			putBookList(bookmarkTree, unsortedList);
		}
	}
	putFolderEnd(unsorted, true);
	delete unsorted;

	return 0;
}

/**
 * Opera 25other(C|[gubN}[N)ȉ̗vfo͂B
 *
 * @param no ΏۂƂȂubN}[N
 * @param bookmarkTree oubN}[Nc[
 * @param targetNode Opera 25customRootÃuEŨj[o[̊i[
 * @return 0:o͐ 1:o͎s
 */
int Op25Writer::writeOp25Other(int no, BookmarkTree *bookmarkTree, bm_listitem *targetNode)
{

	BOOKLIST *customRootList = targetNode->getChild();
	BOOKLIST::iterator iter;

	// C|[gꂽubN}[NTẢĂB
	setIgnoreLevel(65536);
	inSpeedDial = false;

	for (iter = customRootList->begin(); iter != customRootList->end(); ++iter){
		if (iter->getRefer()) {
			Bookmark *bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			if (bm->getItemType() == Bookmark::bookmark){
				continue;
			} else {
				// C|[gꂽubN}[NȊO΂
				if (bm->getOp25Bookmark(no)->getFolderType() != Op25Bookmark::imported) {
					continue;
				}
				// tH_̏ꍇ͍ċAĂяosătH_̒gĂB
				if (iter->getChild() != NULL){
					// putFolder(bm);
					bookmarkTree->putList(iter->getChild());
					// putFolderEnd(bm, false);
				}
			}
		}
	}

	return 0;
}

/**
 * Opera 25userRoot(}CtH_)Ashared(LubN}[N)ȉ̗vfo͂B
 *
 * @param no ΏۂƂȂubN}[N
 * @param bookmarkTree oubN}[Nc[
 * @param userRootList userRoot(}CtH_)Ashared(LubN}[N)Ɋi[ꂽXg
 * @param folderType 0:}CtH_̏o 1:LubN}[N̏o 2:Xs[h_Co
 * @return 0:o͐ 1:o͎s
 */
int Op25Writer::writeOp25UserRoot(int no, BookmarkTree *bookmarkTree, BOOKLIST *userRootList, int folderType)
{
	BOOKLIST::iterator iter;

	for (iter = userRootList->begin(); iter != userRootList->end(); ++iter){
		if (iter->getRefer()) {
			Bookmark *bm = iter->getBookmark();
			if (bm == NULL){
				continue;
			}
			if (bm->getItemType() == Bookmark::bookmark){
				// ubN}[NOpera 25̂̑̃ubN}[NɓĂĂ̂Ŕ΁c
				// Ă̂AOpera 28̓}CtH_ɂubN}[N
				// ûŃ}CtH_̏ꍇ͏o͂B
				if (folderType == 0) {
					// }CtH_̏ꍇ͏o͂B
					putBookmark(bm, false);
				}
			} else {
				// C|[gꂽubN}[N΂
				if (bm->getOp25Bookmark(no)->getFolderType() == Op25Bookmark::imported) {
					continue;
				}
				if (folderType == WRITE_MY_FOLDER) {
					// }CtH_̏ꍇ͈ʃtH_ȊO΂
					if (bm->getOp25Bookmark(no)->getFolderType() != Op25Bookmark::normalFolder) {
						continue;
					}
				} else if (folderType == WRITE_SHARED) {
					// LubN}[N̏ꍇ͋LubN}[NȊO΂B
					if (bm->getOp25Bookmark(no)->getFolderType() != Op25Bookmark::shared) {
						continue;
					}
					if (iter->getChild() != NULL){
						bookmarkTree->putList(iter->getChild());
					}
					continue;
				} else if (folderType == WRITE_SPEED_DIAL) {
					// Xs[h_C̏ꍇ̓Xs[h_CȊO΂B
					if (bm->getOp25Bookmark(no)->getFolderType() != Op25Bookmark::speedDial) {
						continue;
					}
				} else if (folderType == WRITE_TRASH) {
					// ݔ̏ꍇ͂ݔȊO΂B
					if (bm->getOp25Bookmark(no)->getFolderType() != Op25Bookmark::trash) {
						continue;
					}
					if (iter->getChild() != NULL){
						bookmarkTree->putList(iter->getChild());
					}
					continue;
				}

				// tH_̏ꍇ͍ċAĂяosătH_̒gĂB
				putFolder(bm);
				if (iter->getChild() != NULL){
					bookmarkTree->putList(iter->getChild());
				}

				putFolderEnd(bm, false);
			}
		}
	}

	return 0;
}

