#ifndef OP25READER_H
#define OP25READER_H

#include	<vector>
#include	<string>
#include	<set>

#include	"BScommon.h"
#include	"Bookmark.h"
#include	"Logger.h"

#include	"IBookmarkTree.h"
#include	"BookmarkTree.h"
#include	"TJson.h"

#undef EXTERN
#ifdef ISOP25READER
#define EXTERN
#else
#define EXTERN extern
#endif

class Op25Reader {

	enum ItemType {
		FOLDER,
		BOOKMARK
	};

private:
	char noIEfavorites;	// 1:IÊCɓRo[gȂB 0:
	IbookmarkTree *writer;	// ݗpIuWFNg
	int isSilentMode;	// 1:t@CI[vsbZ[WȂ 0:
	TJsonValue *topValue;	// ǂݍ񂾃f[^

	// ꎞobt@
	char *scFile;
	char item[BUFLEN],*pItem;	// H3̒gۑ
	int cItem;				// item̕JEgp
	Bookmark bookmark;
	int f_item;
	int m_bookmarkNo;	// ǂݍłubN}[N̔ԍ

	char *urlBuf;	// URLϊpobt@
	int urlBufLen;
	char *valueBuf;	// lobt@
	char *work;		// ꎞpobt@
	char *valuePtr;	// lobt@̃|C^
	int valueCount;	// lobt@̕JE^
	bool ignoreToolbar;	// c[o[𖳎邩ǂ
	bool isUserRoot;	// }CtH_ǂH
	bool m_putTrash;	// ݔo͂邩ǂ

	int level;			// Kwx
	Logger *logger;
	std::set<std::string> *guidSet;	// GUIDi[set
	bool noUnSorted;

	int flushItem(Op25Reader::ItemType type);
	int setName(char *item, char *type);

	int readFile(const char *bmFile,const char *fvDir);
	int reallocUrlBuf(int size);

	// ǂݍJSOÑIuWFNgf
	int parseStart(void);
	int parseToplevel(TJsonValue *roots);
	int parseCustomRoot(TJsonValue *customRoot);
	int parseBar(TJsonValue *topObject);
	int parseFolder(TJsonValue *folderArray);
	int parseItem(TJsonValue *topObject);
	char *decodeAndRealloc(char *p);
	unsigned int countBar(TJsonValue *topObject);

public:
	char setIEfavoritesImport(char mode){	noIEfavorites = mode;return mode;}
	void setBookmarkWriter(IbookmarkTree *obj)
	{
		writer = obj;
	}
	Op25Reader();
	~Op25Reader();
	int readBookmark(const char *bmFile,const char *fvDir);
	void setSilentMode(int mode){	isSilentMode = mode;}
	int getBookmarkNo(void) { return m_bookmarkNo; }
	void setBookmarkNo(int no){	m_bookmarkNo = no;}
	void setIgnoreToolbar(bool flag) {
		ignoreToolbar = flag;
	}
	void setLogger(Logger *loggerObj) {
		logger = loggerObj;
	}

	/**
	 * GUIDi[psetݒ肷B
	 *
	 * @param value GUIDi[pset
	 */
	void setGuidSet(std::set<std::string> *value) {
		guidSet = value;
	}

	/**
	 * ݔo͂邩ǂ擾B
	 *
	 * @return true:ݔo͂ false:o͂Ȃ
	 */
	bool getTrashMode(void){
		return m_putTrash;
	}

	/**
	 * ݔo͂邩ǂݒ肷B
	 *
	 * @param mode true:ݔo͂ false:o͂Ȃ
	 * @return true:ݔo͂ false:o͂Ȃ
	 */
	bool setTrashMode(bool mode){
		m_putTrash = mode;
		return mode;
	}

	/**
	 * ̑̃ubN}[Nǂݍނǂ
	 *
	 * @return true:ǂ݂܂Ȃ fa;se:ǂݍ
	 */
	bool getNoUnSorted(void) {
		return noUnSorted;
	}

	/**
	 * ̑̃ubN}[Nǂݍނǂ
	 *
	 * @param true:ǂݍ܂Ȃ fa;se:ǂݍ
	 * @return true:ǂݍ܂Ȃ fa;se:ǂݍ
	 */
	bool setNoUnSorted(bool mode) {
		noUnSorted = mode;
		return noUnSorted;
	}
};

#undef EXTERN

#endif
