#define ISOP25READER

#include	<stdlib.h>
#include	<fstream>
#include	<iostream>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>

// BookSyncʃwb_
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"
#include	"TJson.h"

// vbgtH[wb_
#include	"Op25Reader.h"
#include	"IbookmarkTree.h"
#include	"..\core\messages.h"

#ifdef __BORLANDC__
#define	_stricmp stricmp
#endif

// int g_verbose = 0;

/**
 *	RXgN^
 */
Op25Reader::Op25Reader()
{
	noIEfavorites = 0;	// C|[gIÊCɓ΂Ȃ
	isSilentMode = 1;
	topValue = NULL;
	level = 0;
	ignoreToolbar = false;
	isUserRoot = false;
	m_putTrash = false;		// ݔo͂邩ǂ
	noUnSorted = false;


	urlBuf = NULL;
	writer = NULL;

	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
	urlBufLen = BUFLEN;

	try {
		valueBuf = new char[BUFLEN];
		if (valueBuf == NULL) {
			delete []urlBuf;
		}
		valuePtr = valueBuf;
	} catch (...) {
		if (valueBuf == NULL) {
			delete []urlBuf;
		}
	}

	// ꎞobt@mۂB
	work = NULL;
	try{
		work = new char[BUFLEN];
		if (work == NULL){
			delete []urlBuf;
			delete []valueBuf;
			return;
		}
	}catch(...){
		delete []urlBuf;
		delete []valueBuf;
		return;
	}

}

/**
 * fXgN^
 */
Op25Reader::~Op25Reader()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}

	if (valueBuf != NULL) {
		delete []valueBuf;
	}

	if (work != NULL) {
		delete []work;
	}

}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int Op25Reader::reallocUrlBuf(int size)
{
	delete []urlBuf;
	try {
		urlBuf = NULL;
		urlBuf = new char[size];
		if (urlBuf == NULL) {
			logger->debug("No enough memory");
			return -1;
		}
		urlBufLen = size;
	} catch (...) {
		logger->debug("No enough memory");
		return -1;
	}
	return size;
}


/**
 * bookmarkoB
 *
 * @param type ACe̎
 * @return 0  1 G[
 */
int Op25Reader::flushItem(Op25Reader::ItemType type)
{
	int result = 0;

	switch (type){
		case Op25Reader::BOOKMARK:	// Bookmark
			result = writer->storeItem(&bookmark);
		break;
		case Op25Reader::FOLDER:	// Folder
			result = writer->storeItem(&bookmark);
		break;
	}

	return result;
}

/**
 * ubN}[NEtH_ݒ肷B
 *
 * @param name ubN}[NEtH_
 */
int Op25Reader::setName(char *name, char *type)
{
	if (name == NULL) {
		logger->debug("Bookmark/Folder name is NULL.");
		return 1;
	}

	// ϊꂽO
	char *transfered = name;
	char buf[64];

	// }CtH_̖Oϊ
	if (!strcmp("folder", type)) {
		if (isUserRoot && (level == 1)) {
			// userRoot̍ŏ̊Kw̏ꍇ̂__t̖OϊB
			if (!strcmp("_reading_list_", name)) {
				strcpy(buf, mbtoUTF8Internal("[fBOXg"));
				transfered = buf;
			} else if (!strcmp("_videos_", name)) {
				strcpy(buf, mbtoUTF8Internal("rfI"));
				transfered = buf;
			} else if (!strcmp("_shopping_", name)) {
				strcpy(buf, mbtoUTF8Internal("VbsO"));
				transfered = buf;
			} else if (!strcmp("_travel_", name)) {
				strcpy(buf, mbtoUTF8Internal("gx"));
				transfered = buf;
			}
		}
	}

	// ubN}[N
	bookmark.setName(transfered);

	// O̐ݒ(}`oCg)
	char *p;
	p = UTF8tombFileNameInternal(transfered);

	// if (g_verbose) {
	//	std::cout << work << "\n" << std::flush;
	//}
	bookmark.setIeName(p);

	// O̐ݒ(Unicode)
	wchar_t *wp;
	wp = UTF8towcFileNameInternal(transfered);

	bookmark.setIeNameW(wp);

	return 0;
}

/*****************************
  ubN}[Nt@C͕
*****************************/

/* evfʂ̉߃W[ */


/**
 * ACẻ
 *
 * @param roots [gxIuWFNg("roots")
 * @return 0:́Eϊ 1:͎s
 */
int Op25Reader::parseItem(TJsonValue *item)
{
	int result = 0;
	bookmark.reset();
	bookmark.getOp25Bookmark(m_bookmarkNo)->reset();

	// IuWFNg̒g킷typeɊmFB
	TJsonValue *type = item->getObjectValue("type");
	if (type == NULL) {
		// type݂Ȃꍇ͕stH[}bgG[
		logger->debug("type not found");
		return 1;
	} else {
		if (type->getType() != TJsonValue::VALUE) {
			// typelłȂꍇ͕stH[}bgG[
			logger->debug("type is not value");
			return 1;
		} else if (type->getValue() == NULL) {
			// typeɒlĂȂꍇstH[}bgG[
			logger->debug("Value is not in value");
			return 1;
		}
	}

	// Ỏ
	char *typeValue = type->getValue();
	TJsonValue *name = item->getObjectValue("name");
	if (name != NULL) {
		if (name->getType() == TJsonValue::VALUE) {
			// name̒l
			setName(name->getValue(), typeValue);
		}
	}

	TJsonValue *date_added = item->getObjectValue("date_added");
	if (date_added != NULL) {
		if (date_added->getType() == TJsonValue::VALUE) {
			// date_added̒l
			if (date_added->getValue() != NULL) {
				logger->debug("date_added");
				logger->debug(date_added->getValue());
				bookmark.setAdddate(chTimeToTimet(date_added->getValue()));
			}
		}
	}

	TJsonValue *date_modified = item->getObjectValue("date_modified");
	if (date_modified != NULL) {
		if (date_modified->getType() == TJsonValue::VALUE) {
			// date_modified̒l
			if (date_modified->getValue() != NULL) {
				logger->debug("date_modified");
				logger->debug(date_modified->getValue());
				bookmark.setModified(chTimeToTimet(date_modified->getValue()));
			}
		}
	}

	TJsonValue *id = item->getObjectValue("id");
	if (id != NULL) {
		if (id->getType() == TJsonValue::VALUE) {
			// id̒l
			if (id->getValue() != NULL) {
				logger->debug("id");
				logger->debug(id->getValue());
				bookmark.getOp25Bookmark(m_bookmarkNo)->setID(id->getValue());
			}
		}
	}

	TJsonValue *transVer = item->getObjectValue("sync_transaction_version");
	if (transVer != NULL) {
		if (transVer->getType() == TJsonValue::VALUE) {
			// sync_transaction_version̒l
			if (transVer->getValue() != NULL) {
				logger->debug("sync_transaction_version");
				logger->debug(transVer->getValue());
				bookmark.getOp25Bookmark(m_bookmarkNo)->setSyncTransVer(transVer->getValue());
			}
		}
	}

	TJsonValue *metaInfo = item->getObjectValue("meta_info");
	if (metaInfo != NULL) {
		if (metaInfo->getType() == TJsonValue::OBJECT) {
			TJsonValue *customKeywords = metaInfo->getObjectValue(CUSTOM_KEYWORDS);
			if (customKeywords != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setCustomKeywords(customKeywords->getValue());
			}

			TJsonValue *shareData = metaInfo->getObjectValue("shareData");
			if (shareData != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setShareData(shareData->getValue());
			}

			TJsonValue *imageData = metaInfo->getObjectValue("imageData");
			if (imageData != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setImageData(imageData->getValue());
			}

			TJsonValue *imageIdentifier = metaInfo->getObjectValue("imageIdentifier");
			if (imageIdentifier != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setImageIdentifier(imageIdentifier->getValue());
			}

			TJsonValue *imageID = metaInfo->getObjectValue(IMAGEID);
			if (imageID != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setImageID(imageID->getValue());
			}

			TJsonValue *imageType = metaInfo->getObjectValue("imageType");
			if (imageType != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setImageType(atoi(imageType->getValue()));
			}

			TJsonValue *imageDataType = metaInfo->getObjectValue("imageDataType");
			if (imageDataType != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setImageDataType(atoi(imageDataType->getValue()));
			}

			TJsonValue *guid = metaInfo->getObjectValue(OPERA_GUID);
			if (guid != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setGuid(guid->getValue());
				guidSet->insert(guid->getValue());
			}

			TJsonValue *speedDialGuid = metaInfo->getObjectValue("speed_dial_root_folder_guid");
			if (speedDialGuid != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setSpeedDialGuid(speedDialGuid->getValue());
				guidSet->insert(speedDialGuid->getValue());
			}

			TJsonValue *favoriteGuid = metaInfo->getObjectValue(OP25_FAVORITE_GUID);
			if (favoriteGuid != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setFavoriteGuid(favoriteGuid->getValue());
				guidSet->insert(favoriteGuid->getValue());
			}

			TJsonValue *partnerID = metaInfo->getObjectValue(PARTNER_ID);
			if (partnerID != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setPartnerID(partnerID->getValue());
			}

			TJsonValue *partnerUrl = metaInfo->getObjectValue(PARTNER_URL);
			if (partnerUrl != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setPartnerUrl(partnerUrl->getValue());
			}

			TJsonValue *redirect = metaInfo->getObjectValue(REDIRECT);
			if (redirect != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setRedirect(redirect->getValue());
			}

			TJsonValue *itemIsListView = metaInfo->getObjectValue(ISLISTVIEW);
			if (itemIsListView != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setIsListView(itemIsListView->getValue());
			}

			TJsonValue *layoutMode = metaInfo->getObjectValue(LAYOUTMODE);
			if (layoutMode != NULL) {
				bookmark.getOp25Bookmark(m_bookmarkNo)->setLayoutMode(atoi(layoutMode->getValue()));
			}
		}
	}


	// type̒lŃubN}[NƃtH_𔻕ʂAŗL̏ǂݍށB
	if (!strcmp(typeValue,"url")) {
		TJsonValue *url = item->getObjectValue("url");
		if (url != NULL) {
			if (url->getType() == TJsonValue::VALUE) {
				// url̒l
				if (url->getValue() != NULL) {
					char *p = url->getValue();
					if (strncmp("javascript:", p,11) == 0) {
						// JavaScript(ubN}[Nbg)URLGR[hĂ̂
						// Ŏg߃fR[h
						p = decodeAndRealloc(p);
						if (p == NULL) {
							logger->debug("javascript: URL decode error");
							return 1;
						}
					} else if (strncmp("file:", p, 5) == 0) {
						// file([Jt@C)URLGR[hĂ̂
						// Ŏg߃fR[h
						p = decodeAndRealloc(p);
						if (p == NULL) {
							logger->debug("file: URL decode error");
							return 1;
						}
					}
					bookmark.setURL(p);
				}
			}
		}
		// ubN}[NoB
		bookmark.setItemType(Bookmark::bookmark);
		flushItem(Op25Reader::BOOKMARK);

		bookmark.reset();
		bookmark.getOp25Bookmark(m_bookmarkNo)->reset();

	} else if (!strcmp(typeValue, "folder")) {
		// type:folderƑgƂȂchildrenz(tH_)̑݃`FbNsB
		TJsonValue *children = item->getObjectValue("children");
		if (children == NULL) {
			// childrenIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("Folder's children not found");
			return 1;
		}else{
			if (children->getType() != TJsonValue::ARRAY) {
				// childrenzłȂꍇ͕stH[}bgG[
				logger->debug("Folder's children is not array");
				return 1;
			} else {
				// tH_oB
				bookmark.setItemType(Bookmark::folder);
				bookmark.setFolderType(Bookmark::normalFolder);
				bookmark.getOp25Bookmark(m_bookmarkNo)->setFolderType(Op25Bookmark::normalFolder);

				flushItem(Op25Reader::FOLDER);
				bookmark.reset();
				bookmark.getOp25Bookmark(m_bookmarkNo)->reset();

				// childrenIuWFNg̉͂ɓ
				result = parseFolder(children);
			}
		}
	} else {
		// tH_AubN}[NȊÔ͍Ƃ둶݂Ȃ̂ŃG[
		logger->debug("Unknown item type");
		return 1;
	}
	return result;
}

/**
 * URLGR[h̃fR[hƍĊmۂsB
 *
 * @param p fR[hsURL
 * @return NULL:fR[h NULL:fR[hs
 */
char *Op25Reader::decodeAndRealloc(char *p)
{
	int count = decodeURL(NULL, p);
	if ((count + 1) > urlBufLen) {
		int result = reallocUrlBuf(count + 2);
		if (result == -1) {
			return NULL;
		}
	}
	decodeURL(urlBuf, p);
	return urlBuf;
}

/**
 * tH_̉
 *
 * @param folderArray tH_̔z
 * @return 0:́Eϊ 1:͎s
 */
int Op25Reader::parseFolder(TJsonValue *folderArray)
{
	int result = 0;
	unsigned int count = folderArray->getArrayCount();

	level++;
	for (unsigned int i = 0;i < count;i++) {
		// 
		TJsonValue *item = folderArray->getArrayValue(i);
		if (item == NULL) {
			// itemIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("Folder's item not found");
			return 1;
		}else{
			if (item->getType() != TJsonValue::OBJECT) {
				// itemIuWFNgłȂꍇ͕stH[}bgG[
				logger->debug("Folder's item is not object");
				return 1;
			} else {
				// itemIuWFNg̉͂ɓ
				result = parseItem(item);
			}
		}
	}
	// KwЂƂオB
	writer->upFolder();
	level--;
	return result;	
}

/**
 * ubN}[No[Ȃ̃ubN}[Ñgbv̉
 *
 * @param topObject ubN}[No[Ȇ̃ubN}[ÑIuWFNg
 * @return 0:́Eϊ 1:͎s
 */
int Op25Reader::parseBar(TJsonValue *topObject)
{
	int result = 0;	// ͌

	// ԍŏ̔z(tH_)̑݃`FbNsB
	TJsonValue *children = topObject->getObjectValue("children");
	if (children == NULL) {
		// childrenIuWFNg݂Ȃꍇ͕stH[}bgG[
		logger->debug("Bookmark bar folder's item not found");
		return 1;
	}else{
		if (children->getType() != TJsonValue::ARRAY) {
			// childrenIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("Bookmark bar folder is not array");
			return 1;
		} else {
			// childrenIuWFNg̉͂ɓ
			result = parseFolder(children);
		}
	}
	return result;
}

/**
 * ubN}[No[Ȃ̃ubN}[Ñgbv̉
 *
 * @param topObject ubN}[No[Ȇ̃ubN}[ÑIuWFNg
 * @return 0:́Eϊ 1:͎s
 */
unsigned int Op25Reader::countBar(TJsonValue *topObject)
{
	int result = 0;	// ͌

	// ԍŏ̔z(tH_)̑݃`FbNsB
	TJsonValue *children = topObject->getObjectValue("children");
	if (children == NULL) {
		// childrenIuWFNg݂Ȃꍇ͕stH[}bgG[
		logger->debug("Item not found");
		return 0;
	} else{
		if (children->getType() != TJsonValue::ARRAY) {
			// childrenIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("Item is not array");
			return 0;
		}
	}
	return children->getArrayCount();

}


/**
 * ubN}[No[Ȃ̃ubN}[N
 *
 * @param roots [gxIuWFNg("roots")
 * @return 0:́Eϊ 1:͎s
 */
int Op25Reader::parseToplevel(TJsonValue *roots)
{
	int result = 0;	// ͌

	if (ignoreToolbar == false) {
		// bookmark_bar(ubN}[No[)
		TJsonValue *bookmark_bar = roots->getObjectValue("bookmark_bar");
		if (bookmark_bar == NULL) {
			// bookmark_barIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("Bookmark bar not found");
			return 1;
		}else{
			if (bookmark_bar->getType() != TJsonValue::OBJECT) {
				// bookmark_barIuWFNgłȂꍇ͕stH[}bgG[
				logger->debug("Bookmark bar is not boject");
				return 1;
			} else {
				bookmark.reset();
				bookmark.getOp25Bookmark(m_bookmarkNo)->reset();
				level = 0;

				bookmark.setItemType(Bookmark::folder);

				bookmark.setFolderType(Bookmark::toolBar);
				char *p;
				p = wctoUTF8Internal(L"ubN}[N o[");
				if (p != NULL) {
					bookmark.setName(p);
				}
				bookmark.setIeName("ubN}[N o[");
				bookmark.setIeNameW(L"ubN}[N o[");

				flushItem(Op25Reader::FOLDER);
				// bookmark_barIuWFNg̉͂ɓ
				result = parseBar(bookmark_bar);
			}
		}
		if (result) {
			// ͎s炻̎_Ŕ
			return result;
		}
	}

	// custom_root
	TJsonValue *customRoot = roots->getObjectValue("custom_root");
	if (customRoot == NULL) {
		// otherIuWFNg݂Ȃꍇ͕stH[}bgG[
		logger->debug("custom_root not found");
		return 1;
	} else {
		result = parseCustomRoot(customRoot);
	}

	// other(C|[gꂽubN}[Nj[)
	TJsonValue *other = roots->getObjectValue("other");
	if (other == NULL) {
		// otherIuWFNg݂Ȃꍇ͕stH[}bgG[
		logger->debug("Other bookmark not found");
		return 1;
	}else{
		if (other->getType() != TJsonValue::OBJECT) {
			// otherIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("Other bookmark is not object");
			return 1;
		} else {
			// C|[gꂽubN}[Nꍇ̂݉͂sB
			// łȂƁAuEUɃC|[gꂽubN}[Nô͖fB
			unsigned int itemCount = countBar(other);

			if (itemCount > 0) {
				writer->upToBookmarkMenu();

				bookmark.reset();
				bookmark.getOp25Bookmark(m_bookmarkNo)->reset();
				level = 1;

				bookmark.setItemType(Bookmark::folder);

				// Opera 26̓C|[gubN}[Nɓ̂
				// Chromê̑̃ubN}[NƓɂB
				bookmark.setFolderType(Bookmark::normalFolder);
				bookmark.getOp25Bookmark(0)->setFolderType(Op25Bookmark::imported);
				bookmark.getOp25Bookmark(1)->setFolderType(Op25Bookmark::imported);
				char *p;
				p = wctoUTF8Internal(L"C|[gꂽubN}[N");
				if (p != NULL) {
					bookmark.setName(p);
				}
				bookmark.setIeName("C|[gꂽubN}[N");
				bookmark.setIeNameW(L"C|[gꂽubN}[N");
				flushItem(Op25Reader::FOLDER);

				// otherIuWFNg̉͂ɓ
				level = 2;
				result = parseBar(other);
			}
		}
	}

	// oC̃ubN}[N
	// Opera 25̃ubN}[N̏ꍇ
	// gĂȂ̂łȂɂȂB
#if 0
	TJsonValue *synced = roots->getObjectValue("synced");
	if (synced != NULL) {
		if (synced->getType() != TJsonValue::OBJECT) {
			// syncedIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("synced bookmark is not object");
			return 1;
		} else {
			bookmark.reset();
			bookmark.getOp25Bookmark(m_bookmarkNo)->reset();
			level = 0;

			bookmark.setItemType(Bookmark::folder);
			bookmark.setFolderType(Bookmark::mobile);
			char *p;
			p = wctoUTF8Internal(L"oC̃ubN}[N");
			if (p != NULL) {
				bookmark.setName(p);
			}
			bookmark.setIeName("oC̃ubN}[N");
			bookmark.setIeNameW(L"oC̃ubN}[N");
			flushItem(Op25Reader::FOLDER);
				
			// syncedIuWFNg̉͂ɓ
			result = parseBar(synced);
		}
	}
#endif

	return result;
}

/**
 * custom_root
 *
 * @param customRoot custom_rootIuWFNg("custom_root")
 * @return 0:́Eϊ 1:͎s
 */
int Op25Reader::parseCustomRoot(TJsonValue *customRoot)
{
	int result = 0;

	if (customRoot->getType() != TJsonValue::OBJECT) {
		// otherIuWFNgłȂꍇ͕stH[}bgG[
		logger->debug("custom_root is not object");
		return 1;
	}
	// ̃ubN}[N(Opera 25)
	TJsonValue *unsorted = customRoot->getObjectValue("unsorted");
	if ((unsorted != NULL) && (!noUnSorted)){
		bookmark.reset();
		bookmark.getOp25Bookmark(m_bookmarkNo)->reset();
		writer->upToTop();
		level = 0;

		bookmark.setItemType(Bookmark::folder);
		bookmark.getOp25Bookmark(0)->setFolderType(Op25Bookmark::unsorted);
		bookmark.getOp25Bookmark(1)->setFolderType(Op25Bookmark::unsorted);

		// Firefox̂̑̃ubN}[NƓɂB
		bookmark.setFolderType(Bookmark::unFiled);
		char *p;
		p = wctoUTF8Internal(L"̃ubN}[N");
		if (p != NULL) {
			bookmark.setName(p);
		}
		bookmark.setIeName("̃ubN}[N");
		bookmark.setIeNameW(L"̃ubN}[N");
		flushItem(Op25Reader::FOLDER);
			
		// otherIuWFNg̉͂ɓ
		result = parseBar(unsorted);
	}

	// }CtH_(Opera 25)
	TJsonValue *userRoot = customRoot->getObjectValue("userRoot");
	if (userRoot != NULL) {
		bookmark.reset();
		bookmark.getOp25Bookmark(m_bookmarkNo)->reset();
		writer->upToTop();
		level = 0;

		bookmark.setItemType(Bookmark::folder);

		// Chromê̑̃ubN}[NƓɂB
		bookmark.setFolderType(Bookmark::menuBar);
		char *p;
		p = wctoUTF8Internal(L"}CtH_");
		if (p != NULL) {
			bookmark.setName(p);
		}
		bookmark.setIeName("}CtH_");
		bookmark.setIeNameW(L"}CtH_");
		flushItem(Op25Reader::FOLDER);

		/*
		// j[ɍ킹ă}CtH_ꍇ̓tH_邱ƂɂȂ邪A
		// ̃uEUɂĂƈâŃtH_ȂB
		bookmark.reset();
		bookmark.setItemType(Bookmark::folder);
		bookmark.setFolderType(Bookmark::normalFolder);
		bookmark.getOp25Bookmark(0)->setFolderType(Op25Bookmark::myFolder);
		bookmark.getOp25Bookmark(1)->setFolderType(Op25Bookmark::myFolder);

		p = wctoUTF8Internal(L"}CtH_");
		if (p != NULL) {
			bookmark.setName(p);
		}
		bookmark.setIeName("}CtH_");
		bookmark.setIeNameW(L"}CtH_");
		flushItem(Op25Reader::FOLDER);
		*/

		// }CtH_̉͂ɓ
		isUserRoot = true;
		result = parseBar(userRoot);
		isUserRoot = false;
	}

	// LACe(Opera 26)
	TJsonValue *shared = customRoot->getObjectValue("shared");
	if (shared != NULL) {
		writer->upToBookmarkMenu();
		level = 1;
		
		// LACeꍇ̂݉͂sB
		// łȂƁAuEUɋLACeô͖fB
		unsigned int itemCount = countBar(shared);

		if (itemCount > 0) {

			bookmark.reset();
			bookmark.getOp25Bookmark(m_bookmarkNo)->reset();

			// ubN}[Nj[̒ɐpɃtH_邱ƂɂB
			bookmark.setItemType(Bookmark::folder);
			bookmark.getOp25Bookmark(0)->setFolderType(Op25Bookmark::shared);
			bookmark.getOp25Bookmark(1)->setFolderType(Op25Bookmark::shared);

			bookmark.setFolderType(Bookmark::normalFolder);
			char *p;
			p = wctoUTF8Internal(L"LACe");
			if (p != NULL) {
				bookmark.setName(p);
			}
			bookmark.setIeName("LACe");
			bookmark.setIeNameW(L"LACe");
			flushItem(Op25Reader::FOLDER);

			// LACẻ͂ɓ
			result = parseBar(shared);
		}
	}

	// ݔ(Opera 30)
	if (m_putTrash) {
		// ݔo͂ꍇ̂ݓǂݍ݂sB
		TJsonValue *trash = customRoot->getObjectValue(OP25_TRASH);
		if (trash != NULL) {
			writer->upToBookmarkMenu();
			level = 1;

			// S~ꍇ̂݉͂sB
			// łȂƁAuEUɋLACeô͖fB
			unsigned int itemCount = countBar(trash);

			if (itemCount > 0) {

				bookmark.reset();
				bookmark.getOp25Bookmark(m_bookmarkNo)->reset();

				// ubN}[Nj[̒ɐpɃtH_邱ƂɂB
				bookmark.setItemType(Bookmark::folder);
				bookmark.getOp25Bookmark(0)->setFolderType(Op25Bookmark::trash);
				bookmark.getOp25Bookmark(1)->setFolderType(Op25Bookmark::trash);

				bookmark.setFolderType(Bookmark::normalFolder);
				char *p;
				p = wctoUTF8Internal(L"ݔ");
				if (p != NULL) {
					bookmark.setName(p);
				}
				bookmark.setIeName("ݔ");
				bookmark.setIeNameW(L"ݔ");
				flushItem(Op25Reader::FOLDER);

				// ݔ̉͂ɓ
				result = parseBar(trash);
			}
		}
	}

	// Xs[h_C(Opera 29)
	TJsonValue *speedDial = customRoot->getObjectValue("speedDial");
	if (speedDial != NULL) {
		writer->upToBookmarkMenu();
		level = 1;

		// Xs[h_Cꍇ̂݉͂sB
		// łȂƁAuEUɃXs[h_Cô͖fB
		unsigned int itemCount = countBar(speedDial);

		if (itemCount > 0) {
			bookmark.reset();
			bookmark.getOp25Bookmark(m_bookmarkNo)->reset();

			// ubN}[Nj[̒ɐpɃtH_邱ƂɂB
			bookmark.setItemType(Bookmark::folder);
			bookmark.getOp25Bookmark(0)->setFolderType(Op25Bookmark::speedDial);
			bookmark.getOp25Bookmark(1)->setFolderType(Op25Bookmark::speedDial);

			bookmark.setFolderType(Bookmark::normalFolder);
			char *p;
			p = wctoUTF8Internal(L"Xs[h_C");
			if (p != NULL) {
				bookmark.setName(p);
			}
			bookmark.setIeName("Xs[h_C");
			bookmark.setIeNameW(L"Xs[h_C");
			flushItem(Op25Reader::FOLDER);

			// Xs[h_C̉͂ɓ
			result = parseBar(speedDial);
		}
	}

	return result;
}

/**
 * ubN}[N͊Jn
 *
 * @return 0:́Eϊ 1:͎s
 */
int Op25Reader::parseStart(void)
{
	int result = 0;	// ͌

	if (topValue->getType() != TJsonValue::OBJECT) {
		// gbvIuWFNg̓IuWFNgłKvB
		logger->debug("Top level object is not object");
		return 1;
	} else {
#if 0
		// ubN}[Ño[W`FbNȂ̂A
		// 2009/03/01iKł͂܂PȂ̂ŏ璷Ȃ̂ŏsȂB
		TJsonValue *ver = topValue->getObjectValue("version");
		if (ver == NULL) {
			// versionȂꍇ͕sȃtH[}bgȂ̂ŃG[
			return 1;
		}else{
			if (ver->getType() != TJsonValue::VALUE) {
				// lłȂꍇ͕sȃtH[}bgȂ̂ŃG[
				return 1;
			} else {
				char *value = ver->getValue();
				if (value == NULL) {
					// version̒lǂ߂ĂȂ̂ŃG[
					return 1;
				} else {
					// version̒lɂďςKvꍇ
					// Ńo[W`FbN
				}
			}
		}
#endif

		TJsonValue *roots = topValue->getObjectValue("roots");
		if (roots == NULL) {
			// rootsIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("roots object not found");
			return 1;
		}else{
			if (roots->getType() != TJsonValue::OBJECT) {
				// rootsIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("roots object is not object");
				return 1;
			} else {
				// rootsIuWFNg̉͂ɓ
				result = parseToplevel(roots);
			}
		}

	}
	return result;
}

/**
 * ubN}[Nǂݍݕ
 *
 * @param bmFile ubN}[Nt@C
 * @param fvDir uCɓvfBNg
 *
 * @return 0:ǂݍ݁ERo[g 1:ǂݍ݁ERo[gs
 */
int Op25Reader::readFile(const char *bmFile,const char *fvDir)
{
	int ret = 0;	// s
	TJson *reader = NULL;
	try {
		reader = new TJson();
		if (reader == NULL) {
			return 1;
		}
	} catch(...) {
		return 1;
	}
	ret = reader->readFile(bmFile);
	if (ret) {
		// sƂƂƔ
		logger->debug("JSON read error");
		delete reader;
		return 1;
	}
	topValue = reader->getTopValue();
	// ǂݍJSON̉͂JnB
	ret = parseStart();

	delete reader;

	return ret;
}

/**
 * ͂JnBmۂB
 *
 * @param bmFile ubN}[Nt@C
 * @param fvDir gp
 * @return 0: 0:s
 */
int Op25Reader::readBookmark(const char *bmFile,const char *fvDir)
{
	int ret;

	ret = readFile(bmFile,fvDir);

	return ret;
}

