#ifndef OP25BOOKMARK_H
#define OP25BOOKMARK_H

// Wwb_
#include	<stdio.h>

#define IMAGEID				"imageID"
#define CUSTOM_KEYWORDS		"custom_keywords"
#define OPERA_GUID			"guid"
#define PARTNER_ID			"partner_id"
#define PARTNER_URL			"partner_url"
#define REDIRECT			"redirect"
#define ISLISTVIEW			"isListView"
#define OP25_TRASH			"trash"
#define OP25_FAVORITE_GUID	"opera_favorite_guid"
#define LAYOUTMODE			"layoutMode"

class Op25Bookmark {
public:
	enum FolderType
	{
		normalFolder,	// ()tH_
		myFolder,	// }CtH_
		shared,		// LubN}[NtH_
		unsorted,	// ̃ubN}[N
		imported,	// C|[gꂽubN}[N
		speedDial,	// Xs[h_C
		trash		// S~
	};

private:
	char *m_id;	// ID
	char *m_shareData;
	char *m_imageData;
	char *m_imageIdentifier;	// imageIdentifier
	char *m_imageID;		// imageID
	int m_imageType;		// imageType
	int m_imageDataType;	// imageDataType
	FolderType m_folderType;	// tH_̎
	char *m_syncTransVer;	// sync_transaction_version
	char *m_guid;			// guid
	char *m_speedDialGuid;	// speed_dial_root_folder_guid
	char *m_favoriteGuid;	// opera_favorite_guid
	char *m_customKeywords;	// custom_keywords
	char *m_partnerID;		// partner_id
	char *m_partnerUrl;		// partner_url
	char *m_redirect;		// redirect
	char *m_isListView;		// isListView
	int m_layoutMode;		// layoutMode

	void _init(void);
	void _reset(void);
	char *_allocate(char *&pointer, const char *item);

protected:
	void _copy(const Op25Bookmark &src);
	void copy(const Op25Bookmark &src);

public:
	/* EʁEj */
	Op25Bookmark(void);
	Op25Bookmark(const Op25Bookmark &src);
	virtual ~Op25Bookmark();

	Op25Bookmark & operator = (const Op25Bookmark &src);
	void copyWithoutId(Op25Bookmark *src);
	int copyBookmarkIdentifier(Op25Bookmark *src);

	void reset(void);

	char *getID(void) const { return m_id; };
	char *setID(const char *item);

	FolderType getFolderType(void) const {
		return m_folderType;
	}
	void setFolderType(const FolderType type) {
		m_folderType = type;
	}

	char *getShareData(void) const { return m_shareData; };
	char *setShareData(const char *item);

	char *getImageData(void) const { return m_imageData; };
	char *setImageData(const char *item);

	char *getImageIdentifier(void) const { return m_imageIdentifier; };
	char *setImageIdentifier(const char *item);

	char *getImageID(void) const { return m_imageID; };
	char *setImageID(const char *item);

	int getImageType(void) const { return m_imageType; };
	int setImageType(const int type) {
		m_imageType = type;
		return type;
	}

	int getImageDataType(void) const { return m_imageDataType; };
	int setImageDataType(const int type) {
		m_imageDataType = type;
		return type;
	}

	char *getSyncTransVer(void) const { return m_syncTransVer; };
	char *setSyncTransVer(const char *item);

	char *getGuid(void) const { return m_guid; };
	char *setGuid(const char *item);

	char *getSpeedDialGuid(void) const { return m_speedDialGuid; };
	char *setSpeedDialGuid(const char *item);

	char *getCustomKeywords(void) const { return m_customKeywords; };
	char *setCustomKeywords(const char *item) {
		return _allocate(m_customKeywords, item);
	}
	
	char *getPartnerID(void) const { return m_partnerID; };
	char *setPartnerID(const char *item) {
		return _allocate(m_partnerID, item);
	}

	char *getPartnerUrl(void) const { return m_partnerUrl; };
	char *setPartnerUrl(const char *item) {
		return _allocate(m_partnerUrl, item);
	}

	char *getRedirect(void) const { return m_redirect; };
	char *setRedirect(const char *item) {
		return _allocate(m_redirect, item);
	}

	char *getIsListView(void) const { return m_isListView; };
	char *setIsListView(const char *item) {
		return _allocate(m_isListView, item);
	}

	char *getFavoriteGuid(void) const { return m_favoriteGuid; };
	char *setFavoriteGuid(const char *item) {
		return _allocate(m_favoriteGuid, item);
	}

	int getLayoutMode(void) const { return m_layoutMode; };
	int setLayoutMode(const int type) {
		m_layoutMode = type;
		return type;
	}

};

#endif	// OP25BOOKMARK_H
