#include	<stdlib.h>
#include	<new>
#include	<memory>

#include	<stdio.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"encutil2.h"
#include	"Bookmark.h"
#include	"Op25Bookmark.h"

#ifdef _DEBUG
#define debugprintf //printf
#else
#define debugprintf
#endif

/**
 * RXgN^
 */
Op25Bookmark::Op25Bookmark()
{
	_init();
}

/**
 * Rs[RXgN^
 *
 * @param src Rs[̃IuWFNg
 */
Op25Bookmark::Op25Bookmark(const Op25Bookmark &src)
{
	_init();
	_copy(src);
}

/**
 * fXgN^
 */
Op25Bookmark::~Op25Bookmark()
{
	_reset();
}

/**
 *	CX^X̓eɏlB<br>
 *	RXgN^p
 *
 */
void Op25Bookmark::_init(void)
{
	m_id = NULL;
	m_folderType = Op25Bookmark::normalFolder;

	m_shareData = NULL;
	m_imageData = NULL;
	m_imageIdentifier = NULL;
	m_imageID = NULL;
	m_imageType = 0;
	m_imageDataType = 0;
	m_syncTransVer = NULL;
	m_guid = NULL;
	m_speedDialGuid = NULL;
	m_customKeywords = NULL;
	m_partnerID = NULL;		// partner_id
	m_partnerUrl = NULL;	// partner_url
	m_redirect = NULL;		// redirect
	m_isListView = NULL;
	m_favoriteGuid = NULL;
	m_layoutMode = 0;
}

/**
 * CX^X̓eĐݒ肷B(Jt)
 */
void Op25Bookmark::_reset(void)
{
	if (m_id != NULL) {
		delete []m_id;
		m_id = NULL;
	}
	if (m_shareData != NULL) {
		delete[]m_shareData;
		m_shareData = NULL;
	}
	if (m_imageData != NULL) {
		delete[]m_imageData;
		m_imageData = NULL;
	}
	if (m_imageIdentifier != NULL) {
		delete[]m_imageIdentifier;
		m_imageIdentifier = NULL;
	}
	if (m_imageID != NULL) {
		delete[]m_imageID;
		m_imageID = NULL;
	}
	if (m_syncTransVer != NULL) {
		delete[]m_syncTransVer;
		m_syncTransVer = NULL;
	}
	if (m_guid != NULL) {
		delete[]m_guid;
		m_guid = NULL;
	}
	if (m_speedDialGuid != NULL) {
		delete[]m_speedDialGuid;
		m_speedDialGuid = NULL;
	}
	if (m_customKeywords != NULL) {
		delete[]m_customKeywords;
		m_customKeywords = NULL;
	}
	if (m_partnerID != NULL) {
		delete[]m_partnerID;
	}
	if (m_partnerUrl != NULL) {
		delete[]m_partnerUrl;
	}
	if (m_redirect != NULL) {
		delete[]m_redirect;
	}
	if (m_isListView != NULL) {
		delete[]m_isListView;
	}
	if (m_favoriteGuid != NULL) {
		delete[]m_favoriteGuid;
	}
	_init();
}

/**
 * CX^X̃Rs[(ubN}[Nʏ)
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 */
void Op25Bookmark::_copy(const Op25Bookmark &src)
{
	setFolderType(src.getFolderType());
	setShareData(src.getShareData());
	setImageData(src.getImageData());
	setImageIdentifier(src.getImageIdentifier());
	setImageID(src.getImageID());
	setImageType(src.getImageType());
	setImageDataType(src.getImageDataType());
	setCustomKeywords(src.getCustomKeywords());
	setSpeedDialGuid(src.getSpeedDialGuid());
	setPartnerID(src.getPartnerID());
	setPartnerUrl(src.getPartnerUrl());
	setRedirect(src.getRedirect());
	setIsListView(src.getIsListView());
	setLayoutMode(src.getLayoutMode());
}

/**
 * CX^XŜ̓eB
 */
void Op25Bookmark::reset(void)
{
	_reset();
}

/**
 * CX^X̃Rs[(ubN}[Nʏ)
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 */
void Op25Bookmark::copy(const Op25Bookmark &src)
{
	_copy(src);
}

/**
 * =ZqɂCX^X̃Rs[(ubN}[Nʏ܂)
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 * @return g̎Q
 */
Op25Bookmark & Op25Bookmark::operator = (const Op25Bookmark &src)
{
	reset();
	copy(src);
	setID(src.getID());
	setSyncTransVer(src.getSyncTransVer());
	setGuid(src.getGuid());
	setFavoriteGuid(src.getFavoriteGuid());

	return *this;
}

/**
* ubN}[NRs[(ubN}[Nʗp)
*
* @param src ʌBookmarkNX̃CX^Xւ̃|C^
* @return 0Œ
*/
void Op25Bookmark::copyWithoutId(Op25Bookmark *src)
{
	copy(*src);
}

/**
 * ubN}[N̎ʏRs[
 *
 * @param src ʌBookmarkNX̃CX^Xւ̃|C^
 * @return 0Œ
 */
int Op25Bookmark::copyBookmarkIdentifier(Op25Bookmark *src)
{
	if (src->getID() != NULL) {
		setID(src->getID());
	}

	if (src->getSyncTransVer() != NULL) {
		setSyncTransVer(src->getSyncTransVer());
	}

	if (src->getGuid() != NULL) {
		setGuid(src->getGuid());
	}

	if (src->getSpeedDialGuid() != NULL) {
		setSpeedDialGuid(src->getSpeedDialGuid());
	}

	if (src->getFavoriteGuid() != NULL) {
		setFavoriteGuid(src->getFavoriteGuid());
	}

	return 0;
}


/**
 * IDݒ肷B
 *
 * @param item ݒ肷ID
 * @return ݒ肵IDւ̃|C^
 */
char *Op25Bookmark::setID(const char *item)
{
	char *p;
	int len;
	
	if (m_id != NULL){
		delete []m_id;
		m_id = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_id = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * shareDataݒ肷B
 *
 * @param item ݒ肷shareData
 * @return ݒ肵shareDataւ̃|C^
 */
char *Op25Bookmark::setShareData(const char *item)
{
	char *p;
	int len;

	if (m_shareData != NULL){
		delete[]m_shareData;
		m_shareData = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p, item);
		m_shareData = p;
	}
	catch (...){
		return NULL;
	}
	return p;
}

/**
 * imageDataݒ肷B
 *
 * @param item ݒ肷imageData
 * @return ݒ肵imageDataւ̃|C^
 */
char *Op25Bookmark::setImageData(const char *item)
{
	char *p;
	int len;

	if (m_imageData != NULL){
		delete[]m_imageData;
		m_imageData = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p, item);
		m_imageData = p;
	}
	catch (...){
		return NULL;
	}
	return p;
}

/**
 * imageIdentifierݒ肷B
 *
 * @param item ݒ肷imageIdentifier
 * @return ݒ肵imageIdentifierւ̃|C^
 */
char *Op25Bookmark::setImageIdentifier(const char *item)
{
	char *p;
	int len;

	if (m_imageIdentifier != NULL){
		delete[]m_imageIdentifier;
		m_imageIdentifier = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p, item);
		m_imageIdentifier = p;
	}
	catch (...){
		return NULL;
	}
	return p;
}

/**
* imageIDݒ肷B(A킵)
*
* @param item ݒ肷imageID
* @return ݒ肵imageIDւ̃|C^
*/
char *Op25Bookmark::setImageID(const char *item)
{
	char *p;
	int len;

	if (m_imageID != NULL){
		delete[]m_imageID;
		m_imageID = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p, item);
		m_imageID = p;
	}
	catch (...){
		return NULL;
	}
	return p;
}

/**
 * sync_transaction_versionݒ肷B
 *
 * @param item ݒ肷sync_transaction_version
 * @return ݒ肵sync_transaction_versionւ̃|C^
 */
char *Op25Bookmark::setSyncTransVer(const char *item)
{
	char *p;
	int len;

	if (m_syncTransVer != NULL){
		delete[]m_syncTransVer;
		m_syncTransVer = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p, item);
		m_syncTransVer = p;
	}
	catch (...){
		return NULL;
	}
	return p;
}

/**
 * guidݒ肷B
 *
 * @param item ݒ肷guid
 * @return ݒ肵guidւ̃|C^
 */
char *Op25Bookmark::setGuid(const char *item)
{
	char *p;
	int len;

	if (m_guid != NULL){
		delete[]m_guid;
		m_guid = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p, item);
		m_guid = p;
	}
	catch (...){
		return NULL;
	}
	return p;
}

/**
 * speed_dial_root_folder_guidݒ肷B
 *
 * @param item ݒ肷speed_dial_root_folder_guid
 * @return ݒ肵speed_dial_root_folder_guidւ̃|C^
 */
char *Op25Bookmark::setSpeedDialGuid(const char *item)
{
	char *p;
	int len;

	if (m_speedDialGuid != NULL){
		delete[]m_speedDialGuid;
		m_speedDialGuid = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p, item);
		m_speedDialGuid = p;
	}
	catch (...){
		return NULL;
	}
	return p;
}

/**
 * ̃̕ubNJĐṼubNݒ肷B
 *
 * @param pointer li[|C^
 * @param item ݒ肷l
 * @return ݒ肵lւ̃|C^
 */
char *Op25Bookmark::_allocate(char *&pointer, const char *item)
{
	char *p;
	int len;

	if (pointer != NULL){
		delete[]pointer;
		pointer = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p, item);
		pointer = p;
	}
	catch (...){
		return NULL;
	}
	return p;
}
