#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NTfunction.h"
#include	"Bookmark.h"
#include	"url.h"

#include	"Op15Writer.h"

/**
 * RXgN^
 */
Op15Writer::Op15Writer(void)
{
	db = NULL;
	inTransaction = false;
	enableWrite = true;

	level = 0;
	ignoreLevel = -1;
	maxId = 3;	// ID=3̓^Õ[g
	// ŏ̊Kw̐eID1(SubN}[Ñ[g)
	parent.push_back("");
	// ŏ̊Kw̕я
	order.push_back(0);

	putIEToolbar = true;
	doOptimize = false;
	// tH_̒ɃtH_邩ǂ̐ݒ肾A
	// tH_̒ɃtH_Ȃ̂ŃRgAEgB
	// Opera 15ł̑OOpera Nexẗꎞ̊Ԃ͍ꂽ̂B
	// inFolder = false;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN * 2];
	} catch (...) {
	}
}

/**
 * fXgN^<br>
 * ŁAKf[^x[XN[Y悤ɂB
 *
 */
Op15Writer::~Op15Writer()
{
	// gUNVĂꍇ̓gUNV[obNB
	if (!inTransaction) {
		rollback();
	}

	// f[^x[XN[YB
	if (db != NULL){
		sqlite3_close(db);
		db = NULL;
	}

	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * DB̃t@CZbgDBgp\ɂB
 *
 * @param name t@C
 * @return 0:DBI[v 1:DBI[vɎs
 */
int Op15Writer::setDBfileName(const char *name)
{
	int rc;

	dbFile = name;
	char *p = mbtoUTF8Internal(const_cast<char *>(name));
	if (p == NULL) {
		return 1;
	}

	// DBt@CI[v
	rc = sqlite3_open(p, &db);
	if (rc){
		fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
		sqlite3_close(db);
		db = NULL;
		return 1;
	}

	return 0;
}

/**
 * tH_}B
 *
 * @param item }ubN}[N
 * @return -1:}s 0:}
 */
std::string Op15Writer::insertOp15Folder(Bookmark *item)
{
	char *sql;
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	char guid[40];
	std::string guidStr;

	sql = "insert into favorites (guid,idx,name,type,parent_guid)"
		" values (?,?,?,1,?);";

	// ܂́AGUID擾B
	createUUID(guid);
	guidStr = guid;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putFolder\n");
		return "";
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// guid
	rc = sqlite3_bind_text(statement, 1, guid , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return "";
	}

	// idx
	rc = sqlite3_bind_int(statement, 2, order[level]);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return "";
	}

	// name
	wchar_t *filenameW = item->getIeNameW();
	char *utf8 = wctoUTF8Internal(filenameW);

	rc = sqlite3_bind_text(statement, 3, utf8 , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return "";
	}

	if (level > 0) {
		// parent_guid
		rc = sqlite3_bind_text(statement, 4, parent[level].c_str() , -1, SQLITE_STATIC);
		if ( rc != SQLITE_OK ){
			sqlite3_finalize(statement);
			return "";
		}
	}


	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return guidStr;
}

/**
 * ubN}[N}B
 *
 * @param item }ubN}[N
 * @return -1:}s >-1:}ubN}[Nmoz_bookmarksID
 */
sqlite_int64 Op15Writer::insertOp15Bookmark(Bookmark *item)
{
	char *sql;
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	char *url;
	sqlite3_stmt *statement;
	int rc;
	char guid[40];
	int realLevel;

	sql = "insert into favorites (guid,idx,name,url,type,parent_guid)"
				" values (?,?,?,?,0,?);";

	// tH_̒ɃtH_΂Aif͂Ȃ̂A
	// tH_̒ɃtH_Ȃ̂ŃgbvxłȂꍇ͕K1Kw
	// if (!inFolder) {
	if (level > 1) {
		realLevel = 1;
	} else {
		realLevel = level;
	}
	// }

	// ܂́AGUID擾B
	createUUID(guid);

	// ɁAURL݂邩ǂmFāA݂Ȃꍇ͐VɏށB
	url = item->getURL();
	if (url == NULL || strlen(url) == 0) {
		// URL󂾂Ƒs\ɂȂ̂ŁAabout:blankB
		item->setURL("about:blank");
	}

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putFolder\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// guid
	rc = sqlite3_bind_text(statement, 1, guid , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// idx
	rc = sqlite3_bind_int(statement, 2, order[realLevel]);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// title
	wchar_t *filenameW = item->getIeNameW();
	char *utf8 = wctoUTF8Internal(filenameW);

	rc = sqlite3_bind_text(statement, 3, utf8 , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// url
	url = item->getURL();
	if (url != NULL){
		if (strncmp("file:", url, 5) == 0){
			encodeURL(urlBuf, url);
			url = urlBuf;
		} else {
			url = item->getURL();
		}

	}

	rc = sqlite3_bind_text(statement, 4, url , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}


	// parent
	if (realLevel > 0) {
		rc = sqlite3_bind_text(statement, 5, parent[realLevel].c_str(), -1, SQLITE_STATIC);
		if ( rc != SQLITE_OK ){
			sqlite3_finalize(statement);
			return -1;
		}
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	
	order[realLevel]++;	// tH_̏Ԃi߂B
	return 0;
}

// ubN}[NpSQLQ
char *operaBookmarksDelete = "delete from favorites;";

/**
 * ubN}[NɊւe[uB
 *
 * @return 0:폜 1:폜s
 */
int Op15Writer::initializeTables(void)
{
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, operaBookmarksDelete , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[putHeader]SQL error\n");
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ((rc != SQLITE_DONE) && ( rc != SQLITE_OK )){
		fprintf(stderr, "[putHeader]SQL error\n");
		rc = sqlite3_finalize(statement);
		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}

	return 0;
}

/**
 * ubN}[Nt@C̓̕ޏ<br>
 * (DBȂ̂ŃgUNVJnƏsB)
 *
 */
void Op15Writer::putHeader(void)
{
	// ͂߂ɃgUNVJnB

	char *sql = "BEGIN TRANSACTION;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[putHeader]SQL error\n");
		return;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ((rc != SQLITE_DONE) && ( rc != SQLITE_OK )){
		fprintf(stderr, "[putHeader]SQL error\n");
		rc = sqlite3_finalize(statement);
		return;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	inTransaction = true;

	// e[u̓eB
	initializeTables();
}

/**
 * tH_ޏ<br>
 * 
 */
void Op15Writer::putFolder(Bookmark *item)
{
	// IÊCɓo[΂
	/*
	if ((putIEToolbar == false) && (item->isIEToolbar())) {
		enableWrite = false;
		m_ignoreSince = level;
	}
	*/
	if (level > 0) {
		level++;
		return;
	}
	/*
	if (!enableWrite) {
		// ݂stH_ȊȌꍇ͊Kw̃JEgsB
		level++;
		return;
	}
	*/

	// tH_쐬
	std::string id;
	id = insertOp15Folder(item);
	if (id == "") {
		// tH_}sɂǍ̎ssȂB
		return;
	}

	order[level]++;	// tH_̏Ԃi߂B
	// ̊Kw̐ݒsB
	nextLevel(id);	
}

/**
 * ̊Kw̐ݒsB<br>
 * ԁEetH_̐ݒsB
 *
 * @param id 쐬tH_ID
 */
void Op15Writer::nextLevel(std::string &id)
{
	// ̊Kw̐ݒ(ԂƐetH_)
	level++;
	// 
	if ((int)order.size() <= level){
		order.push_back(0);
	}else{
		order[level] = 0;
	}

	// eID̐ݒ
	if ((int)parent.size() <= level){
		parent.push_back(id);
	}else{
		parent[level] = id;
	}
}

/**
 * tH_̍Ōޏ<br>
 * 
 *
 */
void Op15Writer::putFolderEnd(Bookmark *item,bool isLast)
{
	level--;
	if (level == m_ignoreSince) {
		enableWrite = true;
	}
}

/**
 * ubN}[Nޏ<br>
 * 
 *
 */
void Op15Writer::putBookmark(Bookmark *item,bool isLast)
{
	if (!enableWrite) {
		// ݂stH_ȊȌꍇ͉ȂB
		return;
	}

	// ubN}[Nmoz_bookmarksɑ}B
	sqlite_int64 id;
	if (item->getSeparator()) {
		// d؂݂͑Ȃ̂ŉȂ
		return;
	} else {
		id = insertOp15Bookmark(item);
	}

	if (id == -1) {
		// ubN}[N}sɂǍ̎ssȂB
		return;
	}

}

/**
 * ubN}[Nt@C̏I̕ޏ<br>
 * (DBȂ̂ŉȂB)
 *
 */
void Op15Writer::putFooter(void)
{
}

/**
 * R~bgsB<br>
 *
 */
int Op15Writer::commit(void)
{
	char *sql = "COMMIT TRANSACTION;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[commit]SQL error\n");
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (( rc != SQLITE_OK ) && (rc != SQLITE_DONE) ){
		fprintf(stderr, "[commit]SQL error\n");
		rc = sqlite3_finalize(statement);
		sqlite3_close(db);
		db = NULL;

		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}

	if (doOptimize) {
		reindex();
		vacuum();
	}

	rc = sqlite3_close(db);
	db = NULL;

	return 0;
}

/**
 * [obNsB
 *
 */
void Op15Writer::rollback()
{
	char *sql = "ROLLBACK TRANSACTION;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[rollback]SQL error\n");
		return;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (( rc != SQLITE_OK ) && (rc != SQLITE_DONE) ){
		fprintf(stderr, "[rollback]SQL error\n");
		rc = sqlite3_finalize(statement);
		sqlite3_close(db);
		db = NULL;

		return;
	}
	inTransaction = false;

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
}

/**
 * SQLsB<br>
 *
 */
int Op15Writer::executeSQL(char *sql)
{
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[executeSQL]SQL error\n");
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (( rc != SQLITE_OK ) && (rc != SQLITE_DONE) ){
		fprintf(stderr, "[executeSQL]SQL error\n");
		rc = sqlite3_finalize(statement);

		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[executeSQL]finalize failed\n");
	}

	return 0;
}

/**
 * CfbNX̍ĕҐsB
 */
int Op15Writer::reindex()
{
	return executeSQL("REINDEX;");
}

/**
 * 󂫗̈̐sB
 */
int Op15Writer::vacuum()
{
	return executeSQL("VACUUM;");
}
