// Wwb_
#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>

// BookSyncʃwb_
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"

// vbgtH[wb_
#include	"Op15Reader.h"

/**
 * RXgN^
 *
 */
Op15Reader::Op15Reader()
{
	m_bookmarkNo = 0;

	level = 0;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
	urlBufLen = BUFLEN;
}

/**
 * fXgN^
 *
 */
Op15Reader::~Op15Reader()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int Op15Reader::reallocUrlBuf(int size)
{
	delete []urlBuf;
	try {
		urlBuf = NULL;
		urlBuf = new char[size];
		if (urlBuf == NULL) {
			logger->debug("No enough memory");
			return -1;
		}
		urlBufLen = size;
	} catch (...) {
		logger->debug("No enough memory");
		return -1;
	}
	return size;
}

/**
 * c[ւ̃tH_̏oƂ̉̃c[̓ǂ݂
 *
 * @param id tH_id
 * @return 0: 1:s
 */
int Op15Reader::putFolder(char *id)
{
	bookmark.setItemType(Bookmark::folder);

	// tH_̎ނ̐ݒ
	// ʂ̃tH_
	bookmark.setFolderType(Bookmark::normalFolder);

	int result = 0;

	// c[ւ̊i[
	result = writer->storeItem(&bookmark);
	if (result){
		logger->debug("Floder store error");
		return 1;
	}

	// c[o[ȊOc[o[𖳎Ȃꍇ
	// ̃tH_ǂݍށB

	level++;
	// tH_CuubN}[NłȂꍇ̂݃tH_ǂݍށB
	result = readFolder(id);
	// tH_̓ǂݍ݂ItH_1B
	writer->upFolder();	// 
	level--;

	return result;
}

/**
 * c[ւ̃ubN}[N̏o
 *
 * @return 0: 1:s
 */
int Op15Reader::putBookmark(void)
{
	bookmark.setItemType(Bookmark::bookmark);

	// c[ւ̊i[
	int result = writer->storeItem(&bookmark);
	if (result){
		logger->debug("Bookmark store error");
		return 1;
	}

	return result;
}

/**
 * URLGR[h̃fR[hƍĊmۂsB
 *
 * @param p fR[hsURL
 * @return NULL:fR[h NULL:fR[hs
 */
char *Op15Reader::decodeAndRealloc(char *p)
{
	int count = decodeURL(NULL, p);
	if ((count + 1) > urlBufLen) {
		int result = reallocUrlBuf(count + 2);
		if (result == -1) {
			return NULL;
		}
	}
	decodeURL(urlBuf, p);
	return urlBuf;
}

/**
 * tH_ǂݍ
 *
 * @param folderId ubN}[NEtH_tH_moz_bookmarks.id
 * @return 0: 1:s
 */
int Op15Reader::readFolder(char *folderId)
{
	char *sql;
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	char guidBuf[128];
	int order;

	if (folderId == NULL) {
		sql = "select guid,idx,name,url,type "
			"from favorites "
			"where parent_guid IS NULL order by idx;";
	} else {
		sql = "select guid,idx,name,url,type "
			"from favorites "
			"where parent_guid=? order by idx;";
	}

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[readFolder]SQL error\n");
		logger->debug("Folder read SQL error");
		return 1;
	}

	sqlite3_reset(statement);

	if (folderId != NULL) {
		rc = sqlite3_bind_text(statement, 1, folderId, -1, SQLITE_STATIC);
		if ( rc != SQLITE_OK ){
			fprintf(stderr,"[readFolder]bind failed.\n");
			logger->debug("Folder read bind error");
			sqlite3_finalize(statement);
			return 1;
		}
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while (rc == SQLITE_ROW) {
		// ubN}[Ni[IuWFNgZbgB
		bookmark.reset();
		bookmark.getOp15Bookmark(m_bookmarkNo)->reset();

		// 0n܂B
		int type;
		int result = 0;

		// id
		if (sqlite3_column_type(statement,0) == SQLITE_TEXT){
			const unsigned char *id = sqlite3_column_text(statement, 0);
			strcpy(guidBuf, (const char *)id);
			bookmark.getOp15Bookmark(m_bookmarkNo)->setGUID((const char *)id);
		}
		// idx
		if (sqlite3_column_type(statement,1) == SQLITE_INTEGER){
			order = sqlite3_column_int(statement,1);
			fprintf(stdout,"%d:INTEGER:%d\n",1,sqlite3_column_int(statement,1));
		}
		// type
		if (sqlite3_column_type(statement,4) == SQLITE_INTEGER){
			type = sqlite3_column_int(statement,4);
		}
		// name
		if (sqlite3_column_type(statement,2) == SQLITE_TEXT){	// ^Cg
			fprintf(stdout,"%d:TEXT:%s\n",1,sqlite3_column_text(statement,2));
			
			const unsigned char *item = sqlite3_column_text(statement,2);
			if (item != NULL) {
				// ubN}[N
				bookmark.setName((char *)item);
				// IE(}`oCg)̐ݒ
				char *p;
				p = UTF8tombFileNameInternal((char *)item);
				if (p != NULL){
					bookmark.setIeName(p);
				}
				// O̐ݒ(Unicode)
				wchar_t *wp;
				wp = UTF8towcFileNameInternal((char *)item);
				bookmark.setIeNameW(wp);
			}
		}

		switch (type) {
			case 0:
			case 3:
				// ubN}[N̏
				// url
				if (sqlite3_column_type(statement,3) == SQLITE_TEXT){	// URL
					fprintf(stdout,"%d:TEXT:%s\n",1,sqlite3_column_text(statement,3));
					char *p = (char *)sqlite3_column_text(statement,3);
					if (p != NULL) {
						if (strncmp("file:", p,5) == 0) {
							// file:URLGR[hĂ̂ŃfR[hĂB
							p = decodeAndRealloc(p);
							if (p == NULL) {
								logger->debug("file: URL decode error");
								return 1;
							}
						} else if (strncmp("javascript:", p,11) == 0) {
							// JavaScript(ubN}[Nbg)URLGR[hĂ̂
							// Ŏg߃fR[h
							p = decodeAndRealloc(p);
							if (p == NULL) {
								logger->debug("javascript: URL decode error");
								return 1;
							}
						}
						bookmark.setURL((const char *)p);
					}
				}
				result = putBookmark();
				break;
			case 1:
				// tH_̏
				result = putFolder(guidBuf);
				if (result){
					rc = sqlite3_finalize(statement);
					logger->debug("Folder read error by folder store");
					return 1;
				}
				break;
		}

		fprintf(stdout,"\n\n");
		rc = sqlite3_step(statement);
	}
	if (rc != SQLITE_DONE) {
		sqlite3_finalize(statement);
		logger->debug("Folder read error by SQL execute");
		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[readFolder]finalize failed\n");
	}
	
	return 0;
	
}

/**
 * ubN}[Nǂݍ
 *
 * @param bmFile ubN}[Nt@C
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int Op15Reader::readBookmark(const char *bmFile)
{
	int rc;

	fprintf(stderr, "[readBookmark]read start\n");

	dbFile = bmFile;
	char *p = mbtoUTF8Internal(const_cast<char *>(bmFile));
	if (p == NULL) {
		logger->debug("Bookmark db read error");
		return 1;
	}

	// DBt@CI[v
	rc = sqlite3_open(p, &db);
	if (rc){
		fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
		sqlite3_close(db);
		db = NULL;
		logger->debug("Bookmark db open failed");
		return 1;
	}

	// ŏ̃tH_ǂݎn߂
	int result = readFolder(NULL);

	sqlite3_close(db);
	db = NULL;

	return result;
}

