#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NTfunction.h"
#include	"Bookmark.h"
#include	"url.h"

#include	"MozillaBookmark.h"
#include	"MozillaWriter.h"

MozillaWriter::MozillaWriter(void)
{
	m_spaces = 0;
	m_UTF8 = false;
	m_target = 0;
	m_level = 0;
	syncIElinkFolder = false;
	ieName = false;
	placesPut = true;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
}

MozillaWriter::~MozillaWriter()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/* Xy[Xo͂BSeaMonkey/Netscape/Mozillap */
void MozillaWriter::spput(FILE *fp,int spaces)
{
	int i;
	
	for (i = 0;i < spaces;i++){
		fputc(' ',fp);
	}
}


/**
 * tH_̏o͂B
 *
 */
void MozillaWriter::putFolder(Bookmark *item)
{
	// IÊCɓƃNtH_킹ꍇ
	if (syncIElinkFolder){
		if (item->getIeName() != NULL){
			if (!_stricmp(ieLinkFolderName,item->getIeName())){
				if (m_level == 0){
					item->getMozillaBookmark(m_target)->setLinkbarFolder(true);
				}else{
					item->getMozillaBookmark(m_target)->setLinkbarFolder(false);
				}
			}else{
				item->getMozillaBookmark(m_target)->setLinkbarFolder(false);
			}
		}
	}

	// printf("putFolder\n");
	spput(cs_fpo,m_spaces);
	fprintf(cs_fpo,"<DT><H3");

	if (!m_outputType){
		/* FOLDEDNetscape 7Mozillaɂ͂ȂB */
		fprintf(cs_fpo," FOLDED");
	}

	if (item->getAdddate() != 0){
		fprintf(cs_fpo," ADD_DATE=\"%llu\"",item->getAdddate());
	}
	if (item->getModified() != 0){
		fprintf(cs_fpo," LAST_MODIFIED=\"%llu\"",item->getModified());
	}
	if (m_outputType){	// MozillaV[YŗL
		if (item->getMozillaBookmark(m_target)->getLinkbarFolder()){
			fprintf(cs_fpo," PERSONAL_TOOLBAR_FOLDER=\"true\" ID=\"NC:PersonalToolbarFolder\"");
		}
		// ubN}[NFirefox̂̂*Ȃ*ꍇAMozillaŗLo͂B
		if (m_mozVersion < 3){
			if (item->getMozillaBookmark(m_target)->getGroup()){
				fprintf(cs_fpo," FOLDER_GROUP=\"true\"");
			}
			if (item->getMozillaBookmark(m_target)->getNewSearchFolder()){
				fprintf(cs_fpo," NEW_SEARCH_FOLDER=\"true\"");
			}
			if (item->getMozillaBookmark(m_target)->getNewBookmarkFolder()){
				fprintf(cs_fpo," NEW_BOOKMARK_FOLDER=\"true\"");
			}
		}
		// ID(Mozilla 1.4/Firefox)
		/*
		if ((item->getMozillaBookmark(m_target)->getID() != NULL) && m_outputType && !item->getMozillaBookmark(m_target)->getLinkbarFolder()){
			fprintf(cs_fpo," ID=\"%s\"",item->getMozillaBookmark(m_target)->getID());
		}
		*/
	}

	fprintf(cs_fpo,">");
	wchar_t *filenameW = item->getIeNameW();
	if (filenameW != NULL){
		putname(cs_fpo,filenameW);
	}
	fprintf(cs_fpo,"</H3>\n");

	if (item->getDescription() != NULL){
		fprintf(cs_fpo,"<DD>");
		putDescription(cs_fpo,item->getDescription());
		fprintf(cs_fpo,"\n");
	}

	spput(cs_fpo,m_spaces);
	fprintf(cs_fpo,"<DL><p>\n");
	m_spaces += 4;
	m_level++;

}

/*
	tH_Io͂B
	
		Ȃ
	߂l
		Ȃ
*/
void MozillaWriter::putFolderEnd(Bookmark *item,bool isLast)
{
	m_level--;
	m_spaces -= 4;
	spput(cs_fpo,m_spaces);
	fprintf(cs_fpo,"</DL><p>\n");
}

/**
 * ubN}[N̏o͂B
 */
void MozillaWriter::putBookmark(Bookmark *item,bool isLast)
{
	if (!placesPut) {
		// Firefox 3̃X}[gubN}[NtH_炱𖳎B
		if (item->isPlaceURI()) {
			return;
		}
	}

	// printf("putBookmark\n");
	spput(cs_fpo,m_spaces);
	if (item->getSeparator()){
		if (Bookmark::getSortMode() == 0){	/* \[gȂo͂B\[gꍇ͈ӖȂ̂ŁB */
			return;
		}

		// oubN}[NȊOɂZp[^͖B
		// Zp[^̓ubN}[Nł̈ʒuĂ͂߂ĈӖB
		if (item->getOrgOrder(1 + m_target) < 0){
			return;
		}

		fprintf(cs_fpo,"<HR");
		if ((item->getMozillaBookmark(m_target)->getHRName() != NULL) && m_outputType && m_mozVersion > 1){
			fprintf(cs_fpo," NAME=\"%s\"",item->getMozillaBookmark(m_target)->getHRName());
		}
		fprintf(cs_fpo,">\n");
		return;
	}
	if (item->getURL() != NULL){
		char *p;
		p = item->getURL();
		if (strncmp("file:",p,5) == 0){
			if (m_outputType == 0){	// Netscape 4`̂Ƃ̂ݕϊB
				p = UTF8tombInternal(item->getURL());
			}else{
				// Mozillȁꍇ͂̂܂
				p = item->getURL();
			}
			encodeURL(urlBuf, p);
			p = urlBuf;
		} else {
			if (strncmp("javascript:", p,11) == 0) {
				if (m_outputType == 0){	// Netscape 4`̂Ƃ̂ݕϊB
					p = UTF8tombInternal(item->getURL());
				}else{
					// Mozillȁꍇ͂̂܂
					p = item->getURL();
				}
				encodeOnlyDoubleQuote(urlBuf, p);
				p = urlBuf;
			}
		}
		fprintf(cs_fpo,"<DT><A HREF=\"%s\" ADD_DATE=\"%u\"",p,item->getAdddate());
	}else{
		fprintf(cs_fpo,"<DT><A HREF=\"\" ADD_DATE=\"%u\"",item->getAdddate());
	}

	if (item->getLastvisit() > 0){
		fprintf(cs_fpo," LAST_VISIT=\"%u\"",item->getLastvisit());
	}
	
	if (item->getModified() > 0){
		fprintf(cs_fpo," LAST_MODIFIED=\"%u\"",item->getModified());
	}

	// MozillaŗL̑o
	if (m_outputType){
		if (item->getMozillaBookmark(m_target)->getWebPanel()){
			fprintf(cs_fpo," WEB_PANEL=\"true\"");
		}

		if (item->getShortcut() != NULL){
			fprintf(cs_fpo," SHORTCUTURL=\"");
			putShortcut(cs_fpo,item->getShortcut());
			fprintf(cs_fpo,"\"");
		}

		if (item->getMozillaBookmark(m_target)->getIconUri() != NULL){
			if (strlen(item->getMozillaBookmark(m_target)->getIconUri()) > 0){
				fprintf(cs_fpo," ICON_URI=\"%s\"",item->getMozillaBookmark(m_target)->getIconUri());
			}
		}

		if (item->getIcon() != NULL){
			if (m_mozVersion != 3){
				// MozillãubN}[N̏ꍇ̂݃ACRo͂B
				if (strlen(item->getIcon()))
					fprintf(cs_fpo," ICON=\"%s\"",item->getIcon());
			}
		}
		if (item->getMozillaBookmark(m_target)->getFirefoxIcon() != NULL){
			if (m_mozVersion == 3){
				// Firefox̃ubN}[N̏ꍇ̂BASE64GR[hACRo͂B
				if (strlen(item->getMozillaBookmark(m_target)->getFirefoxIcon()))
					fprintf(cs_fpo," ICON=\"%s\"",item->getMozillaBookmark(m_target)->getFirefoxIcon());
			}
		}
		if (item->getMozillaBookmark(m_target)->getSchedule() != NULL){
			fprintf(cs_fpo," SCHEDULE=\"%s\"",item->getMozillaBookmark(m_target)->getSchedule());
		}
		if (item->getMozillaBookmark(m_target)->getCheck()){
			fprintf(cs_fpo," LAST_PING=\"%ld\"",item->getMozillaBookmark(m_target)->getCheck());
		}
		if (item->getMozillaBookmark(m_target)->getCharset() != NULL){
			fprintf(cs_fpo," LAST_CHARSET=\"%s\"",item->getMozillaBookmark(m_target)->getCharset());
		}
		if (item->getMozillaBookmark(m_target)->getFeedUrl() != NULL){
			if (m_mozVersion == 3){	// Firefox̃ubN}[N̏ꍇ̂݃CuubN}[No͂B
				fprintf(cs_fpo," FEEDURL=\"%s\"",item->getMozillaBookmark(m_target)->getFeedUrl());
			}
		}
		/*
		if (item->getMozillaBookmark(m_target)->getID() != NULL){
			if (m_mozVersion > 1){	// Netscape 6ȏŁAΏۂMozilla 1.4ȏゾIDo͂B
				fprintf(cs_fpo," ID=\"%s\"",item->getMozillaBookmark(m_target)->getID());
			}
		}
		*/
		if (item->getMozillaBookmark(m_target)->getMicsum_gen_uri() != NULL){
			if (m_mozVersion == 3){	// Firefox̃ubN}[N̏ꍇ̂݃CuubN}[No͂B
				fprintf(cs_fpo," MICSUM_GEN_URI=\"%s\"",item->getMozillaBookmark(m_target)->getMicsum_gen_uri());
			}
		}
		if (item->getMozillaBookmark(m_target)->getMicsum_expiration() != NULL){
			if (m_mozVersion == 3){	// Firefox̃ubN}[N̏ꍇ̂݃CuubN}[No͂B
				fprintf(cs_fpo," MICSUM_EXPIRATION=\"%s\"",item->getMozillaBookmark(m_target)->getMicsum_expiration());
			}
		}
		if (item->getMozillaBookmark(m_target)->getGeneratedTitle() != NULL){
			if (m_mozVersion == 3){	// Firefox̃ubN}[N̏ꍇ̂݃CuubN}[No͂B
				fprintf(cs_fpo," GENERATED_TITLE=\"%s\"",item->getMozillaBookmark(m_target)->getGeneratedTitle());
			}
		}
	}

	fprintf(cs_fpo,">");
	if (item->getIeNameW() != NULL){
		putname(cs_fpo,item->getIeNameW());
	}
	fprintf(cs_fpo,"</A>\n");
	
	if (item->getDescription() != NULL){
		fprintf(cs_fpo,"<DD>");
		putDescription(cs_fpo,item->getDescription());
		fprintf(cs_fpo,"\n");
	}
}

/*
	ubN}[Ñwb_o͂B
	
		Ȃ
	߂l
		Ȃ
*/
void MozillaWriter::putHeader(void)
{
	fprintf(cs_fpo,"<!DOCTYPE NETSCAPE-Bookmark-file-1>\n");
	if (m_outputType > 0){
		fprintf(cs_fpo,"<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=UTF-8\">\n");
	}
	fprintf(cs_fpo,"<TITLE>Bookmarks</TITLE>\n");
	fprintf(cs_fpo,"<H1>Bookmarks</H1>\n\n");
	fprintf(cs_fpo,"<DL><p>\n");


}

/*
	ubN}[Ñtb^o͂B
	
		fpo o͐
	߂l
		Ȃ
*/
void MozillaWriter::putFooter(void)
{
	fprintf(cs_fpo,"</DL><p>\n\n");
}

/*
	&HTML̕QƂɕϊȂ當o͂B
	
		fp t@C|C^
		name o͂镶
	߂l
		Ȃ
*/
void MozillaWriter::putname2(FILE *fp,char *name)
{
//	debugprintf("putname2\n");

	while(*name){
		switch(*name){
			case '&':
				fprintf(fp,"&amp;");
			break;
			case '<':
				fprintf(fp,"&lt;");
			break;
			case '>':
				fprintf(fp,"&gt;");
			break;
			case '\"':
				fprintf(fp,"&quot;");
			break;
			default:
				fputc(*name,fp);
			break;
		}
		name++;
	}
}

/*
	&HTML̕QƂɕϊȂ當o͂B
	
		fp t@C|C^
		name o͂镶
	߂l
		Ȃ
*/
void MozillaWriter::putname3(FILE* fp, unsigned char* name)
{
	int c;

	while (*name) {
		if (*name > 127) {
			c = (int)(*name);
		} else {
			c = *name;
		}
		switch (*name) {
			case '&':
				fprintf(fp, "&amp;");
				break;
			case '<':
				fprintf(fp, "&lt;");
				break;
			case '>':
				fprintf(fp, "&gt;");
				break;
			case '\"':
				fprintf(fp, "&quot;");
				break;
			default:
				fputc(c, fp);
				break;
		}
		name++;
	}
}


/*
	ėpo̓[` SJIS -> UTF8ϊt
	
		fp o͐FILE\̂ւ̃|C^
		name o͂镶
	߂l
		Ȃ
*/
void MozillaWriter::putname(FILE *fp,wchar_t *name)
{

	wchar_t *unicode;
	unsigned char *utf8;
	int utf8Count;
	
//	debugprintf("putname\n");
	if (name == NULL)
		return;
	
	if ( m_outputType != 0){
		unicode = name;

		// Unicode -> UTF8
		utf8Count = countUTF16LEtoUTF8str(unicode);
		utf8 = (unsigned char *)calloc(utf8Count + 1, sizeof(unsigned char));
		if (utf8 == NULL){
			return;
		}
		toUTF8(utf8,unicode);

		putname3(fp, utf8);

		free(utf8);
	}else{
		unicode = name;

		// Unicode -> }`oCg
		int mbCount = wcstombsByteFileName( NULL , unicode , ( wcslen(unicode) + 1 ) * 2 );
		char *mbStr = (char *)calloc(mbCount + 1,sizeof(unsigned char));
		if (mbStr == NULL){
			return;
		}
		wcstombsByteFileName( mbStr , unicode , mbCount + 1);

		putname2(fp, mbStr);

		free(mbStr);
	}


}

/**
 * Descriptiono͗pėp[`
 * o͂`ɍ킹R[hŏo͂sB
 * SHORTCUTURLƌpȂ̂ŁAs͎ŏo͂邱ƁB
 *
 * @param fp o͐FILE\̂ւ̃|C^
 * @param name o͂镶(UTF-8)
 *
 */
void MozillaWriter::putDescription(FILE *fp,char *name)
{
	if ( m_outputType != 0){
		// Mozilla
		putname2(fp,name);
	}else{
		// Netscape 4
		char *p = UTF8tombInternal(name);
		if (p != NULL){
			putname2(fp,p);
		}
	}
}

/**
 * Shortcuto͗pėp[`
 * o͂`ɍ킹R[hŏo͂sB
 *
 * @param fp o͐FILE\̂ւ̃|C^
 * @param name o͂镶(UTF-8)
 *
 */
void MozillaWriter::putShortcut(FILE *fp,char *name)
{
	if ( m_outputType != 0){
		// Mozilla
		fprintf(fp,"%s",name);
	}else{
		// Netscape 4
		char *p = UTF8tombInternal(name);
		if (p != NULL){
			fprintf(fp,"%s",p);
		}
	}
}
