#define ISMOZILLAREADER

// Wwb_
//#if defined(_DEBUG) && defined(_MSC_VER)
//#define _CRTDBG_MAP_ALLOC
//#endif

#include	<stdlib.h>

//#if defined(_DEBUG) && defined(_MSC_VER)
//#include	<crtdbg.h>
//#endif

#include	<fstream>
#include	<iostream>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>

// BookSyncʃwb_
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"

// vbgtH[wb_
#include	"MozillaBookmark.h"
// #include	"nbexie.h"
#include	"MozillaReader.h"
#include	"IbookmarkTree.h"
// #include	"ieBookmark.h"
#include	"..\core\messages.h"

#ifdef __BORLANDC__
#define	_stricmp stricmp
#endif

extern int g_lang;
extern int g_verbose;

/**
 *	RXgN^
 */
MozillaReader::MozillaReader()
{
	noIEfavorites = 0;	// C|[gIÊCɓ΂Ȃ
	isSilentMode = 1;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
		urlBufLen = BUFLEN;
	} catch (...) {
	}

}

MozillaReader::~MozillaReader()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int MozillaReader::reallocUrlBuf(int size)
{
	delete []urlBuf;
	try {
		urlBuf = NULL;
		urlBuf = new char[BUFLEN];
		if (urlBuf == NULL) {
			logger->debug("No enough memory");
			return -1;
		}
		urlBufLen = size;
	} catch (...) {
		logger->debug("No enough memory");
		return -1;
	}
	return size;
}

/**
 *	̃Xy[X؂B
 */
void MozillaReader::trimLastSpaceOnly(char *buf)
{
	int flag = 0;	// JbgXy[XǂH
	char *p;
	
	while(*buf){
		if (*buf == 0x20){
			// Xy[X݂
			if (!flag){
				// ŏ̃Xy[X̏ꍇAtO𗧂ĂăJbgʒuۑB
				flag = 1;
				p = buf;
			}
		}else{
			flag = 0;
		}
		
		buf++;
	}
	if (flag){
		// JbgXy[X炻łB
		*p = '\0';
	}
}


/**
 * bookmarkoB
 *
 * @return 0  1 G[
 */
int MozillaReader::flushItem(int type,struct parseStatus *stat)
{
	int result = 0;
	
	switch(type){
		//case 0:	// Ȃ
		//break;
		case 1:	// Bookmark
			if (!stat->ignore){
				result = writer->storeItem(&bookmark);
			}
			if (result) {
				logger->debug("Bookmark store error");
			}
		break;
		case 2:	// Folder
			if (!stat->ignore){
				result = writer->storeItem(&bookmark);
			}
			if (result) {
				logger->debug("Folder store error");
			}
		break;
	}
	return result;
}

/*****************************
  ubN}[Nt@C͕
*****************************/

/* evfʂ̉߃W[ */

/**
 * AGg(ubN}[N)
 * @param tag	aGgiubN}[N)̏
 * @return ͌ 0:͐ 1:LocationȂB
 */
int MozillaReader::checkAnchorTag(HTMLtag *tag)
{
	char *p;
	
	bookmark.setItemType(Bookmark::bookmark);

	// HREFɂꏊ
	p = tag->getAttrValue("href");
	if (p != NULL){
		if (strncmp("file:", p,5) == 0) {
			int count = decodeURL(NULL, p);
			if ((count + 1) > urlBufLen) {
				int result = reallocUrlBuf(count + 2);
				if (result == -1) {
					logger->debug("file: read error");
					return 1;
				}
			}
			decodeURL(urlBuf, p);
			if (!MozillaBookmark::isUTF8(0)){
				p = mbtoUTF8Internal(urlBuf);
			} else {
				p = urlBuf;
			}
		} else if (strncmp("javascript:", p,11) == 0) {
			int count = decodeOnlyDoubleQuote(NULL, p);
			if ((count + 1) > urlBufLen) {
				int result = reallocUrlBuf(count + 2);
				if (result == -1) {
					logger->debug("javascript: read error");
					return 1;
				}
			}
			decodeOnlyDoubleQuote(urlBuf, p);
			if (!MozillaBookmark::isUTF8(0)){
				p = mbtoUTF8Internal(urlBuf);
			} else {
				p = urlBuf;
			}
		}
		bookmark.setURL(p);
	}

	// t@C̃ZbgAbv
	if (g_verbose){
		std::cout << MozillaReader_message[g_lang][1] << std::flush;
		std::cout << MozillaReader_message[g_lang][2] << tag->getAttrValue("href") << "\n" << std::flush;
	}
	strcpy(item,"");
	pItem = item;

	// ACR͂邩?
	p = tag->getAttrValue("ICON");
	if (p != NULL){
		if (!strncmp(p,"data:",5)){
			// Firefox 1.0̃ACR
			bookmark.getMozillaBookmark(m_bookmarkNo)->setFirefoxIcon(p);
			MozillaBookmark::setBrowserVersion(m_bookmarkNo,3);
		}else{
			bookmark.setIcon(p);
		}
	}

	// ACRURI
	p = tag->getAttrValue("ICON_URI");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setIconUri(p);
		MozillaBookmark::setBrowserVersion(m_bookmarkNo,3);
	}

	// ubN}[Nɒǉ
	p = tag->getAttrValue("ADD_DATE");
	if (p != NULL){
		bookmark.setAdddate(p);
	}else{
		bookmark.setAdddate(static_cast<INT_TIME_T>(0L));
	}
	
	// ŏIK
	p = tag->getAttrValue("LAST_VISIT");
	if (p != NULL){
		bookmark.setLastvisit(p);
	}else{
		bookmark.setLastvisit(static_cast<time_t>(0L));
	}
	
	// ŏIXV
	p = tag->getAttrValue("LAST_MODIFIED");
	if (p != NULL){
		bookmark.setModified(p);
	}else{
		bookmark.setModified(static_cast<time_t>(0L));
	}
	
	// V[gJbg
	p = tag->getAttrValue("SHORTCUTURL");
	if (p != NULL){
		if (!MozillaBookmark::isUTF8(0)){
			p = mbtoUTF8Internal(p);
		}
		// &lt;WJB
		bookmark.setShortcut(p);
	}

	// XPW[
	p = tag->getAttrValue("SCHEDULE");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setSchedule(p);
	}

	p = tag->getAttrValue("LAST_PING");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setCheck(p);
	}

	// R[h
	p = tag->getAttrValue("LAST_CHARSET");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setCharset(p);
	}

	/* Mozilla 1.4 */
	p = tag->getAttrValue("ID");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setID(p);
		if (MozillaBookmark::getBrowserVersion(m_bookmarkNo) < 2){
			MozillaBookmark::setBrowserVersion(m_bookmarkNo,2);
		}
	}

	/* Mozilla Firebird() 0.7 */
	p = tag->getAttrValue("WEB_PANEL");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setWebPanel(true);
		MozillaBookmark::setBrowserVersion(m_bookmarkNo,3);
	}

	/* Micro summary֘A3̑(SFirefox 2) */
	p = tag->getAttrValue("MICSUM_GEN_URI");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setMicsum_gen_uri(p);
		MozillaBookmark::setBrowserVersion(m_bookmarkNo,3);
	}

	p = tag->getAttrValue("MICSUM_EXPIRATION");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setMicsum_expiration(p);
		MozillaBookmark::setBrowserVersion(m_bookmarkNo,3);
	}

	p = tag->getAttrValue("GENERATED_TITLE");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setGeneratedTitle(p);
		MozillaBookmark::setBrowserVersion(m_bookmarkNo,3);
	}

	/* Mozilla Firefox 1.0 */
	p = tag->getAttrValue("FEEDURL");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setFeedUrl(p);
		MozillaBookmark::setBrowserVersion(m_bookmarkNo,3);
		if (tag->getAttrValue("href") == NULL){
			// New Live BookmarkŒǉLive BookmarkɂhrefȂ̂
			// NɎĂB
			bookmark.setURL(p);
		}
	}

	if (bookmark.getURL() == NULL){
		putMessage(MozillaReader_message[g_lang][0]);
		logger->debug("URL is NULL");
		return 1;
	}

	return 0;
}

/**
 * Avf̉͂sB
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::parseAElement(struct parseStatus *stat,HTMLtag *tag)
{
	int ret = 0;
	
	if ( !tag->isEndtag() ){
		if (f_item){
			// ȌoB
			ret = flushItem(f_item,stat);
			if (ret) {
				logger->debug("Item store error");
				return 1;
			}
		}
		// VubN}[N̊i[JnB
		bookmark.getMozillaBookmark(m_bookmarkNo)->reset();
		bookmark.reset();
		if (checkAnchorTag(tag)){
			ret = 1;
			putMessage(MozillaReader_message[g_lang][3]);
		}
		stat->storeing = 1;
		f_item = 1;
		//std::cout << add << "\n" << std::flush;
	}else{
		//std::cout << "\nubN}[NI\n" << std::flush;
		*pItem = '\0';
		stat->storeing = 0;
		stat->itemType = 1;	// Oɏ񂾂̂̓ubN}[N

		// ubN}[N
		bookmark.setName(item);

		// O̐ݒ(}`oCg)
		char *p;
		if (stat->isUtf8){
			//p = utf8tomb(item,BUFLEN);
			p = UTF8tombFileNameInternal(item);
		}else{
			p = item;
		}
		// QƂϊB
		convChRef(work,p,g_lang);

		bookmark.setIeName(work);

		// O̐ݒ(Unicode)
		wchar_t *wp;
		if (stat->isUtf8){
			wp = UTF8towcFileNameInternal(item);
		}else{
			wp = mbtowcInternal(item);
		}
		// QƂϊB
		convChRefW(wp,wp);

		bookmark.setIeNameW(wp);

		if (g_verbose){
			std::cout << item << "\n" << std::flush;
		}

	}
	return ret;
}

/**
 * tH_̃^O͂B
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::checkFolderTag(HTMLtag *tag)
{
	char *p;

	bookmark.setItemType(Bookmark::folder);

	p = tag->getAttrValue("ADD_DATE");
	if (p != NULL){
		bookmark.setAdddate(p);
	}else{
		bookmark.setAdddate(static_cast<INT_TIME_T>(0L));
	}

	p = tag->getAttrValue("LAST_MODIFIED");
	if (p != NULL){
		bookmark.setModified(p);
	}else{
		bookmark.setModified(static_cast<time_t>(0L));
	}

	p = tag->getAttrValue("ID");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setID(p);
		if (!strcmp("NC:PersonalToolbarFolder",p)){	// NC:PersonalToolbarFolder
			bookmark.getMozillaBookmark(m_bookmarkNo)->setLinkbarFolder(1);
		}
	}

	// Group of Tabs(Mozilla)
	p = tag->getAttrValue("FOLDER_GROUP");
	if (p != NULL){
		if (!strcmp("true",p)){
			bookmark.getMozillaBookmark(m_bookmarkNo)->setGroup(1);
		}
	}

	// New Internet Search Folder(Mozilla)
	p = tag->getAttrValue("NEW_SEARCH_FOLDER");
	if (p != NULL){
		if (!strcmp("true",p)){
			bookmark.getMozillaBookmark(m_bookmarkNo)->setNewSearchFolder(true);
		}
	}

	// New Bookmark Folder(Mozilla)
	p = tag->getAttrValue("NEW_BOOKMARK_FOLDER");
	if (p != NULL){
		if (!strcmp("true",p)){
			bookmark.getMozillaBookmark(m_bookmarkNo)->setNewBookmarkFolder(true);
		}
	}

	// ̃o[WMozilla? 1.0RC1?2?
	// 1.0RC3͂ĨubN}[NoŏoȂB
	p = tag->getAttrValue("PERSONAL_TOOLBAR_FOLDER");
	if (p != NULL){
		if (!strcmp("true",p)){
			bookmark.getMozillaBookmark(m_bookmarkNo)->setLinkbarFolder(1);
		}
	}
	return 0;
}


/**
 * H3vf̉͂sB
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::parseH3Element(struct parseStatus *stat,HTMLtag *tag)
{
	int ret = 0;

	if ( !tag->isEndtag() ){
		if (g_verbose)
			std::cout << MozillaReader_message[g_lang][4] << std::flush;

		if (f_item){
			// ȌoB
			ret = flushItem(f_item,stat);
			if (ret) {
				logger->debug("Item store error");
				return 1;
			}
		}

		// VtH_̊i[JnB
		bookmark.getMozillaBookmark(m_bookmarkNo)->reset();
		bookmark.reset();
		checkFolderTag(tag);

		f_item = 2;

		pItem = item;
		cItem = 0;
		stat->storeing = 1;
		if (noIEfavorites){
			if (tag->getAttrValue("ID") != NULL){
				// IÊCɓ肩ǂ̔(MozillaŗLȂ̂łŔ)
				if (!strcmp(tag->getAttrValue("ID"),"NC:SystemBookmarksStaticRoot")){
					stat->ignore = 1;
					stat->ignoreLevel = stat->folderLevel;
				}
			}
		}
	}else{
		//std::cout << "\ntH_I\n" << std::flush;
		*pItem = '\0';
		stat->storeing = 0;
		stat->itemType = 0;	// Oɏ񂾂̂̓tH_

		// ubN}[N
		bookmark.setName(item);

		// O̐ݒ(}`oCg)
		char *p;
		if (stat->isUtf8){
			//p = utf8tomb(item,BUFLEN);
			p = UTF8tombFileNameInternal(item);
		}else{
			p = item;
		}
		// QƂϊB
		convChRef(work,p,g_lang);

		if (g_verbose)
			std::cout << work << "\n" << std::flush;
		bookmark.setIeName(work);

		// O̐ݒ(Unicode)
		wchar_t *wp;
		if (stat->isUtf8){
			//p = utf8tomb(item,BUFLEN);
			wp = UTF8towcFileNameInternal(item);
		}else{
			wp = mbtowcInternal(item);
		}
		// QƂϊB
		convChRefW(wp,wp);

		bookmark.setIeNameW(wp);

		stat->folderLevel++;
	}
	return ret;
}

/**
 * DLvf̉͂sB
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::parseDlElement(struct parseStatus *stat,HTMLtag *tag)
{
	int ret = 0;
	
	if (tag->isEndtag()){
		// tH_񂪏Î1KwɏオB
		//std::cout << "\ntH_I\n" << std::flush;
		//std::cout << stat->folderLevel << std::flush;
		if (f_item){
			// ȌoB
			ret = flushItem(f_item,stat);
			if (ret){
				logger->debug("Item store error");
				return 1;
			}

			f_item = 0;
		}

		if (stat->folderLevel > 0){
			stat->folderLevel--;
			if (stat->ignore){
				// tH_tH_𖳎̊Kw
				// 肵āAtH_Iǂ
				// 肷B
				if (stat->folderLevel == stat->ignoreLevel){
					stat->ignore = 0;
				}
			}else{
				writer->upFolder();	// tH_1鏈
			}
		}else{
			stat->folderLevel = -1;
		}
	}
	return ret;
}

/**
 * DDvfȈB
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::parseDdEnd(struct parseStatus *stat,HTMLtag *tag)
{
	int ret = 0;
	char *p;
	
	*pItem = '\0';
	cItem = 0;
	stat->storeing = 0;
	stat->inDD = 0;

	// ̉s{Xy[X폜B
	int len = strlen(item);
	for (int i = len - 1;i > -1; i--) {
		if (item[i] == ' ') {
			item[i] = '\0';
			continue;
		}
		if (item[i] == 0x0d) {
			item[i] = '\0';
			break;
		} else {
			break;
		}
	}

	if (!(stat->isUtf8)){
		p = mbtoUTF8Internal(item);
	}else{
		p = item;
	}

	trimLastSpaceOnly(p);	// Ō̃Xy[X̓CfgpȂ̂ŎB
	
	// &lt;WJB
	convChRefUTF8(work,p,g_lang);
	
	bookmark.setDescription(work);

	return ret;
}

/**
 * DDvf̉͂sB
 * @param stat:͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::parseDdElement(struct parseStatus *stat,HTMLtag *tag)
{
	int ret = 0;
	
	//std::cout << "\nDDGg\n";
	if ( !tag->isEndtag() ){
		// DDGgJn
		pItem = item;
		cItem = 0;
		stat->storeing = 1;	/* vf̒gi[JnB */
		stat->inDD = 1;
	}else{
		// ۂɂSeaMonkey/Netscape/Mozilla</DD>ȗĂ̂
		// ̃ubN͎sȂ\B
		ret = parseDdEnd(stat,tag);
	}
	return ret;
}

/**
 * METAvf̉͂sB
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::parseMetaElement(struct parseStatus *stat,HTMLtag *tag)
{
	/* http-equivmFB */
	if (tag->getAttrValue("HTTP-EQUIV") != NULL){
		if (!_stricmp(tag->getAttrValue("HTTP-EQUIV"),"Content-Type")){
			/* contentmFB */
			if (tag->getAttrValue("CONTENT") != NULL){
				if (strstr(tag->getAttrValue("CONTENT"),"UTF-8") != NULL){
					stat->isUtf8 = 1;
					MozillaBookmark::setUTF8(0,true);

					/* UTF-8̏ꍇAMozillãubN}[NƂ݂ȂB */
					MozillaBookmark::setBrowserVersion(m_bookmarkNo,1);
					// writer->setSection(1);
					if (g_verbose)
						std::cout << MozillaReader_message[g_lang][5];
				}
			}
		}
	}
	return 0;
}

/**
 * hrGg(Zp[^)
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:LocationȂB
 */
int MozillaReader::checkHrTag(HTMLtag *tag)
{
	char *p;
	
	bookmark.setItemType(Bookmark::bookmark);

	bookmark.setSeparator(true);

	// name̋Lq
	p = tag->getAttrValue("name");
	if (p != NULL){
		bookmark.getMozillaBookmark(m_bookmarkNo)->setHRName(p);
	}

	return 0;
}

/**
 * HRvf̉͂sB
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::parseHrElement(struct parseStatus *stat,HTMLtag *tag)
{
	int ret = 0;
	
	if ( !tag->isEndtag() ){
		if (f_item){
			// ȌoB
			ret = flushItem(f_item,stat);
			if (ret)
				return 1;
		}
		// VubN}[N̊i[JnB
		bookmark.getMozillaBookmark(m_bookmarkNo)->reset();
		bookmark.reset();
		if (checkHrTag(tag)){
			ret = 1;
			putMessage(MozillaReader_message[g_lang][3]);
		}
		// i[瑦oB
		if (!stat->ignore){
			ret = writer->storeItemWithRefer(&bookmark);
			if (ret) {
				logger->debug("Separator store error");
				return 1;
			}
		}

		// õ͎ubN}[No悤ԂZbgB
		bookmark.getMozillaBookmark(m_bookmarkNo)->reset();
		bookmark.reset();
		stat->storeing = 0;
		f_item = 0;
		//std::cout << add << "\n" << std::flush;
	}else{
	}
	return ret;
}


/**
 * HTMLevf̉͂sB
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::parseElement(struct parseStatus *stat,HTMLtag *tag)
{
	int ret = 0;
	
	if ( !_stricmp(tag->getName(),"A") ){
		if (stat->folderLevel < 0){
			//fprintf(stderr,"Warning:bad folder end.\n");
			logger->debug("Invalid bookmark");
			return 1;
		}
		ret = parseAElement(stat,tag);
	}
	
	if ( !_stricmp(tag->getName(),"H3") ){
		if (stat->folderLevel < 0){
			//fprintf(stderr,"Warning:bad folder end.\n");
			logger->debug("Invalid folder");
			return 1;
		}
		ret = parseH3Element(stat,tag);
	}
	
	if ( !_stricmp(tag->getName(),"DL") ){
		if (stat->folderLevel < 0){
			//fprintf(stderr,"Warning:bad folder end.\n");
			logger->debug("Invalid description");
			return 1;
		}
		ret = parseDlElement(stat,tag);
	}

	if ( !_stricmp(tag->getName(),"DD") ){
		if (stat->folderLevel < 0){
			//fprintf(stderr,"Warning:bad folder end.\n");
			logger->debug("Invalid description");
			return 1;
		}
		ret = parseDdElement(stat,tag);
	}
	
	if ( !_stricmp(tag->getName(),"META") ){
		if (stat->folderLevel < 0){
			//fprintf(stderr,"Warning:bad folder end.\n");
			logger->debug("Invalid meta element");
			return 1;
		}
		ret = parseMetaElement(stat,tag);
	}

	if ( !_stricmp(tag->getName(),"HR") ){
		if (stat->folderLevel < 0){
			//fprintf(stderr,"Warning:bad folder end.\n");
			logger->debug("Invalid separator");
			return 1;
		}
		ret = parseHrElement(stat,tag);
	}
	return ret;
}

/**
 * HTML̊{Iȉ͂sB
 * @param stat ͏ԕۑ\
 * @param tag ^OIuWFNg
 * @param c ǂݍ񂾕
 * @return ͌ 0:͐ 1:̓G[
 */
int MozillaReader::parseHTML(struct parseStatus *stat,HTMLtag *tag,char c)
{
	int result;	/* ^Oߌ */
	int ret = 0;

	if (!stat->inTag){
		/* ^O̒ł͂Ȃ */
		if (c == '<'){
			/* ^OJn */
			if (stat->inDD){	// DDGg̏ꍇ̓ubN}[N̏ށB
				ret = parseDdEnd(stat,tag);
			}

			stat->inTag = 1;
			stat->inComment = 0;
			tag->init();

		}else{
			/* ʏ̕ */
			//std::cout << c;
			if (stat->storeing){
				/* vf̒li[B(A,DD) */
				if (cItem < (BUFLEN - 1)){
					*pItem = c;
					pItem++;
					cItem++;
				}
			}
		}
	}else{
		/* ^O̒ */
		if (!stat->inComment){
			result = tag->doParse(c);
		}else{
			/* Rg */
			if (c == '-' && stat->previous == '-'){	// RgI
				//std::cout << "RgI\n";
				stat->inComment = 0;
			}
			result = 0;
		}
		switch(result){
			case 0:	/* ^Oi[ */
			break;
			case 2:	/* RgJn */
				stat->inComment = 1;
			break;
			case 1:	/* ^OI */
				if (tag->getName() != NULL){
					/* ^Ỏ͂sB */
					ret = parseElement(stat,tag);
					stat->inTag = 0;
				}
			break;
			case 3:	/* ߃G[̎͂܂ł𖳌ɂB */
				stat->inTag = 0;
			break;
		}
	}
	stat->previous = c;
	return ret;
}

/**
 * HTMLߏԏ
 * @param stat ߏ
 * @return Ȃ
 */
void MozillaReader::initParseStatus(struct parseStatus *stat)
{
	stat->previous = 0;	/* 1O̕ */
	stat->inTag = 0;	/* ^O̒ǂH */
	stat->inComment = 0;	/* RgǂH */
	stat->isUtf8 = 0;	/* UTF-8ǂH */
	stat->inDD = 0;	/* DDGgǂ? */
	stat->storeing = 0;	/* i[Ă邩ǂ */
	stat->itemType = -1;	/* ݈ĂvftH_ubN}[NH */
	stat->folderLevel = 0;	/* Kw */
	stat->ignore = 0;	/* tH_tO */
	stat->ignoreLevel = 0;	/* tH_JnKw */
	f_item = 0;
}

/**
 * ubN}[Nǂݍݕ
 * @param bmFile ubN}[Nt@C
 * @param fvDir:uCɓvfBNg
 * @return ǂݍ݌<br>
 * 0:ǂݍ݁ERo[g
 * 1:ǂݍ݁ERo[gs
 */
int MozillaReader::readFile(const char *bmFile,const char *fvDir)
{
	int ret = 0;	// s
	std::ifstream fin;	// ǂݍ݃Xg[
	char c;	// ǂݍ񂾕
	char prev = '\0';
	struct parseStatus stat;	// ߏԍ\
	HTMLtag tag;	// ^OIuWFNg

	initParseStatus(&stat);	// ͏ԂB
	
	fin.open(bmFile , std::ios::in | std::ios::binary);
	if (fin.bad()) {
		if (!isSilentMode){
			if (g_messageType == 1){
				MessageBox(NULL,MozillaReader_message[g_lang][10],"BookSync",MB_OK | MB_ICONEXCLAMATION);
			}else{
				putMessage2(MozillaReader_message[g_lang][6],bmFile);
			}
		}
		logger->debug("File read error");
		return 1;
	}
	if (!fin){
		if (!isSilentMode){
			if (g_messageType == 1){
				MessageBox(NULL,MozillaReader_message[g_lang][10],"BookSync",MB_OK | MB_ICONEXCLAMATION);
			}else{
				putMessage2(MozillaReader_message[g_lang][6],bmFile);
			}
		}
		return(1);
	}
	if (!isSilentMode){
		putMessage(MozillaReader_message[g_lang][7]);
	}

	// t@Cǂݍ݂sB
	while(fin.get(c)){
		// LF+CȐꍇACR𖳎B
		if (c == 0x0a) {
			if (prev == 0x0d) {
				prev = c;
				continue;
			}
		}
		ret = parseHTML(&stat,&tag,c);	/* HTMLߕɓnB */
		if (ret){
			/* G[炻̎_ŔB */
			break;
		}
		prev = c;
	}

	fin.close();
	if (f_item && (ret == 0)){
		// ȌoB
		ret = flushItem(f_item,&stat);
	}
	bookmark.getMozillaBookmark(m_bookmarkNo)->reset();
	bookmark.reset();

	if (ret){
		putMessage(MozillaReader_message[g_lang][9]);
		logger->debug("File read error");
	}else{
		if (!isSilentMode){
			putMessage(MozillaReader_message[g_lang][8]);
		}
	}

	return(ret);
}

/**
 * ͂JnBmۂB
 * @param bmFile ubN}[Nt@C
 * @param fvDir CɓfBNg
 * @return ͌ 0: 1:s
 */
int MozillaReader::readBookmark(const char *bmFile,const char *fvDir)
{
	int ret;

	// ꎞobt@mۂB
	work = NULL;
	try{
		work = new char[BUFLEN];
		if (work == NULL){
			logger->debug("No enough memory");
			return 1;
		}
	}catch(...){
		logger->debug("No enough memory");
		return 1;
	}
	ret = readFile(bmFile,fvDir);

	delete []work;

	return ret;
}

