#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"encutil.h"
#include	"encutil2.h"
#include	"Bookmark.h"

#include	"MozillaBookmark.h"
//#include	"eixebn.h"

#ifdef _DEBUG
#define debugprintf //printf
#else
#define debugprintf
#endif

// int MozillaBookmark::m_sortMode = 1;	// \[g
int MozillaBookmark::m_outputType[2] = {0,0};			// 0:Netscape 4/1:Netscape 6,7/Mozilla/2:Mozilla 1.4
int MozillaBookmark::m_mozVersion[2] = {0,0};			// 0:Netscape 4/1:Netscape 6,7/Mozilla/2:Mozilla 1.4
bool MozillaBookmark::m_UTF8[2] = {false,false};
int MozillaBookmark::m_spaces = 4;
FILE *MozillaBookmark::cs_fpo = NULL;

/*------------------------------*/
/* Mozilla dependent attributes */
/*------------------------------*/

/**
 * ftHgRXgN^<br>
 * ftHglݒ肷B
 */
MozillaBookmark::MozillaBookmark(void)
{
//	Bookmark::Bookmark();

	_init();
}

/**
 * Rs[RXgN^
 *
 * @param src Rs[̃IuWFNg
 */
MozillaBookmark::MozillaBookmark(const MozillaBookmark &src)
{
	_init();
	_copy(src);
}

/**
 * fXgN^
 */
MozillaBookmark::~MozillaBookmark()
{
	reset();
}

void MozillaBookmark::reset(void)
{
//	Bookmark::reset();
	if (m_id != NULL){
		delete []m_id;
		m_id = NULL;
	}
	if (m_charset != NULL){
		delete []m_charset;
		m_charset = NULL;
	}
	m_check = 0;			// ŏIXVmF
	if (m_Firefoxicon != NULL){
		delete []m_Firefoxicon;
		m_Firefoxicon = NULL;
	}
	if (m_FeedUrl != NULL){
		delete []m_FeedUrl;
		m_FeedUrl = NULL;
	}
	if (m_schedule != NULL){
		delete []m_schedule;
		m_schedule = NULL;
	}
	m_group = 0;			// tH_O[vǂ
	m_LinkbarFolder = 0;	// tH_Personal Toolbar Folderǂ
	m_webPanel = false;
	m_NewSearchFolder = false;	// New Internet Search FolderH
	m_NewBookmarkFolder = false;	// New Bookmark FolderH

	if (m_HRName != NULL){
		delete []m_HRName;
		m_HRName = NULL;
	}

	if (m_micsum_gen_uri != NULL){
		delete []m_micsum_gen_uri;
		m_micsum_gen_uri = NULL;	// Micro summary generate URL(Firefox 2)
	}
	if (m_micsum_expiration != NULL){
		delete []m_micsum_expiration;
		m_micsum_expiration = NULL;	// Micro summary expiration(Firefox 2)
	}
	if (m_generatedTitle != NULL){
		delete []m_generatedTitle;
		m_generatedTitle = NULL;	// Generated title(Firefox 2)
	}
	if (m_icon_uri != NULL){
		delete []m_icon_uri;
		m_icon_uri = NULL;			// ACRURI(Gran Paradiso)
	}
}

/**
 *	CX^X̓eɏlB<br>
 *	RXgN^p
 *
 */
void MozillaBookmark::_init()
{
	m_id = NULL;			// fBNgID
	m_charset = NULL;		// R[h
	m_check = 0;			// ŏIXVmF
	m_Firefoxicon = NULL;	// ACR(Firefox)
	m_FeedUrl = NULL;		// RSS feed URL
	m_schedule = NULL;		// XVmFXPW[
	m_group = 0;			// tH_O[vǂ
	m_LinkbarFolder = 0;	// c[o[tH_ǂ
	m_HRName = NULL;	// ؂̃x
	m_webPanel = false;
	m_NewSearchFolder = false;	// New Internet Search FolderH
	m_NewBookmarkFolder = false;	// New Bookmark FolderH
	m_micsum_gen_uri = NULL;	// Micro summary generate URL(Firefox 2)
	m_micsum_expiration = NULL;	// Micro summary expiration(Firefox 2)
	m_generatedTitle = NULL;	// Generated title(Firefox 2)
	m_icon_uri = NULL;			// ACRURI(Gran Paradiso)

}

/**
 * CX^X̃Rs[(ubN}[Nʏ)
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 */
void MozillaBookmark::_copy(const MozillaBookmark &src)
{
	if (src.getID() != NULL)
		setID(src.getID());

	if (src.getCharset() != NULL)
		setCharset(src.getCharset());

	setCheck(src.getCheck());

	if (src.getFirefoxIcon() != NULL)
		setFirefoxIcon(src.getFirefoxIcon());

	if (src.getFeedUrl() != NULL)
		setFeedUrl(src.getFeedUrl());

	if (src.getSchedule() != NULL)
		setSchedule(src.getSchedule());

	setGroup(src.getGroup());
	setLinkbarFolder(src.getLinkbarFolder());
	setWebPanel(src.getWebPanel());
	setNewSearchFolder(src.getNewSearchFolder());
	setNewBookmarkFolder(src.getNewBookmarkFolder());

	if (src.getHRName() != NULL)
		setHRName(src.getHRName());

	if (src.getMicsum_gen_uri() != NULL)
		setMicsum_gen_uri(src.getMicsum_gen_uri());

	if (src.getMicsum_expiration() != NULL)
		setMicsum_expiration(src.getMicsum_expiration());

	if (src.getGeneratedTitle() != NULL)
		setGeneratedTitle(src.getGeneratedTitle());

	if (src.getIconUri() != NULL)
		setIconUri(src.getIconUri());

}

MozillaBookmark & MozillaBookmark::operator = (const MozillaBookmark &src)
{
	copy(src);
	return *this;
}

// ubN}[NRs[B
void MozillaBookmark::copy(const MozillaBookmark &src)
{
	reset();
	_copy(src);
}

char *MozillaBookmark::setID(const char *item)
{
	char *p;
	int len;
	
	if (m_id != NULL){
		delete []m_id;
		m_id = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_id = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *MozillaBookmark::setCharset(const char *item)
{
	char *p;
	int len;
	
	if (m_charset != NULL){
		delete []m_charset;
		m_charset = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_charset = p;
	}catch(...){
		return NULL;
	}
	return p;
}

time_t MozillaBookmark::setCheck(const char *item)
{
	char *p;

	m_check = (time_t)strtoul(item,&p,10);

	return m_check;

}

char *MozillaBookmark::setSchedule(const char *item)
{
	char *p;
	int len;
	
	if (m_schedule != NULL){
		delete []m_schedule;
		m_schedule = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_schedule = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *MozillaBookmark::setHRName(const char *item)
{
	char *p;
	int len;
	
	if (m_HRName != NULL){
		delete []m_HRName;
		m_HRName = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_HRName = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *MozillaBookmark::setFirefoxIcon(const char *item)
{
	char *p;
	int len;
	
	if (m_Firefoxicon != NULL){
		delete []m_Firefoxicon;
		m_Firefoxicon = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_Firefoxicon = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *MozillaBookmark::setFeedUrl(const char *item)
{
	char *p;
	int len;
	
	if (m_FeedUrl != NULL){
		delete []m_FeedUrl;
		m_FeedUrl = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_FeedUrl = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *MozillaBookmark::setMicsum_gen_uri(const char *item)
{
	char *p;
	int len;
	
	if (m_micsum_gen_uri != NULL){
		delete []m_micsum_gen_uri;
		m_micsum_gen_uri = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_micsum_gen_uri = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *MozillaBookmark::setMicsum_expiration(const char *item)
{
	char *p;
	int len;
	
	if (m_micsum_expiration != NULL){
		delete []m_micsum_expiration;
		m_micsum_expiration = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_micsum_expiration = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *MozillaBookmark::setGeneratedTitle(const char *item)
{
	char *p;
	int len;
	
	if (m_generatedTitle != NULL){
		delete []m_generatedTitle;
		m_generatedTitle = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_generatedTitle = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * ACRURIݒ肷B(Gran Paradiso)
 *
 * @param item ACRURL)
 * @return ݒ肵URIւ̃|C^
 */
char *MozillaBookmark::setIconUri(const char *item)
{
	char *p;
	int len;
	
	if (m_icon_uri != NULL){
		delete []m_icon_uri;
		m_icon_uri = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_icon_uri = p;
	}catch(...){
		return NULL;
	}
	return p;
}

