#ifndef IEWRITER_H
#define IEWRITER_H

#include	<vector>

#include	"BScommon.h"
#include	"Bookmark.h"
#include	"BSStringHolder.h"
#include	"IBookmarkWriter.h"
#include	"Logger.h"

class IeWriter : public IBookmarkWriter {

private:
	char *mbPath;
	wchar_t *wcPath;
	wchar_t *regPath;

	// CɓtH_gbv̕
	int topPathLen;

	// IeWriter.hŎgp
	char *urlBuf;	// URLϊpꎞobt@

	int toIEFileURL(char *ieURL,const char *mozURL);

	int storeFolder(char *scFile,Bookmark *bookmark);
	int storeFolderW(wchar_t *scFile,Bookmark *bookmark);
	int storeBookmark(BSStringHolder &filename,Bookmark *bookmark);

	BOOL WritePrivateProfileStringEx(BSStringHolder &section,BSStringHolder &key,const char *str,BSStringHolder &filename);
	void putWriteError(const char *message,BSStringHolder &scFile);
	int writeOrderKey(wchar_t *key);
	void initOrderInfo(unsigned char *info);
	void setOrderInfo(wchar_t *path);
	void setOrderInfoEdge(wchar_t *path, bool isFolder);
	int writeOrder(wchar_t *key, unsigned char *buf, long size);
	void writeOrderInfoHeader(void);

	INT_TIME_T m_chgTime;
	bool overwriteMode;
	bool manageOrder;

	int m_browserNumber;	// uEUԍ
	int wcPrefix;	// CĥƂ̃pX̓ɕtB
	bool placesPut;	// Firefox 3̃X}[gubN}[NtH_o͂邩ǂH
	bool isEdge;	// CɓEdgê̂H

	int level;
	int orgLevel;
	std::vector<unsigned char *> orderInfo;	// ԏ
	std::vector<int> orderInfoCurrent;	// ԏ݈̏ʒu
	std::vector<int> orderItems;			// ԏ̐
	std::vector<int> orderInfoSize;		// ԏ̃TCY
	Logger *logger;

public:
	// IbookmarkTree̎B
	IeWriter(bool isEdgeValue);
	~IeWriter();

	bool getOverwriteMode(void){	return overwriteMode;}
	bool setOverwriteMode(bool mode){	overwriteMode = mode;return mode;}
	int getBrowserNumber(void) {	return m_browserNumber;	};
	int setBrowserNumber(int BrowserNumber) {	m_browserNumber = BrowserNumber;return m_browserNumber;	};

	void setFavoritesFolder(const char *folder);
	void setFavoritesFolderW(const wchar_t *folder);

	/* ubN}[No̓C^[tFCXCvg */
	void putHeader(void) {};	// Pt@Cł͂Ȃ̂ŉȂ
	void putFolder(Bookmark *item);
	void putFolderEnd(Bookmark *item,bool isLast);
	void putBookmark(Bookmark *item,bool isLast);
	void putFooter(void);
	void setPlacesPut(bool mode) {
		placesPut = mode;
	}

	bool getManageOrder(void) {
		return manageOrder;
	}
	void setManageOrder(bool value) {
		manageOrder = value;
	}
	void setLogger(Logger *loggerObj) {
		logger = loggerObj;
	}

};

extern int g_verbose;

#endif	// IEWRITER_H
