//#if defined(_DEBUG) && defined(_MSC_VER)
//#define _CRTDBG_MAP_ALLOC
//#endif

#include	<stdlib.h>

//#if defined(_DEBUG) && defined(_MSC_VER)
//#include	<crtdbg.h>
//#endif

#include	<fstream>
#include	<iostream>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>

#include	"NTfunction.h"
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"
#include	"BSStringHolder.h"

#include	"IeUtil.h"
#include	"IeWriter.h"
#include	"IeOrder.h"

#ifdef __BORLANDC__
#define	_stricmp stricmp
#endif

#define LANGUAGES 2

const char *IeWriter_message[5] = {
	"C^[lbgV[gJbgt@C݂̏Ɏs܂B\nt@C:",
	"fBNg̍쐬Ɏs܂B\nfBNg:",
	"łɃtH_Ɠ̃t@C݂Ă܂B\n",
	"XV\n",
	"XVȂ\n",
};

/**
 * RXgN^
 */
IeWriter::IeWriter(bool isEdgeValue)
{
	isEdge = isEdgeValue;
	g_isEdge = isEdgeValue;

	mbPath = NULL;
	wcPath = NULL;
	regPath = NULL;
	try{
		mbPath = new char[BUFLEN];
		if (mbPath == NULL){
			return;
		}
		wcPath = new wchar_t[BUFLEN];
		if (wcPath == NULL){
			delete []mbPath;
			return;
		}
		regPath = new wchar_t[BUFLEN];
		if (regPath == NULL){
			delete []wcPath;
			delete []mbPath;
			return;
		}
	}catch(...){
		if (wcPath != NULL) {
			delete []wcPath;
		}
		if (mbPath != NULL){
			delete []mbPath;
		}
		return;
	}

	overwriteMode = true;

	try{
		urlBuf = new char[BUFLEN];
		if (urlBuf == NULL){
			delete []regPath;
			delete []mbPath;
			delete []wcPath;
			return;
		}
	}catch(...){
		delete []regPath;
		delete []mbPath;
		delete []wcPath;
		return;
	}

	wcPrefix = 0;	// \\?\`gȂ̂œɂ0
	placesPut = true;
	
	// Cɓ̏Ԃ\WXg̈ʒuIEEdgeňقȂ̂Ōʐݒ
	if (isEdge) {
		wcscpy(regPath, edgeOrderKeyW);
	} else {
		wcscpy(regPath, favoriteOrderKeyW);
	}

	level = 0;
	orgLevel = 0;

	unsigned char *order = (unsigned char *)calloc(BUFLEN, 1);
	orderInfo.push_back(order);
	orderInfoCurrent.push_back(0);
	orderItems.push_back(0);
	orderInfoSize.push_back(BUFLEN);
	if (order != NULL) {
		initOrderInfo(order);
	}
	manageOrder = true;
}

/**
 * fXgN^
 */
IeWriter::~IeWriter()
{
	if (regPath != NULL) {
		delete []regPath;
	}
	if (wcPath != NULL){
		delete []wcPath;
	}
	if (mbPath != NULL){
		delete []mbPath;
	}

	delete []urlBuf;

	// ԏ
	int size = orderInfo.size();
	for (int i = 0; i < size; i++) {
		if (orderInfo[i] != NULL) {
			free(orderInfo[i]);
		}
	}}

#define COPYCHAR(p,c)  if (p != NULL){*p = c;p++;}

/**
 * file:URL\LIEpɒB([Jt@Cp)
 *
 * @param escapedUrl ϊURL
 * @param srcUrl ϊURL
 * @return ϊ̕
 */
int IeWriter::toIEFileURL(char *escapedUrl,const char *srcUrl)
{
	int escaped;
	char c;

	logger->trace("toIEFileURL start");

	escaped = 0;
	while (*srcUrl) {
		switch (*srcUrl) {
			case ' ':
			case '%':
			case '#':
			case '&':
			case '[':
			case ']':
				c = *srcUrl;
				sprintf(escapedUrl,"%%%02X",((int)c & 0xff));
				escapedUrl += 3;
				escaped += 3;
				break;
			default:
				*escapedUrl = *srcUrl;
				escapedUrl++;
				escaped++;
				break;
		}
		srcUrl++;
	}
	*escapedUrl = '\0';

	logger->trace("toIEFileURL end");
	return 0;
}

/**
 * tH_쐬B(Windows 9xn)
 *
 * @param scFile tH_̃pX
 * @param bookmark ubN}[N̏
 * @return 0:쐬 1:쐬s
 */
int IeWriter::storeFolder(char *scFile,Bookmark *bookmark)
{
	DWORD dwAttr;
	int ret = 0;

	logger->trace("storeFolder start");

	dwAttr = GetFileAttributes(scFile);
	if (dwAttr == 0xffffffff){
		// fBNg݂Ȃꍇ͍쐬B
		if (_mkdir(scFile)){
			putMessageWithInfo(IeWriter_message[1],scFile);
			ret = 1;
			logger->debug("directory create error");
		}
	}else if (!(dwAttr & FILE_ATTRIBUTE_DIRECTORY)){
		// ̃t@C݂G[ƂB
		putMessage(IeWriter_message[2]);
		ret = 1;
		logger->debug("directory create error");
	}
	
	logger->trace("storeFolder end");
	return ret;
}

/**
 * tH_쐬B(Windows NTn)
 *
 * @param scFile tH_̃pX
 * @param bookmark ubN}[N̏
 * @return 0:쐬 1:쐬s
 */
int IeWriter::storeFolderW(wchar_t *scFile,Bookmark *bookmark)
{
	DWORD dwAttr;
	int ret = 0;

	logger->trace("storeFolderW start");

	dwAttr = gGetFileAttributesW(scFile);
	if (dwAttr == 0xffffffff){
		// printf("1\n");
		// fBNg݂Ȃꍇ͍쐬B
		if (!gCreateDirectoryW(scFile,NULL)){
			// printf("2\n");
			putMessageWithInfoW(IeWriter_message[1],scFile);
			ret = 1;
			logger->debug("directory create error");
		}
	}else if (!(dwAttr & FILE_ATTRIBUTE_DIRECTORY)){
		// printf("3\n");
		// ̃t@C݂G[ƂB
		putMessage(IeWriter_message[2]);
		ret = 1;
		logger->debug("directory create error");
	}
	
	logger->trace("storeFolder end");
	return ret;
}

// INIt@C(IÊCɓ)p萔
static BSStringHolder cNULL(NULL,NULL);
static BSStringHolder cSECTION(MAKEDUALLITERAL("InternetShortcut"));
static BSStringHolder cURL(MAKEDUALLITERAL("URL"));
static BSStringHolder cICONFILE(MAKEDUALLITERAL("IconFile"));
static BSStringHolder cICONINDEX(MAKEDUALLITERAL("IconIndex"));
static BSStringHolder cWEBSLICESECTION(MAKEDUALLITERAL("MonitoredItem"));
static BSStringHolder cFEEDURL(MAKEDUALLITERAL("FeedUrl"));
static BSStringHolder cPREVIEWSIZE(MAKEDUALLITERAL("PreviewSize"));
static BSStringHolder cLIVEPREVIEW(MAKEDUALLITERAL("IsLivePreview"));

/**
 *	INIt@Cނ߂̃bp
 * @param section ރZNV
 * @param key ރL[
 * @param str ޕ(NTn:UTF-8/ASCII 9xn:}`oCg)
 * @param filename ރt@C
 */
BOOL IeWriter::WritePrivateProfileStringEx(BSStringHolder &section,BSStringHolder &key,const char *str,BSStringHolder &filename)
{
	BOOL result;
	
	logger->trace("WritePrivateProfileStringEx start");

	if (g_isWinNT){
		wchar_t *p;

		// p = mbtowcInternal(str);
		if (str != NULL){
			p = UTF8towcFileNameInternal(str);
		}else{
			p = NULL;	// l̏
		}

		//MessageBox(NULL,"Attach!","",MB_OK);
		result = gWritePrivateProfileStringW(section,key,p,filename);
		//int e = GetLastError();
		//MessageBox(NULL,"Attach!","",MB_OK);
	}else{
		result = WritePrivateProfileString(section,key,str,filename);
	}
	
	logger->trace("WritePrivateProfileStringEx end");
	return result;
}

/**
 * Cɓ菑ݎ̃G[bZ[Wo͂B
 *
 * @param message G[bZ[W
 * @param scFile t@C
 */
void IeWriter::putWriteError(const char *message,BSStringHolder &scFile)
{
	if (g_isWinNT) {
		putMessageWithInfoW(message,scFile);
	} else {
		putMessageWithInfo(message,scFile);
	}
}

/**
 * ubN}[N(Cɓ)쐬B
 *
 * @param scFile t@C
 * @param bookmark ރubN}[N̏
 * @return 0: 1:s
 */
int IeWriter::storeBookmark(BSStringHolder &scFile,Bookmark *bookmark)
{
	char *p;		// R[hϊobt@̃|C^

	logger->trace("storeBookmark start");

	// IEɂ̓Zp[^ȂĂ̂͂Ȃ̂ŉɏݐƂB
	if (bookmark->getSeparator()) {
		logger->trace("storeBookmark end");
		return 0;
	}

	Bookmark *mozBookmark;

	mozBookmark = bookmark;

	m_chgTime = bookmark->getAdddate();
	if (m_chgTime < (INT_TIME_T)bookmark->getLastvisit()){
		m_chgTime = bookmark->getLastvisit();
	}

	// URL̏
	if (bookmark->getURL() != NULL) {
		// file:ȊÔƂ͂̂܂܏
		if (strncmp("file:", bookmark->getURL(),5) == 0){
			toIEFileURL(urlBuf, bookmark->getURL());
		} else {
			strcpy(urlBuf, bookmark->getURL());
		}
	}else{
		urlBuf[0] = '\0';
	}

	if (!g_isWinNT){
		// NTnȊO̓}`oCgɒB݂̌̏̓}`oCĝ܂܂ŏ܂B
		p = UTF8tombInternal(urlBuf);
	}else{
		p = urlBuf;
	}

	if (p == NULL){
		logger->debug("storeBookmark url convert error");
		return 1;
	}

	if (!WritePrivateProfileStringEx(cSECTION,cURL,p,scFile)){
		putWriteError(IeWriter_message[0],scFile);
		logger->trace("storeBookmark error end");
		return 1;
	}

	// ACRMozillaIEŕ\LʂȂ̂ŃRo[gB
	if (mozBookmark->getIcon() != NULL){
		// Firefox 1.0̃ACR͕ʈ
		if (strncmp(mozBookmark->getIcon(),"data:",5)){
			if (!WritePrivateProfileStringEx(cSECTION,cICONFILE,mozBookmark->getIcon(),scFile)){
				putWriteError(IeWriter_message[0],scFile);
			}
			if (!WritePrivateProfileStringEx(cSECTION,cICONINDEX,"1",scFile)){
				putWriteError(IeWriter_message[0],scFile);
			}
		}
	}else{
		if (!WritePrivateProfileStringEx(cSECTION,cICONFILE,NULL,scFile)){
			putWriteError(IeWriter_message[0],scFile);
		}
		if (!WritePrivateProfileStringEx(cSECTION,cICONINDEX,NULL,scFile)){
			putWriteError(IeWriter_message[0],scFile);
		}
	}

	// WebSlice֘Ȁ
	if (mozBookmark->getIeBookmark()->getFeedUrl() != NULL) {
		if (mozBookmark->getURL() != NULL) {
			if (!strcmp(mozBookmark->getIeBookmark()->getFeedUrl(),mozBookmark->getURL())) {
				// URLWebXCXURLsB

				// FeedUrl
				p = mozBookmark->getIeBookmark()->getFeedUrl();
				if (p != NULL) {
					if (!WritePrivateProfileStringEx(cWEBSLICESECTION, cFEEDURL, p, scFile)) {
						putWriteError(IeWriter_message[0], scFile);
						logger->trace("storeBookmark error end");
						return 1;
					}
				}

				// PreviewSize
				p = mozBookmark->getIeBookmark()->getPreviewSize();
				if (p != NULL) {
					if (!WritePrivateProfileStringEx(cWEBSLICESECTION, cPREVIEWSIZE, p, scFile)) {
						putWriteError(IeWriter_message[0], scFile);
						logger->trace("storeBookmark error end");
						return 1;
					}
				}

				// IsLivePreview
				if (mozBookmark->getIeBookmark()->getLivePreview()) {
					if (!WritePrivateProfileStringEx(cWEBSLICESECTION,cLIVEPREVIEW,"true",scFile)){
						putWriteError(IeWriter_message[0],scFile);
						logger->trace("storeBookmark error end");
						return 1;
					}
				} else {
					if (!WritePrivateProfileStringEx(cWEBSLICESECTION,cLIVEPREVIEW,NULL,scFile)){
						putWriteError(IeWriter_message[0],scFile);
						logger->trace("storeBookmark error end");
						return 1;
					}
				}
			} else {
				// WebXCX֘AS폜
				if (!WritePrivateProfileStringEx(cWEBSLICESECTION,cNULL,p,scFile)){
					putWriteError(IeWriter_message[0],scFile);
					logger->trace("storeBookmark error end");
					return 1;
				}
			}
		}
	}

	// Cɓt@CtbVB
	WritePrivateProfileStringEx(cNULL,cNULL,NULL,scFile);

	if (m_chgTime != 0){
		if (g_isWinNT){
			setulFileTimeW(scFile,m_chgTime,bookmark->getAdddate());
		}else{
			setulFileTime(scFile,m_chgTime,bookmark->getAdddate());
		}
	}

	logger->trace("storeBookmark end");
	return 0;

}

/**
 * IÊCɓ̏ԏރL[쐬B
 *
 * @param key L[
 * @return 0: 1:s
 */
int IeWriter::writeOrderKey(wchar_t *key)
{
	LONG result;
	HKEY hKey;

	logger->trace("writeOrderKey start");

	if (!manageOrder) {
		return 0;
	}

	if (key == NULL) {
		return 1;
	}

	// WXg̃L[B
	result = RegCreateKeyExW(HKEY_CURRENT_USER,key,
		0,NULL,REG_OPTION_NON_VOLATILE,
		KEY_WRITE,NULL,&hKey,NULL);
	if (result != ERROR_SUCCESS){
		return 1;
	}
	RegCloseKey(hKey);

	logger->trace("writeOrderKey end");
	return 0;
}

/**
 * IÊCɓ̏ԏރL[쐬B
 *
 * @param key L[
 * @return 0: 1:s
 */
int IeWriter::writeOrder(wchar_t *key, unsigned char *buf, long size)
{
	LONG result;
	HKEY hKey;

	logger->trace("writeOrderKey start");

	if (!manageOrder) {
		logger->trace("writeOrderKey end");
		return 0;
	}
	if (key == NULL) {
		logger->trace("writeOrderKey error end");
		return 1;
	}
	if (buf == NULL) {
		logger->trace("writeOrderKey error end");
		return 1;
	}

	// WXg̃L[B
	result = RegCreateKeyExW(HKEY_CURRENT_USER,key,
		0,NULL,REG_OPTION_NON_VOLATILE,
		KEY_WRITE,NULL,&hKey,NULL);
	if (result != ERROR_SUCCESS){
		logger->trace("writeOrderKey error end");
		return 1;
	}

	RegSetValueEx(hKey, "Order", 0, REG_BINARY, (const BYTE *)buf, size);
	RegCloseKey(hKey);

	logger->trace("writeOrderKey end");
	return 0;
}

/**
 * IÊCɓ̏ԏB<br>
 * ԏ0ŏĂKvB
 *
 * @param info IÊCɓ̏ԏi[̈
 */
void IeWriter::initOrderInfo(unsigned char *info)
{

	// wb_̂A0ȊOŎOɒl܂Ăӏݒ肷B
	if (isEdge) {
		info[0] = 0x0c;
		info[4] = 0x0a;
		// }[J[̂悤Ȃ́H
		info[16] = 0x01;
		// TCY
		orderInfoCurrent[level] = 24;
	} else {
		info[0] = 0x08;
		info[4] = 0x02;
		// }[J[̂悤Ȃ́H
		info[12] = 0x01;
		// TCY
		orderInfoCurrent[level] = 20;
	}
	// CɓEtH_̌
	orderItems[level] = 0;

}

/**
 * ԏݒ肷(IEp)B
 *
 * @param path ԏݒ肷tH_Et@C̃tpX
 */
void IeWriter::setOrderInfo(wchar_t *path)
{
	unsigned char *item;
	unsigned char *p;
	int order = orderItems[level];
	long size;
	long total;

	logger->trace("setOrderInfo start");

	if (path == NULL) {
		logger->trace("setOrderInfo error end");
		return;
	}
	if (orderInfo[level] == NULL) {
		logger->trace("setOrderInfo error end");
		return;
	}

	// ITEMIDLIST擾B
	item = (unsigned char *)createIDList(path);
	if (item == NULL) {
		logger->trace("setOrderInfo error end");
		return;
	}
	size = item[1];
	size = size << 8;
	size = size + item[0];
	total = size;

	if (size & 1) {
		total++;
	}
	total += 14;	// TCYi[̈ƏԂƃtO2oCg
	if ((orderInfoCurrent[level] + total) > orderInfoSize[level]) {
		unsigned char *newBuf = (unsigned char *)realloc(orderInfo[level], orderInfoSize[level] * 2);
		if (newBuf == NULL) {
			orderInfo[level] = NULL;
			free(item);
			logger->trace("setOrderInfo error end");
			return;
		}
		orderInfoSize[level] = orderInfoSize[level] * 2;
		orderInfo[level] = newBuf;
	}

	// TCY
	long offset = orderInfoCurrent[level];
	long tmp = total;
	for (int i = 0; i < 4; i++) {
		p = orderInfo[level] + offset + i;
		*p = (unsigned char)(tmp & 0xff);
		tmp = tmp >> 8;
	}

	// 
	offset += 4;
	tmp = order;
	for (int i = 0; i < 4; i++) {
		p = orderInfo[level] + offset + i;
		*p = (unsigned char)(tmp & 0xff);
		tmp = tmp >> 8;
	}

	// ITEMIDLIST
	offset += 4;
	memcpy(orderInfo[level] + offset, item, size);
	offset += size;

	// Padding
	if (size & 1) {
		p = orderInfo[level] + offset;
		*p = 0x00;
		offset++;
	}

	// ???
	for (int i = 0; i < 2; i++) {
		p = orderInfo[level] + offset + i;
		*p = 0x00;
	}

	// flag
	offset += 2;
	tmp = 0;
	for (int i = 0; i < 4; i++) {
		p = orderInfo[level] + offset + i;
		*p = (unsigned char)(tmp & 0xff);
		tmp = tmp >> 8;
	}

	orderInfoCurrent[level] = orderInfoCurrent[level] + total;
	orderItems[level] = order + 1;

	logger->trace("setOrderInfo end");
}

/**
 * ԏݒ肷(Edgep)B
 *
 * @param path ԏݒ肷tH_Et@C̃tpX
 * @param isFolder true:ޏ̓tH_ false:ޏ͂Cɓ
 */
void IeWriter::setOrderInfoEdge(wchar_t *path, bool isFolder)
{
	unsigned char *p;
	int order = orderItems[level];
	long total;

	logger->trace("setOrderInfoEdge start");

	if (path == NULL) {
		logger->debug("setOrderInfoEdge end");
		return;
	}
	if (orderInfo[level] == NULL) {
		logger->debug("setOrderInfoEdge end");
		return;
	}


	long offset = orderInfoCurrent[level];
	long tmp;
	offset += 4;

	// g[^TCY̎(DWORD)0
	tmp = 0;
	for (int i = 0; i < 4; i++) {
		p = orderInfo[level] + offset + i;
		*p = (unsigned char)(tmp & 0xff);
		tmp = tmp >> 8;
	}
	total = 8;
	offset += 4;

	//
	// CɓtH_gbṽpX
	//

	// ܂ACɓtH_gbv܂ł̕ZoB
	int topPathDelimLen = topPathLen + 1;
	// CɓtH_̑΃pX
	long relPathLen = wcslen(path + topPathDelimLen);

	// CɓtH_gbṽpXTCY
	tmp = (relPathLen + 1) * 2;
	for (int i = 0; i < 4; i++) {
		p = orderInfo[level] + offset + i;
		*p = (unsigned char)(tmp & 0xff);
		tmp = tmp >> 8;
	}
	total += 4;
	offset += 4;

	// CɓtH_gbṽpX
	memcpy(orderInfo[level] + offset, path + topPathDelimLen, relPathLen * 2);
	total += relPathLen * 2;
	offset += relPathLen * 2;

	// pX̎L'*'
	*(orderInfo[level] + offset) = '*';
	*(orderInfo[level] + offset + 1) = 0x00;

	total += 2;
	offset += 2;

	// tH_ECɓ薼(gq.url)
	wchar_t *lastDelim = wcsrchr(path, L'\\');
	wchar_t *name;
	if (lastDelim == NULL) {
		name = path;
	} else {
		name = lastDelim + 1;
	}
	long nameLen;
	if (!isFolder) {
		// gq̃`FbN
		wchar_t *ext = wcsrchr(name, L'.');
		if (ext == NULL) {
			nameLen = wcslen(name);
		} else {
			nameLen = wcslen(name);
			if (!wcsicmp(ext, L".url")) {
				// gqCɓ̊gq̏ꍇ͂̕
				nameLen -= 4;
			}
		}
	} else {
		nameLen = wcslen(name);
	}
	// ̏
	tmp = nameLen * 2 + 2;
	for (int i = 0; i < 4; i++) {
		p = orderInfo[level] + offset + i;
		*p = (unsigned char)(tmp & 0xff);
		tmp = tmp >> 8;
	}
	total += 4;
	offset += 4;

	// Ȍ
	memcpy(orderInfo[level] + offset, name, nameLen * 2);
	total += nameLen * 2;
	offset += nameLen * 2;

	// pX̎L'*'
	*(orderInfo[level] + offset) = '*';
	*(orderInfo[level] + offset + 1) = 0x00;

	total += 2;
	offset += 2;

	// (DWORD) Kw(1`)
	tmp = level + 1;
	for (int i = 0; i < 4; i++) {
		p = orderInfo[level] + offset + i;
		*p = (unsigned char)(tmp & 0xff);
		tmp = tmp >> 8;
	}
	total += 4;
	offset += 4;

	// 
	if (isFolder) {
		tmp = 1;
	} else {
		tmp = 0;
	}
	for (int i = 0; i < 4; i++) {
		p = orderInfo[level] + offset + i;
		*p = (unsigned char)(tmp & 0xff);
		tmp = tmp >> 8;
	}
	total += 4;
	offset += 4;

	// TCY
	offset = orderInfoCurrent[level];
	tmp = total;
	for (int i = 0; i < 4; i++) {
		p = orderInfo[level] + offset + i;
		*p = (unsigned char)(tmp & 0xff);
		tmp = tmp >> 8;
	}

	orderInfoCurrent[level] = orderInfoCurrent[level] + total;
	orderItems[level] = order + 1;

	logger->trace("setOrderInfoEdge end");
}

/**
 * IÊCɓ̃tH_
 *
 * @param item ރubN}[ÑtH_
 */
void IeWriter::putFolder(Bookmark *item)
{
	int ret;	// ϊ
	char *sfn;
	wchar_t *wfn;

	logger->trace("putFolder start");

	if (item->getIeBookmark()->getFsDirName() != NULL) {
		// IEDscktop.iniŃt@Cw肳Ăꍇ
		wfn = item->getIeBookmark()->getFsDirName();
		sfn = wctombInternal(wfn);
		if (sfn == NULL) {
			// ܂AsȂƎvÔ߁B
			sfn = item->getIeName();
		}
	} else {
		// IEDscktop.iniŃt@Cw肳ĂȂꍇ
		if ((level == 0) && (item->getIeNameW() != NULL) &&
			(!wcscmp(item->getIeNameW(), gIeLinkDisplayW))) {
			// IÊCɓo[̖Ot@CVXe̖OɒB
			sfn = gIeLinkFolder;
			wfn = gIeLinkFolderW;
		} else {
			sfn = item->getIeName();
			wfn = item->getIeNameW();
		}
	}

	// tH_̃pX̍쐬(}`oCg)
	mbstrncatFit((unsigned char *)mbPath,(unsigned char *)"\\",247 /* _MAX_DIR */);
	/* \.url\0̕cČB */
	mbstrncatFit((unsigned char *)mbPath,(unsigned char *)sfn,248 /* _MAX_DIR */);

	int lenBefore = wcslen(wcPath);
	wcsncatFit(wcPath,L"\\",247 + wcPrefix);
	/* \.url\0̕cČB */
	wcsncatFit(wcPath,wfn,248 + wcPrefix);
	int lenAfter = wcslen(wcPath);

	if (lenBefore < lenAfter) {
		// ԊǗ̃WXg
		wcscat(regPath, L"\\");
		wcscat(regPath, wfn);

		// ԏݒ肷B
		if (manageOrder) {
			if (isEdge) {
				setOrderInfoEdge(wcPath, true);
			}
			else {
				setOrderInfo(wcPath);
			}
		}
		// ԊǗp
		level++;

		// Cɓ̏ԏݒ
		// L[쐬B
		int result = writeOrderKey(regPath);

		// Cɓ̏ԏ̏ݒ
		unsigned char *order = (unsigned char *)calloc(BUFLEN, 1);
		if (orderInfo.size() == level) {
			orderInfo.push_back(order);
			orderInfoCurrent.push_back(0);
			orderItems.push_back(0);
			orderInfoSize.push_back(BUFLEN);
		}
		else {
			orderInfo[level] = order;
			orderInfoCurrent[level] = 0;
			orderItems[level] = 0;
			orderInfoSize[level] = BUFLEN;
		}
		if (order != NULL) {
			initOrderInfo(order);
		}
	}

	orgLevel++;

	// tH_̃pX̍쐬(Unicode)
	if (g_isWinNT){
		ret = storeFolderW(wcPath,item);
	}else{
		ret = storeFolder(mbPath,item);
	}
	logger->trace("putFolder end");
}

/**
 * tH_̏I
 *
 */
void IeWriter::putFolderEnd(Bookmark *item,bool isLast)
{
	logger->trace("putFolderEnd start");

	if (level == orgLevel) {
		// ԏoB
		if (manageOrder) {
			// CɓEtH_̌Əԏ̃TCYݒ肵
			// WXgɏށB
			writeOrderInfoHeader();
		}

		// pX߂
		cutLast(mbPath);
		cutLastW(wcPath);
		cutLastW(regPath);

		if (manageOrder) {
			if (orderInfo[level] != NULL) {
				free(orderInfo[level]);
				orderInfo[level] = NULL;
			}
		}
		if (level > 0) {
			level--;
		}
	}
	orgLevel--;

	logger->trace("putFolderEnd end");
}

/**
 * IÊCɓ
 *
 * @param item ރubN}[N
 */
void IeWriter::putBookmark(Bookmark *item,bool isLast)
{
	int ret;
	char *descBuf = NULL;	// Netscape 4/6
	bool mbCatFlag = false;
	bool wcCatFlag = false;

	logger->trace("putBookmark start");

	if (!placesPut) {
		// Firefox 3̃X}[gubN}[NtH_炱𖳎B
		if (item->isPlaceURI()) {
			logger->trace("putBookmark end(no action)");
			return;
		}
	}

	if (item->getSeparator()) {
		// Zp[^IEɑ݂Ȃ̂ŔB
		logger->trace("putBookmark end(no action)");
		return;
	}

	int lenBefore = strlen(mbPath);
	// tH_؂
	mbstrncatFit((unsigned char *)mbPath,(unsigned char *)"\\",MAX_PATH - 4);
	// ubN}[N
	mbstrncatFit((unsigned char *)mbPath,(unsigned char *)item->getIeName(),MAX_PATH - 4);
	// gq
	mbstrncatFit((unsigned char *)mbPath,(unsigned char *)".url",MAX_PATH);
	int lenAfter = strlen(mbPath);
	// pX̊Kw̌vZ
	if (lenBefore < lenAfter){
		mbCatFlag = true;
	}

	lenBefore = wcslen(wcPath);
	// tH_؂
	wcsncatFit(wcPath,L"\\", MAX_PATH + wcPrefix - 4);
	// ubN}[N
	wcsncatFit(wcPath,item->getIeNameW(), MAX_PATH + wcPrefix - 4);
	// gq
	wcsncatFit(wcPath,L".url", MAX_PATH + wcPrefix);
	lenAfter = wcslen(wcPath);
	// pX̊Kw̌vZ
	if (lenBefore < lenAfter){
		wcCatFlag = true;
	}

	// ԏݒ肷B
	if (manageOrder) {
		if (isEdge) {
			setOrderInfoEdge(wcPath, false);
		} else {
			setOrderInfo(wcPath);
		}
	}

	BSStringHolder filename(wcPath,mbPath);
	ret = storeBookmark(filename,item);

	if (mbCatFlag){	// }`oCg̃ubN}[NpXɕǉꍇ
		cutLast(mbPath);
	}
	if (wcCatFlag){	// Ch̃ubN}[NpXɕǉꍇ
		cutLastW(wcPath);
	}

	logger->trace("putBookmark end");
}

/**
 * IÊCɓtH_ݒ肷(}`oCg)
 *
 * @param folder tH_̕
 */
void IeWriter::setFavoritesFolder(const char *folder)
{
	logger->trace("setFavoritesFolder start");

	strcpy(mbPath,folder);

	logger->trace("setFavoritesFolder end");
}

/**
 * IÊCɓtH_ݒ肷(Unicode)
 *
 * @param folder tH_̕
 */
void IeWriter::setFavoritesFolderW(const wchar_t *folder)
{
	logger->trace("setFavoritesFolderW start");

	wcscpy(wcPath,folder);
	topPathLen = wcslen(wcPath);

	logger->trace("setFavoritesFolderW end");
}

/**
 * ubN}[Ñt@CGhށB<br>
 * IÊCɓł͍ŏ̃tH_̏Ԃݒ肷̂ɎgpB
 */
void IeWriter::putFooter(void)
{
	logger->trace("putFooter start");

	level = 0;

	if (!manageOrder) {
		logger->trace("putFooter end");
		return;
	}

	// CɓEtH_̌Əԏ̃TCYݒ肵
	// WXgɏށB
	writeOrderInfoHeader();

	logger->trace("putFooter end");
}

/**
 * Cɓ̏ԏݒ肵WXgp̃f[^ɃTCYE̏
 * ݒ肵ďށB
 */
void IeWriter::writeOrderInfoHeader(void)
{
	logger->trace("writeOrderInfoHeader start");

	if (orderInfo[level] != NULL) {
		long offset;
		long tmp;
		unsigned char *p;

		// wb_oCiTCY̌vZ
		if (isEdge) {
			// TCYވʒu
			offset = 12;
			// ނCɓ菇̃TCY
			tmp = orderInfoCurrent[level] - 12;
		} else {
			// TCYވʒu
			offset = 8;
			// ނCɓ菇̃TCY
			tmp = orderInfoCurrent[level] - 8;
		}

		// wb_oCiTCY̏
		for (int i = 0; i < 4; i++) {
			p = orderInfo[level] + offset + i;
			*p = (unsigned char)(tmp & 0xff);
			tmp = tmp >> 8;
		}

		// Cɓ̌̏
		if (isEdge) {
			// Cɓ̌݈̏ʒu
			offset = 20;
		} else {
			// Cɓ̌݈̏ʒu
			offset = 16;
		}
		tmp = orderItems[level];
		for (int i = 0; i < 4; i++) {
			p = orderInfo[level] + offset + i;
			*p = (unsigned char)(tmp & 0xff);
			tmp = tmp >> 8;
		}
		writeOrder(regPath, orderInfo[level], orderInfoCurrent[level]);
	}

	logger->trace("writeOrderInfoHeader end");
}