#include	<string.h>
#include	<wchar.h>
#include	<assert.h>
#include	<windows.h>
#include	<shlobj.h>
#include	<shellapi.h>

#include	"bslib.h"
#include	"Bookmark.h"
#include	"url.h"
#include	"NTfunction.h"
#include	"encutil.h"
#include	"encutil2.h"

#define IEUTIL_CPP
#include	"IeUtil.h"

/**
 * IEŎgȂt@CEtH_ϊB
 *
 * @param bookmark ϊΏۂ̃ubN}[NIuWFNg
 */
void changeIeInvalidName(Bookmark *bookmark)
{
	assert(bookmark->getIeName() != NULL);

	/* IEŎgȂ̃`FbN */
	convFilename((unsigned char *)bookmark->getIeName());
	/* foCXǂ̃`FbN */
	if (isDeviceName(bookmark->getIeName())){
		int len;
		char *p;

		len = strlen(bookmark->getIeName());
		try{
			p = new char[len + 2];
			if (p == NULL){
				return;
			}

			// O̐擪-𒅂ăfoCXƏdȂ悤ɂB
			// IE̕ϊ@Ƃ͈قȂ邪A̕₷ƎvB
			strcpy(p,"-");
			strcat(p,bookmark->getIeName());

			bookmark->setName(p);
			delete []p;
		}catch(...){
			return;
		}
	}
}

/**
 * IEŎgȂt@CEtH_ϊB
 *
 * @param bookmark ϊΏۂ̃ubN}[NIuWFNg
 */
void changeIeInvalidNameW(Bookmark *bookmark)
{
	assert(bookmark->getIeNameW() != NULL);

	/* IEŎgȂ̃`FbN */
	convFilenameW(bookmark->getIeNameW());
	/* foCXǂ̃`FbN */
	if (isDeviceNameW(bookmark->getIeNameW())){
		int len;
		wchar_t *p;

		len = wcslen(bookmark->getIeNameW());
		try{
			p = new wchar_t[len + 2];
			if (p == NULL){
				return;
			}

			// O̐擪-𒅂ăfoCXƏdȂ悤ɂB
			// IE̕ϊ@Ƃ͈قȂ邪A̕₷ƎvB
			wcscpy(p,L"-");
			wcscat(p,bookmark->getIeNameW());

			bookmark->setIeNameW(p);
			delete []p;
		}catch(...){
			return;
		}
	}
}

/**
 * [JCYꂽtH_擾B(Windows Vistaȍ~̂)
 *
 * @param path 擾Ώۂ̃t@CVXẽtH_
 * @param buf 擾tH_̊i[
 * @param bufSize buf̃TCY
 * @return S_OK:擾ɐ S_OKȊO:G[
 */
HRESULT getLocalizedName(wchar_t *path,wchar_t *buf,int bufSize)
{
    IShellItem *pShellItem;  // XP & later
    HRESULT hRes; 

	// Shell Item IuWFNg̍쐬 
	hRes = gSHCreateItemFromParsingName(   // Vista or later
		path, NULL, IID_IShellItem, (void**)&pShellItem); 
	if(hRes == S_OK) {
        // O̎Q 
        LPWSTR pLocalizedName; 
        hRes = pShellItem->GetDisplayName(SIGDN_NORMALDISPLAY, &pLocalizedName);  //[10] 
		if (hRes == S_OK) {
			wcsncpy(buf, pLocalizedName, bufSize - 1);
			buf[bufSize - 1] = L'\0';
            ::CoTaskMemFree((LPVOID)pLocalizedName);  //[12] 
        } 

		pShellItem->Release();
    } 
 
    return hRes; 
}


/**
 * IE 7/8̃No[[`
 *
 * @param dllName \[Xԍ
 * @param resourceNo \[Xԍ
 * @param buf CɓtH_i[obt@
 * @param bufSize CɓtH_i[obt@TCY
 * @return -1:͎s 0:\[X擾s >0:\[X擾
 */
int getLinkbarName(char *dllName,int resourceNo,wchar_t *buf,int bufSize)
{
	int result;
	HMODULE hDll;

	hDll = LoadLibrary(dllName);
	if (hDll == NULL) {
		return 0;
	}

	result = gLoadStringW(hDll,resourceNo,buf,256);

	FreeLibrary( hDll );
	return result;
}

/**
 * IE7/8LocalizedResourceName̓[`
 *
 * @param resource \[XLq
 * @param buf CɓtH_i[obt@
 * @param bufSize CɓtH_i[obt@TCY
 * @return -1:͎s 0:\[X擾s >0:\[X擾
 */
int parseResourceName(char *resource,wchar_t *buf,int bufSize)
{
	char *p,*pDelim,pathBuf[256];
	int resourceNo;

	// f~^ƃ\[Xԍ̉
	pDelim = strchr(resource,',');
	if (pDelim == NULL) {
		return -1;
	}
	// DLLgݗ
	*pDelim = '\0';

	p = strstr(resource,"@%windir%");
	if (p == resource) {
		// strcpy(pathBuf,"C:\\Windows");
		GetWindowsDir(pathBuf);
		strcat(pathBuf,resource + 9);
	}
	p = strstr(resource,"@%systemroot%");
	if (p == resource) {
		// strcpy(pathBuf,"C:\\Windows");
		GetWindowsDir(pathBuf);
		strcat(pathBuf,resource + 13);
	}

	pDelim++;
	if (*pDelim == '-') {
		resourceNo = atoi(pDelim + 1);
	} else {
		return -1;
	}
	return getLinkbarName(pathBuf,resourceNo,buf,bufSize);
}

/**
 * IE7/8desktop.ini̓[`
 *
 * @param path desktop.inĩpX
 * @param buf CɓtH_i[obt@
 * @param bufSize CɓtH_i[obt@TCY
 * @return -2:\[X擾s -1:͎s 0:\[X擾s >0:\[X擾
 */
int getDesktopIni(wchar_t *path,wchar_t *buf,int bufSize)
{
	wchar_t resourceBuf[256];
	char resourceBuf2[256];
	
	resourceBuf[0] = L'\0';
	gGetPrivateProfileStringW(
		L".ShellClassInfo",
		L"LocalizedResourceName",
		L"",
		resourceBuf,
		256,
		path);
	if (resourceBuf[0] == L'\0') {
		return -2;
	}

	wcstombs(resourceBuf2,resourceBuf,256);

	return parseResourceName(resourceBuf2,buf,bufSize);
}

/**
 * IẼNo[/Cɓo[̕\擾B<br>
 * i[gIeLinkDisplayAgIeLinkDisplayW
 */
int getIeLinkDisplay()
{
	char buf[MAX_PATH];
	wchar_t bufW[MAX_PATH];

	if (getIeMajorVersion() < 7) {
		// IE6ȑO͕\ƃtH_
		getIeLinkbarFolder(gIeLinkDisplay,MAX_PATH);
		mbstowcs(gIeLinkDisplayW,gIeLinkDisplay,MAX_PATH);
		return 0;
	}
	if ((getIeMajorVersion() == 7) && (gWindowsMajorVersion < 6)) {
		// IE 7 on XP͖̌Œ
		strcpy(gIeLinkDisplay,IE7_LINK_NAME_JP);
		wcscpy(gIeLinkDisplayW,IE7_LINK_NAME_JP_W);
		return 0;
	}

	// IE 7 on Vista,IE8

	// NtH_zdesktop.inĩpXgݗĂ
	getIEfavoriteFolder(buf);
	strcat(buf,"\\");

	if (gWindowsMajorVersion > 5) {
		// Vista
		strcat(buf,IE7_LINK_NAME);
	} else {
		// 2000/XP
		strcat(buf,IE7_LINK_NAME_JP);
	}
	strcat(buf,"\\");
	strcat(buf,"desktop.ini");
	mbstowcs(bufW,buf,256);

	int result = getDesktopIni(bufW,gIeLinkDisplayW,MAX_PATH);
	if (result > 0) {
		// desktop.ini鎞̖O
		wcstombsByte(gIeLinkDisplay,gIeLinkDisplayW,MAX_PATH);
	} else {
		// desktop.iniȂ̖O
		if (gWindowsMajorVersion > 5) {
			// Vista
			strcpy(gIeLinkDisplay,IE7_LINK_NAME);
			wcscpy(gIeLinkDisplayW,IE7_LINK_NAME_W);
		} else {
			// 2000/XP
			strcpy(gIeLinkDisplay,IE7_LINK_NAME_JP);
			wcscpy(gIeLinkDisplayW,IE7_LINK_NAME_JP_W);
		}
	}
	return 0;

}

/**
 * t@CVXeIẼNo[tH_擾B
 *
 * @param buf No[tH_obt@
 * @param bufSize bufobt@̃TCY
 *
 * @return 0:擾s 1:擾
 *
 */
int getIeLinkbarFolder(char *buf,DWORD bufSize)
{
	LONG result;	// e֐̎sʁB
	HKEY hKey;		// WXgL[nh
	int setResult = 1;	// 

	if (getIeMajorVersion() > 6){
		// IE7ȍ~(?)̎̓No[tH_ߑłB
		// XPVistaňႤƂ̂͂ȂƂʓ|B
		if (gWindowsMajorVersion > 5){
			// Windows Vista or later
			// Windows Vistał̓No[tH_Links
			strcpy(buf,IE7_LINK_NAME);
		}else{
			// IE7 on Windows XPł N ߂
			strcpy(buf,IE7_LINK_NAME_JP);
		}
	}else{
		// IE6ȉ̎̓WXg烊NtH_̖O擾B
		
		// IẼo[WWXgL[JB
		result = RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Microsoft\\Internet Explorer\\Toolbar",0,
								KEY_READ,&hKey);

		if (result == ERROR_SUCCESS){
			buf[bufSize - 1] = '\0';
			bufSize--;
			// WXgL[J獡xVersionl擾B
			result = RegQueryValueEx(hKey,"LinksFolderName",NULL,NULL,
									(LPBYTE)buf,&bufSize);
			
			if (result != ERROR_SUCCESS){
				setResult = 0;
			}
			RegCloseKey(hKey);
		}else{
			setResult = 0;
		}
	}

	return setResult;

}

/**
 * IẼNo[/Cɓo[̃t@CVXe̖O擾B
 * i[gIeLinkFolderAgIeLinkFolderW
 */
int getIeLinkFolder()
{
	getIeLinkbarFolder(gIeLinkFolder,MAX_PATH);
	memset(gIeLinkFolderW,0,sizeof(wchar_t) * MAX_PATH);
	mbstowcsByte(gIeLinkFolderW,gIeLinkFolder,strlen(gIeLinkFolder));

	return 0;
}

/**
 * IÊCɓtH_擾B
 *
 * @param buf i[((MAX_PATH+1)Kv)
 */
void getIeFavoritesFolder(char *buf)
{
	LPITEMIDLIST pItemIDList;
	HRESULT hr;
	LPMALLOC pMalloc = NULL;//IMallocւ̃|C^
	HRESULT r;

	// CɓtH_̎擾
	r = SHGetSpecialFolderLocation(::GetDesktopWindow(),CSIDL_FAVORITES,&pItemIDList);
	if (r == NOERROR){
		hr = SHGetMalloc(&pMalloc);
		if (hr != E_FAIL) {
			// bufփpXƂĎ擾
			SHGetPathFromIDList(pItemIDList,buf);
			pMalloc->Free(pItemIDList);
			pMalloc->Release();
		}else{
			buf[0] = '\0';
			return;
		}
	}else{
		buf[0] = '\0';
		return;
	}

}

/**
 * EdgẽNo[/Cɓo[̃t@CVXe̖O擾B
 */
int getEdgeLinkFolder()
{
	strcpy(gEdgeLinkFolder, EDGE_LINK_NAME);
	memset(gEdgeLinkFolderW, 0, sizeof(wchar_t) * MAX_PATH);
	mbstowcsByte(gEdgeLinkFolderW, gEdgeLinkFolder, strlen(gEdgeLinkFolder));

	return 0;
}

