#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>

#include <windows.h>
#include <winbase.h>
#include <shlobj.h> 

#define IS_IEORDER 1

#include "NTfunction.h"
#include "bslib.h"
#include "clearKey.h"
#include "IeOrder.h"

// IÊCɓ̏Ԃi[ꂽWXgL[
const wchar_t *favoriteOrderKeyW =
	L"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\MenuOrder\\Favorites";
const char *favoriteOrderKey =
	"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\MenuOrder\\Favorites";

// EdgêCɓ̏Ԃi[ꂽWXgL[
const wchar_t *edgeOrderKeyW =
	L"SOFTWARE\\Classes\\Local Settings\\Software\\Microsoft\\Windows\\CurrentVersion\\AppContainer\\Storage\\microsoft.microsoftedge_8wekyb3d8bbwe\\MicrosoftEdge\\FavOrder\\Favorites";
const char *edgeOrderKey =
	"SOFTWARE\\Classes\\Local Settings\\Software\\Microsoft\\Windows\\CurrentVersion\\AppContainer\\Storage\\microsoft.microsoftedge_8wekyb3d8bbwe\\MicrosoftEdge\\FavOrder\\Favorites";

// ̂EdgêCɓ肩H
bool g_isEdge = false;

/**
 * ITEMIDLIST擾B
 *
 * @param name 擾Ώۂ̃t@CEfBNg̃tpX
 * @return NULL:ITEMIDLIST̎擾Ɏs NULL:擾ITEMIDLIST̃Rs[(freeŉ邱ƁB)
 */
char *createIDList(wchar_t *name)
{
	IShellFolder *shell;
	ULONG eaten;
	LPITEMIDLIST item;
	LPITEMIDLIST firstItem;
	LPITEMIDLIST lastItem = NULL;

	if (name == NULL) {
		return NULL;
	}

	HRESULT hr = SHGetDesktopFolder(&shell);
	if (FAILED(hr)) {
		// printf("SHGetDesktopFolder failed.");
		return NULL;
	}
	hr = shell->ParseDisplayName(NULL, NULL, name, &eaten, &item, NULL);
	if (FAILED(hr)) {
		// printf("SHGetDesktopFolder failed.");
		return NULL;
	}
	firstItem = item;

	SHITEMID mkid = item->mkid;
	int cb = mkid.cb;
	// printf("item size:%d\n",mkid.cb);
	// for (int i = 0; i < mkid.cb; i++) {
		// printf("%02x\n", *((char *)(item) + i));
	// }
	char *p;
	while (cb != 0) {
		lastItem = item;

		// ̗vfB
		p = (char *)item;
		p = p + mkid.cb;

		item = (LPITEMIDLIST)p;
		mkid = item->mkid;
		// printf("item size:%d\n",mkid.cb);
		cb = mkid.cb;

		/*
		for (int i = 0; i < mkid.cb; i++) {
			printf("%02.2x ", *((char *)(item) + i));
		}
		printf("\n");

		for (int i = 0; i < mkid.cb; i++) {
			printf("%c", *((char *)(item) + i));
		}
		printf("\n");
		*/
	}
	char *idList = NULL;
	if (lastItem != NULL) {
		mkid = lastItem->mkid;
		int size = mkid.cb;
		idList = (char *)calloc(size, 1);
		if (idList != NULL) {
			memcpy(idList, lastItem, size);
		}
	}

	CoTaskMemFree(firstItem);

	shell->Release();

	return idList;
}


/**
 * Ŏꂽʒu4oCggGfBAlonglɕϊB
 *
 * @param buf ϊΏ
 * @return l
 */
long getLongLE(unsigned char *buf)
{
	long value = 0;

	for (int i = 3; i >= 0;i--) {
		value = (value << 8) + *(buf + i);
	}
	return value;
}

/**
 * WXg̓eɓԂ߂B
 *
 * @param valueBuf WXg̒lobt@
 * @param target Ώۂ̃t@CEtH_
 * @return -2:G[ -1:Ȃ 0ȏ:WXg̈ʒu
 */
long findOrder(unsigned char *valueBuf, wchar_t *targetFile)
{
	unsigned char *p;
	long size = 0;
	long members = 0;
	long target;
	long entrySize;
	long order;
	ITEMIDLIST *item;
	wchar_t path[MAX_PATH];
	long result = -1;
	int firstNumber;	// ŏ4oCg1Ֆڂ̐
	int secondNumber;	// 4oCg1Ֆڂ̐

	p = valueBuf;
	if (g_isEdge) {
		firstNumber = 0x0c;
		secondNumber = 0x0a;
	} else {
		firstNumber = 0x08;
		secondNumber = 0x02;
	}

	/* wb_̉ */
	if (*p != firstNumber) {
		// printf("Illegal format.\n");
		return -2;
	}

	p = valueBuf + 4;
	if (*p != secondNumber) {
		// printf("Illegal format.\n");
		return -2;
	}

	// TCY
	if (g_isEdge) {
		p = valueBuf + 12;
	} else {
		p = valueBuf + 8;
	}
	size = getLongLE(p);
	// printf("Size - 8 bytes:%ld\n", size);

	// o
	if (g_isEdge) {
		p = valueBuf + 20;
	} else {
		p = valueBuf + 16;
	}
	members = getLongLE(p);
	// printf("Members:%ld\n", members);

	if (g_isEdge) {
		p = valueBuf + 24;
	} else {
		p = valueBuf + 20;
	}
	// eGg̉
	for (target = 0; target < members; target++) {
		entrySize = getLongLE(p);
		if (!g_isEdge) {
			order = getLongLE(p + 4);
			item = (LPITEMIDLIST)(p + 8);

			// printf("Entry size:%ld\n", entrySize);
			// printf("Order:%ld\n", order);

			SHITEMID mkid = item->mkid;
			// printf("SHITEMID cb:%d\n",mkid.cb);

			BOOL gotPath = SHGetPathFromIDListW(item, path);
			if (gotPath) {
				// ꂽpX̓fXNgbvtH_̈ʒu{t@CEtH_
				// printf("path:%s\n",path);
				wchar_t *orderFileName = wcsrchr(path, L'\\');
				orderFileName++;
				if (!_wcsicmp(orderFileName, targetFile)) {
					result = order;
					break;
				}
			}
		} else {
			// t@C؂oB
			order = target;
			long nameLen = getLongLE(p + 8);
			char buf[MAX_PATH * 2];
			memset(buf, 0, MAX_PATH * 2);
			memcpy(buf, p + 12, nameLen - 2);	// Ō̕*Ȃ̂łobt@ɃRs[B
			// t@C̃pX͑΃pXȂ̂Ńt@C؂oB
			wchar_t *orderPath = (wchar_t *)buf;
			wchar_t *orderFileName = wcsrchr(orderPath, L'\\');
			if (orderFileName == NULL) {
				orderFileName = orderPath;
			}
			if (!_wcsicmp(orderFileName, targetFile)) {
				result = order;
				break;
			}
		}

		// printf("\n");
		p += entrySize;
	}

	return result;
}

/**
 * WXg̏ԏl擾B
 *
 * @param hKey WXgL[
 * @return NULL:l擾s̓f[^s NULLȊO:Orderڂ̒l
 */
unsigned char *getOrderValue(HKEY hKey)
{
	DWORD bufSize;
	LONG result;
	unsigned char *valueBuf;

	// KvȃTCY̎擾
	result = RegQueryValueEx(hKey, "Order", 0, NULL, NULL, &bufSize);
	if (result != ERROR_SUCCESS) {
		// printf("Value size get failed.\n");
		return NULL;
	} else {
		// printf("Value size:%ld\n", bufSize);
	}
	if (g_isEdge) {
		if (bufSize < 16) {	// Edgeł16oCg̏ꍇ͐ȏԃf[^ł͂ȂB
			return NULL;
		}
	} else {
		if (bufSize < 12) {	// IEł12oCg̏ꍇ͐ȏԃf[^ł͂ȂB
			return NULL;
		}
	}

	valueBuf = (unsigned char *)calloc(bufSize, sizeof(unsigned char));
	if (valueBuf == NULL) {
		return NULL;
	}

	result = RegQueryValueEx(hKey, "Order", 0, NULL, (LPBYTE)valueBuf, &bufSize);
	if (result != ERROR_SUCCESS) {
		free(valueBuf);
		return NULL;
	} else {
		// f[^TCYĂ邩ǂ`FbNāAmFB
		// printf("Registry parse start.\n", bufSize);
		long prefixSize;	// WXg̃f[^TCY܂ł̒
		if (g_isEdge) {
			prefixSize = 12;
		} else {
			prefixSize = 8;
		}

		long dataSize;
		dataSize = getLongLE(valueBuf + prefixSize);

		if (bufSize != (dataSize + prefixSize)) {
			free(valueBuf);
			return NULL;
		}
	}
	return valueBuf;
}

/**
 * WXg̃L[JB
 *
 * @param keyName WXgL[
 * @return NULL:L[擾s NULL:L[擾
 */
unsigned char *getOrder(const char *keyName)
{
	HKEY hKey;		// WXgL[nh
	LONG result;

	// printf("TargetKey:%s\n",keyName);
	result = RegOpenKeyEx(HKEY_CURRENT_USER, keyName,0,
		KEY_READ | KEY_WRITE,&hKey);
	if (result != ERROR_SUCCESS) {
		// WXgL[݂Ȃ悤ȏꍇȂǃL[JȂꍇ
		// ǂ悤Ȃ̂łŔB
		return NULL;
	}

	unsigned char *valueBuf = getOrderValue(hKey);

	RegCloseKey(hKey);

	return valueBuf;
}

/**
 * IÊCɓ̏ԂNAB
 *
 */
void deleteIEFavoriteOrder()
{
	if (g_isWinNT){
		deleteKeysW(favoriteOrderKeyW);
	}else{
		deleteKeys(favoriteOrderKey);
	}
}

