#include	<stdlib.h>
#include	<new>
#include	<memory>

#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<io.h>
#include	<time.h>
#include	<wchar.h>
#include	<windows.h>
#include	<mbstring.h>
#include	<winreg.h>

#include	"NTfunction.h"
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"BSStringHolder.h"
#include	"url.h"

#include	"BookmarkTree.h"
#include	"Bookmark.h"

#include	"IeOrder.h"
#include	"IeFavoriteReader.h"
#include	"IeReader.h"
#include	"ieUtil.h"

/**
 * RXgN^
 *
 */
IeFavoriteReader::IeFavoriteReader(bool isEdgeValue)
{
	genBufW = new wchar_t[BUFLEN];
	level = 0;
	regKey = new char[BUFLEN + 80];
	isEdge = isEdgeValue;

	// Ԏ擾[`ɂEdgeǂ`B
	g_isEdge = isEdgeValue;

	if (isEdge) {
		strcpy(regKey, edgeOrderKey);
	} else {
		strcpy(regKey, favoriteOrderKey);
	}
	unsigned char *order = getOrder(regKey);
	orderInfo.push_back(order);
}

/**
 * fXgN^
 *
 */
IeFavoriteReader::~IeFavoriteReader(void)
{
	delete []genBufW;
	int size = orderInfo.size();
	for (int i = 0; i < size; i++) {
		if (orderInfo[i] != NULL) {
			free(orderInfo[i]);
		}
	}
}

/**
 *	INIt@Cǂݍނ߂̃bp
 * @param section ǂݍރZNV
 * @param key ǂݍރL[
 * @param initial ̕
 * @param buf 擾镶
 * @param size obt@̃TCY
 * @param filename ǂݍރt@C
 */
DWORD IeFavoriteReader::GetPrivateProfileStringEx(
	BSStringHolder &section,
	BSStringHolder &key,
	BSStringHolder &initial,
	char *buf,
	int size,
	BSStringHolder &filename)
{
	BOOL result;
	
	if (g_isWinNT){
		result = gGetPrivateProfileStringW(section,key,initial,genBufW,BUFLEN,filename);
		
		char *p;
		p = wctombInternal(genBufW);	// Unicode -> ASCII
		if (p != NULL){
			buf[size - 1] = '\0';
			strncpy(buf,p,size - 1);
		}
	}else{
		result = GetPrivateProfileString(section,key,initial,buf,size,filename);
	}
	
	return result;
}


/* IẼubN}[N擾B */
BSStringHolder cSECTION(MAKEDUALLITERAL("InternetShortcut"));
BSStringHolder cURL(MAKEDUALLITERAL("URL"));
BSStringHolder cEMPTY(MAKEDUALLITERAL(""));
BSStringHolder cICONFILE(MAKEDUALLITERAL("ICONFILE"));
BSStringHolder cWEBSLICESECTION(MAKEDUALLITERAL("MonitoredItem"));
BSStringHolder cFEEDURL(MAKEDUALLITERAL("FeedUrl"));
BSStringHolder cPREVIEWSIZE(MAKEDUALLITERAL("PreviewSize"));
BSStringHolder cLIVEPREVIEW(MAKEDUALLITERAL("IsLivePreview"));

/**
 * IẼubN}[N擾B
 *
 * @param bookmark i[IuWFNg
 * @param filename IÊCɓ̃tpX(}`oCg)
 * @param filenameW IÊCɓ̃tpX(Ch)
 * @param time IÊCɓ̍ŏIXV
 * @return 0:i[ 1:i[s
 */
int IeFavoriteReader::GetItem(Bookmark *bookmark,char *filename,wchar_t *filenameW,INT_TIME_T time)
{
	char *buf,*buf2;
	long result;
	char *p;
	BSStringHolder path(filenameW,filename);	// tpX
	
	logger->trace("GetItem\n");
	
	buf = buf2 = NULL;
	try{
		buf = new char[BUFLEN];
		if (buf == NULL){
			logger->debug("Temporary buffer allocate failed");
			return 1;
		}
		buf2 = new char[BUFLEN];
		if (buf2 == NULL){
			delete []buf;
			logger->debug("Temporary buffer allocate failed");
			return 1;
		}
	}catch(...){
		logger->debug("Temporary buffer allocate failed");
		if (buf != NULL)
			delete []buf;
		return 1;
	}
	
	// URL擾B
	result = GetPrivateProfileStringEx(cSECTION,
							cURL,cEMPTY,buf,BUFLEN,path);
	if (result == 0){
		logger->debug("URL get failed");
		delete []buf;
		delete []buf2;
		return 1;
	}

	p = mbtoUTF8Internal(buf);
	if (p == NULL){
		logger->debug("URL encode convert failed");
		delete []buf;
		delete []buf2;
		return 1;
	}

	if (strncmp("file:", p,5) == 0){
		// file:̓p[ZgGR[fBOĂ̂ŃfR[hB
		decodeURL(buf2, p);
	} else if (strncmp("javascript:", p,11) == 0) {
		// javascript:̂Ƃ̓GR[hȂ
		strcpy(buf2, p);
	} else {
		// file:ȊÔƂ
		// VistaIE7͔ASCIIB
		// XPIE6/7͔ASCII̓GR[hȂ
		encodeNonAsciiURL(buf2, p);
	}

	bookmark->setURL(buf2);

	if (bookmark->getAdddate() == 0){
		bookmark->setAdddate(time);
	}

	// Mozilla or IE 5.5 and later
	GetPrivateProfileStringEx(cSECTION,cICONFILE,cEMPTY,
							buf,BUFLEN,path);
	if (strlen(buf)){
		bookmark->setIcon(buf);
	}

	// FeedUrl
	GetPrivateProfileStringEx(cWEBSLICESECTION,cFEEDURL,cEMPTY,
							buf,BUFLEN,path);
	if (strlen(buf)){
		bookmark->getIeBookmark()->setFeedUrl(buf);
	}

	// PreviewSize
	GetPrivateProfileStringEx(cWEBSLICESECTION,cPREVIEWSIZE,cEMPTY,
							buf,BUFLEN,path);
	if (strlen(buf)){
		bookmark->getIeBookmark()->setPreviewSize(buf);
	}

	// IsLivePreview
	GetPrivateProfileStringEx(cWEBSLICESECTION,cLIVEPREVIEW,cEMPTY,
							buf,BUFLEN,path);
	if (!strcmp(buf,"true")){
		bookmark->getIeBookmark()->setLivePreview(true);
	}

	delete []buf;
	delete []buf2;
	return 0;

}

/**
 * t@Cɑ΂铮<br>
 * t@CIÊCɓ̏ꍇ͓c[Ɋi[B<br>
 * t@CIÊCɓȊȌꍇ͉Ȃ<br>
 *
 * @param bookmark ubN}[Ni[pIuWFNg
 * @param f_infoW t@C
 * @param path t@C̃tpX(}`oCg)
 * @param pathW t@C̃tpX(Ch)
 * @param filename t@C(}`oCg)
 * @param filenameW t@C(Ch)
 * @return s 0:i[ 1:ΏۊO 2:̂̂ 3:i[s
 */
int IeFavoriteReader::fileAction( 
	Bookmark *bookmark,
	WIN32_FIND_DATAW *f_infoW,
	char *path,
	wchar_t *pathW,
	char *filename,
	wchar_t *filenameW)
{
	int result;

	// IÊCɓ肩ǂ̔sB
	wchar_t *last;
	wchar_t *nameW;
	last = wcsrchr( filenameW , L'.' );
	if ( last == NULL ){
		// gqȂt@CIÊCɓł͂ȂB
		logger->trace("Item is not IE favorite");
		return 1;
	}
	if ( isIEfavorites( last + 1 ) ){
		// tH_̏
		long order = -1;
		if (orderInfo[level] != NULL) {
			order = findOrder(orderInfo[level], filenameW);
		}
		bookmark->setOrgOrder(0, (int)order);

		// gq̕؂B
		*last = L'\0';
		nameW = filenameW;
	}else{
		// IÊCɓł͂Ȃꍇ͉ȂłƂƂƔB
		logger->trace("Item is not IE favorite");
		return 1;
	}

	// char̃pX
	char name[_MAX_FNAME];

	/* t@C */
	_splitpath(filename,NULL,NULL,name,NULL);	// .urlB

	// ubN}[Nݒ肷B
	bookmark->setItemType(Bookmark::bookmark);
	bookmark->setIeName(name);
	bookmark->setIeNameW(nameW);
	char *p = wctoUTF8Internal(nameW);
	if (p != NULL){
		bookmark->setName(p);
	}else{
		logger->debug("IE favorite name encode error");
		return 3;
	}

	// ǂݍ
	INT_TIME_T time_write = FileTimeToTime_t(&f_infoW->ftLastWriteTime);
	result = GetItem(bookmark,path,pathW,time_write);
	if (result){
		logger->debug("IE favorite time stamp get error");
		return 1;
	}

	// ubN}[Ni[
	result = writer->storeItem(bookmark);
	debugprintf("%d\n",result);

	switch (result){
		case 0:		// i[
			return 0;
		case 1:		// ̃ubN}[N݂B
			return 2;
		case 2:		// i[ɃG[B
			logger->debug("IE favorite store error");
			return 3;
		default:	// 
			logger->debug("IE favorite store error");
			return 3;
	}

	return 3;
}

/**
 * IE/GNXv[̃tH_\擾B
 *
 * @param path desktop.inĩpX
 * @param buf CɓtH_i[obt@
 * @param bufSize CɓtH_i[obt@TCY
 * @return -2:\[X擾s -1:͎s 0:\[X擾s >0:\[X擾
 */
int IeFavoriteReader::getFolderDisplayName(wchar_t *dirNameW,wchar_t *buf, int bufSize)
{
	int result;
	HRESULT hResult;
	int dirLen;
	wchar_t *desktopIni;

	if (gWindowsMajorVersion > 5) {
		// Windows Vista,7,8,and later
		hResult = getLocalizedName(dirNameW, buf, bufSize);
		if (FAILED(hResult)) {
			return 0;
		} else {
			return 1;
		}
	} else {
		// Windows 2000/XP
		dirLen = wcslen(dirNameW);
		desktopIni = (wchar_t *)calloc(dirLen + 11 + 2,sizeof(wchar_t));
		if (desktopIni == NULL) {
			logger->debug("IE favorite folder name memory allocate error");
			return 0;
		}
		wcscpy(desktopIni,dirNameW);
		wcscat(desktopIni,L"\\");
		wcscat(desktopIni,L"Desktop.ini");
		result = getDesktopIni(desktopIni,genBufW,BUFLEN);
		free(desktopIni);

		return result;
	}
}

/**
 *
 * fBNgǂ
 *
 * @param ubN}[N
 * @param dirName fBNg(tpX)
 * @param dirNameW fBNg(tpX)(Unicode)
 * @param filename t@C
 * @param filenameW t@C(Unicode)
 * @return s 0:fBNgǂݍݐ 1:fBNg𖳎 3:G[o
 */
int IeFavoriteReader::dirAction(
	Bookmark *bookmark,char *dirName,wchar_t *dirNameW,
	char *filename,wchar_t *filenameW)
{
	int result;

	// fBNg
	bookmark->setIEToolbar(false);
	if (g_noIElink){	//IẼN΂B
		if (!_stricmp(ieLinkFolder,dirName)){
			// IẼNtH_ɓ疳B
			return 1;
		}
	} else {
		// IÊCɓ肩ǂ肷B
		if (!_stricmp(ieLinkFolder,dirName)){
			bookmark->setIEToolbar(true);
		}
	}

	// tH_̏
	long order = -1;
	if (orderInfo[level] != NULL) {
		order = findOrder(orderInfo[level], filenameW);
	}
	bookmark->setOrgOrder(0, (int)order);

	bookmark->setItemType(Bookmark::folder);
	// ܂̓t@CVXẽfBNgi[ĂB
	bookmark->getIeBookmark()->setFsDirName(filenameW);

	// IEł̕\𒲂ׂB
	result = getFolderDisplayName(dirNameW,genBufW,BUFLEN);

	// ubN}[N̊i[
	if (result > 0) {
		// Desktop.iniŃtH_w肳ĂB
		char *sfn;
		if (g_isEdge && bookmark->isIEToolbar()) {
			// EdgȅꍇLinkstH_ߑłłCɓo[ƂAVF̃\[XȂ̂
			// ŕϊB
			sfn = wctombInternal(EDGE_LINK_NAME_JP_W);
			wcscpy(genBufW, EDGE_LINK_NAME_JP_W);
		} else {
			sfn = wctombInternal(genBufW);
		}
		if (sfn != NULL) {
			bookmark->setIeName(sfn);
		}
		bookmark->setIeNameW(genBufW);
		char *p = wctoUTF8Internal(genBufW);
		if (p != NULL){
			bookmark->setName(p);
		}else{
			logger->debug("IE favorite folder name encode error");
			return 3;
		}
	} else {
		// Desktop.iniŃtH_w肳ĂȂB
		bookmark->setIeName(filename);
		bookmark->setIeNameW(filenameW);
		char *p = wctoUTF8Internal(filenameW);
		if (p != NULL){
			bookmark->setName(p);
		}else{
			logger->debug("IE favorite folder name encode error");
			return 3;
		}
	}

	// tH_i[B
	result = writer->storeItem(bookmark);

	// TufBNgċAB
	level++;
	strcat(regKey, "\\");
	strcat(regKey, filename);
	unsigned char *orderBuf = getOrder(regKey);
	if (orderInfo.size() == level) {
		orderInfo.push_back(orderBuf);
	} else {
		orderInfo[level] = orderBuf;
	}
	search_dir(dirName,dirNameW);

	// pX߂B
	cutLast(regKey);
	if (orderInfo[level] != NULL) {
		free(orderInfo[level]);
		orderInfo[level] = NULL;
	}
	level--;
	writer->upFolder();	// tH_1鏈

	return result;

}

/**
 * t@C/tH_ɑ΂đsB
 *
 * @return 0 t@C폜Ȃ -1:G[N
 */
int IeFavoriteReader::doAction(
	const char *dirName,WIN32_FIND_DATA *f_info,
	const wchar_t *dirNameW,WIN32_FIND_DATAW *f_infoW)
{

	// char̃pX
	char *filename,*buf;
	int len;
	// wchar_t̃pX
	wchar_t *filenameW,*bufW;
	int lenW;
	// ubN}[N̏
	Bookmark *bookmark;
	int result;

	result = 2;	// ʕs

	debugprintf("filenameput\n");

	try{
		bookmark = new Bookmark;
		if (bookmark == NULL){
			logger->debug("IE favorite item memory allocate error");
			return -1;
		}
	}catch(...){
		logger->debug("IE favorite item memory allocate error");
		return -1;
	}
	/* tpX̑gݗ */
	filename = f_info->cFileName;
	len = strlen(filename) + strlen(dirName) + 1;
	if ((buf = (char *)malloc(len + 1)) == NULL){
		delete bookmark;
		logger->debug("IE favorite path memory allocate error");
		return -1;
	}
	sprintf(buf,"%s\\%s",dirName,filename);

	/* tpX̑gݗ(wchar_t) */
	filenameW = f_infoW->cFileName;
	lenW = wcslen(filenameW) + wcslen(dirNameW) + 1 + 4;
	if ((bufW = (wchar_t *)malloc(sizeof(wchar_t) * (lenW + 1))) == NULL){
		delete bookmark;
		free(buf);
		logger->debug("IE favorite path(Unicode) memory allocate error");
		return -1;
	}

	if ( !(f_infoW->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) ){
		// t@C͂
		if (dirNameW[0] != '\\'){
			// ̊g
			wcscpy(bufW,L"\\\\?\\");
		}else{
			// lbg[NhCu
			wcscpy(bufW,L"");
		}
	}else{
		// fBNg͌\\?\̂łł͓ɃpXȂB
		wcscpy(bufW,L"");
	}
	wcscat(bufW,dirNameW);		// fBNg
	wcscat(bufW,L"\\");			// 
	wcscat(bufW,filenameW);		// t@C

	if (f_infoW->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY){

		result = dirAction(bookmark,buf,bufW,filename,filenameW);
		
		delete bookmark;

		if (result > 1){
			// i[ɎsăG[ꍇ
			logger->debug("IE favorite folder item store error");
			free(bufW);
			free(buf);
			return -1;
		}

	}else{
		result = fileAction(bookmark , f_infoW , buf , bufW , filename , filenameW);

		debugprintf("%d\n",result);

		delete bookmark;

		if (result > 2){
			// i[ɎsăG[ꍇ
			logger->debug("IE favorite file item store error");
			free(bufW);
			free(buf);
			return -1;
		}

	}

	free(bufW);
	free(buf);

	return 0;
}

