#include	<stdlib.h>
#include	<new>
#include	<memory>

#include	<stdio.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"encutil2.h"
#include	"Bookmark.h"
#include	"IeBookmark.h"

/**
 * RXgN^
 */
IeBookmark::IeBookmark()
{
	_init();
}

/**
 * Rs[RXgN^
 */
IeBookmark::IeBookmark(const IeBookmark &src)
{
	_init();
	_copy(src);
}

/**
 * fXgN^
 */
IeBookmark::~IeBookmark()
{
	_reset();
}

/**
 *	CX^X̓eB<br>
 *	RXgN^p
 *
 */
void IeBookmark::_init(void)
{
	m_feedUrl = NULL;
	m_previewSize = NULL;
	m_isLivePreview = false;
	m_fsDirName = NULL;
}

/**
 * CX^X̓eĐݒ肷Bmۂ̊JƗ҂ɈႢoB
 */
void IeBookmark::_reset(void)
{
	if (m_feedUrl != NULL){
		delete []m_feedUrl;
		m_feedUrl = NULL;
	}
	if (m_previewSize != NULL){
		delete []m_previewSize;
		m_previewSize = NULL;
	}
	if (m_fsDirName != NULL) {
		delete []m_fsDirName;
		m_fsDirName = NULL;
	}
	_init();
}

/**
 *	CX^XRs[B(IeBookmark̂)
 *
 * @param src Rs[̃IuWFNg
 */
void IeBookmark::_copy(const IeBookmark &src)
{
	setFeedUrl(src.getFeedUrl());
	setPreviewSize(src.getPreviewSize());
	setLivePreview(src.getLivePreview());
	setFsDirName(src.getFsDirName());
}

/**
 * CX^XŜ̓eB
 */
void IeBookmark::reset(void)
{
	_reset();
}

/**
 * CX^XŜRs[B
 *
 * @param src Rs[̃IuWFNg
 */
void IeBookmark::copy(const IeBookmark &src)
{
	reset();
	_copy(src);
}

/**
 * CX^X̃Rs[
 */
IeBookmark & IeBookmark::operator = (const IeBookmark &src)
{
	copy(src);
	return *this;
}

/**
 * FeedUrl̒li[B
 *
 * @param item FeedUrl̒l
 * @return i[ꂽl
 */
char *IeBookmark::setFeedUrl(const char *item)
{
	char *p;
	int len;
	
	if (m_feedUrl != NULL){
		delete []m_feedUrl;
		m_feedUrl = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_feedUrl = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * PreviewSize̒li[B
 *
 * @param item PreviewSize̒l
 * @return i[ꂽl
 */
char *IeBookmark::setPreviewSize(const char *item)
{
	char *p;
	int len;
	
	if (m_previewSize != NULL){
		delete []m_previewSize;
		m_previewSize = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_previewSize = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * t@CVXẽfBNgi[B
 *
 * @param name fBNg
 * @return i[ꂽl
 */
wchar_t *IeBookmark::setFsDirName(const wchar_t *name)
{
	wchar_t *p;
	int len;
	
	if (m_fsDirName != NULL){
		delete []m_fsDirName;
		m_fsDirName = NULL;
	}

	if (name == NULL){
		return NULL;
	}

	len = wcslen(name) + 1;
	
	try{
		p = new wchar_t[len];
		if (p == NULL){
			return NULL;
		}
		wcscpy(p,name);
		m_fsDirName = p;
	}catch(...){
		return NULL;
	}
	return p;
}

