#ifndef FXWRITER_H
#define FXWRITER_H

#include	<stdio.h>
#include	<vector>
#include	<string>
#include	<set>

#include	"sqlite3.h"

#include	"Bookmark.h"
#include	"IBookmarkWriter.h"
#include	"FxBookmark.h"
#include	"FxInfo.h"

class FxWriter : public IBookmarkWriter {
private:
	sqlite3 *db;	// DBANZXp
	const char *dbFile;	// DBt@C
	FxInfo *info;	// ubN}[NɊւ

	int level;	// Kw̐[
	int ignoreLevel;	// JnKw̐[
	std::vector<sqlite_int64> parent;	// eKw̐etH_
	std::vector<int> order;		// eKw̃tH_ɂ鏇
	sqlite_int64 maxId;			// őID(moz_bookmarks)
	char *urlBuf;		// URLϊpobt@

	// ݑΏۂ̑
	int m_target;

	bool deleteToolbar;	// c[o[̓e폜邩
	bool deleteUnsorted;	// Unsorted̓e폜邩
	bool deleteMobile;	// oC̃ubN}[N폜邩

	bool inTransaction;	// gUNVJnĂ邩ǂH
	bool enableWrite;
	bool putIEToolbar;	// IÊCɓo[o͂邩ǂ
	unsigned int m_ignoreSince;
	bool doOptimize;	// œK{邩
	std::set<std::string> *guidSet;	// GUIDi[set

	sqlite_int64 getMaxBookmarkId(void);
	sqlite_int64 getMaxPlacesId(void);
	sqlite_int64 findUrl(char *url);
	int deleteTable(char *sql);
	sqlite_int64 putPlaces(Bookmark *item, int hidden= 0);
	sqlite_int64 putPlaces(char *urlItem, const wchar_t *name, int hidden = 0);
	int readFolder(sqlite_int64 id);
	int deleteItem(sqlite_int64 id);
	int deleteBookmarkRow(sqlite_int64 id);
	int deleteAnnotates(sqlite_int64 id);
	int deleteKeyword(sqlite_int64 id);
	void nextLevel(sqlite_int64 id);
	sqlite_int64 getMaxKeywordId(void);
	sqlite_int64 insertKeyword(Bookmark *item);
	sqlite_int64 updateBookmarkKeyword(Bookmark *item,sqlite_int64 id);
	sqlite_int64 insertMozBookmark(Bookmark *item);
	sqlite_int64 insertMozBookmarkFolder(Bookmark *item);
	sqlite_int64 insertMozBookmarkSeparator(Bookmark *item);
	sqlite_int64 getMaxAnnotationItemId(void);
	sqlite_int64 insertDescription(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertInSidebar(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertReadOnly(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertGeneratorURI(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertStaticTitle(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertSummaryExpiration(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertFeedUrl(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertFeedSiteUrl(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertFeedExpiration(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertOrganaizerQuery(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertOrganaizerFolder(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertSmartBookmark(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertExcludeFromBackup(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertSyncParent(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 insertMobileRoot(Bookmark *item,sqlite_int64 itemId);
	sqlite_int64 getOrganizer(sqlite_int64 targetId);

	int addMobileBookmark(sqlite_int64 folderID);
	sqlite_int64 getManagerRoot();
	sqlite_int64 getAllBookmarks(sqlite_int64 managerRoot);
	sqlite_int64 addMobileBookmarkToAll(sqlite_int64 parent, sqlite_int64 mobileFolderID);
	sqlite_int64 getMobileInAll(sqlite_int64 managerRoot);
	int resetPlacesForeignCount(void);
	int updatePlacesForeignCount(sqlite_int64 id, sqlite_int64 count);
	int updateForeignCountAll(void);

	void createGuid(char *buf);
	void createPlacesGuid(char *buf);

	void rollback();
	int executeSQL(const char *sql);
	int reindex();
	int vacuum();

public:
	/* ubN}[No̓C^[tFCX֐Q */
	void putHeader(void);
	void putFolder(Bookmark *item);
	void putFolderEnd(Bookmark *item,bool isLast);
	void putBookmark(Bookmark *item,bool isLast);
	void putFooter(void);
	int initializeTables(void);

	FxWriter(void);
	~FxWriter();

	int commit(void);

	int setDBfileName(const char *name);

	// ݑΏۑ̐ݒ
	int getTarget(void) {return m_target;};
	void setTarget(int target) {m_target = target;};

	void setToolbarDelete(bool mode) {
		deleteToolbar = mode;
	}

	void setUnsortedDelete(bool mode) {
		deleteUnsorted = mode;
	}

	/**
	 * oC̃ubN}[NݑOɍ폜邩ǂݒ肷B
	 *
	 * @param mode true:폜 false:폜Ȃ
	 */
	void setMobileDelete(bool mode) {
		deleteMobile = mode;
	}

	bool getIEToolbarPut(void) {
		return putIEToolbar;
	}
	void setIEToolbarPut(bool value) {
		putIEToolbar = value;
	}
	
	void setOptimize(bool value) {
		doOptimize = value;
	}

	/**
	 * GUIDi[psetݒ肷B
	 *
	 * @param value GUIDi[pset
	 */
	void setGuidSet(std::set<std::string> *value) {
		guidSet = value;
	}

};

#endif
