#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NTfunction.h"
#include	"Bookmark.h"
#include	"url.h"

#include	"FxWriter.h"

/**
 * RXgN^
 */
FxWriter::FxWriter(void)
{
	db = NULL;
	info = NULL;
	inTransaction = false;
	enableWrite = false;

	level = 0;
	ignoreLevel = -1;
	maxId = 3;	// ID=3̓^Õ[g
	// ŏ̊Kw̐eID1(SubN}[Ñ[g)
	parent.push_back(1);
	// ŏ̊Kw̕я
	order.push_back(6);

	deleteToolbar = false;	// c[o[̓e폜邩
	deleteUnsorted = false;	// Unfiled̓e폜邩
	deleteMobile = false;	// oC̃ubN}[N̓e폜邩
	putIEToolbar = true;
	doOptimize = false;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN * 2];
	} catch (...) {
	}

	srand(time(NULL));
}

/**
 * fXgN^<br>
 * ŁAKf[^x[XN[Y悤ɂB
 *
 */
FxWriter::~FxWriter()
{
	if (info != NULL) {
		delete info;
	}

	// gUNVĂꍇ̓gUNV[obNB
	if (!inTransaction) {
		rollback();
	}

	// f[^x[XN[YB
	if (db != NULL){
		sqlite3_close(db);
		db = NULL;
	}

	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * DB̃t@CZbgDBgp\ɂB
 *
 * @param name t@C
 * @return 0:DBI[v 1:DBI[vɎs
 */
int FxWriter::setDBfileName(const char *name)
{
	int rc;

	dbFile = name;
	char *p = mbtoUTF8Internal(const_cast<char *>(name));
	if (p == NULL) {
		return 1;
	}

	// DBt@CI[v
	rc = sqlite3_open(p, &db);
	if (rc){
		fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
		sqlite3_close(db);
		db = NULL;
		return 1;
	}

	try {
		info = new FxInfo(db);
		if (info == NULL) {
			return 1;
		}
	}catch(...) {
		return 1;
	}

	// ǂݍށB
	int result = info->readInformations();
	if (result) {
		delete info;
		sqlite3_close(db);
		db = NULL;
		info = NULL;
		return 1;
	}

	return 0;
}

/**
 * moz_bookmarks(ubN}[N)ōł傫ID擾B
 *
 * @return -1:ID̍ől擾s >-1:ID̍ől
 */
sqlite_int64 FxWriter::getMaxBookmarkId(void)
{
	const char *sql = "select MAX(id) from moz_bookmarks;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -1;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		int type = sqlite3_column_type(statement, 0);
		if (type == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
		} else {
			id = 1;
		}
		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		// fprintf(stderr,"finalize failed\n");
	}

	return id;
}

/**
 * moz_places(URL)ōł傫ID擾B
 *
 * @return -1:ID̍ől擾s >-1:ID̍ől
 */
sqlite_int64 FxWriter::getMaxPlacesId(void)
{
	const char *sql = "select MAX(id) from moz_places;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -1;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		int type = sqlite3_column_type(statement, 0);
		if (type == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
		} else {
			id = 1;
		}
		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		// fprintf(stderr,"finalize failed\n");
	}

	return id;
}

/**
 * URL݂邩ǂ肷B
 *
 * @return -2:G[ -1:URL݂Ȃ@>-1:URLmoz_placesID
 */
sqlite_int64 FxWriter::findUrl(char *url)
{
	const char *sql = "select id from moz_places where url=?;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -1;
	char *encodedUrl;

	if (url == NULL) {
		return -1;
	}

	if (strncmp("file:",url,5) == 0){
		encodeURL(urlBuf, url);
		encodedUrl = urlBuf;
	} else if (strncmp("javascript:",url,11) == 0){
		// JavaScript(ubN}[Nbg)URLGR[h
		// (Firefox 2̃C|[gƓlB)
		encodeURL(urlBuf, url);
		encodedUrl = urlBuf;
	} else {
		encodedUrl = url;
	}

	fprintf(stderr, "***%s***\n",url);
	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		return -2;
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	if (url != NULL) {
		rc = sqlite3_bind_text(statement, 1, encodedUrl , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 1, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		// fprintf(stderr,"bind failed #1\n");
		sqlite3_finalize(statement);
		return -2;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (rc == SQLITE_ROW) {
		if (sqlite3_column_type(statement,0) == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
			// fprintf(stderr,"id found #1\n");
		}else{
			id = -2;
		}
	}else{
		// fprintf(stderr,"id not found #1 %d\n",rc);
		id = -1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		// fprintf(stderr,"finalize failed\n");
	}

	return id;
}

/**
 * ł傫L[[hIDZoB
 *
 * @return >0:L[[hID 0:܂L[[hȂ -1:G[
 */
sqlite_int64 FxWriter::getMaxKeywordId(void)
{
	const char *sql = "select MAX(id) from moz_keywords;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -1;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		int type = sqlite3_column_type(statement, 0);
		if (type == SQLITE_INTEGER) {
			id = sqlite3_column_int64(statement, 0);
		} else {
			id = 1;
		}
		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		// fprintf(stderr,"finalize failed\n");
	}

	return id;
}

/**
 * L[[h}B
 *
 * @return -1:G[ >-1:moz_keywordsID
 */
sqlite_int64 FxWriter::insertKeyword(Bookmark *item)
{
	const char *sql = "insert into moz_keywords (id,keyword)"
				" values (?,?);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxKeywordId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// keyword
	char *keyword = item->getShortcut();
	if (keyword != NULL) {
		rc = sqlite3_bind_text(statement, 2, keyword , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 2, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * L[[h邽moz_bookmarksXVB
 *
 * @param item ubN}[N
 * @param id moz_bookmarksid
 * @return -1:G[ >-1:moz_bookmarksID
 */
sqlite_int64 FxWriter::updateBookmarkKeyword(Bookmark *item,sqlite_int64 id)
{
	sqlite_int64 result = insertKeyword(item);
	if (result == -1) {
		return -1;
	}

	const char *sql = "update moz_bookmarks set keyword_id=? "
				" where id=?;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
		return -1;
	}

	sqlite3_reset(statement);
	// moz_keywordsID
	rc = sqlite3_bind_int64(statement, 1, result);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ID
	rc = sqlite3_bind_int64(statement, 2, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * ł傫annotationIDZoB
 *
 * @return >0:annotationID 0:܂annotationȂ -1:G[
 */
sqlite_int64 FxWriter::getMaxAnnotationItemId(void)
{
	const char *sql = "select MAX(id) from moz_items_annos;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -1;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		int type = sqlite3_column_type(statement, 0);
		if (type == SQLITE_INTEGER) {
			id = sqlite3_column_int64(statement, 0);
		} else {
			id = 1;
		}
		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		// fprintf(stderr,"finalize failed\n");
	}

	return id;
}

/**
 * }B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertDescription(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,3,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getDescriptionId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// description
	char *description = item->getDescription();
	if (description != NULL) {
		rc = sqlite3_bind_text(statement, 4, description , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 4, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * TCho[ւ̃[hݒ}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertInSidebar(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,1,0,4,1,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getInSideBarId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * ǂݎp}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertReadOnly(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,1,0,4,1,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getReadOnlyId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * }CNT}URI}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertGeneratorURI(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,3,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getGeneratorId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// GeneratorURI
	char *uri = item->getFxBookmark(m_target)->getMicsum_gen_uri();
	if (uri != NULL) {
		rc = sqlite3_bind_text(statement, 4, uri , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 4, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * }CNT}̐ÓI^Cg}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertStaticTitle(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,3,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getStaticTitleId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// GeneratorURI
	char *title = item->getFxBookmark(m_target)->getGeneratedTitle();
	if (title != NULL) {
		rc = sqlite3_bind_text(statement, 4, title , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 4, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * }CNT}̊}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertSummaryExpiration(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,2,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getStaticTitleId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// }CNT}expiration
	char *expiration = item->getFxBookmark(m_target)->getMicsum_expiration();
	if (expiration != NULL) {
		rc = sqlite3_bind_text(statement, 4, expiration , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 4, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}


/**
 * CuubN}[NURL}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertFeedUrl(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,3,?,?);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getFeedUriId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// FeedURL
	char *url = item->getFxBookmark(m_target)->getFeedUrl();
	if (url != NULL) {
		rc = sqlite3_bind_text(statement, 4, url , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 4, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// dateAdded
	sqlite_int64 add = item->getAdddate();
	add = add * 1000000;
	rc = sqlite3_bind_int64(statement, 5, add);
	if (rc != SQLITE_OK) {
		sqlite3_finalize(statement);
		return -1;
	}

	// lastModified
	sqlite_int64 modify = item->getModified();
	modify = modify * 1000000;
	rc = sqlite3_bind_int64(statement, 6, modify);
	if (rc != SQLITE_OK) {
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * CuubN}[ÑTCgURL}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertFeedSiteUrl(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,3,?,?);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getSiteUriId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// SiteURL
	char *url = item->getURL();
	if (url != NULL) {
		rc = sqlite3_bind_text(statement, 4, url , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 4, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// dateAdded
	sqlite_int64 add = item->getAdddate();
	add = add * 1000000;
	rc = sqlite3_bind_int64(statement, 5, add);
	if (rc != SQLITE_OK) {
		sqlite3_finalize(statement);
		return -1;
	}

	// lastModified
	sqlite_int64 modify = item->getModified();
	modify = modify * 1000000;
	rc = sqlite3_bind_int64(statement, 6, modify);
	if (rc != SQLITE_OK) {
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * CuubN}[N̊}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertFeedExpiration(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,2,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getExpirationId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// }CNT}expiration
	char *expiration = item->getFxBookmark(m_target)->getFeed_expiration();
	if (expiration != NULL) {
		rc = sqlite3_bind_text(statement, 4, expiration , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 4, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * I[KiCŨNG}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertOrganaizerQuery(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,1,0,4,1,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getOrganizerQueryId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * I[KiCŨtH_}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertOrganaizerFolder(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,1,0,4,1,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getOrganizerFolderId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * CuubN}[NURL}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertSmartBookmark(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,3,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getSmartBookmarkId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// Name
	wchar_t *filenameW = item->getIeNameW();
	char *utf8 = NULL;
	if (filenameW != NULL) {
		utf8 = wctoUTF8Internal(filenameW);
	}
	if (utf8 != NULL) {
		rc = sqlite3_bind_text(statement, 4, utf8 , -1, SQLITE_STATIC);
	} else {
		rc = sqlite3_bind_text(statement, 4, "" , -1, SQLITE_STATIC);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * excludeFromBackup}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertExcludeFromBackup(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,1,0,4,1,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getExcludeFromBackup());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * sync/parentl}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertSyncParent(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,3,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getSyncParentId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	rc = sqlite3_bind_text(statement, 4, item->getFxBookmark(m_target)->getSyncParent() , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * sync/parentl}B
 *
 * @return -1:G[ >-1:moz_items_annosID
 */
sqlite_int64 FxWriter::insertMobileRoot(Bookmark *item,sqlite_int64 itemId)
{
	const char *sql =
		"insert into moz_items_annos "
		"(id,item_id,anno_attribute_id,content,flags,expiration,type,dateAdded,lastModified) "
		"values (?,?,?,?,0,4,3,0,0);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;

	// ܂́AőID擾B
	id = getMaxAnnotationItemId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// item_id
	rc = sqlite3_bind_int64(statement, 2, itemId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// anno_attribute_id
	rc = sqlite3_bind_int64(statement, 3, info->getMobileRootId());
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	rc = sqlite3_bind_text(statement, 4, "1" , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * ubN}[Nޏ<br>
 *
 * @param item ޑΏۂ̃ubN}[N
 * @param hidden 0:\ 1:\Ȃ
 * @return ubN}[NID
 */
sqlite_int64 FxWriter::putPlaces(Bookmark *item, int hidden)
{
	return putPlaces(item->getURL(), item->getIeNameW(), hidden);
}

/**
 * ubN}[Nޏ<br>
 *
 * @param urlItem URL
 * @param name ubN}[N
 * @param hidden 0:\ 1:\Ȃ
 * @return ubN}[NID
 */
sqlite_int64 FxWriter::putPlaces(char *urlItem, const wchar_t *name, int hidden)
{
	const char *sql = "insert into moz_places (id,url,title,visit_count,hidden,foreign_count,guid)"
				" values (?,?,?,0,?,1,?);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;
	char guid[13];

	// ܂́AőID擾B
	id = getMaxPlacesId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putPlaces\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// url
	const char *url = "";
	if (urlItem != NULL){
		if (strncmp("file:",urlItem,5) == 0){
			encodeURL(urlBuf, urlItem);
			url = urlBuf;
		} else if (strncmp("javascript:",urlItem,11) == 0){
			// JavaScript(ubN}[Nbg)URLGR[h
			// (Firefox 2̃C|[gƓlB)
			encodeURL(urlBuf, urlItem);
			url = urlBuf;
		} else {
			url = urlItem;
		}
	}

	rc = sqlite3_bind_text(statement, 2, url , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// title
	char *utf8 = wctoUTF8Internal(name);

	rc = sqlite3_bind_text(statement, 3, utf8 , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// Hidden
	rc = sqlite3_bind_int64(statement, 4, hidden);
	if (rc != SQLITE_OK) {
		sqlite3_finalize(statement);
		return -1;
	}

	createPlacesGuid(guid);
	rc = sqlite3_bind_text(statement, 5, guid, -1, SQLITE_STATIC);
	if (rc != SQLITE_OK) {
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * GUIDKɍ쐬(Firefox 48̃CuubN}[Np)B
 *
 * @param buf 쐬GUID̊i[
 */
void FxWriter::createGuid(char *buf)
{
	const char *pattern = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

	const char *sql = "select guid "
		"from moz_bookmarks "
		"where guid=?;";

	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -2;
	const char *p;	// ǂݍ܂ȂƂŵă|C^

	rc = sqlite3_prepare_v2(db, sql, -1, &statement, &p);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getMobileInAll]SQL error\n");
		return;
	}

	while (1) {

		for (int i = 0; i < 12; i++) {
			buf[i] = pattern[rand() % 62];
		}
		buf[12] = '\0';

		sqlite3_reset(statement);
		rc = sqlite3_bind_text(statement, 1, buf, -1, SQLITE_STATIC);
		if (rc != SQLITE_OK) {
			fprintf(stderr, "[getMobileInAll]bind failed.\n");
			sqlite3_finalize(statement);
			return;
		}

		// ŎsB
		rc = sqlite3_step(statement);
		if (rc == SQLITE_ROW) {
			continue;
		} else {
			break;
		}
	}

	rc = sqlite3_finalize(statement);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getMobileInAll]finalize failed\n");
	}
	return;
}

/**
* GUIDKɍ쐬(Firefox 48̃CuubN}[Np)B
*
* @param buf 쐬GUID̊i[
*/
void FxWriter::createPlacesGuid(char *buf)
{
	const char *pattern = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

	const char *sql = "select guid "
		"from moz_places "
		"where guid=?;";

	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -2;
	const char *p;	// ǂݍ܂ȂƂŵă|C^

	rc = sqlite3_prepare_v2(db, sql, -1, &statement, &p);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getMobileInAll]SQL error\n");
		return;
	}

	while (1) {

		for (int i = 0; i < 12; i++) {
			buf[i] = pattern[rand() % 62];
		}
		buf[12] = '\0';

		sqlite3_reset(statement);
		rc = sqlite3_bind_text(statement, 1, buf, -1, SQLITE_STATIC);
		if (rc != SQLITE_OK) {
			fprintf(stderr, "[getMobileInAll]bind failed.\n");
			sqlite3_finalize(statement);
			return;
		}

		// ŎsB
		rc = sqlite3_step(statement);
		if (rc == SQLITE_ROW) {
			continue;
		} else {
			break;
		}
	}

	rc = sqlite3_finalize(statement);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getMobileInAll]finalize failed\n");
	}
	return;
}



/**
 * tH_moz_bookmarksɑ}B
 *
 * @param item }ubN}[N
 * @return -1:}s >-1:}ubN}[Nmoz_bookmarksID
 */
sqlite_int64 FxWriter::insertMozBookmarkFolder(Bookmark *item)
{
	const char *sql;
	const char* p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;
	char newGuid[13];

	if (info->hasSyncStatus()) {
		sql = "insert into moz_bookmarks (id,type,parent,position,title,dateAdded,lastModified,guid,syncStatus,syncChangeCounter)"
			" values (?,?,?,?,?,?,?,?,?,?);";
	} else if (info->getHasGUID()) {
		sql = "insert into moz_bookmarks (id,type,parent,position,title,dateAdded,lastModified,guid)"
			" values (?,?,?,?,?,?,?,?);";
	} else {
		sql = "insert into moz_bookmarks (id,type,parent,position,title,dateAdded,lastModified)"
			" values (?,?,?,?,?,?,?);";
	}

	// ܂́AőID擾B
	id = getMaxBookmarkId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putFolder\n");
		return -1;
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// type
	rc = sqlite3_bind_int(statement, 2, 2);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// parent
	rc = sqlite3_bind_int64(statement, 3, parent[level]);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// position
	rc = sqlite3_bind_int(statement, 4, order[level]);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// title
	wchar_t *filenameW = item->getIeNameW();
	char *utf8 = wctoUTF8Internal(filenameW);

	rc = sqlite3_bind_text(statement, 5, utf8 , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// dateAdded
	rc = sqlite3_bind_int(statement, 6, 0);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// lastModified
	rc = sqlite3_bind_int(statement, 7, 0);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// guid
	if (info->getHasGUID()) {
		if (item->getFxBookmark(m_target)->getGUID() != NULL) {

			rc = sqlite3_bind_text(
				statement,
				8,
				item->getFxBookmark(m_target)->getGUID(),
				-1,
				SQLITE_STATIC);

		} else {
//			if (item->getFxBookmark(m_target)->getFeedUrl() != NULL) {
				// Firefox 48ł̓CuubN}[NguidKvȂ̂
				// KȒlB
				createGuid(newGuid);
				rc = sqlite3_bind_text(
					statement,
					8,
					newGuid,
					-1,
					SQLITE_STATIC);
//			}
		}
	}

	if (info->hasSyncStatus()) {
		rc = sqlite3_bind_int64(statement, 9, item->getFxBookmark(m_target)->getSyncStatus());
		if (rc != SQLITE_OK) {
			sqlite3_finalize(statement);
			return -1;
		}
		rc = sqlite3_bind_int64(statement, 10, item->getFxBookmark(m_target)->getSyncChangeCount());
		if (rc != SQLITE_OK) {
			sqlite3_finalize(statement);
			return -1;
		}
	}
	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
 * ubN}[Nmoz_bookmarksɑ}B
 *
 * @param item }ubN}[N
 * @return -1:}s >-1:}ubN}[Nmoz_bookmarksID
 */
sqlite_int64 FxWriter::insertMozBookmark(Bookmark *item)
{
	const char *sql;
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	char *url;
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;
	sqlite_int64 placesId;
	char newGuid[13];

	if (info->hasSyncStatus()) {
		sql = "insert into moz_bookmarks (id,type,parent,position,title,dateAdded,lastModified,fk,guid,syncStatus,syncChangeCounter)"
			" values (?,?,?,?,?,?,?,?,?,?,?);";
	} else if (info->getHasGUID()) {
		sql = "insert into moz_bookmarks (id,type,parent,position,title,dateAdded,lastModified,fk,guid)"
					" values (?,?,?,?,?,?,?,?,?);";
	} else {
		sql = "insert into moz_bookmarks (id,type,parent,position,title,dateAdded,lastModified,fk)"
					" values (?,?,?,?,?,?,?,?);";
	}

	// ܂́AőID擾B
	id = getMaxBookmarkId();
	if (id == -1){
		return -1;
	}
	id++;

	// ɁAURL݂邩ǂmFāA݂Ȃꍇ͐VɏށB
	url = item->getURL();
	if (item->getURL() == NULL || strlen(item->getURL()) == 0) {
		// URL󂾂Ƒs\ɂȂ̂ŁAabout:blankB
		item->setURL("about:blank");
	}
	placesId = findUrl(item->getURL());
	if (placesId == -2) {
		return -1;
	}
	if (placesId == -1){
		// ȂꍇVɏ
		placesId = putPlaces(item);
	}


	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putFolder\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// type
	rc = sqlite3_bind_int(statement, 2, 1);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// parent
	rc = sqlite3_bind_int64(statement, 3, parent[level]);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// position
	rc = sqlite3_bind_int(statement, 4, order[level]);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// title
	wchar_t *filenameW = item->getIeNameW();
	char *utf8 = wctoUTF8Internal(filenameW);

	rc = sqlite3_bind_text(statement, 5, utf8 , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// dateAdded
	sqlite_int64 add = item->getAdddate();
	add = add * 1000000;
	rc = sqlite3_bind_int64(statement, 6, add);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// lastModified
	sqlite_int64 modify = item->getModified();
	modify = modify * 1000000;
	if (modify == 0) {
		modify = add;
	}
	rc = sqlite3_bind_int64(statement, 7, modify);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// fk
	if (placesId != -1) {
		rc = sqlite3_bind_int64(statement, 8, placesId);
	} else {
		rc = sqlite3_bind_null(statement, 8);
	}
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// guid
	if (info->getHasGUID()) {
		if (item->getFxBookmark(m_target)->getGUID() != NULL) {
			rc = sqlite3_bind_text(
				statement,
				9,
				item->getFxBookmark(m_target)->getGUID(),
				-1,
				SQLITE_STATIC);
		} else {
			createGuid(newGuid);
			rc = sqlite3_bind_text(
				statement,
				9,
				newGuid,
				-1,
				SQLITE_STATIC);
		}
	}
	if (info->hasSyncStatus()) {
		rc = sqlite3_bind_int64(statement, 10, item->getFxBookmark(m_target)->getSyncStatus());
		if (rc != SQLITE_OK) {
			sqlite3_finalize(statement);
			return -1;
		}
		rc = sqlite3_bind_int64(statement, 11, item->getFxBookmark(m_target)->getSyncChangeCount());
		if (rc != SQLITE_OK) {
			sqlite3_finalize(statement);
			return -1;
		}
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	
	order[level]++;	// tH_̏Ԃi߂B
	return id;
}


/**
 * Zp[^moz_bookmarksɑ}B
 *
 * @param item }ubN}[N
 * @return -1:}s >-1:}ubN}[Nmoz_bookmarksID
 */
sqlite_int64 FxWriter::insertMozBookmarkSeparator(Bookmark *item)
{
	const char *sql;
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;
	char newGuid[13];

	if (info->hasSyncStatus()) {
		sql = "insert into moz_bookmarks (id,type,parent,position,dateAdded,lastModified,guid,syncStatus,syncChangeCounter)"
			" values (?,?,?,?,?,?,?,?,?);";
	} else if (info->getHasGUID()) {
		sql = "insert into moz_bookmarks (id,type,parent,position,dateAdded,lastModified,guid)"
				" values (?,?,?,?,?,?,?);";
	} else {
		sql = "insert into moz_bookmarks (id,type,parent,position,dateAdded,lastModified)"
				" values (?,?,?,?,?,?);";
	}

	// oubN}[NȊOɂZp[^͖B
	// Zp[^̓ubN}[Nł̈ʒuĂ͂߂ĈӖB
	if (item->getOrgOrder(5 + m_target) < 0){
		return 0;
	}


	// ܂́AőID擾B
	id = getMaxBookmarkId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putFolder\n");
		return -1;
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// type
	rc = sqlite3_bind_int(statement, 2, 3);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// parent
	rc = sqlite3_bind_int64(statement, 3, parent[level]);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// position
	rc = sqlite3_bind_int(statement, 4, order[level]);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

#if 0
	// dateAdded
	rc = sqlite3_bind_int(statement, 5, 0);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// lastModified
	rc = sqlite3_bind_int(statement, 6, 0);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}
#endif

	// dateAdded
	sqlite_int64 add = item->getAdddate();
	add = add * 1000000;
	rc = sqlite3_bind_int64(statement, 5, add);
	if (rc != SQLITE_OK) {
		sqlite3_finalize(statement);
		return -1;
	}

	// lastModified
	sqlite_int64 modify = item->getModified();
	modify = modify * 1000000;
	rc = sqlite3_bind_int64(statement, 6, modify);
	if (rc != SQLITE_OK) {
		sqlite3_finalize(statement);
		return -1;
	}


	// guid
	if (info->getHasGUID()) {
		if (item->getFxBookmark(m_target)->getGUID() != NULL) {
			rc = sqlite3_bind_text(
				statement,
				7,
				item->getFxBookmark(m_target)->getGUID(),
				-1,
				SQLITE_STATIC);
		} else {
			// Firefox 48ł̓CuubN}[NguidKvȂ̂
			// KȒlB
			createGuid(newGuid);
			rc = sqlite3_bind_text(
				statement,
				8,
				newGuid,
				-1,
				SQLITE_STATIC);
		}
	}

	if (info->hasSyncStatus()) {
		rc = sqlite3_bind_int64(statement, 8, item->getFxBookmark(m_target)->getSyncStatus());
		if (rc != SQLITE_OK) {
			sqlite3_finalize(statement);
			return -1;
		}
		rc = sqlite3_bind_int64(statement, 9, item->getFxBookmark(m_target)->getSyncChangeCount());
		if (rc != SQLITE_OK) {
			sqlite3_finalize(statement);
			return -1;
		}
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}

/**
* ubN}[N}l[ŴׂẴubN}[NtH_擾B
*
* @param targetId ΏۃtH_ID
* @return PlacesOrganizer/OrganizerFoldersID -2:ȂƂ -1:G[
*/
sqlite_int64 FxWriter::getOrganizer(sqlite_int64 targetId)
{
	const char *sql = "select id "
		"from moz_items_annos "
		"where item_id=? and anno_attribute_id=?;";

	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -2;
	const char *p;	// ǂݍ܂ȂƂŵă|C^

	rc = sqlite3_prepare_v2(db, sql, -1, &statement, &p);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getOrganizer]SQL error\n");
		return -1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int64(statement, 1, targetId);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getOrganizer]bind failed.\n");
		sqlite3_finalize(statement);
		return -1;
	}

	rc = sqlite3_bind_int64(statement, 2, info->getOrganizerFolderId());
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getOrganizer]bind failed.\n");
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while (rc == SQLITE_ROW) {
		// id
		if (sqlite3_column_type(statement, 0) == SQLITE_INTEGER) {
			id = sqlite3_column_int64(statement, 0);
			break;
		}
		rc = sqlite3_step(statement);
	}
	rc = sqlite3_finalize(statement);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getAllBookmarks]finalize failed\n");
	}
	return id;
}


/**
 * oC̃ubN}[NubN}[N}l[W̕\ptH_ɒǉB
 *
 * @param folderID oC̃ubN}[NtH_ID
 * @return 0:ǉ 1:ǉs
 */
int FxWriter::addMobileBookmark(sqlite_int64 folderID)
{
	sqlite_int64 managerRoot;
	sqlite_int64 allBookmarks;

	// ubN}[N}l[W̕\̃[gtH_擾B
	managerRoot = getManagerRoot();
	if (managerRoot == -1) {
		return 1;
	}
	// ׂẴubN}[NtH_擾B
	allBookmarks = getAllBookmarks(managerRoot);
	if (allBookmarks == -1) {
		return 1;
	}
	addMobileBookmarkToAll(allBookmarks, folderID);

	return 0;
}

/**
 * ubN}[N}l[W̕\̃[gtH_擾B
 *
 * @return ubN}[N}l[W̕\̃[gtH_ID(ȂƂ-1)
 */
sqlite_int64 FxWriter::getManagerRoot()
{
	const char *sql = "select id "
		"from moz_bookmarks "
		"where parent=1 and title='';";

	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -1;
	const char *p;	// ǂݍ܂ȂƂŵă|C^

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[getManagerRoot]SQL error\n");
		return -1;
	}

	sqlite3_reset(statement);

	// ŎsB
	rc = sqlite3_step(statement);
	while (rc == SQLITE_ROW) {
		// id
		if (sqlite3_column_type(statement,0) == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
			sqlite_int64 organizerFolder = getOrganizer(id);
			if (organizerFolder == -1) {
				rc = sqlite3_finalize(statement);
				return -1;
			}
			if (organizerFolder > -1) {
				break;
			}
		}
		rc = sqlite3_step(statement);
	}
	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[getManagerRoot]finalize failed\n");
	}
	return id;
}

/**
 * ubN}[N}l[ŴׂẴubN}[NtH_擾B
 *
 * @param managerRoot ubN}[N}l[W̕\̃[gtH_ID
 * @return ubN}[N}l[ŴׂẴubN}[NtH_ID(ȂƂ-1)
 */
sqlite_int64 FxWriter::getAllBookmarks(sqlite_int64 managerRoot)
{
	const char *sql = "select id "
		"from moz_bookmarks "
		"where parent=? and type=2;";

	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -1;
	const char *p;	// ǂݍ܂ȂƂŵă|C^

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[getAllBookmarks]SQL error\n");
		return -1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int64(statement, 1, managerRoot);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[getAllBookmarks]bind failed.\n");
		sqlite3_finalize(statement);
		return -1;
	}


	// ŎsB
	rc = sqlite3_step(statement);
	while (rc == SQLITE_ROW) {
		// id
		if (sqlite3_column_type(statement,0) == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
			break;
		}
		rc = sqlite3_step(statement);
	}
	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[getAllBookmarks]finalize failed\n");
	}
	return id;
}

/**
 * ubN}[N}l[ŴׂẴubN}[NtH_̃oC̃ubN}[N擾B
 *
 * @param managerRoot oC̃ubN}[NID
 * @return oC̃ubN}[NID(ȂƂ-1)
 */
sqlite_int64 FxWriter::getMobileInAll(sqlite_int64 managerRoot)
{
	const char *sql = "select id "
		"from moz_bookmarks "
		"where fk=? and type=1;";

	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id = -2;
	const char *p;	// ǂݍ܂ȂƂŵă|C^

	rc = sqlite3_prepare_v2(db, sql, -1, &statement, &p);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getMobileInAll]SQL error\n");
		return -1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int64(statement, 1, managerRoot);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getMobileInAll]bind failed.\n");
		sqlite3_finalize(statement);
		return -1;
	}


	// ŎsB
	rc = sqlite3_step(statement);
	while (rc == SQLITE_ROW) {
		// id
		if (sqlite3_column_type(statement, 0) == SQLITE_INTEGER) {
			id = sqlite3_column_int64(statement, 0);
			break;
		}
		rc = sqlite3_step(statement);
	}
	rc = sqlite3_finalize(statement);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[getMobileInAll]finalize failed\n");
	}
	return id;
}

/**
 * ׂẴubN}[NɃoC̃ubN}[N}B
 *
 * @param parent }̃tH_ID
 * @param mobileFolderID oC̃ubN}[NID
 * @return -1:}s >-1:}ubN}[Nmoz_bookmarksID
 */
sqlite_int64 FxWriter::addMobileBookmarkToAll(sqlite_int64 parent, sqlite_int64 mobileFolderID)
{
	const char *sql;
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	sqlite_int64 id;
	sqlite_int64 placesId;
	char url[128];

	sprintf(url, "place:folder=%I64d", mobileFolderID);
	placesId = findUrl(url);
	if (placesId == -2) {
		return -1;
	}
	if (placesId == -1) {
		// ȂꍇVɏ
		placesId = putPlaces(url, L"oC̃ubN}[N", 1);
		if (placesId == -1) {
			return -1;
		}
	}

	// ׂẴubN}[N̒ɃoC̃ubN}[N邩ǂׂB
	id = getMobileInAll(placesId);
	if (id == -1) {
		return -1;
	}
	if (id != -2) {
		return 0;
	}

	// ݂Ȃꍇׂ͂ẴubN}[NɃoC̃ubN}[N쐬B
	sql = "insert into moz_bookmarks (id,type,parent,position,dateAdded,lastModified,title,fk)"
			" values (?,?,?,?,?,?,?,?);";

	// ܂́AőID擾B
	id = getMaxBookmarkId();
	if (id == -1){
		return -1;
	}
	id++;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in putFolder\n");
		return -1;
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// type
	rc = sqlite3_bind_int(statement, 2, 1);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// parent
	rc = sqlite3_bind_int64(statement, 3, parent);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// position
	rc = sqlite3_bind_int(statement, 4, 3);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// dateAdded
	rc = sqlite3_bind_int(statement, 5, 0);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// lastModified
	rc = sqlite3_bind_int(statement, 6, 0);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// lastModified
	unsigned char buf[64];
	toUTF8(buf, L"oC̃ubN}[N");
	rc = sqlite3_bind_text(statement, 7, (const char *)buf , -1, SQLITE_STATIC);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ID
	rc = sqlite3_bind_int64(statement, 8, placesId);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	return id;
}



/**
 * tH_ǂݍ(ubN}[NtH_̍폜p)
 *
 * @param folderId ubN}[NEtH_tH_moz_bookmarks.id
 * @return 0: -1:s
 */
int FxWriter::readFolder(sqlite_int64 folderId)
{
	const char *sql = "select id,type,title,fk,keyword_id,dateAdded,lastModified "
		"from moz_bookmarks "
		"where parent=? order by position;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[readFolder]SQL error\n");
		return -1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int64(statement, 1, folderId);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[readFolder]bind failed.\n");
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while (rc == SQLITE_ROW) {

		// 0n܂B
		sqlite_int64 id = -1;
		int type;
		sqlite_int64 fk;
		//int link;

		// id
		if (sqlite3_column_type(statement,0) == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
			// fprintf(stdout,"%d:INTEGER:%ld\n",0,sqlite3_column_int64(statement,0));
		}
		// ^Cv
		if (sqlite3_column_type(statement,1) == SQLITE_INTEGER){
			type = sqlite3_column_int(statement,1);
			fprintf(stdout,"%d:INTEGER:%d\n",1,sqlite3_column_int(statement,1));
		}

		// {vOňtH_̔ẑID`FbN͕sv
#if 0
		if (id <= info->getRootFolders()) {
			// [gtH_͑ΏۊOB
			rc = sqlite3_step(statement);
			continue;
		}
#endif

		// OL[
		if (sqlite3_column_type(statement,3) == SQLITE_INTEGER){
			fk = sqlite3_column_int64(statement,3);
			if (type == 1) {
				// URL擾B
				// place:folder=ƂꍇAtH_ւ̃NƂďB
				// Kv͂邩ȁH
				//link = getFolderLink(fk);
				//if (link != -1){
				//	type = 2;	// ̓tH_B
				//	id = link;	// B
				//}
			}
		}
		if (id == info->getTagsFolder()) {
			// ^O͈ȂB
			rc = sqlite3_step(statement);
			continue;
		}

		// tH_ʂ̐ݒ
		if (id == info->getUnfiledFolder()) {
			// unfiled͂ǂ邩ȁH
		}
		if (id == info->getMenuFolder()) {
			// ubN}[Nj[
		}
		if (id == info->getToolbarFolder()) {
			// p[\ic[o[tH_
		}

		int result = 0;
		switch (type) {
			case 1:
				// ubN}[N̏
				// 폜
				result = deleteItem(id);
				if (result) {
					return 1;
				}
				break;
			case 2:
				// tH_̏

				// TutH_ċAIɍ폜B
				result = readFolder(id);
				if (result){
					rc = sqlite3_finalize(statement);
					return -1;
				}
				// qׂč폜ċAIɍ폜B
				result = deleteItem(id);
				if (result) {
					return 1;
				}
				break;
			case 3:
				// ؂
				// 폜
				result = deleteItem(id);
				if (result) {
					return 1;
				}
				break;
		}

		fprintf(stdout,"\n\n");
		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[readFolder]finalize failed\n");
	}
	
	return 0;
	
}

/**
 * ubN}[NEtH_g̍폜
 *
 * @param id 폜Ώۂ̃ubN}[NtH_(moz_bookmark̍s)
 * @return 0:폜 1:폜s
 */
int FxWriter::deleteItem(sqlite_int64 id)
{
	int result;

	// L[[h
	result = deleteKeyword(id);
	if (result) {
		return 1;
	}

	// 
	result = deleteAnnotates(id);
	if (result) {
		return 1;
	}

	// ubN}[Ng
	result = deleteBookmarkRow(id);
	if (result) {
		return 1;
	}
	return 0;
}

/**
 * ubN}[N̍s폜
 *
 * @param id 폜Ώۂmoz_bookmark̍s
 * @return 0:폜 1:폜s
 */
int FxWriter::deleteBookmarkRow(sqlite_int64 id)
{
	const char *sql =
		"delete from moz_bookmarks "
		"where id=?;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in deleteTable\n");
		return 1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[deleteBookmarkRow]bind failed.\n");
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
		rc = sqlite3_finalize(statement);
		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	
	return 0;
}

/**
 * tH_ubN}[N̑폜
 *
 * @param id 폜Ώۂmoz_bookmarkid
 * @return 0:폜 1:폜s
 */
int FxWriter::deleteAnnotates(sqlite_int64 id)
{
	const char *sql =
		"delete from moz_items_annos "
		"where item_id=?;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in deleteTable\n");
		return 1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[deleteAnnotates]bind failed.\n");
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
		rc = sqlite3_finalize(statement);
		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	
	return 0;
}

/**
 * ubN}[ÑL[[h폜
 *
 * @param id 폜Ώۂmoz_bookmarkid
 * @return 0:폜 1:폜s
 */
int FxWriter::deleteKeyword(sqlite_int64 id)
{
	const char *sql =
		"delete from moz_keywords "
		"where id=?;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in deleteTable\n");
		return 1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[deleteKeyword]bind failed.\n");
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
		rc = sqlite3_finalize(statement);
		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	
	return 0;
}


/**
 * e[u̍s폜
 *
 * @param sql e[u폜SQL
 * @return 0:폜 1:폜s
 */
int FxWriter::deleteTable(char *sql)
{
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in deleteTable\n");
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	
	return 0;
}

/**
 * ubN}[NɊւe[uB
 *
 * @return 0:폜 1:폜s
 */
int FxWriter::initializeTables(void)
{
	int result;

	// ܂AubN}[N
	result = readFolder(info->getMenuFolder());
	if (result){
		return result;
	}

	if (deleteToolbar) {
		result = readFolder(info->getToolbarFolder());
		if (result){
			return result;
		}
	}

	if (deleteUnsorted) {
		result = readFolder(info->getUnfiledFolder());
		if (result){
			return result;
		}
	}

	if (info->getMobileFolder() > -1) {
		result = readFolder(info->getMobileFolder());
		if (result){
			return result;
		}
	}

	return 0;
}

/**
 * moz_placesforeign_countZbgB
 *
 * @return 0:Zbg 1:Zbgs
 */
int FxWriter::resetPlacesForeignCount(void)
{
	const char *sql =
		"update moz_places "
		"set foreign_count=0;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql, -1, &statement, &p);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "SQL error in reset foreign_count\n");
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (rc != SQLITE_DONE) {
		fprintf(stderr, "SQLITE_DONE ȊÕbZ[W\n");
		rc = sqlite3_finalize(statement);
		return 1;
	}

	rc = sqlite3_finalize(statement);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "finalize failed\n");
	}

	return 0;
}

/**
 * moz_placesforeign_countXVB
 *
 * @param fk XVΏۂmoz_placesfk
 * @param count XVΏۂmoz_placesforeign_count
 * @return 0:XV 1:XVs
*/
int FxWriter::updatePlacesForeignCount(sqlite_int64 id, sqlite_int64 count)
{
	const char *sql =
		"update moz_places "
		"set foreign_count=? where id=?;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql, -1, &statement, &p);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "SQL error in deleteTable\n");
		return 1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int64(statement, 1, count);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[updatePlacesForeignCount]bind failed.\n");
		sqlite3_finalize(statement);
		return 1;
	}

	rc = sqlite3_bind_int64(statement, 2, id);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[updatePlacesForeignCount]bind failed.\n");
		sqlite3_finalize(statement);
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (rc != SQLITE_DONE) {
		fprintf(stderr, "SQLITE_DONE ȊÕbZ[W\n");
		rc = sqlite3_finalize(statement);
		return 1;
	}

	rc = sqlite3_finalize(statement);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "finalize failed\n");
	}

	return 0;
}

/**
 * moz_placesforeign_countׂčXVB
 *
 * @return 0: -1:s
 */
int FxWriter::updateForeignCountAll(void)
{
	const char *sql = "select fk, count(fk) "
		"from moz_bookmarks "
		"group by fk;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql, -1, &statement, &p);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[readFolder]SQL error\n");
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while (rc == SQLITE_ROW) {

		// 0n܂B
		sqlite_int64 fk = -1;
		int type;
		sqlite_int64 count;

		// fk
		type = sqlite3_column_type(statement, 0);
		if (type == SQLITE_INTEGER) {
			fk = sqlite3_column_int64(statement, 0);

			// fk̐
			if (sqlite3_column_type(statement, 1) == SQLITE_INTEGER) {
				count = sqlite3_column_int64(statement, 1);
			}

			rc = updatePlacesForeignCount(fk, count);
			if (rc == 1) {
				rc = sqlite3_finalize(statement);
				return -1;
			}
		}

		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "[readFolder]finalize failed\n");
	}

	return 0;

}



/**
 * ubN}[Nt@C̓̕ޏ<br>
 * (DBȂ̂őɑOsB)
 *
 */
void FxWriter::putHeader(void)
{
	// ͂߂ɃgUNVJnB

	const char *sql = "BEGIN TRANSACTION;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[putHeader]SQL error\n");
		return;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if ((rc != SQLITE_DONE) && ( rc != SQLITE_OK )){
		fprintf(stderr, "[putHeader]SQL error\n");
		rc = sqlite3_finalize(statement);
		return;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	inTransaction = true;

	if (getPutWithoutToolbar()) {
		// c[o[o͂Ȃꍇ͖Ńc[o[̓e
		// 폜ȂB
		deleteToolbar = false;
	}

	// e[u̓eB
	initializeTables();
}


/**
 * tH_ޏ<br>
 * 
 */
void FxWriter::putFolder(Bookmark *item)
{
	// ꂼ̐etH_֘A

	if (level == 0) {
		if (item->getFolderType() == Bookmark::menuBar) {
			// ̊Kw̐ݒsB
			nextLevel(info->getMenuFolder());
			enableWrite = true;
			return;
		}

		if (item->getFolderType() == Bookmark::toolBar) {
			if (!getPutWithoutToolbar()) {
				// ̊Kw̐ݒsB
				nextLevel(info->getToolbarFolder());
				enableWrite = true;
				return;
			}
		}

		if (item->getFolderType() == Bookmark::unFiled) {
			// ̊Kw̐ݒsB
			nextLevel(info->getUnfiledFolder());
			enableWrite = true;
			return;
		}

		if (item->getFolderType() == Bookmark::mobile) {
#if 1
			order[level] = 7;
			// ̊Kw̐ݒsB
			sqlite_int64 folderID = info->getMobileFolder();
			if (folderID == -1) {
				// oC̃ubN}[N܂Ȃꍇ
				// ܂AoC̃ubN}[NtH_gB
				item->setIeNameW(L"mobile");
				item->getFxBookmark(m_target)->setGUID("mobile______");
				folderID = insertMozBookmarkFolder(item);
				if (folderID == -1) {
					// tH_}sɂǍ̎ssȂB
					return;
				}
				// oC̃ubN}[NtH_ɕKvȑB
				insertExcludeFromBackup(item, folderID);
				insertMobileRoot(item, folderID);
			}
			// ubN}[N}l[W̊Kwɂ"oC̃ubN}[N"ǉB
			addMobileBookmark(folderID);

			nextLevel(folderID);
			enableWrite = true;
#else
			enableWrite = false;
			order[level]++;	// tH_̏Ԃi߂B
			m_ignoreSince = level;
			level++;
#endif
			return;
		}
		order[level]++;	// tH_̏Ԃi߂B
		enableWrite = false;
		m_ignoreSince = level;
		level++;

		return;
	}
	if ((putIEToolbar == false) && (item->isIEToolbar())) {
		enableWrite = false;
		m_ignoreSince = level;
	}
	if (!enableWrite) {
		// ݂stH_ȊȌꍇ͊Kw̃JEgsB
		level++;
		return;
	}

	//
	// ubN}[Nc[o[Ej[EunfiledgȊÔƂ̃tH_쐬
	//
	sqlite_int64 id;
	id = insertMozBookmarkFolder(item);
	if (id == -1) {
		// tH_}sɂǍ̎ssȂB
		return;
	}

	order[level]++;	// tH_̏Ԃi߂B
	// ̊Kw̐ݒsB
	nextLevel(id);	

	// Description
	if (item->getDescription() != NULL) {
		insertDescription(item,id);
	}

	// ǂݍݐp
	if (item->getFxBookmark(m_target)->getReadOnly()) {
		insertReadOnly(item,id);
	}

	// I[KiCŨtH_
	if (item->getFxBookmark(m_target)->getOrganizerFolder()) {
		insertOrganaizerFolder(item,id);
	}

	// I[KiCŨNG
	if (item->getFxBookmark(m_target)->getOrganizerQuery()) {
		insertOrganaizerQuery(item,id);
	}

	// excludeFromBackup
	if (item->getFxBookmark(m_target)->getExcludeFromBackup() == 1) {
		insertExcludeFromBackup(item,id);
	}

	// sync/parent
	if (item->getFxBookmark(m_target)->getSyncParent() != NULL) {
		insertSyncParent(item,id);
	}

	// mobile/bookmarksRoot
	if (item->getFxBookmark(m_target)->getMobileRoot() != NULL) {
		insertMobileRoot(item,id);
	}

	// Firefox 48łLive bookmarktH_ƂČ̂ŁA
	// Live bookmark炻̏ށB
	// Live bookmark̃tB[hURI
	if (item->getFxBookmark(m_target)->getFeedUrl() != NULL) {
		insertFeedUrl(item, id);

		// Live bookmark̃TCgURI
		if (item->getURL() != NULL) {
			insertFeedSiteUrl(item, id);
		}
	}

}

/**
 * ̊Kw̐ݒsB<br>
 * ԁEetH_̐ݒsB
 *
 * @param id 쐬tH_ID
 */
void FxWriter::nextLevel(sqlite_int64 id)
{
	// ̊Kw̐ݒ(ԂƐetH_)
	level++;
	// 
	if ((int)order.size() <= level){
		order.push_back(0);
	}else{
		order[level] = 0;
	}

	// eID̐ݒ
	if ((int)parent.size() <= level){
		parent.push_back(id);
	}else{
		parent[level] = id;
	}
}

/**
 * tH_̍Ōޏ<br>
 * 
 *
 */
void FxWriter::putFolderEnd(Bookmark *item,bool isLast)
{
	level--;
	if (level == m_ignoreSince) {
		enableWrite = true;
	}
}

/**
 * ubN}[Nޏ<br>
 * 
 *
 */
void FxWriter::putBookmark(Bookmark *item,bool isLast)
{
	if (!enableWrite) {
		// ݂stH_ȊȌꍇ͉ȂB
		return;
	}

	if (level == 0) {
		// ݂stH_ȊȌꍇ͉ȂB
		return;
	}

	// ubN}[Nmoz_bookmarksɑ}B
	sqlite_int64 id = -1;
	if (item->getSeparator()) {
		if (Bookmark::getSortMode() == 0){	/* \[gȂo͂B\[gꍇ͈ӖȂ̂ŁB */
			id = insertMozBookmarkSeparator(item);
		}
	} else {
		if (item->getFxBookmark(m_target)->getFeedUrl() != NULL) {
			// CuubN}[N̓tH_
			id = insertMozBookmarkFolder(item);
		} else {
			id = insertMozBookmark(item);
		}
	}

	if (id == -1) {
		// Ȃꍇ͂̌̎ssȂB
		return;
	}

	// keyword
	if (item->getShortcut() != NULL) {
		updateBookmarkKeyword(item,id);
	}
	// Description
	if (item->getDescription() != NULL) {
		insertDescription(item,id);
	}
	// TCho[փ[h
	if (item->getFxBookmark(m_target)->getWebPanel()) {
		insertInSidebar(item,id);
	}
	// R[hZbg
	// if (item->getFxBookmark(m_target)->getCharset() != NULL) {
	// }

	// ǂݍݐp
	if (item->getFxBookmark(m_target)->getFeedUrl() == NULL) {
		if (item->getFxBookmark(m_target)->getReadOnly()) {
			insertReadOnly(item, id);
		}
	}

	// Live bookmark̃tB[hURI
	if (item->getFxBookmark(m_target)->getFeedUrl() != NULL) {
		insertFeedUrl(item,id);

		// Live bookmark̃TCgURI
		if (item->getURL() != NULL) {
			insertFeedSiteUrl(item,id);
		}
	}

	// Live bookmark̃tB[h̊
	if (item->getFxBookmark(m_target)->getFeed_expiration() != NULL) {
		insertFeedExpiration(item,id);
	}

	// }CNT}URI
	if (item->getFxBookmark(m_target)->getMicsum_gen_uri() != NULL) {
		insertGeneratorURI(item,id);
	}

	// }CNT}̐ÓI^Cg
	if (item->getFxBookmark(m_target)->getGeneratedTitle() != NULL) {
		insertStaticTitle(item,id);
	}

	// }CNT}̊
	if (item->getFxBookmark(m_target)->getMicsum_expiration() != NULL) {
		insertSummaryExpiration(item,id);
	}

	// I[KiCŨtH_
	if (item->getFxBookmark(m_target)->getOrganizerFolder()) {
		insertOrganaizerFolder(item,id);
	}

	// I[KiCŨNG
	if (item->getFxBookmark(m_target)->getOrganizerQuery()) {
		insertOrganaizerQuery(item,id);
	}

	// X}[gubN}[N
	//if (item->getFxBookmark(m_target)->getSmartBookmark()) {
	//	insertSmartBookmark(item,id);
	//}
	if (item->getURL() != NULL) {
		// Places̃NG̏ꍇPlaces/SmartBookmarkށB
		if (strncmp(item->getURL(),"place:",6) == 0) {
			insertSmartBookmark(item,id);
		}
	}

	// excludeFromBackup
	if (item->getFxBookmark(m_target)->getExcludeFromBackup() == 1) {
		insertExcludeFromBackup(item,id);
	}

	// sync/parent
	if (item->getFxBookmark(m_target)->getSyncParent() != NULL) {
		insertSyncParent(item,id);
	}

	// mobile/bookmarksRoot
	if (item->getFxBookmark(m_target)->getMobileRoot() != NULL) {
		insertMobileRoot(item,id);
	}
}

/**
 * ubN}[Nt@C̏I̕ޏ<br>
 * DBݏIƂāAmoz_places̐ƂB
 *
 */
void FxWriter::putFooter(void)
{
	// foreign_countZbgB
	int result = resetPlacesForeignCount();
	if (result == 0) {
		// Ŝ߁Aforeign_countZbgł玟Ɉڂ
		updateForeignCountAll();
	}
}

/**
 * R~bgsB<br>
 *
 */
int FxWriter::commit(void)
{
	const char *sql = "COMMIT TRANSACTION;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[commit]SQL error\n");
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (( rc != SQLITE_OK ) && (rc != SQLITE_DONE) ){
		fprintf(stderr, "[commit]SQL error\n");
		rc = sqlite3_finalize(statement);
		sqlite3_close(db);
		db = NULL;

		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
	
	if (doOptimize) {
		reindex();
		vacuum();
	}

	rc = sqlite3_close(db);
	db = NULL;

	return 0;
}

/**
 * [obNsB
 *
 */
void FxWriter::rollback()
{
	const char *sql = "ROLLBACK TRANSACTION;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[rollback]SQL error\n");
		return;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (( rc != SQLITE_OK ) && (rc != SQLITE_DONE) ){
		fprintf(stderr, "[rollback]SQL error\n");
		rc = sqlite3_finalize(statement);
		sqlite3_close(db);
		db = NULL;

		return;
	}
	inTransaction = false;

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}
}

/**
 * SQLsB<br>
 *
 */
int FxWriter::executeSQL(const char *sql)
{
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[executeSQL]SQL error\n");
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (( rc != SQLITE_OK ) && (rc != SQLITE_DONE) ){
		fprintf(stderr, "[executeSQL]SQL error\n");
		rc = sqlite3_finalize(statement);

		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[executeSQL]finalize failed\n");
	}

	return 0;
}

/**
 * CfbNX̍ĕҐsB
 */
int FxWriter::reindex()
{
	return executeSQL("REINDEX;");
}

/**
 * 󂫗̈̐sB
 */
int FxWriter::vacuum()
{
	return executeSQL("VACUUM;");
}
