#ifndef FXREADER_H
#define FXREADER_H

#include	<string>
#include	<set>

#include	"sqlite3.h"

#include	"FxBookmark.h"
#include	"Bookmark.h"

#include	"IbookmarkTree.h"
#include	"Logger.h"
#include	"FxInfo.h"

class FxReader {
private:
	sqlite3 *db;	// DBANZXp
	const char *dbFile;	// DBt@C

	IbookmarkTree *writer;	// ݗpIuWFNg
	FxInfo *info;	// ubN}[NɊւ

	char item[BUFLEN],*pItem;	// H3̒gۑ
	int cItem;				// item̕JEgp
	Bookmark bookmark;
	int m_bookmarkNo;	// ǂݍłubN}[N̔ԍ
	char *urlBuf;		// URLϊpobt@

	int level;			// Kwx
	bool ignoreToolbar;	// c[o[𖳎邩ǂ
	int urlBufLen;
	Logger *logger;
	std::set<std::string> *guidSet;	// GUIDi[set

	int reallocUrlBuf(int size);
	int readFolder(sqlite_int64 folderId);
	sqlite_int64 getFolderLink(int key);
	int putLine(void);
	int putFolder(sqlite_int64 id);
	int putBookmark(void);
	int getFolderInfo(sqlite_int64 id);
	int getBookmarkInfo(sqlite_int64 id);
	int getBookmarkAnnotates(sqlite_int64 id);
	char *decodeAndRealloc(char *p);

public:
	FxReader();
	~FxReader();
	void setBookmarkWriter(IbookmarkTree *obj){	writer = obj; }
	int readBookmark(const char *bmFile);
	void setBookmarkNo(int no){	m_bookmarkNo = no;}
	void setIgnoreToolbar(bool flag) {
		ignoreToolbar = flag;
	}
	void setLogger(Logger *loggerObj) {
		logger = loggerObj;
	}

	/**
	 * GUIDi[psetݒ肷B
	 *
	 * @param value GUIDi[pset
	 */
	void setGuidSet(std::set<std::string> *value) {
		guidSet = value;
	}
};

#endif
