// Wwb_
#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>

// BookSyncʃwb_
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"

// vbgtH[wb_
#include	"FxReader.h"

/**
 * RXgN^
 *
 */
FxReader::FxReader()
{
	m_bookmarkNo = 0;

	level = 0;

	info = NULL;
	ignoreToolbar = false;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
	urlBufLen = BUFLEN;
}

/**
 * fXgN^
 *
 */
FxReader::~FxReader()
{
	if (info != NULL) {
		delete info;
	}

	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int FxReader::reallocUrlBuf(int size)
{
	delete []urlBuf;
	try {
		urlBuf = NULL;
		urlBuf = new char[size];
		if (urlBuf == NULL) {
			logger->debug("No enough memory");
			return -1;
		}
		urlBufLen = size;
	} catch (...) {
		logger->debug("No enough memory");
		return -1;
	}
	return size;
}

/**
 * c[ւ̃Zp[^̏o
 *
 * @return 0: 1:s
 */
int FxReader::putLine(void)
{
	bookmark.setItemType(Bookmark::bookmark);
	bookmark.setSeparator(true);

	// c[ւ̊i[
	int result = writer->storeItemWithRefer(&bookmark);
	if (result){
		logger->debug("Separator store error");
		return 1;
	}

	return result;
}

/**
 * c[ւ̃tH_̏oƂ̉̃c[̓ǂ݂
 *
 * @param id tH_id
 * @return 0: 1:s
 */
int FxReader::putFolder(sqlite_int64 id)
{
	bookmark.setItemType(Bookmark::folder);

	if (bookmark.getFxBookmark(m_bookmarkNo)->getFeedUrl() != NULL) {
		// CuubN}[N̏ꍇ̓ubN}[NɐUԂB
		bookmark.setItemType(Bookmark::bookmark);
	}

	// tH_̎ނ̐ݒ
	// ʂ̃tH_
	bookmark.setFolderType(Bookmark::normalFolder);
	if (id == info->getRootFolders()) {
		// ŏʊKw
		bookmark.setFolderType(Bookmark::topFolder);
	}
	if (id == info->getMenuFolder()) {
		// j[o[̃ubN}[Nj[
		bookmark.setFolderType(Bookmark::menuBar);
	}
	if (id == info->getToolbarFolder()) {
		// ubN}[Nc[o[
		bookmark.setFolderType(Bookmark::toolBar);
	}
	if (id == info->getTagsFolder()) {
		// ^O
		bookmark.setFolderType(Bookmark::tags);
	}
	if (id == info->getUnfiledFolder()) {
		// Unfiled bookmark
		bookmark.setFolderType(Bookmark::unFiled);
	}
	if (id == info->getMobileFolder()) {
		// oC̃ubN}[N
		bookmark.setFolderType(Bookmark::mobile);
	}

	int result = 0;

	if (id != info->getToolbarFolder() || ignoreToolbar == false) {
		// c[ւ̊i[
		result = writer->storeItem(&bookmark);
		if (result){
			logger->debug("Floder store error");
			return 1;
		}

		if (bookmark.getFxBookmark(m_bookmarkNo)->getFeedUrl() == NULL) {
			// c[o[ȊOc[o[𖳎Ȃꍇ
			// ̃tH_ǂݍށB

			level++;
			// tH_CuubN}[NłȂꍇ̂݃tH_ǂݍށB
			result = readFolder(id);
			// tH_̓ǂݍ݂ItH_1B
			writer->upFolder();	// 
			level--;
		}
	}
	return result;
}

/**
 * c[ւ̃ubN}[N̏o
 *
 * @return 0: 1:s
 */
int FxReader::putBookmark(void)
{
	bookmark.setItemType(Bookmark::bookmark);

	// c[ւ̊i[
	int result = writer->storeItem(&bookmark);
	if (result){
		logger->debug("Bookmark store error");
		return 1;
	}

	return result;
}

/**
 * tH_̎擾
 *
 * @param id tH_id
 * @return 0: 1:s
 */
int FxReader::getFolderInfo(sqlite_int64 id)
{
	const char *sql = 
		"select moz_bookmarks.title,dateAdded,lastModified "
		"from moz_bookmarks "
		"where moz_bookmarks.id=?;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		logger->debug("Folder info SQL error");
		return 1;
	}

	sqlite3_reset(statement);
	// bind_??1n܂B(̏ꍇ\0̕̕Kv)
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"bind failed #2\n");
		sqlite3_finalize(statement);
		logger->debug("Folder info bind error");
		return 1;
	}


	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		// 0n܂B
		if (sqlite3_column_type(statement,0) == SQLITE_TEXT){	// ^Cg
			fprintf(stdout,"%d:TEXT:%s\n",0,sqlite3_column_text(statement,0));
			
			const unsigned char *item = sqlite3_column_text(statement,0);

			if (item != NULL) {
				if (id == info->getMenuFolder()) {
					// ubN}[Nj[̎ProperNameɂށB
					bookmark.getFxBookmark(m_bookmarkNo)->setProperName((char *)item);
				}
				
				if (id != info->getMobileFolder()) {
					// ubN}[N
					bookmark.setName((char *)item);
					// IE(}`oCg)̐ݒ
					char *p;
					p = UTF8tombFileNameInternal((char *)item);
					if (p != NULL){
						bookmark.setIeName(p);
					}
					// O̐ݒ(Unicode)
					wchar_t *wp;
					wp = UTF8towcFileNameInternal((char *)item);
					bookmark.setIeNameW(wp);
				} else {
					// ubN}[N
					bookmark.setIeName("oC̃ubN}[N");
					// IE(}`oCg)̐ݒ
					char *p;
					p = mbtoUTF8Internal("oC̃ubN}[N");
					if (p != NULL){
						bookmark.setName(p);
					}
					// O̐ݒ(Unicode)
					bookmark.setIeNameW(L"oC̃ubN}[N");
				}
			}
		}
		if (sqlite3_column_type(statement, 1) == SQLITE_INTEGER) {	// ǉ
			time_t added = fx3TimeToTimet((const char *)sqlite3_column_text(statement, 1));
			bookmark.setAdddate(added);
		}
		if (sqlite3_column_type(statement, 2) == SQLITE_INTEGER) {	// ύX
			time_t modified = fx3TimeToTimet((const char *)sqlite3_column_text(statement, 2));
			bookmark.setModified(modified);
		}

		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed");
	}

	return 0;
}

/**
 * ubN}[N̎擾
 *
 * @param id ubN}[Nid
 * @return 0: 1:s
 */
int FxReader::getBookmarkInfo(sqlite_int64 id)
{
	const char *sql =
		"select moz_bookmarks.id,moz_bookmarks.title,moz_places.url,"
		"moz_bookmarks.dateAdded,moz_bookmarks.lastModified "
		"from moz_bookmarks,moz_places "
		"where moz_bookmarks.id=? and moz_bookmarks.fk=moz_places.id;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		logger->debug("Bookmark info SQL error");
		return 1;
	}

	sqlite3_reset(statement);
	// bind_??1n܂B(̏ꍇ\0̕̕Kv)
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"bind failed #2\n");
		logger->debug("Bookmark info bind error");
		sqlite3_finalize(statement);
		return 1;
	}


	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		// 0n܂B
		sqlite_int64 id = -1;
		if (sqlite3_column_type(statement,0) == SQLITE_INTEGER){	// ID
			id = sqlite3_column_int64(statement,0);
			// fprintf(stdout,"%d:INTEGER:%ld\n",0,sqlite3_column_int64(statement,0));
		}
		if (sqlite3_column_type(statement,1) == SQLITE_TEXT){	// ^Cg
			fprintf(stdout,"%d:TEXT:%s\n",1,sqlite3_column_text(statement,1));
			
			const unsigned char *item = sqlite3_column_text(statement,1);
			if (item != NULL) {
				// ubN}[N
				bookmark.setName((char *)item);
				// IE(}`oCg)̐ݒ
				char *p;
				p = UTF8tombFileNameInternal((char *)item);
				if (p != NULL){
					bookmark.setIeName(p);
				}
				// O̐ݒ(Unicode)
				wchar_t *wp;
				wp = UTF8towcFileNameInternal((char *)item);
				bookmark.setIeNameW(wp);
			}
		}
		if (sqlite3_column_type(statement,2) == SQLITE_TEXT){	// URL
			fprintf(stdout,"%d:TEXT:%s\n",1,sqlite3_column_text(statement,2));
			char *p = (char *)sqlite3_column_text(statement,2);
			if (p != NULL) {
				if (strncmp("file:", p,5) == 0) {
					// file:URLGR[hĂ̂ŃfR[hĂB
					p = decodeAndRealloc(p);
					if (p == NULL) {
						logger->debug("file: URL decode error");
						return 1;
					}
				} else if (strncmp("javascript:", p,11) == 0) {
					// JavaScript(ubN}[Nbg)URLGR[hĂ̂
					// Ŏg߃fR[h
					p = decodeAndRealloc(p);
					if (p == NULL) {
						logger->debug("javascript: URL decode error");
						return 1;
					}
				}
				bookmark.setURL((const char *)p);
			}
		}
		if (sqlite3_column_type(statement,3) == SQLITE_INTEGER) {	// ǉ
			time_t added = fx3TimeToTimet((const char *)sqlite3_column_text(statement,3));
			bookmark.setAdddate(added);
		}
		if (sqlite3_column_type(statement,4) == SQLITE_INTEGER) {	// ύX
			time_t modified = fx3TimeToTimet((const char *)sqlite3_column_text(statement,4));
			bookmark.setModified(modified);
		}
		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed");
	}

	return 0;
}

/**
 * URLGR[h̃fR[hƍĊmۂsB
 *
 * @param p fR[hsURL
 * @return NULL:fR[h NULL:fR[hs
 */
char *FxReader::decodeAndRealloc(char *p)
{
	int count = decodeURL(NULL, p);
	if ((count + 1) > urlBufLen) {
		int result = reallocUrlBuf(count + 2);
		if (result == -1) {
			return NULL;
		}
	}
	decodeURL(urlBuf, p);
	return urlBuf;
}

/**
 * ubN}[N̎擾
 *
 * @param id ubN}[Nid
 * @return 0: 1:s
 */
int FxReader::getBookmarkAnnotates(sqlite_int64 id)
{
	const char *sql = 
		"select moz_items_annos.anno_attribute_id,moz_items_annos.content "
		"from moz_bookmarks,moz_items_annos "
		"where moz_bookmarks.id=? and moz_bookmarks.id=moz_items_annos.item_id;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		logger->debug("Attributes SQL error");
		return 1;
	}

	sqlite3_reset(statement);
	// bind_??1n܂B(̏ꍇ\0̕̕Kv)
	rc = sqlite3_bind_int64(statement, 1, id);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"bind failed #2\n");
		sqlite3_finalize(statement);
		logger->debug("Attributes bind error");
		return 1;
	}


	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		// 0n܂B
		sqlite_int64 id = -1;
		if (sqlite3_column_type(statement,0) == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
			// fprintf(stdout,"%d:INTEGER:%d\n",0,sqlite3_column_int64(statement,0));
		}
		const char *content;
		if (sqlite3_column_type(statement,1) == SQLITE_TEXT){
			content = (const char *)sqlite3_column_text(statement,1);
			//fprintf(stdout,"%d:TEXT:%s\n",1,content);
		}
		if (id == info->getDescriptionId()) {	// 
			bookmark.setDescription(content);
		} else if (id == info->getInSideBarId()) {	// TCho[ւ̕\
			bookmark.getFxBookmark(m_bookmarkNo)->setWebPanel(true);
		} else if (id == info->getFeedUriId()) {	// CuubN}[ÑtB[h
			bookmark.getFxBookmark(m_bookmarkNo)->setFeedUrl(content);
		} else if (id == info->getSiteUriId()) {	// CuubN}[ÑTCg
			bookmark.setURL(content);
		} else if (id == info->getExpirationId()) {	// CuubN}[N̊
			bookmark.getFxBookmark(m_bookmarkNo)->setFeed_expiration(content);
		} else if (id == info->getReadOnlyId()) {	// ǂݎp
			bookmark.getFxBookmark(m_bookmarkNo)->setReadOnly(true);
		} else if (id == info->getGeneratorId()) {	// }CNT}WFl[^
			bookmark.getFxBookmark(m_bookmarkNo)->setMicsum_gen_uri(content);
		} else if (id == info->getStaticTitleId()) {	// }CNT}̐ÓI^Cg
			bookmark.getFxBookmark(m_bookmarkNo)->setGeneratedTitle(content);
		} else if (id == info->getSummaryExpirationId()) {	// }CNT}expiration
			bookmark.getFxBookmark(m_bookmarkNo)->setMicsum_expiration(content);
		} else if (id == info->getOrganizerFolderId()) {	// I[KiCŨtH_
			bookmark.getFxBookmark(m_bookmarkNo)->setOrganizerFolder(true);
		} else if (id == info->getOrganizerQueryId()) {	// I[KiCŨNG
			bookmark.getFxBookmark(m_bookmarkNo)->setOrganizerQuery(true);
		} else if (id == info->getSmartBookmarkId()) {	// X}[gubN}[N
			bookmark.getFxBookmark(m_bookmarkNo)->setSmartBookmark(true);
		} else if (id == info->getExcludeFromBackup()) {	// ExcludeFromBackup
			bookmark.getFxBookmark(m_bookmarkNo)->setExcludeFromBackup(1);
		} else if (id == info->getSyncParentId()) {	// sync/parent
			bookmark.getFxBookmark(m_bookmarkNo)->setSyncParent(content);
		} else if (id == info->getSyncParentId()) {	// mobile/bookmarksRoot
			bookmark.getFxBookmark(m_bookmarkNo)->setMobileRoot(content);
		}

		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed");
	}

	return 0;
}

/**
 * tH_ւ̃N邩ǂ`FbNB
 *
 * @param key moz_places̃L[
 * @return -1:tH_ւ̃Nł͂Ȃ >-1 :ÑtH_
 */
sqlite_int64 FxReader::getFolderLink(int key)
{
	const char *sql = "select url from moz_places where id=?;";
	const char *p;	// ǂݍ܂ȂƂŵă|C^

	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[readFolder]SQL error\n");
		logger->debug("URL SQL error");
		return -1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int(statement, 1, key);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[readFolder]bind failed.\n");
		logger->debug("URL bind error");
		sqlite3_finalize(statement);
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	if (rc == SQLITE_ROW) {
		// ^Cg
		if (sqlite3_column_type(statement,0) == SQLITE3_TEXT){
			const unsigned char *item = sqlite3_column_text(statement,0);
			if (item != NULL) {
				if (strncmp((const char *)item,"place:folder=",13) == 0){
					char *p = (char *)item + 13;
					while(*p) {
						if (*p == '&') {
							// &oꍇ͒PȂtH_̎QƂł͂Ȃ̂
							// URLƂB
							sqlite3_finalize(statement);
							return -1;
						}
						p++;
					}
					sqlite_int64 folder = -1;
					if (strcmp((const char *)item + 13,"TAGS") == 0) {
						folder = info->getTagsFolder();
					}
					if (strcmp((const char *)item + 13,"TOOLBAR") == 0) {
						folder = info->getToolbarFolder();
					}
					if (strcmp((const char *)item + 13,"BOOKMARKS_MENU") == 0) {
						folder = info->getMenuFolder();
					}
					if (strcmp((const char *)item + 13,"UNFILED_BOOKMARKS") == 0) {
						folder = info->getUnfiledFolder();;
					}
					sqlite3_finalize(statement);
					return folder;
				}
			}
		}
	}

	sqlite3_finalize(statement);
	return -1;
}


/**
 * tH_ǂݍ
 *
 * @param folderId ubN}[NEtH_tH_moz_bookmarks.id
 * @return 0: 1:s
 */
int FxReader::readFolder(sqlite_int64 folderId)
{
	const char *sql;
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	char guidBuf[128];

	if (info->hasSyncStatus()) {
		sql = "select id,type,title,fk,keyword_id,dateAdded,lastModified,guid,syncStatus,syncChangeCounter "
			"from moz_bookmarks "
			"where parent=? order by position;";
	} else if (info->getHasGUID()) {
		sql = "select id,type,title,fk,keyword_id,dateAdded,lastModified,guid "
			"from moz_bookmarks "
			"where parent=? order by position;";
	} else {
		sql = "select id,type,title,fk,keyword_id,dateAdded,lastModified "
			"from moz_bookmarks "
			"where parent=? order by position;";
	}

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "[readFolder]SQL error\n");
		logger->debug("Folder read SQL error");
		return 1;
	}

	sqlite3_reset(statement);
	rc = sqlite3_bind_int64(statement, 1, folderId);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[readFolder]bind failed.\n");
		logger->debug("Folder read bind error");
		sqlite3_finalize(statement);
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while (rc == SQLITE_ROW) {
		// ubN}[Ni[IuWFNgZbgB
		bookmark.reset();
		bookmark.getFxBookmark(m_bookmarkNo)->reset();

		// 0n܂B
		sqlite_int64 id = -1;
		int type;
		//int fk;
		//int link;
		int result = 0;
		sqlite_int64 syncStatus;
		sqlite_int64 syncCount;

		// id
		if (sqlite3_column_type(statement,0) == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
			// fprintf(stdout,"%d:INTEGER:%d\n",0,sqlite3_column_int64(statement,0));
		}
		// ^Cv
		if (sqlite3_column_type(statement,1) == SQLITE_INTEGER){
			type = sqlite3_column_int(statement,1);
			fprintf(stdout,"%d:INTEGER:%d\n",1,sqlite3_column_int(statement,1));
		}
		// GUID
		if (info->getHasGUID()) {
			if (sqlite3_column_type(statement,7) == SQLITE_TEXT) {
				guidBuf[0] = '\n';
				strcpy(guidBuf,(const char *)sqlite3_column_text(statement,7));
				if (strlen(guidBuf) > 0) {
					bookmark.getFxBookmark(m_bookmarkNo)->setGUID(guidBuf);
					guidSet->insert(guidBuf);
				}
			}
		}
		// syncStatus
		if (info->hasSyncStatus()) {
			if (sqlite3_column_type(statement, 8) == SQLITE_INTEGER) {
				syncStatus = sqlite3_column_int64(statement, 8);
			}
			if (sqlite3_column_type(statement, 9) == SQLITE_INTEGER) {
				syncCount = sqlite3_column_int64(statement, 9);
			}
		}
		if (folderId == info->getTopFolder()) {
			if (id == info->getTagsFolder()) {
				// ^O͈ȂB
				rc = sqlite3_step(statement);
				continue;
			}

			// tH_ʂ̐ݒ
			if (id == info->getMenuFolder()) {
				// ubN}[Nj[
				bookmark.setFolderType(Bookmark::menuBar);
			} else if (id == info->getToolbarFolder()) {
				// p[\ic[o[tH_
				bookmark.setFolderType(Bookmark::toolBar);
			} else if (id == info->getUnfiledFolder()) {
				// unfiled͂ǂ邩ȁH
				bookmark.setFolderType(Bookmark::unFiled);
				// continue;
			} else if (id == info->getMobileFolder()) {
				// oC̃ubN}[N
				bookmark.setFolderType(Bookmark::mobile);
				// continue;
			} else {
				// All bookmarksȉ̓NȂ̂ňȂB
				// ^O͈ȂB
				rc = sqlite3_step(statement);
				continue;
			}
		}

		switch (type) {
			case 1:
				// ubN}[N̏
				result = getBookmarkInfo(id);
				if (result){
					rc = sqlite3_finalize(statement);
					logger->debug("Folder read error by bookmark info");
					return 1;
				}
				result = getBookmarkAnnotates(id);
				if (result){
					rc = sqlite3_finalize(statement);
					logger->debug("Folder read error by bookmark attribute");
					return 1;
				}
				if (bookmark.getURL() == NULL) {
					// qXgȊȌꍇɏo͂sB
					result = putBookmark();
					if (result){
						rc = sqlite3_finalize(statement);
					logger->debug("Folder read error by bookmark store");
						return 1;
					}
				} else {
					if (strncmp((const char *)bookmark.getURL(),"place:sort=4&",13) != 0){
						// qXgȊȌꍇɏo͂sB
						result = putBookmark();
						if (result){
							rc = sqlite3_finalize(statement);
							logger->debug("Folder read error by bookmark store");
							return 1;
						}
					}
				}
				break;
			case 2:
				// tH_̏
				result = getFolderInfo(id);
				if (result){
					rc = sqlite3_finalize(statement);
					logger->debug("Folder read error by folder info");
					return 1;
				}
				result = getBookmarkAnnotates(id);
				if (result){
					rc = sqlite3_finalize(statement);
					logger->debug("Folder read error by folder attribute");
					return 1;
				}
				result = putFolder(id);
				if (result){
					rc = sqlite3_finalize(statement);
					logger->debug("Folder read error by folder store");
					return 1;
				}
				break;
			case 3:
				// ؂
				result = putLine();
				if (result){
					rc = sqlite3_finalize(statement);
					logger->debug("Folder read error by separator store");
					return 1;
				}
				break;
		}

		fprintf(stdout,"\n\n");
		rc = sqlite3_step(statement);
	}
	if (rc != SQLITE_DONE) {
		sqlite3_finalize(statement);
		logger->debug("Folder read error by SQL execute");
		return 1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"[readFolder]finalize failed\n");
	}
	
	return 0;
	
}

/**
 * ubN}[Nǂݍ
 *
 * @param bmFile ubN}[Nt@C
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int FxReader::readBookmark(const char *bmFile)
{
	int rc;

	fprintf(stderr, "[readBookmark]read start\n");

	dbFile = bmFile;
	char *p = mbtoUTF8Internal(const_cast<char *>(bmFile));
	if (p == NULL) {
		logger->debug("Bookmark db read error");
		return 1;
	}

	// DBt@CI[v
	rc = sqlite3_open(p, &db);
	if (rc){
		fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
		sqlite3_close(db);
		db = NULL;
		logger->debug("Bookmark db open failed");
		return 1;
	}
	try {
		info = new FxInfo(db);
		if (info == NULL) {
			logger->debug("Bookmark db information object create failed");
			return 1;
		}
	}catch(...) {
		logger->debug("Bookmark db information object create failed");
		return 1;
	}

	// ǂݍށB
	int result = info->readInformations();
	if (result) {
		delete info;
		info = NULL;
		logger->debug("Bookmark db information get failed");
		return 1;
	}

	// ŏ̃tH_ǂݎn߂
	result = readFolder(info->getTopFolder());

	delete info;
	info = NULL;
	sqlite3_close(db);
	db = NULL;

	return result;
}

